/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.pipespec.Steps;
import org.apache.camel.v1.pipespec.steps.DataTypes;
import org.apache.camel.v1.pipespec.steps.Properties;
import org.apache.camel.v1.pipespec.steps.PropertiesBuilder;
import org.apache.camel.v1.pipespec.steps.PropertiesFluent;
import org.apache.camel.v1.pipespec.steps.Ref;
import org.apache.camel.v1.pipespec.steps.RefBuilder;
import org.apache.camel.v1.pipespec.steps.RefFluent;

public class StepsFluent<A extends StepsFluent<A>>
extends BaseFluent<A> {
    private Map<String, DataTypes> dataTypes;
    private PropertiesBuilder properties;
    private RefBuilder ref;
    private String uri;

    public StepsFluent() {
    }

    public StepsFluent(Steps instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Steps instance) {
        Steps steps = instance = instance != null ? instance : new Steps();
        if (instance != null) {
            this.withDataTypes(instance.getDataTypes());
            this.withProperties(instance.getProperties());
            this.withRef(instance.getRef());
            this.withUri(instance.getUri());
        }
    }

    public A addToDataTypes(String key, DataTypes value) {
        if (this.dataTypes == null && key != null && value != null) {
            this.dataTypes = new LinkedHashMap<String, DataTypes>();
        }
        if (key != null && value != null) {
            this.dataTypes.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDataTypes(Map<String, DataTypes> map) {
        if (this.dataTypes == null && map != null) {
            this.dataTypes = new LinkedHashMap<String, DataTypes>();
        }
        if (map != null) {
            this.dataTypes.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromDataTypes(String key) {
        if (this.dataTypes == null) {
            return (A)((Object)this);
        }
        if (key != null && this.dataTypes != null) {
            this.dataTypes.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromDataTypes(Map<String, DataTypes> map) {
        if (this.dataTypes == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.dataTypes == null) continue;
                this.dataTypes.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, DataTypes> getDataTypes() {
        return this.dataTypes;
    }

    public <K, V> A withDataTypes(Map<String, DataTypes> dataTypes) {
        this.dataTypes = dataTypes == null ? null : new LinkedHashMap<String, DataTypes>(dataTypes);
        return (A)((Object)this);
    }

    public boolean hasDataTypes() {
        return this.dataTypes != null;
    }

    public Properties buildProperties() {
        return this.properties != null ? this.properties.build() : null;
    }

    public A withProperties(Properties properties) {
        this._visitables.remove((Object)"properties");
        if (properties != null) {
            this.properties = new PropertiesBuilder(properties);
            this._visitables.get((Object)"properties").add(this.properties);
        } else {
            this.properties = null;
            this._visitables.get((Object)"properties").remove((Object)this.properties);
        }
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public PropertiesNested<A> withNewProperties() {
        return new PropertiesNested(null);
    }

    public PropertiesNested<A> withNewPropertiesLike(Properties item) {
        return new PropertiesNested(item);
    }

    public PropertiesNested<A> editProperties() {
        return this.withNewPropertiesLike(Optional.ofNullable(this.buildProperties()).orElse(null));
    }

    public PropertiesNested<A> editOrNewProperties() {
        return this.withNewPropertiesLike(Optional.ofNullable(this.buildProperties()).orElse(new PropertiesBuilder().build()));
    }

    public PropertiesNested<A> editOrNewPropertiesLike(Properties item) {
        return this.withNewPropertiesLike(Optional.ofNullable(this.buildProperties()).orElse(item));
    }

    public Ref buildRef() {
        return this.ref != null ? this.ref.build() : null;
    }

    public A withRef(Ref ref) {
        this._visitables.remove((Object)"ref");
        if (ref != null) {
            this.ref = new RefBuilder(ref);
            this._visitables.get((Object)"ref").add(this.ref);
        } else {
            this.ref = null;
            this._visitables.get((Object)"ref").remove((Object)this.ref);
        }
        return (A)((Object)this);
    }

    public boolean hasRef() {
        return this.ref != null;
    }

    public RefNested<A> withNewRef() {
        return new RefNested(null);
    }

    public RefNested<A> withNewRefLike(Ref item) {
        return new RefNested(item);
    }

    public RefNested<A> editStepsRef() {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(null));
    }

    public RefNested<A> editOrNewRef() {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(new RefBuilder().build()));
    }

    public RefNested<A> editOrNewRefLike(Ref item) {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(item));
    }

    public String getUri() {
        return this.uri;
    }

    public A withUri(String uri) {
        this.uri = uri;
        return (A)((Object)this);
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StepsFluent that = (StepsFluent)((Object)o);
        if (!Objects.equals(this.dataTypes, that.dataTypes)) {
            return false;
        }
        if (!Objects.equals((Object)this.properties, (Object)that.properties)) {
            return false;
        }
        if (!Objects.equals((Object)this.ref, (Object)that.ref)) {
            return false;
        }
        return Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataTypes, this.properties, this.ref, this.uri, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dataTypes != null && !this.dataTypes.isEmpty()) {
            sb.append("dataTypes:");
            sb.append(this.dataTypes + ",");
        }
        if (this.properties != null) {
            sb.append("properties:");
            sb.append(this.properties + ",");
        }
        if (this.ref != null) {
            sb.append("ref:");
            sb.append(this.ref + ",");
        }
        if (this.uri != null) {
            sb.append("uri:");
            sb.append(this.uri);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PropertiesNested<N>
    extends PropertiesFluent<PropertiesNested<N>>
    implements Nested<N> {
        PropertiesBuilder builder;

        PropertiesNested(Properties item) {
            this.builder = new PropertiesBuilder(this, item);
        }

        public N and() {
            return (N)StepsFluent.this.withProperties(this.builder.build());
        }

        public N endProperties() {
            return this.and();
        }
    }

    public class RefNested<N>
    extends RefFluent<RefNested<N>>
    implements Nested<N> {
        RefBuilder builder;

        RefNested(Ref item) {
            this.builder = new RefBuilder(this, item);
        }

        public N and() {
            return (N)StepsFluent.this.withRef(this.builder.build());
        }

        public N endStepsRef() {
            return this.and();
        }
    }
}

