/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Manage secrets in IBM Secrets Manager Service
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface IBMSecretsManagerEndpointBuilderFactory {

    /**
     * Builder for endpoint for the IBM Secrets Manager component.
     */
    public interface IBMSecretsManagerEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedIBMSecretsManagerEndpointBuilder advanced() {
            return (AdvancedIBMSecretsManagerEndpointBuilder) this;
        }

        /**
         * Operation to be performed.
         * 
         * The option is a:
         * <code>org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerOperation</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IBMSecretsManagerEndpointBuilder operation(org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Operation to be performed.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerOperation</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IBMSecretsManagerEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Service URL for IBM Secrets Manager.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default IBMSecretsManagerEndpointBuilder serviceUrl(String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
        /**
         * IBM Cloud API Token for IBM Secrets Manager.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param token the value to set
         * @return the dsl builder
         */
        default IBMSecretsManagerEndpointBuilder token(String token) {
            doSetProperty("token", token);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IBM Secrets Manager component.
     */
    public interface AdvancedIBMSecretsManagerEndpointBuilder
            extends
                EndpointProducerBuilder {
        default IBMSecretsManagerEndpointBuilder basic() {
            return (IBMSecretsManagerEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIBMSecretsManagerEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIBMSecretsManagerEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface IBMSecretsManagerBuilders {
        /**
         * IBM Secrets Manager (camel-ibm-secrets-manager)
         * Manage secrets in IBM Secrets Manager Service
         * 
         * Category: cloud,cloud
         * Since: 4.11
         * Maven coordinates: org.apache.camel:camel-ibm-secrets-manager
         * 
         * @return the dsl builder for the headers' name.
         */
        default IBMSecretsManagerHeaderNameBuilder ibmSecretsManager() {
            return IBMSecretsManagerHeaderNameBuilder.INSTANCE;
        }
        /**
         * IBM Secrets Manager (camel-ibm-secrets-manager)
         * Manage secrets in IBM Secrets Manager Service
         * 
         * Category: cloud,cloud
         * Since: 4.11
         * Maven coordinates: org.apache.camel:camel-ibm-secrets-manager
         * 
         * Syntax: <code>ibm-secrets-manager:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default IBMSecretsManagerEndpointBuilder ibmSecretsManager(String path) {
            return IBMSecretsManagerEndpointBuilderFactory.endpointBuilder("ibm-secrets-manager", path);
        }
        /**
         * IBM Secrets Manager (camel-ibm-secrets-manager)
         * Manage secrets in IBM Secrets Manager Service
         * 
         * Category: cloud,cloud
         * Since: 4.11
         * Maven coordinates: org.apache.camel:camel-ibm-secrets-manager
         * 
         * Syntax: <code>ibm-secrets-manager:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default IBMSecretsManagerEndpointBuilder ibmSecretsManager(String componentName, String path) {
            return IBMSecretsManagerEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the IBM Secrets Manager component.
     */
    public static class IBMSecretsManagerHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final IBMSecretsManagerHeaderNameBuilder INSTANCE = new IBMSecretsManagerHeaderNameBuilder();

        /**
         * Overrides the desired operation to be used in the producer.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IbmSecretsManagerProducerOperation}.
         */
        public String ibmSecretsManagerProducerOperation() {
            return "CamelIbmSecretsManagerProducerOperation";
        }
        /**
         * Set the desired secret path as header.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IbmSecretsManagerSecretName}.
         */
        public String ibmSecretsManagerSecretName() {
            return "CamelIbmSecretsManagerSecretName";
        }
        /**
         * Set the desired secret version as header.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IbmSecretsManagerSecretVersion}.
         */
        public String ibmSecretsManagerSecretVersion() {
            return "CamelIbmSecretsManagerSecretVersion";
        }
        /**
         * Set the desired secret version as header.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IbmSecretsManagerSecretId}.
         */
        public String ibmSecretsManagerSecretId() {
            return "CamelIbmSecretsManagerSecretId";
        }
    }
    static IBMSecretsManagerEndpointBuilder endpointBuilder(String componentName, String path) {
        class IBMSecretsManagerEndpointBuilderImpl extends AbstractEndpointBuilder implements IBMSecretsManagerEndpointBuilder, AdvancedIBMSecretsManagerEndpointBuilder {
            public IBMSecretsManagerEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new IBMSecretsManagerEndpointBuilderImpl(path);
    }
}