/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.perf.test.BasicRecord;
import org.apache.avro.perf.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class RecordTest {
    private static final String RECORD_SCHEMA = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }";

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void decode(TestStateDecode state, Blackhole blackHole) throws Exception {
        Decoder d = state.decoder;
        double sd = 0.0;
        int si = 0;
        for (int i = 0; i < state.getBatchSize(); ++i) {
            sd += d.readDouble();
            sd += d.readDouble();
            sd += d.readDouble();
            si += d.readInt();
            si += d.readInt();
            si += d.readInt();
        }
        blackHole.consume(sd);
        blackHole.consume(si);
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private final Schema readerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }");
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            for (int i = 0; i < this.getBatchSize(); ++i) {
                BasicRecord r = new BasicRecord(super.getRandom());
                encoder.writeDouble(r.f1);
                encoder.writeDouble(r.f2);
                encoder.writeDouble(r.f3);
                encoder.writeInt(r.f4);
                encoder.writeInt(r.f5);
                encoder.writeInt(r.f6);
            }
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = DecoderFactory.get().validatingDecoder(this.readerSchema, super.newDecoder(this.testData));
        }
    }
}

