/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.annotations;

import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.openjdk.jmh.generators.annotations.APClassInfo;
import org.openjdk.jmh.generators.annotations.APMetadataInfo;
import org.openjdk.jmh.generators.core.ClassInfo;
import org.openjdk.jmh.generators.core.FieldInfo;

class APFieldInfo
extends APMetadataInfo
implements FieldInfo {
    private final VariableElement ve;

    public APFieldInfo(ProcessingEnvironment processEnv, VariableElement ve) {
        super(processEnv, ve);
        if (ve == null) {
            throw new IllegalArgumentException("element is null");
        }
        this.ve = ve;
    }

    @Override
    public String getName() {
        return this.ve.getSimpleName().toString();
    }

    @Override
    public ClassInfo getType() {
        return new APClassInfo(this.processEnv, this.ve.asType());
    }

    @Override
    public boolean isPublic() {
        return this.ve.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isStatic() {
        return this.ve.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isFinal() {
        return this.ve.getModifiers().contains((Object)Modifier.FINAL);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        return this.ve.getAnnotation(annClass);
    }

    @Override
    public ClassInfo getDeclaringClass() {
        return new APClassInfo(this.processEnv, (TypeElement)this.ve.getEnclosingElement());
    }

    public String toString() {
        return this.getType() + " " + this.getName();
    }
}

