/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;

public class PostgresLargeObjectManager {
    public static final int WRITE = 131072;
    public static final int READ = 262144;
    public static final int READWRITE = 393216;
    private boolean shouldUseReflection;

    public PostgresLargeObjectManager() {
        try {
            this.getClass().getClassLoader().loadClass("org.postgresql.PGConnection");
            this.shouldUseReflection = false;
        }
        catch (ClassNotFoundException ex) {
            this.shouldUseReflection = true;
        }
    }

    public final Long createLO(Connection connection) throws SQLException {
        if (this.shouldUseReflection) {
            Object largeObjectManager = this.getLargeObjectManager(connection);
            try {
                Method method = largeObjectManager.getClass().getMethod("createLO", new Class[0]);
                return (Long)method.invoke(largeObjectManager, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SQLException("Couldn't access org.postgresql.largeobject.LargeObjectManager", ex);
            }
        }
        return connection.unwrap(PGConnection.class).getLargeObjectAPI().createLO();
    }

    public Object open(Connection connection, long oid, int mode) throws SQLException {
        if (this.shouldUseReflection) {
            Object largeObjectManager = this.getLargeObjectManager(connection);
            try {
                Method method = largeObjectManager.getClass().getMethod("open", Long.TYPE, Integer.TYPE);
                return method.invoke(largeObjectManager, oid, mode);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SQLException("Couldn't access org.postgresql.largeobject.LargeObjectManager", ex);
            }
        }
        return connection.unwrap(PGConnection.class).getLargeObjectAPI().open(oid, mode);
    }

    public int size(Object largeObject) throws SQLException {
        if (this.shouldUseReflection) {
            try {
                Method method = largeObject.getClass().getMethod("size", new Class[0]);
                return (Integer)method.invoke(largeObject, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SQLException("Couldn't access org.postgresql.largeobject.LargeObject", ex);
            }
        }
        return ((LargeObject)largeObject).size();
    }

    public void close(Object largeObject) throws SQLException {
        if (this.shouldUseReflection) {
            try {
                Method method = largeObject.getClass().getMethod("close", new Class[0]);
                method.invoke(largeObject, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SQLException("Couldn't access org.postgresql.largeobject.LargeObject", ex);
            }
        } else {
            ((LargeObject)largeObject).close();
        }
    }

    public byte[] read(Object largeObject, int length) throws SQLException {
        if (this.shouldUseReflection) {
            try {
                Method method = largeObject.getClass().getMethod("read", Integer.TYPE);
                return (byte[])method.invoke(largeObject, length);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SQLException("Couldn't access org.postgresql.largeobject.LargeObject", ex);
            }
        }
        return ((LargeObject)largeObject).read(length);
    }

    public void write(Object largeObject, byte[] data) throws SQLException {
        if (this.shouldUseReflection) {
            try {
                Method method = largeObject.getClass().getMethod("write", byte[].class);
                method.invoke(largeObject, new Object[]{data});
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SQLException("Couldn't access org.postgresql.largeobject.LargeObject", ex);
            }
        } else {
            ((LargeObject)largeObject).write(data);
        }
    }

    public void seek(Object largeObject, int position) throws SQLException {
        if (this.shouldUseReflection) {
            try {
                Method method = largeObject.getClass().getMethod("seek", Integer.TYPE);
                method.invoke(largeObject, position);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SQLException("Couldn't access org.postgresql.largeobject.LargeObject", ex);
            }
        } else {
            ((LargeObject)largeObject).seek(position);
        }
    }

    public void truncate(Object largeObject, int position) throws SQLException {
        if (this.shouldUseReflection) {
            try {
                Method method = largeObject.getClass().getMethod("truncate", Integer.TYPE);
                method.invoke(largeObject, position);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SQLException("Couldn't access org.postgresql.largeobject.LargeObject", ex);
            }
        } else {
            ((LargeObject)largeObject).truncate(position);
        }
    }

    private Object getLargeObjectManager(Connection connection) throws SQLException {
        if (this.shouldUseReflection) {
            try {
                Connection conn = this.unwrap(connection);
                Method method = conn.getClass().getMethod("getLargeObjectAPI", new Class[0]);
                return method.invoke((Object)conn, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new SQLException("Couldn't access org.postgresql.largeobject.LargeObjectManager", ex);
            }
        }
        return connection.unwrap(PGConnection.class).getLargeObjectAPI();
    }

    public final Connection unwrap(Connection connection) throws SQLException {
        return this.unwrapIronJacamar(this.unwrapDbcp(this.unwrapDbcp2(this.unwrapSpring(connection.unwrap(Connection.class)))));
    }

    private Connection unwrapIronJacamar(Connection conn) {
        try {
            Method method = conn.getClass().getMethod("getUnderlyingConnection", new Class[0]);
            return (Connection)method.invoke((Object)conn, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return conn;
        }
    }

    private Connection unwrapDbcp(Connection conn) {
        try {
            Method method = conn.getClass().getMethod("getDelegate", new Class[0]);
            return (Connection)method.invoke((Object)conn, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return conn;
        }
    }

    private Connection unwrapDbcp2(Connection conn) {
        try {
            Method method = conn.getClass().getMethod("getInnermostDelegateInternal", new Class[0]);
            return (Connection)method.invoke((Object)conn, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return conn;
        }
    }

    private Connection unwrapSpring(Connection conn) {
        try {
            Method method = conn.getClass().getMethod("getTargetConnection", new Class[0]);
            return (Connection)method.invoke((Object)conn, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return conn;
        }
    }
}

