/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.subject;

import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.shiro.ConnectionReference;
import org.apache.activemq.shiro.DefaultSecurityContextFactory;
import org.apache.activemq.shiro.SecurityContextFactory;
import org.apache.activemq.shiro.env.EnvironmentFilter;
import org.apache.activemq.shiro.subject.ConnectionSubjectFactory;
import org.apache.activemq.shiro.subject.DefaultConnectionSubjectFactory;
import org.apache.activemq.shiro.subject.SubjectConnectionReference;
import org.apache.shiro.subject.Subject;

public class SubjectFilter
extends EnvironmentFilter {
    private ConnectionSubjectFactory connectionSubjectFactory = new DefaultConnectionSubjectFactory();
    private SecurityContextFactory securityContextFactory = new DefaultSecurityContextFactory();

    public ConnectionSubjectFactory getConnectionSubjectFactory() {
        return this.connectionSubjectFactory;
    }

    public void setConnectionSubjectFactory(ConnectionSubjectFactory connectionSubjectFactory) {
        if (connectionSubjectFactory == null) {
            throw new IllegalArgumentException("ConnectionSubjectFactory argument cannot be null.");
        }
        this.connectionSubjectFactory = connectionSubjectFactory;
    }

    public SecurityContextFactory getSecurityContextFactory() {
        return this.securityContextFactory;
    }

    public void setSecurityContextFactory(SecurityContextFactory securityContextFactory) {
        if (securityContextFactory == null) {
            throw new IllegalArgumentException("SecurityContextFactory argument cannot be null.");
        }
        this.securityContextFactory = securityContextFactory;
    }

    protected Subject createSubject(ConnectionReference conn) {
        return this.connectionSubjectFactory.createSubject(conn);
    }

    protected SecurityContext createSecurityContext(SubjectConnectionReference conn) {
        return this.securityContextFactory.createSecurityContext(conn);
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        SecurityContext secCtx;
        if (this.isEnabled() && (secCtx = context.getSecurityContext()) == null) {
            ConnectionReference conn = new ConnectionReference(context, info, this.getEnvironment());
            Subject subject = this.createSubject(conn);
            SubjectConnectionReference subjectConn = new SubjectConnectionReference(context, info, this.getEnvironment(), subject);
            secCtx = this.createSecurityContext(subjectConn);
            context.setSecurityContext(secCtx);
        }
        try {
            super.addConnection(context, info);
        }
        catch (Exception e) {
            context.setSecurityContext(null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        try {
            super.removeConnection(context, info, error);
        }
        finally {
            context.setSecurityContext(null);
        }
    }
}

