Object subclass: #MapColoringExample
	instanceVariableNames: 'neighColors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Logic_Processing - examples'!
MapColoringExample comment:
'This class is map coloring example - see protocol "solving".

(C) 	Vojtech Merunka
	Smetanova 647
	CZ-286 01 CASLAV

	merunka@pef.czu.cz
	http://omega.pef.czu.cz/pef/ki/merunka'!


!MapColoringExample methodsFor: 'solving'!

colorMap
	"This is the four color map filling problem"

	"	self default colorMap     "
	"	[self default colorMap. self fail] solve     "

	| a b c d e f g x |

	a 	:=	nil.
	b 	:= 	#blue.
	c 	:= 	#yellow.
	d 	:= 	nil.
	e 	:= 	#blue.
 	f 	:= 	nil.
	g 	:= 	#yellow.
	
	x 	:= 	AnyValue new.


	[a :=	neighColors call: (Array with: x with: b) andReturnAt: 1] &
	[	neighColors call: (Array with: a with: c)] &
	[d :=	neighColors call: (Array with: a with: x) andReturnAt: 2] &
	[	neighColors call: (Array with: b with: c)] &
	[	neighColors call: (Array with: b with: d)] &
	[	neighColors call: (Array with: c with: d)] &
	[	neighColors call: (Array with: d with: e)] &
	[f :=	neighColors call: (Array with: d with: x) andReturnAt: 2] &
	[	neighColors call: (Array with: e with: f)] &
	[	neighColors call: (Array with: e with: g)] &
	[	neighColors call: (Array with: f with: g)].


	Transcript cr.
	Transcript show: 'a:	' , a printString; cr.
	Transcript show: 'b:	' , b printString; cr.
	Transcript show: 'c:	' , c printString; cr.
	Transcript show: 'd:	' , d printString; cr.
	Transcript show: 'e:	' , e printString; cr.
	Transcript show: 'f:	' , f printString; cr.
	Transcript show: 'g:	' , g printString; cr! !

!MapColoringExample methodsFor: 'defaulting'!

setDefault
	| colors |
	neighColors := FactBase new.
	colors := #(#red #green #blue #yellow ).
	colors do: [:c1 | colors do: [:c2 | c1 ~= c2 ifTrue: [neighColors add: (Array with: c1 with: c2)]]]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MapColoringExample class
	instanceVariableNames: ''!


!MapColoringExample class methodsFor: 'defaulting'!

default
	^self new setDefault! !

Object subclass: #FamilyExample
	instanceVariableNames: 'fathers mothers wedlocks men women '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Logic_Processing - examples'!
FamilyExample comment:
'This class represents the simple example of logic processing in Smalltalk.

The database has following structure:

					^Jan-------------------+Lida
						|		  |
		+Marta-----------------^Pavel		+Jana-------^Mirek
			|		|				  |
			^Vojta	+Pavla			+Stana

The legend is...

^	man
+	woman
--	marriage
|	parent/child relation (parent is on the top)

(C) 	Vojtech Merunka
	Smetanova 647
	CZ-286 01 CASLAV

	merunka@pef.czu.cz
	http://omega.pef.czu.cz/pef/ki/merunka'!


!FamilyExample methodsFor: 'queries - declarative methods'!

auntOf: aPerson 
	| parent brother aunt |
	[[parent := self parentOf: aPerson]
		& [aunt := self sisterOf: parent]]
		| [[parent := self parentOf: aPerson]
				& [brother := self brotherOf: parent] & [aunt := self wifeOf: brother]].
	^aunt!

brotherInLawOf: aPerson 
	| result partner sister |
	[[sister := self sisterOf: aPerson]
		& [result := self husbandOf: sister]]
		| [[partner := self partnerOf: aPerson]
				& [result := self brotherOf: partner]].
	^result!

brotherOf: aPerson 
	| brother |
	[brother := self brotherOrSisterOf: aPerson]
		& [brother is: self man].
	^brother!

brotherOrSisterOf: aPerson 
	| father brOrSist |
	[father := self fatherOf: aPerson]
		& [brOrSist := self childOf: father] & [brOrSist isNot: aPerson].
	^brOrSist!

childOf: aPerson 
	| child |
	[child := fathers
				callValue: aPerson
				at: 1
				andReturnAt: 2]
		| [child := mothers
						callValue: aPerson
						at: 1
						andReturnAt: 2].
	^child!

cousinOf: aPerson 
	| uncle cousin |
	[uncle := self uncleOf: aPerson]
		& [cousin := self childOf: uncle].
	^cousin!

daughterOf: aPerson 
	| child |
	
		 [child := self childOf: aPerson ] & [child is: self woman] . 
	^child!

fatherOf: aPerson 
	^fathers
		callValue: aPerson
		at: 2
		andReturnAt: 1!

grandChildOf: aPerson 
	| child grandChild |
	[child := self childOf: aPerson]
		& [grandChild := self childOf: child].
	^grandChild!

grandDaughterOf: aPerson 
	| child grandDaughter |
	[child := self childOf: aPerson]
		& [grandDaughter := self daughterOf: child].
	^grandDaughter!

grandFatherOf: aPerson 
	| parent grandFather |
	[parent := self parentOf: aPerson]
		& [grandFather := self fatherOf: parent].
	^grandFather!

grandMotherOf: aPerson 
	| parent grandMother |
	[parent := self parentOf: aPerson]
		& [grandMother := self motherOf: parent].
	^grandMother!

grandSonOf: aPerson 
	| child grandSon |
	[child := self childOf: aPerson]
		& [grandSon := self sonOf: child].
	^grandSon!

husbandOf: aPerson 
	^wedlocks
		callValue: aPerson
		at: 2
		andReturnAt: 1!

man
	^men callAndReturnAt: 1!

motherOf: aPerson 
	^mothers
		callValue: aPerson
		at: 2
		andReturnAt: 1!

parentOf: aPerson 
	| parent |
	[parent := self fatherOf: aPerson]
		| [parent := self motherOf: aPerson].
	^parent!

partnerOf: aPerson 
	| partner |
	[partner := self husbandOf: aPerson]
		| [partner := self wifeOf: aPerson].
	^partner!

sisterInLawOf: aPerson 
	| result partner brother |
	[[brother := self brotherOf: aPerson]
		& [result := self wifeOf: brother]]
		| [[partner := self partnerOf: aPerson]
				& [result := self sisterOf: partner]].
	^result!

sisterOf: aPerson 
	| result |
	[result := self brotherOrSisterOf: aPerson]
		& [result is: self woman].
	^result!

sonOf: aPerson 
	| child |
	
		 [child := self childOf: aPerson ] & [child is: self man] . 
	^child!

uncleOf: aPerson 
	| parent sister uncle |
	[[parent := self parentOf: aPerson]
		& [uncle := self brotherOf: parent]]
		| [[parent := self parentOf: aPerson]
				& [sister := self sisterOf: parent] & [uncle := self husbandOf: sister]].
	^uncle!

wifeOf: aPerson 
	^wedlocks
		callValue: aPerson
		at: 1
		andReturnAt: 2!

woman
	^women callAndReturnAt: 1! !

!FamilyExample methodsFor: 'set default data'!

setDefault
	fathers := FactBase with: 
#(	#(#Jan #Jana)
	#(#Jan #Pavel)
	#(#Pavel #Vojta)
	#(#Pavel #Pavla)
	#(#Mirek #Stana)).

	mothers := FactBase with:
#(
	#(#Lida #Jana)
	#(#Lida #Pavel)
	#(#Marta #Vojta)
	#(#Marta #Pavla)
	#(#Jana #Stana)).

	wedlocks := FactBase with:
#(
	#(#Jan #Lida)
	#(#Pavel #Marta)
	#(#Mirek #Jana)).
	
	men := FactBase with:
#(
	#(#Jan)
	#(#Pavel)
	#(#Mirek)
	#(#Vojta)).

	women := FactBase with:
#(
	#(#Lida)
	#(#Jana)
	#(#Marta)
	#(#Pavla)
	#(#Stana))! !

!FamilyExample methodsFor: 'database accessing'!

fathers
	^fathers!

mothers
	^mothers!

wedlocks
	^wedlocks! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

FamilyExample class
	instanceVariableNames: ''!


!FamilyExample class methodsFor: 'default'!

default
	^self new setDefault! !

