| signal oldChangeSet noChanges fixes framework animationFramework toolDevelopment examples animatedExamples
	installAnimation installDevelopment installExamples installPatch patchFile workspaceString |

"Initialize the filename to use below"

framework := #('HotDraw-Framework.st' 'HotDraw-Figures.st' 'HotDraw-Handles.st'
	'HotDraw-Tools.st' 'HotDraw-Constraints.st' 'HotDraw-Toolbar.st').
animationFramework := #('HotDraw-Animation.st').
toolDevelopment := #('HotDraw-ToolCreation.st').
examples := #('DrawingInspector.st' 'HotPaint.st' 'PERTChart.st').
animatedExamples := #('MovingDrawing.st' 'NetworkDrawing.st' 'ObjectWorld.st').
patchFile := 'Polyline-outlineIntersects-fix.st'.

fixes := #().


(Smalltalk includesKey: #Event) 
	ifFalse: 
		[self halt: 'The extras/events.st file is not installed.<n>HotDraw will not work without the events.st file.' expandMacros].


noChanges := Dialog confirm: 'Do you wish to file-in without modifying current change set?'.
installPatch := Dialog confirm: 'Do you wish to install a patch to Polyline>>outlineIntersects:?<n>Without the patch, you will be unable to select vertical or horizontal lines.' expandMacros.
installAnimation := Dialog confirm: 'Do you want to install the animation part of the framework?'.
installDevelopment := Dialog confirm: 'Do you want to install the tool development?'.
installExamples := Dialog confirm: 'Do you want to install the examples?'.
[
noChanges ifTrue: 
	[oldChangeSet := ChangeSet current. 
	ChangeSet newChanges: ChangeSet new].

signal := Signal new.
signal handle: [:ex | ex return]
	do: 
		[| directory ctx name |
"Try to find the directory of the file-in. If this is not working, you can replace these lines with an assignment of the directory."
		ctx := thisContext.
		[ctx isNil or: [(ctx receiver isKindOf: Filename) or: [ctx receiver isKindOf: FileBrowser]]]
			whileFalse: [ctx := ctx sender].
		ctx isNil
			ifTrue: 
				[name := Dialog request: 'Enter directory that contains the sources:'.
				name isEmpty ifTrue: [signal raise].
				directory := name asFilename.
				directory exists
					ifFalse: 
						[Dialog warn: 'Directory does not exist'.
						signal raise]]
			ifFalse: [directory := ((ctx receiver isKindOf: Filename) ifTrue: [ctx receiver] ifFalse: [ctx receiver fileName asFilename]) directory].

"Start the installation process"
		
		workspaceString := 'DrawingEditor open<n>'.
		installPatch ifTrue: [(directory construct: patchFile) fileIn].		
		framework do: [:each | (directory construct: each) fileIn].
		installAnimation ifTrue: [animationFramework do: [:each | (directory construct: each) fileIn]].
		installDevelopment ifTrue: [toolDevelopment do: [:each | (directory construct: each) fileIn].
			workspaceString := workspaceString , 'ToolStateMachineEditor open<n>'].
		installExamples ifTrue: [
			examples do: [:each | (directory construct: each) fileIn].
			workspaceString := workspaceString , 'Transcript draw<n>HotPaintEditor open<n>PERTChart open<n>'.
			installAnimation ifTrue: [
				animatedExamples do: [:each | (directory construct: each) fileIn].
				workspaceString := workspaceString , 'MovingDrawingEditor open<n>NetworkEditor open<n>ObjectWorld open<n>']].

		fixes do: [:each | (directory construct: each) fileIn].
		(Smalltalk at: #Tool) reinitialize.
		(Smalltalk includesKey: #ComposedTextView)
			ifTrue: [(Smalltalk at: #ComposedTextView) open: (workspaceString expandMacros asValue) label: 'Workspace']
		]]
			valueNowOrOnUnwindDo: [
				noChanges ifTrue: [ChangeSet newChanges: oldChangeSet]]!
