'From VisualWorks(R), Release 2.5.1 of September 26, 1995 on January 8, 1998 at 8:27:43 am'!



ViewAdapterFigure subclass: #PERTEventFigure
	instanceVariableNames: 'outgoing '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-PERTChart'!
PERTEventFigure comment:
'PERTEventFigure represents an event in the drawing. It simply adapts a PERTEventAppModel to the figure protocol.

Instance Variables:
	outgoing	<IdentityDictionary key: LineFigure value: PERTEventFigure>	mapping of lines to the figure they connect, when a line is deleted we must update the figure its connected to

'!


!PERTEventFigure methodsFor: 'accessing'!

handles
	| handles |
	handles := OrderedCollection withAll: (TrackHandle allCornersOf: self).
	handles add: (Handle connectionOn: self at: #rightCenter).
	^handles! !

!PERTEventFigure methodsFor: 'changing'!

deletionUpdateFrom: aFigure 
	model disconnectFrom: (outgoing at: aFigure ifAbsent: [^self]) model.
	outgoing removeKey: aFigure.
	super deletionUpdateFrom: aFigure! !

!PERTEventFigure methodsFor: 'connection'!

canConnectFromFigure: aFigure 
	^self class == aFigure class!

canConnectToFigure: aFigure 
	self == aFigure ifTrue: [^false].
	self class == aFigure class ifFalse: [^false].
	^(aFigure isConnectedTo: self) not 
		and: [(self isConnectedTo: aFigure) not]!

connectFromPoint: myPoint to: aFigure at: figurePoint 
	| newFigure |
	newFigure := super 
				connectFromPoint: myPoint
				to: aFigure
				at: figurePoint.
	outgoing at: newFigure put: aFigure.
	newFigure addDependent: self.
	self model connectTo: aFigure model.
	^newFigure! !

!PERTEventFigure methodsFor: 'displaying'!

displayFigureOn: aGraphicsContext 
	super displayFigureOn: aGraphicsContext copy.
	aGraphicsContext
		paint: self lineColor;
		lineWidth: self lineWidth.
	self bounds displayStrokedOn: aGraphicsContext! !

!PERTEventFigure methodsFor: 'initialize-release'!

initialize
	super initialize.
	model := PERTEventAppModel new.
	self view: (model allButOpenInterface: #windowSpec) window component
		in: (0 @ 0 corner: 100 @ 90).
	self opaque.
	outgoing := IdentityDictionary new! !

!PERTEventFigure methodsFor: 'testing'!

isConnectedTo: aFigure 
	^self == aFigure 
		or: [outgoing contains: [:each | each isConnectedTo: aFigure]]! !


DrawingEditor subclass: #PERTChart
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-PERTChart'!
PERTChart comment:
'PERTChart is the DrawingEditor for the PERTChart application.

PERTChart open

'!


!PERTChart methodsFor: 'drawing description'!

toolNames
	"Return the list of names for the tools."

	^(super toolNames asOrderedCollection)
		add: nil;
		add: 'Pert Event Tool';
		yourself! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

PERTChart class
	instanceVariableNames: ''!


!PERTChart class methodsFor: 'resources'!

pertEventIcon
	^OpaqueImage figure: self pertEventIconImage shape: self pertEventIconMask!

pertEventIconImage
	"UIMaskEditor new openOnClass: self andSelector: #pertEventIconImage"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[255 255 0 0 255 255 0 0 255 255 0 0 255 255 0 0 128 1 0 0 191 253 0 0 160 125 0 0 191 253 0 0 160 69 0 0 191 253 0 0 160 69 0 0 191 253 0 0 128 1 0 0 255 255 0 0 255 255 0 0 255 255 0 0])!

pertEventIconMask
	"UIMaskEditor new openOnClass: self andSelector: #pertEventIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 254 0 0 127 254 0 0 127 254 0 0 127 254 0 0 127 254 0 0 127 254 0 0 127 254 0 0 127 254 0 0 127 254 0 0 0 0 0 0 0 0 0 0 0 0 0 0])! !


!Tool class methodsFor: 'tool states'!

initializePERTTool
	"This method was automatically generated by the HotDraw ToolStateMachineEditor.
	To edit this method, evaluate the comment below"

	"| states transitions stateTable |
	states := ((OrderedCollection new) add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Pert Event Tool'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 183 y: 70); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Create Pert Figure'; instVarAt: 3 put: (Text string: '[:tool :event | 
tool drawing add: 
	(PERTEventFigure createAt: (tool cursorPointFor: event))]' runs: (RunArray runs: #(94) values: #(nil))); instVarAt: 4 put: (Point x: 180 y: 180); instVarAt: 5 put: true; instVarAt: 6 put: false; yourself); yourself).
	stateTable := Dictionary new.
	states do: [:each | stateTable at: each name put: each].

	transitions := OrderedCollection new.
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Pert Event Tool'); to: (stateTable at: 'Create Pert Figure'); type: (TransitionType basicNew instVarAt: 1 put: #redButtonPress; yourself); points: ((OrderedCollection new) add: (Point x: 232 y: 101); add: (Point x: 236 y: 180); yourself); yourself).
	ToolStateMachineEditor openWithStates: states connections: transitions"

	Tool states at: 'Pert Event Tool' put: (ToolState name: 'Pert Event Tool' command: [:tool :event | ]).
	Tool states at: 'Create Pert Figure' put: (EndToolState name: 'Create Pert Figure' command: [:tool :event | 
tool drawing add: 
	(PERTEventFigure createAt: (tool cursorPointFor: event))]).
	(Tool stateFor: 'Pert Event Tool') redButtonPress: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Create Pert Figure'); yourself).! !


ApplicationModel subclass: #PERTEventAppModel
	instanceVariableNames: 'durationHolder endDateHolder nameHolder incoming outgoing '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-PERTChart'!
PERTEventAppModel comment:
'PERTEventAppModel is an ApplicationModel that represents an individual event.

Instance Variables:
	durationHolder	<ValueHolder on: Number>	how long does this event last
	endDateHolder	<ValueHolder on: Number>	when do we end
	incoming	<Collection of: PERTEventAppModel>	events that must occur before us
	nameHolder	<ValueHolder on: String>	our name
	outgoing	<Collection of: PERTEventAppModel>	events that occur after us

'!


!PERTEventAppModel methodsFor: 'accessing'!

addIncoming: aPertEventAppModel 
	aPertEventAppModel addDependent: self.
	incoming add: aPertEventAppModel.
	self updateEndDate!

connectTo: aPertEventAppModel
	outgoing add: aPertEventAppModel.
	aPertEventAppModel addIncoming: self!

disconnectFrom: aPertEventAppModel 
	outgoing remove: aPertEventAppModel ifAbsent: [].
	aPertEventAppModel removeIncoming: self!

duration
	^self durationHolder value!

endDate
	^self endDateHolder value!

removeIncoming: aPertEventAppModel 
	aPertEventAppModel removeDependent: self.
	incoming remove: aPertEventAppModel ifAbsent: [].
	self updateEndDate!

startDate
	^incoming inject: 0 into: [:sum :each | sum max: each endDate]! !

!PERTEventAppModel methodsFor: 'aspects'!

durationHolder
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^durationHolder isNil
		ifTrue:
			[durationHolder := 0 asValue]
		ifFalse:
			[durationHolder]!

endDateHolder
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^endDateHolder isNil
		ifTrue:
			[endDateHolder := 0 asValue]
		ifFalse:
			[endDateHolder]!

nameHolder
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^nameHolder isNil
		ifTrue:
			[nameHolder := String new asValue]
		ifFalse:
			[nameHolder]! !

!PERTEventAppModel methodsFor: 'changing'!

update: anAspect with: anArg from: anObject 
	self updateEndDate!

updateEndDate
	self endDateHolder value: self startDate + self duration! !

!PERTEventAppModel methodsFor: 'initialize-release'!

initialize
	super initialize.
	incoming := OrderedCollection new.
	outgoing := OrderedCollection new.
	self endDateHolder onChangeSend: #changed to: self.
	self durationHolder onChangeSend: #updateEndDate to: self! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

PERTEventAppModel class
	instanceVariableNames: ''!


!PERTEventAppModel class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Unlabeled Canvas' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 791 610 895 703 ) 
			#colors: 
			#(#LookPreferences 
				#setBackgroundColor: #(#ColorValue 7700 7700 7700 ) ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 1 0 1 0 -1 1 29 0 ) 
					#name: #nameHolder 
					#model: #nameHolder ) 
				#(#LabelSpec 
					#layout: #(#Point 1 30 ) 
					#label: 'Duration:' ) 
				#(#LabelSpec 
					#layout: #(#Point 1 61 ) 
					#label: 'End date:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0.666666 31 0 -1 1 58 0 ) 
					#name: #durationHolder 
					#model: #durationHolder 
					#alignment: #right 
					#type: #number ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 0 0.666666 60 0 -1 1 89 0 ) 
					#name: #endDateHolder 
					#model: #endDateHolder 
					#alignment: #right 
					#isReadOnly: true 
					#type: #number ) ) ) )! !


