'From VisualWorks(R), Release 2.5.1 of September 26, 1995 on January 8, 1998 at 8:26:33 am'!



DrawingEditor subclass: #ObjectWorld
	instanceVariableNames: 'parser commandText '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-ObjectWorld'!
ObjectWorld comment:
'I am the model in an ObjectWorld application.  I am like a subclass of both ValueHolder and DrawingEditor, because one of my views is a ComposedTextView and the other one is a DrawingView.  However, I copy code from DrawingEditor and am a subclass of ValueHolder.

In ObejctWorld, if a user types ''''self doSomething'''' the message gets sent to me.  Things users are allowed to do are all contained in my ''''public'''' protocol.  Special commands are trapped in the ''''private'''' protocol (i.e. ''''self remove'''' which does *not* remove ObjectWorld).

ObjectParser and ObjectWorldMetaFigure are the other important classes of the ObjectWorld application.  ObjectParser is the controller of the text pane, and it parses user input and directs messages to the ObjectWorld, to the drawing, and to the individual figures in the drawing.  ObjectWorldMetaFigure implements ObjectWorld-specific protocol for figures.  

Instance variables:
parser :-
	The object parsing ObjectWorld commands is also the controller of our text pane.
drawingView	The view of our drawing, needed for flashing, etc.
drawing	The ObjectWorldDrawing. 

tools, currentTool, fileName:	variables from DrawingEditor'!


!ObjectWorld methodsFor: 'accessing'!

parser
	^parser! !

!ObjectWorld methodsFor: 'aspects'!

commandText
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^commandText isNil
		ifTrue:
			[commandText := String new asValue]
		ifFalse:
			[commandText]!

subcanvas
	^self! !

!ObjectWorld methodsFor: 'drawing description'!

drawingClass
	^ObjectWorldDrawing!

windowName
	^'Object World'! !

!ObjectWorld methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	| editor oldController |
	super postBuildWith: aBuilder.
	editor := (builder componentAt: #commandText) widget.
	oldController := editor controller.
	editor controller: (parser := (ObjectParser new)
						drawingEditor: self;
						keyboardProcessor: oldController keyboardProcessor;
						yourself)! !

!ObjectWorld methodsFor: 'ObjectParser protocol'!

register: anObject as: aString
	parser register: anObject as: aString!

unregister: anObject
	parser unregister: anObject! !

!ObjectWorld methodsFor: 'private'!

remove
	"Catch an attempt by the user to do a 'self remove!!!!' from the
	ObjectWorld text window."

	parser view flash! !

!ObjectWorld methodsFor: 'public'!

clearAnimation
	"Clear list of figures being animated"

	drawing stopAll!

pause
	"Temporarily pause animation"

	drawing pause!

refresh
	"If the screen has gotten out of sync refresh it"

	drawing repairDamage!

resume
	"Restart animation"

	drawing resume!

setFont: aFontSize 
	"set a new font for everything in the Universe"

	TextAttributes setDefaultTo: aFontSize asSymbol.
	TextAttributes resetViews!

who
	"Show the objects we know about"

	| mb |
	mb := MenuBuilder new.
	parser keys do: [:each | mb add: each -> each].
	mb menu startUp! !

!ObjectWorld methodsFor: 'user interface'!

browse
	"Browse only the methods users are allowed to see"

	Browser openProtocolBrowserOn: ((Browser new)
				onClass: self class;
				protocol: #public;
				yourself)! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ObjectWorld class
	instanceVariableNames: ''!


!ObjectWorld class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Object World' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 597 461 1084 900 ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 0.3 ) 
					#name: #commandText 
					#model: #commandText ) 
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 0 0 28 0.3 0 1 0 1 ) 
					#component: #drawing ) 
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 0 0 0 0.3 0 1 28 0.3 ) 
					#flags: 0 
					#component: #toolbar ) ) ) )! !


TextEditorController subclass: #ObjectParser
	instanceVariableNames: 'bindings drawingEditor '
	classVariableNames: ''
	poolDictionaries: 'TextConstants '
	category: 'HotDraw-ObjectWorld'!
ObjectParser comment:
'This is the parser and controller for the StringHolder part of ObjectWorld.   Hacks have been added to ''''access'''' and doItProcessing to allow user''''s to enter text such as ''''fred moveRight!!!!'''' and have the ''''!!!!'''' cause a doIt.

Instance Variables
bindings :-
	A dictionary of all of the named objects that we currently know about.  This dictionary always contains a binding to map ''''self'''' to our model (i.e. an ObjectWorld object)

'!


!ObjectParser methodsFor: 'initialize-release'!

drawingEditor: aModel 
	bindings at: 'self' put: aModel.
	drawingEditor := aModel!

initialize
	| table |
	super initialize.
	bindings := Dictionary new.
	table := self dispatchTable.
	table 
		bindValue: #selectAndDoItKey:
		to: ESC
		followedBy: ESC.
	dispatchTable := table!

initializeMenu
	menuHolder := (Menu 
				labelList: #(#(#again #undo) #(#copy #cut #paste) #(#browse) #('do it' 'print it' 'inspect') #(#accept #cancel) #(#hardcopy))
				values: #(#again #undo #copySelection #cut #paste #browse #doIt #printIt #inspectIt #accept #cancel #hardcopy)) 
					asValue! !

!ObjectParser methodsFor: 'private'!

browse
	drawingEditor browse!

evaluateSelection
	"Evaluate the current text selection as an expression "

	| result selectionStart oldTextSize selection |
	selectionStart := self selectionStartIndex.
	oldTextSize := self text size.
	selection := self selection.
	result := WorkspaceCompiler new 
				evaluate: self selectionAsStream
				inWorkspace: bindings
				receiver: drawingEditor
				notifying: self
				ifFail: [].
	self selection asString = selection asString 
		ifFalse: 
			[self selectFrom: selectionStart
				to: selectionStart + selection size - 1 + (self text size - oldTextSize)	"Reselect doIt range after compiler interaction"].	"Smalltalk logChange: self selection string."
	^result!

selectAndDoItKey: aKey 
	"Select the text that has been typed recently and DoIt"

	self selectCurrentTypeInKey: aKey.
	self evaluateSelection! !

!ObjectParser methodsFor: 'registration'!

keys
	"Return all of the keys we have bindings for"

	^bindings keys!

register: anObject as: aString 
	"Register aString as a pointer to anObject"

	bindings at: aString asSymbol put: anObject!

unregister: anObject 
	"Remove anObject from the binding list"

	bindings removeKey: anObject model name asSymbol! !


Model subclass: #ObjectWorldFigureModel
	instanceVariableNames: 'figure name animationMethods model pause stayVisible '
	classVariableNames: 'DebugFlag DefaultMovement DefaultOrbit '
	poolDictionaries: ''
	category: 'HotDraw-ObjectWorld'!
ObjectWorldFigureModel comment:
'a MetaFigure for the ObjectWorld application.
=========================
Assumes that a figure must implement :
	rotateBy:     Rotate the figure by the given angle.

Instance Variables:

name <String>
    The name of the figure in the ObjectWorld.  This is the string associated with the figure by the user.

animationMethods  <Collection>
    A collection of the method the figure should apply to itself to perform a step in its animation.

model <ObjectParser>
   The ObjectWorld that the figure belongs to.

pause <Boolean>
   Indicator for the figure as to whether or not it will perform its animation step.  This allows each figure to control whether or not it wants to perform a step in its
   animation.

stayVisible <Boolean>
   Indicator telling the figure if it should stay within the visible bounds given to it as part of an animation step.  

Class Variables:
DebugFlag <Boolean>
   Indicator telling the figure to perform debug operations.

DefaultGrow <Integer>
   Amount to grow a figure when the grow or shrink message is sent to a figure.  

DefaultRotate <Float>
   Angle to rotate a figure when the turnRight or turnLeft message is sent to a figure.

DefaultMovement <Integer>
   Amount to move a figure when it is sent the moveLeft, moveRight, moveUp, or moveDown messages are sent to it.

DefaultOrbit <Float>
   Angle to rotate the figure around the object it is orbiting.

DefaultSize <Integer>
   Size in pixels to create the initial figure.'!


!ObjectWorldFigureModel methodsFor: 'accessing'!

menu
	| mb |
	mb := MenuBuilder new.
	mb add: 'Rename...' -> #rename.
	^mb menu! !

!ObjectWorldFigureModel methodsFor: 'animating'!

animate: aMethod 
	"Add aMethod to the list of methods to invoke for animation on this 
	figure. aMethod is either a block or the name of a message to send."

	| block |
	block := aMethod isSymbol 
				ifTrue: 
					[(self respondsTo: aMethod) 
						ifTrue: [[:fig | fig perform: aMethod]]
						ifFalse: [^self error: aMethod , ' is an illegal message']]
				ifFalse: [aMethod].
	animationMethods addFirst: block!

checkVisible: drawingBounds oldBounds: oldBounds 
	| newBox xDirection yDirection |
	stayVisible ifFalse: [^self].
	newBox := self bounds.
	xDirection := newBox left - oldBounds left.
	yDirection := newBox top - oldBounds top.
	xDirection < 0 & (newBox right < drawingBounds left) 
		ifTrue: [self translateBy: (drawingBounds width + newBox width) @ 0].
	xDirection > 0 & (newBox left > drawingBounds right) 
		ifTrue: [self translateBy: (drawingBounds width + newBox width) negated @ 0].
	yDirection < 0 & (newBox bottom < drawingBounds top) 
		ifTrue: [self translateBy: 0 @ (drawingBounds height + newBox height)].
	yDirection > 0 & (newBox top > drawingBounds bottom) 
		ifTrue: [self translateBy: 0 @ (drawingBounds height + newBox height) negated]!

home
	"Tell this Figure to move to the center of the visible part of the view. "

	| newCenter bounds |
	bounds := model drawing bounds.
	newCenter := bounds center - self center.
	figure translateBy: newCenter!

pause
	"Suspend animation for this Figure."

	pause := true!

resume
	"Begin animation for this Figure."

	pause := false!

stayVisible
	"Require that this Figure stay within the visible part of the view."

	stayVisible := true!

stepIn: drawingBounds 
	"Perform all the methods in the animation list on this Figure. This is 
 	meant to move the figure one step through its animation. If the pause
 	indicator is set, skip animation for this figure. If animation is to occur, 
	then once it has moved through one step, see if the figure is supposed 
	to stay within the visible bounds of drawing that were passed in. If so, 
	make sure the user can still see the figure, if not, move it to the opposite 
	side of the drawing based on the direction the figure is traveling in."

	| oldBounds |
	oldBounds := self bounds.
	pause ifTrue: [^self].
	animationMethods do: [:method | method value: self].
	self checkVisible: drawingBounds oldBounds: oldBounds!

stop
	"Stop all the methods in the animation list on this Figure. This is an 
	   ObjectWorld extension. This method is intended to be invoked 
 	 by the ObjectWorld user."

	[animationMethods isEmpty] whileFalse: [animationMethods removeFirst]!

stop: aMethod 
	"Stop the given method from the animation list for the figure. 
	   This is an ObjectWorld extension. This method is intended to be invoked 
 	 by the ObjectWorld user."

	| methodSymbol |
	methodSymbol := aMethod asSymbol.
	(animationMethods includes: methodSymbol) 
		ifTrue: [animationMethods remove: methodSymbol ifAbsent: []]!

unbounded
	stayVisible := false! !

!ObjectWorldFigureModel methodsFor: 'figure'!

bounds
	^figure bounds!

center
	^figure center!

changed
	^figure changed!

damage
	^figure damage!

number
	^figure number!

number: aNumber
	^figure number: aNumber!

translateBy: aPoint
	^figure translateBy: aPoint! !

!ObjectWorldFigureModel methodsFor: 'initialize-release'!

figure
	^figure!

figure: aFigure
	figure := aFigure!

initialize
	"Create the animation list, start the figure out with pausing turned off
	   and let it roam outside the visible part of the drawing. "

	animationMethods := OrderedCollection new.
	pause := false.
	stayVisible := false!

model: aModel
	model := aModel!

name
	"Return the name of the figure."

	^name!

name: aString 
	"Register the receiver with the local model. Check if the receiver has been registered 
	before (i.e. if the receiver already has a non-null name), in which case the receiver 
	must unregister itself before re-registering under the new name."

	name isNil ifFalse: [model unregister: self].
	model register: self as: aString.
	name := aString! !

!ObjectWorldFigureModel methodsFor: 'private'!

doesNotUnderstand: aMessage 
	"Override the same method in the Object class to allow us to
	signal the user that they made an error by flashing the view,
	rather than by raising an exception and popping up a window."

	self class debugFlag 
		ifTrue: [^super doesNotUnderstand: aMessage]
		ifFalse: [model parser view flash]!

rename
	"Let the ObjectWorld user change the name of the receiver with a dialogue."

	| newname defaultName |
	defaultName := name isNil ifTrue: [''] ifFalse: [name].
	newname := Dialog request: 'Enter name of object:'
				initialAnswer: defaultName.
	self name: newname! !

!ObjectWorldFigureModel methodsFor: 'removing'!

remove
	"Remove the receiving Figure from its Drawing."

	figure changed.
	self unregister.
	model drawing remove: self!

unregister
	"Remove the receiving Figure from its Drawing."

	model unregister: self! !

!ObjectWorldFigureModel methodsFor: 'transforming'!

moveDown
	"Move the receiving Figure downwards the default distance."

	self moveDown: self class defaultMovement!

moveDown: anInteger 
	"Move the receiving Figure downwards the specified distance.
	Intended for the ObjectWorld user."

	self translateBy: 0 @ anInteger!

moveLeft
	"Move the receiving Figure left the default distance.
	Intended for the ObjectWorld user."

	self moveLeft: self class defaultMovement!

moveLeft: anInteger 
	"Move the receiving Figure left the specified distance.
	Intended for the ObjectWorld user."

	self translateBy: anInteger negated @ 0!

moveRight
	"Move the receiving Figure right the default distance.
	Intended for the ObjectWorld user."

	self moveRight: self class defaultMovement!

moveRight: anInteger 
	"Move the receiving Figure right the specified distance.
	Intended for the ObjectWorld user."

	self translateBy: anInteger @ 0!

moveUp
	"Move the receiving Figure upwards the default distance. 
	Intended for the ObjectWorld user."

	self moveUp: self class defaultMovement!

moveUp: anInteger 
	"Move the receiving Figure upwards the specified distance. 
	Intended for the ObjectWorld user."

	self translateBy: 0 @ anInteger negated!

orbit: aFigure 
	"Make the receiving Figure move in an 'orbit' around aFigure. 
	To do this, we rotate the receiver about the center of aFigure.
	This is an ObjectWorld user method."

	| deltaX deltaY sin cos newX newY |
	deltaX := (self center x - aFigure center x) asDouble.
	deltaY := (self center y - aFigure center y) asDouble.
	sin := self class defaultOrbit sin.
	cos := self class defaultOrbit cos.
	newX := aFigure center x + (deltaX * cos) - (deltaY * sin) - self center x.
	newY := aFigure center y + (deltaY * cos) + (deltaX * sin) - self center y.
	figure translateBy: newX @ newY! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ObjectWorldFigureModel class
	instanceVariableNames: ''!


!ObjectWorldFigureModel class methodsFor: 'accessing'!

debugFlag
	^DebugFlag!

debugFlag: aBoolean 
	"Control the class' DebugFlag: if true, then handle doesNotUnderstand 
	messages in the usual way, i.e. raise an exception. If false (the default), 
	then override doesNotUnderstand: to just flash the view to signal the 
	error to the user."

	DebugFlag := aBoolean!

defaultMovement
	"Return the default amount of movement for a figure"

	^DefaultMovement!

defaultMovement: anInteger 
	"Set the default amount of movement for a figure to anInteger"

	DefaultMovement := anInteger!

defaultOrbit
	^DefaultOrbit!

defaultOrbit: aFloat 
	DefaultOrbit := aFloat! !

!ObjectWorldFigureModel class methodsFor: 'class initialization'!

initialize
	"self initialize"

	"Initialize the class defaults for movement, etc."

	DebugFlag := false.
	DefaultMovement := 10.
	DefaultOrbit := 0.0872665! !

!ObjectWorldFigureModel class methodsFor: 'instance creation'!

new
	^super new initialize!

on: aFigure 
	| model |
	model := self new.
	model figure: aFigure.
	aFigure model: model! !


AnimatedDrawing subclass: #ObjectWorldDrawing
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-ObjectWorld'!
ObjectWorldDrawing comment:
'I am  a Drawing (from HotDraw) that provides a number of instance methods for ObjectWorld animation control.'!


!ObjectWorldDrawing methodsFor: 'adding'!

add: aFigure 
	ObjectWorldFigureModel on: aFigure.
	aFigure model model: self model.
	^super add: aFigure! !

!ObjectWorldDrawing methodsFor: 'animating'!

pause
	"Pause the animation on all Figures in the receiving Drawing."

	self components do: [:each | each model notNil ifTrue: [each model pause]]!

resume
	"Resume animation on all Figures in the receiving Drawing. 
	(This is the opposite of pause.)"

	self components 
		do: [:each | each model notNil ifTrue: [each model resume]]!

step
	"Tell each Figure in the receiving Drawing to perform 
	one step in its animation sequence (if any)."

	self components 
		do: [:each | each model notNil ifTrue: [each model stepIn: self bounds]]!

stopAll
	"Shut off animation and delete the list of animation steps for
	all Figures in the receiving Drawing."

	self components do: [:each | each model notNil ifTrue: [each model stop]]! !


Compiler subclass: #WorkspaceCompiler
	instanceVariableNames: 'workspaceDictionary '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-ObjectWorld'!
WorkspaceCompiler comment:
'I am a compiler for an object that is a workspace, i.e. it has its own
set of variables that can be named by the code I evaluate.  You should
only use me to evaluate strings using my public access protocol.  My
inherited public access protocol has not been tested and probably
does not work.'!


!WorkspaceCompiler methodsFor: 'private'!

scopeForClass
	"Return a scope for the workspace. This is a carefully placed hack."

	| scope |
	scope := StaticScope variables: workspaceDictionary.
	scope outerScope: NameScope global.
	^scope! !

!WorkspaceCompiler methodsFor: 'public access'!

evaluate: textOrStream inWorkspace: aDict receiver: receiver notifying: aRequestor ifFail: failBlock 
	"Evaluate an expression binding the receiver to self and using aDict as a global dictionary of names.
	The idea is that aDict is a workspace context of some sort, and receiver
	might be the workspace."

	workspaceDictionary := aDict.
	^self 
		evaluate: textOrStream
		in: nil
		receiver: receiver
		notifying: aRequestor
		ifFail: failBlock! !

ObjectWorldFigureModel initialize!


