'From VisualWorks(R), Release 2.5.1 of September 26, 1995 on January 8, 1998 at 8:24:23 am'!



CachedFigure subclass: #NetworkNode
	instanceVariableNames: 'name '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Network Drawing'!


!NetworkNode methodsFor: 'accessing'!

name
	^name! !

!NetworkNode methodsFor: 'connection'!

connectionFigureClass
	^PolylineFigure! !

!NetworkNode methodsFor: 'displaying'!

fillCache
	| title aGC rect |
	title := name asComposedText.
	cache := Pixmap extent: title extent + (2 @ 4).
	aGC := cache graphicsContext.
	aGC medium background: LookPreferences defaultForWindows backgroundColor.
	aGC paint: ColorValue white.
	rect := 0 @ 0 extent: cache extent - (2 @ 2).
	aGC displayRectangle: rect.
	aGC paint: ColorValue black.
	title displayOn: aGC at: 0 @ 2.
	aGC displayRectangularBorder: rect.
	^cache asImage! !

!NetworkNode methodsFor: 'initialize-release'!

name: aName 
	name := aName.
	self initialize! !

!NetworkNode methodsFor: 'printing'!

printOn: aStream 
	aStream
		nextPutAll: name;
		nextPutAll: ' at: ';
		print: self origin! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

NetworkNode class
	instanceVariableNames: ''!


!NetworkNode class methodsFor: 'instance creation'!

name: aName
	^self new name: aName! !


DrawingEditor subclass: #NetworkEditor
	instanceVariableNames: 'nodes edgeWeights nodeList2 nodeList1 textEditor '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Network Drawing'!
NetworkEditor comment:
'Network editors are a good example of embedding HotDraw in a larger
MVC application, and of how to do animation in HotDraw.  The idea
is that you create a set of nodes and can assign weights to the edges
between the nodes.  An edge with weight zero doesn''''t exist.  The
drawing rearranges itself so that edges act like springs, and nodes
with high-weight edges are closer together than nodes with low-weight
edges.  

nodes   <Collection of: NetworkNode>
edgeWeights <Dictionary from: Figure to: Number>
node1, node2 <NetworkNode>  the selected nodes

NetworkEditor open'!


!NetworkEditor methodsFor: 'aspects'!

nodeList1
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^nodeList1 isNil
		ifTrue:
			[nodeList1 := SelectionInList new]
		ifFalse:
			[nodeList1]!

nodeList2
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^nodeList2 isNil
		ifTrue:
			[nodeList2 := SelectionInList new]
		ifFalse:
			[nodeList2]!

textEditor
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^textEditor isNil
		ifTrue:
			[textEditor := String new asValue]
		ifFalse:
			[textEditor]! !

!NetworkEditor methodsFor: 'drawing description'!

drawingClass
	^NetworkDrawing!

windowName
	^'Network Editor'! !

!NetworkEditor methodsFor: 'initialize-release'!

initialize
	super initialize.
	nodes := SortedCollection new.
	edgeWeights := Dictionary new.
	self updateLists! !

!NetworkEditor methodsFor: 'nodes'!

addNode
	"Get name of node from user."

	| name |
	name := Dialog request: 'enter name of new node'.
	name isNil ifTrue: [^nil].
	nodes add: name.
	drawing addNode: name.
	self updateLists!

deleteNode1
	nodes remove: self node1 ifAbsent: [].
	drawing removeNode: self node1.
	self updateLists!

deleteNode2
	nodes remove: self node2 ifAbsent: [].
	drawing removeNode: self node2.
	self updateLists!

nodeMenu1
	"Answer a Menu for the node list panes."

	^Menu
			labels: 'add node\delete node' withCRs
			lines: #( )
			values: #(#addNode #deleteNode1 )!

nodeMenu2
	"Answer a Menu for the node list panes."

	^Menu
			labels: 'add node\delete node' withCRs
			lines: #( )
			values: #(#addNode #deleteNode2 )!

updateLists
	| selection |
	selection := self nodeList1 selection.
	self nodeList1 list: nodes asList.
	self nodeList1 selection: selection.
	selection := self nodeList2 selection.
	self nodeList2 list: nodes asList.
	self nodeList2 selection: selection! !

!NetworkEditor methodsFor: 'private'!

getTableFor: name 
	^edgeWeights at: name ifAbsentPut: [Dictionary new]! !

!NetworkEditor methodsFor: 'updating'!

changedNode
	textEditor value: self weight printString!

update: anAspectSymbol with: aParameter from: aSender 
	anAspectSymbol == #removeNode 
		ifTrue: 
			[nodes remove: aParameter ifAbsent: [].
			edgeWeights removeKey: aParameter ifAbsent: [].
			edgeWeights values do: [:value | value removeKey: aParameter ifAbsent: []].
			self updateLists].
	^super 
		update: anAspectSymbol
		with: aParameter
		from: aSender! !

!NetworkEditor methodsFor: 'weights'!

acceptText: aString from: what
	self weight: aString asNumber.
	^true!

node1
	^self nodeList1 selection!

node2
	^self nodeList2 selection!

textMenu
	"Answer a Menu for the node list panes."

	^Menu
			labels: 'again\undo\copy\cut\paste\accept\cancel' withCRs
			lines: #(2 5 )
			values: #(#again #undo #copySelection #cut #paste #acceptText:from: #cancel )!

weight
	^(edgeWeights at: self node1 ifAbsent: [^0])
		at: self node2 ifAbsent: [0]!

weight: number 
	| node1 node2 |
	node1 := self node1.
	node2 := self node2.
	node1 isNil | node2 isNil ifTrue: [^self].
	(self getTableFor: node1)
		at: node2 put: number.
	(self getTableFor: node2)
		at: node1 put: number.
	drawing
		edgeWeight: number
		from: node1
		to: node2! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

NetworkEditor class
	instanceVariableNames: ''!


!NetworkEditor class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Network' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 285 385 755 708 ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 0.65 ) 
					#name: #drawing 
					#component: #drawing ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0 0 0.65 0 0.333333 0 1 ) 
					#name: #nodeList1 
					#model: #nodeList1 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedNode ) 
					#menu: #nodeMenu1 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 0 0.333333 0 0.65 0 0.666666 0 1 ) 
					#name: #nodeList2 
					#model: #nodeList2 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedNode ) 
					#menu: #nodeMenu2 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 0 0.666666 0 0.65 0 1 0 1 ) 
					#name: #textEditor 
					#model: #textEditor 
					#menu: #textMenu ) ) ) )! !


AnimatedDrawing subclass: #NetworkDrawing
	instanceVariableNames: 'nodes edgeWeights forces '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Network Drawing'!


!NetworkDrawing methodsFor: 'accessing'!

addNode: aName 
	| aNode anOC |
	aNode := NetworkNode name: aName.
	aNode origin: self center.
	nodes add: aNode.
	self add: aNode.
	edgeWeights do: [:oc | oc add: 0].
	anOC := OrderedCollection new: nodes size.
	nodes size timesRepeat: [anOC add: 0].
	edgeWeights add: anOC.
	forces add: 0!

edgeWeight: aNum from: name1 to: name2 
	| i j figure |
	i := self indexOfNode: name1.
	j := self indexOfNode: name2.
	(((edgeWeights at: i) at: j) == 0 and: [aNum ~~ 0]) 
		ifTrue: 
			["Add an edge in the drawing"

			figure := (nodes at: i) 
						connectFromPoint: (nodes at: i) center
						to: (nodes at: j)
						at: (nodes at: j) center.
			self add: figure].
	aNum == 0 ifTrue: [self error: 'Need code to delete edge'].
	(edgeWeights at: i) at: j put: aNum.
	^(edgeWeights at: j) at: i put: aNum!

indexOfNode: name1 
	1 to: nodes size do: [:i | (nodes at: i) name = name1 ifTrue: [^i]].
	self error: name1 , ' is not a node'!

removeNode: aName 
	| index |
	index := self indexOfNode: aName.
	self remove: (nodes at: index)! !

!NetworkDrawing methodsFor: 'animation'!

step
	"Move nodes. Each node repulses others with a force that 
	is inverse to their distance. Some nodes have springs, and 
	the spring force is constant. Not realistic, but it works."

	| center repulsiveConstant stepSize |
	nodes isEmpty ifTrue: [^self].
	center := self center.
	repulsiveConstant := (200000 / nodes size sqrt) truncated.
	1 to: forces size do: [:i | forces at: i put: 0 @ 0].
	1 to: nodes size
		do: 
			[:i | 
			| n1 sum center1 |
			n1 := nodes at: i.
			center1 := n1 center.	"Make all nodes attracted to the center of the picture"
			sum := forces at: i.
			center ~= center1 
				ifTrue: [sum := sum + ((center - center1) unitVector * 10)].
			i + 1 to: nodes size
				do: 
					[:j | 
					| n2 delta |
					n2 := nodes at: j.
					delta := center1 - n2 center.
					delta = (0 @ 0) 
						ifFalse: 
							[| spring pairForce distance |
							distance := delta x * delta x + (delta y * delta y).
							pairForce := delta unitVector * repulsiveConstant / distance.
							spring := (edgeWeights at: i) at: j.
							spring ~~ 0 
								ifTrue: [pairForce := pairForce - (delta unitVector * spring) truncated].
							sum := sum + pairForce.
							forces at: j put: (forces at: j) - pairForce]].
			forces at: i put: sum].
	stepSize := forces inject: 0
				into: [:max :elem | (elem x abs max: elem y abs) max: max].
	stepSize < 1 ifTrue: [^self].
	nodes with: forces do: [:node :force | node translateBy: force / 10]! !

!NetworkDrawing methodsFor: 'deleting'!

remove: aFigure 
	| index |
	super remove: aFigure.
	aFigure class = NetworkNode ifFalse: [^self].
	self changed: #removeNode with: aFigure name.
	index := self indexOfNode: aFigure name.
	nodes removeAtIndex: index.
	edgeWeights do: [:each | each removeAtIndex: index]! !

!NetworkDrawing methodsFor: 'initialize-release'!

initialize
	super initialize.
	nodes := OrderedCollection new.
	forces := OrderedCollection new.
	edgeWeights := OrderedCollection new! !


