'From VisualWorks(R), Release 2.5.1 of September 26, 1995 on January 8, 1998 at 8:23:17 am'!


AnimatedDrawing subclass: #MovingDrawing
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Moving Drawing'!

MovingDrawing comment:
'MovingDrawing is a simple drawing that shows animation.

'!


!MovingDrawing methodsFor: 'animation'!

step
	"First, calculate the new velocities of each figure by calculating the gravitational
	force that each has on the others."

	self components do: 
			[:fig1 | 
			fig1 force: (self components inject: 0 @ 0
						into: [:sum :fig2 | sum + (fig2 forceOn: fig1)])].
	self components do: [:fig1 | fig1 step]! !

MovingDrawing class
	instanceVariableNames: ''!

DrawingEditor subclass: #MovingDrawingEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Moving Drawing'!

MovingDrawingEditor comment:
'A MovingDrawing is one of the simplest examples of how to do animation.
It simulates objects in orbit around each other, i.e. the n-body
problem.

MovingDrawingEditor open'!


!MovingDrawingEditor methodsFor: 'drawing description'!

drawingClass
	^MovingDrawing!

toolNames
	"Return the list of names for the tools."

	^#('Selection Tool' 
	nil 
	'Delete Tool' 
	'Bring To Front Tool' 
	'Send To Back Tool' 
	nil 
	'Moving Figure Tool')!

windowName
	^'Moving Drawing'! !

MovingDrawingEditor class
	instanceVariableNames: ''!


!MovingDrawingEditor class methodsFor: 'resources'!

movingFigureIcon
	^self rectangleIcon! !

RectangleFigure subclass: #MovingFigure
	instanceVariableNames: 'velocity '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Moving Drawing'!

MovingFigure comment:
'A RectangleFigure with a velocity.

The only instance variable, velocity, is a point that represents the
velocity vector.'!


!MovingFigure methodsFor: 'accessing'!

force: aPoint
	"Apply a force to the object.
	The only effect now is to change the velocity."

	velocity := velocity + aPoint!

forceOn: aBody 
	| delta x y |
	self == aBody ifTrue: [^0 @ 0].
	delta := self center - aBody center.
	x := delta x = 0 ifTrue: [0] ifFalse: [200 / delta x].
	y := delta y = 0 ifTrue: [0] ifFalse: [200 / delta y].
	^delta - (x @ y)!

handles
	^TrackHandle allCornersOf: self!

step
	self translateBy: velocity / 100.0.
	velocity := 0 @ 0! !

!MovingFigure methodsFor: 'initialize-release'!

initialize
	"The figure is initially at rest."

	super initialize.
	velocity := 0 @ 0! !

MovingFigure class
	instanceVariableNames: ''!


!Tool class methodsFor: 'tool states'!

initializeMovingFigureTool
	"This method was automatically generated by the HotDraw ToolStateMachineEditor.
	To edit this method, evaluate the comment below"

	"| states transitions stateTable |
	states := ((OrderedCollection new) add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Moving Figure Tool'; instVarAt: 3 put: (Text string: '[:tool :event | 
tool valueAt: #class put: MovingFigure.
tool cursor: Cursor origin]' runs: (RunArray runs: #(84) values: #(nil))); instVarAt: 4 put: (Point x: 202 y: 60); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Create Origin/Corner Figure'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 182 y: 172); instVarAt: 5 put: false; instVarAt: 6 put: true; yourself); yourself).
	stateTable := Dictionary new.
	states do: [:each | stateTable at: each name put: each].

	transitions := OrderedCollection new.
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Moving Figure Tool'); to: (stateTable at: 'Create Origin/Corner Figure'); type: (TransitionType basicNew instVarAt: 1 put: #redButtonPress; yourself); points: ((OrderedCollection new) add: (Point x: 261 y: 91); add: (Point x: 264 y: 172); yourself); yourself).
	ToolStateMachineEditor openWithStates: states connections: transitions"

	Tool states at: 'Moving Figure Tool' put: (ToolState name: 'Moving Figure Tool' command: [:tool :event | 
tool valueAt: #class put: MovingFigure.
tool cursor: Cursor origin]).
	(Tool stateFor: 'Moving Figure Tool') redButtonPress: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Create Origin/Corner Figure'); yourself).! !


