'From VisualWorks(R), Release 2.5.1 of September 26, 1995 on January 8, 1998 at 8:21:28 am'!



DrawingEditor subclass: #HotPaintEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-HotPaint'!
HotPaintEditor comment:
'This editor is a typical HotDraw editor except that it contains tools for creating CanvasFigures and painting on them.

HotPaintEditor open'!


!HotPaintEditor methodsFor: 'drawing description'!

toolNames
	"Return the list of names for the tools."

	^super toolNames 
		, #(nil 'Hot Paint Canvas Tool' 'Hot Paint Paintbrush Tool' 'Hot Paint Mask Tool' 'Hot Paint Image Tool' 'Hot Paint Erase Tool')!

windowName
	^'Hot Paint Editor'! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

HotPaintEditor class
	instanceVariableNames: ''!


!HotPaintEditor class methodsFor: 'accessing'!

images
	| anArrayOfBits anArrayOfMasks |
	anArrayOfBits := #(#[3 224 7 240 12 24 24 12 48 6 96 2 68 35 192 129 129 1 194 2 83 146 72 38 103 196 48 12 14 24 3 224] #[24 24 60 60 126 126 255 255 255 255 255 255 255 255 255 255 127 254 63 252 31 248 15 248 7 240 3 224 1 192 0 128]).
	anArrayOfMasks := Array new: anArrayOfBits size.
	^(1 to: anArrayOfBits size) collect: 
			[:i | 
			anArrayOfMasks at: i
				put: (Image 
						extent: 16 @ 16
						depth: 1
						palette: (MappedPalette with: ColorValue white with: ColorValue red)
						bits: (anArrayOfBits at: i)
						pad: 8)]!

paintStyles
	| anArrayOfBits anArrayOfMasks |
	anArrayOfBits := #(#[0 0 0 0 0 0 0 0 0 0 4 64 0 0 1 0 0 0 4 64 0 0 0 0 0 0 0 0 0 0 0 0] #[0 0 0 0 0 0 0 0 2 128 0 0 2 72 0 16 0 192 1 0 4 136 2 160 1 0 0 0 0 0 0 0] #[0 0 0 0 0 72 24 72 4 80 1 0 0 64 48 70 30 208 0 96 2 80 0 64 4 8 8 64 16 68 32 2] #[0 64 1 0 4 8 83 16 42 196 36 129 0 72 74 156 66 201 41 0 32 73 2 164 9 16 16 40 3 68 0 0] #[0 0 5 132 43 112 20 188 107 86 89 184 62 164 75 254 30 210 115 76 93 184 54 98 37 84 58 168 77 210 0 0]).
	anArrayOfMasks := Array new: anArrayOfBits size.
	^(1 to: anArrayOfBits size) collect: 
			[:i | 
			anArrayOfMasks at: i
				put: (Image 
						extent: 16 @ 16
						depth: 1
						palette: CoveragePalette monoMaskPalette
						bits: (anArrayOfBits at: i)
						pad: 8)]! !

!HotPaintEditor class methodsFor: 'resources'!

hotPaintCanvasIcon
	"UIMaskEditor new openOnClass: self andSelector: #hotPaintCanvasIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 4) at: 1 put: ColorValue black; at: 2 put: ColorValue red; at: 3 put: ColorValue blue; at: 4 put: ColorValue white; yourself)) usingBits: #[0 0 0 0 63 255 255 252 63 255 243 252 63 255 204 252 63 255 243 252 61 247 255 252 61 87 255 252 61 87 255 232 63 95 255 168 63 255 254 172 63 255 250 188 63 255 234 252 63 255 171 252 63 255 175 252 63 255 255 252 0 0 0 0])!

hotPaintEraseIcon
	^OpaqueImage figure: self hotPaintEraseImage
		shape: self hotPaintEraseMask!

hotPaintEraseImage
	"UIMaskEditor new openOnClass: self andSelector: #hotPaintEraseImage"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: (ColorValue red: 3/4 green: 3/4 blue: 0); at: 3 put: ColorValue yellow; at: 4 put: ColorValue white; at: 5 put: (ColorValue red: 3/4 green: 3/4 blue: 3/4); yourself)) usingBits: #[51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 48 0 0 3 51 51 51 51 3 35 35 32 51 51 51 48 50 50 50 0 51 51 51 3 35 35 32 16 51 51 48 50 50 50 1 16 51 51 3 35 35 32 17 3 51 48 50 50 50 1 16 51 51 4 68 68 64 17 3 51 51 4 68 68 64 16 51 51 51 4 68 68 64 3 51 51 51 48 0 0 0 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51 51])!

hotPaintEraseMask
	"UIMaskEditor new openOnClass: self andSelector: #hotPaintEraseMask"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 0 0 0 0 0 0 0 0 126 0 0 0 255 0 0 1 255 0 0 3 255 0 0 7 255 0 0 15 254 0 0 31 252 0 0 63 248 0 0 63 240 0 0 63 224 0 0 31 192 0 0 0 0 0 0 0 0 0 0])!

hotPaintImageIcon
	^OpaqueImage figure: self hotPaintImageImage
		shape: self hotPaintImageMask!

hotPaintImageImage
	"UIMaskEditor new openOnClass: self andSelector: #hotPaintImageImage"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[255 255 0 0 254 63 0 0 252 31 0 0 252 31 0 0 254 63 0 0 255 127 0 0 255 127 0 0 240 7 0 0 255 127 0 0 255 127 0 0 255 127 0 0 255 127 0 0 254 191 0 0 253 223 0 0 251 239 0 0 247 247 0 0])!

hotPaintImageMask
	"UIMaskEditor new openOnClass: self andSelector: #hotPaintImageMask"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 1 192 0 0 3 224 0 0 3 224 0 0 1 192 0 0 0 128 0 0 0 128 0 0 15 248 0 0 0 128 0 0 0 128 0 0 0 128 0 0 0 128 0 0 1 64 0 0 2 32 0 0 4 16 0 0 8 8 0 0])!

hotPaintMaskIcon
	^OpaqueImage figure: self hotPaintMaskImage
		shape: self hotPaintMaskMask!

hotPaintMaskImage
	"UIMaskEditor new openOnClass: self andSelector: #hotPaintMaskImage"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 3) at: 1 put: ColorValue black; at: 2 put: ColorValue red; at: 3 put: ColorValue white; yourself)) usingBits: #[170 170 169 169 170 170 154 154 170 170 169 169 170 169 154 154 170 38 169 169 170 41 154 154 160 2 169 169 160 2 154 154 160 2 169 169 160 2 170 154 160 2 170 169 160 2 170 170 160 2 170 170 160 2 170 170 160 2 170 170 170 170 170 170])!

hotPaintMaskMask
	"UIMaskEditor new openOnClass: self andSelector: #hotPaintMaskMask"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 17 0 0 0 68 0 0 0 17 0 0 1 68 0 0 10 17 0 0 9 68 0 0 62 17 0 0 62 68 0 0 62 17 0 0 62 4 0 0 62 1 0 0 62 0 0 0 62 0 0 0 62 0 0 0 62 0 0 0 0 0 0 0])!

hotPaintPaintbrushIcon
	^OpaqueImage figure: self hotPaintPaintbrushImage
		shape: self hotPaintPaintbrushMask!

hotPaintPaintbrushImage
	"UIMaskEditor new openOnClass: self andSelector: #hotPaintPaintbrushImage"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 2 bitsPerPixel: 2 palette: (MappedPalette withColors: ((Array new: 3) at: 1 put: ColorValue black; at: 2 put: ColorValue red; at: 3 put: ColorValue white; yourself)) usingBits: #[170 170 170 170 170 170 42 170 170 168 74 170 170 168 74 170 170 168 74 170 170 168 74 170 170 168 74 170 170 161 82 170 170 5 84 42 170 21 85 42 170 0 0 42 170 42 170 42 170 40 138 42 170 40 138 42 168 0 0 170 170 170 170 170])!

hotPaintPaintbrushMask
	"UIMaskEditor new openOnClass: self andSelector: #hotPaintPaintbrushMask"

	<resource: #image>
	^CachedImage on: (Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 0 0 0 0 128 0 0 1 192 0 0 1 192 0 0 1 192 0 0 1 192 0 0 1 192 0 0 3 224 0 0 15 248 0 0 15 248 0 0 15 248 0 0 15 248 0 0 15 248 0 0 15 248 0 0 31 240 0 0 0 0 0 0])! !


Figure subclass: #CanvasFigure
	instanceVariableNames: 'pixmap width '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-HotPaint'!
CanvasFigure comment:
'A CanvasFigure is a concrete subclass that can be painted with painting tools
like the airbrush and paintbrush.  It uses color, too.'!


!CanvasFigure methodsFor: 'accessing'!

menuAt: aPoint 
	| mb |
	mb := MenuBuilder new.
	mb beginSubMenuLabeled: 'Tool Width'.
	#('1 Smallest' '2 Small' '3 Medium' '4 Big' '5 Biggest') with: (1 to: 5)
		do: [:label :i | mb add: label -> [self width: i]].
	mb endSubMenu.
	mb beginSubMenuLabeled: 'Tool Color'.
	#(#black #cyan #red #green #blue #yellow #pink) 
		do: [:each | mb add: each -> [self fillColor: (ColorValue perform: each)]].
	mb endSubMenu.
	^mb menu!

width
	^width!

width: anInteger 
	width := anInteger.
	self changed! !

!CanvasFigure methodsFor: 'damage control'!

changed: anAspectSymbol with: aParameter 
	self resetBounds.
	super changed: anAspectSymbol with: aParameter! !

!CanvasFigure methodsFor: 'displaying'!

displayFigureOn: aGraphicsContext 
	| originForPixmap |
	originForPixmap := self origin.
	self lineWidth > 0 
		ifTrue: 
			[originForPixmap := originForPixmap + self lineWidth.
			aGraphicsContext lineWidth: self lineWidth.
			aGraphicsContext paint: self lineColor.
			aGraphicsContext displayRectangularBorder: self bounds].
	pixmap displayOn: aGraphicsContext at: originForPixmap! !

!CanvasFigure methodsFor: 'initialize-release'!

initialize: aRectangle 
	bounds := aRectangle.
	width := 2.
	self
		lineColor: ColorValue black;
		fillColor: ColorValue black;
		lineWidth: 1;
		resetBounds;
		opaque! !

!CanvasFigure methodsFor: 'painting'!

paintAt: aPoint 
	| aRectangle gc extent |
	extent := self brushWidth @ self brushWidth.
	aRectangle := aPoint - (extent // 2) - self origin extent: extent.
	gc := pixmap graphicsContext paint: self fillColor.
	gc 
		displayWedgeBoundedBy: aRectangle
		startAngle: 0
		sweepAngle: 360.
	self changed!

paintAt: aPoint brushMask: aMask 
	pixmap graphicsContext paint: self fillColor.
	pixmap graphicsContext displayImage: aMask
		at: aPoint - (8 @ 8) - self origin.
	self changed!

paintFrom: startPoint to: endPoint 
	| gc |
	gc := pixmap graphicsContext.
	gc paint: self fillColor.
	gc lineWidth: self brushWidth.
	gc displayLineFrom: startPoint - self origin to: endPoint - self origin.
	self changed! !

!CanvasFigure methodsFor: 'private'!

brushWidth
	^self width ** 2!

resetBounds
	| newPixmap extent |
	extent := self bounds extent - (self lineWidth * 2).
	(extent x <= 0 or: [extent y <= 0]) ifTrue: [extent := 0 @ 0].
	(pixmap notNil and: [extent = pixmap extent]) ifTrue: [^self].
	newPixmap := Pixmap extent: extent.
	pixmap isNil 
		ifFalse: [pixmap displayOn: newPixmap graphicsContext at: 0 @ 0].
	pixmap := newPixmap! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

CanvasFigure class
	instanceVariableNames: ''!


!CanvasFigure class methodsFor: 'instance creation'!

createAt: aPoint
	^self rectangle: (aPoint corner: aPoint)!

rectangle: aRectangle 
	^self new initialize: aRectangle! !


!Tool class methodsFor: 'tool states'!

initializeCanvasToolStates
	"This method was automatically generated by the HotDraw ToolStateMachineEditor.
	To edit this method, evaluate the comment below"

	"| states transitions stateTable |
	states := ((OrderedCollection new) add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Create Origin/Corner Figure'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 59 y: 197); instVarAt: 5 put: false; instVarAt: 6 put: true; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Hot Paint Canvas Tool'; instVarAt: 3 put: (Text string: '[:tool :event | 
tool valueAt: #class put: CanvasFigure.
tool cursor: Cursor origin]' runs: (RunArray runs: #(84) values: #(nil))); instVarAt: 4 put: (Point x: 193 y: 81); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Menu'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 352 y: 199); instVarAt: 5 put: false; instVarAt: 6 put: true; yourself); yourself).
	stateTable := Dictionary new.
	states do: [:each | stateTable at: each name put: each].

	transitions := OrderedCollection new.
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Canvas Tool'); to: (stateTable at: 'Create Origin/Corner Figure'); type: (TransitionType basicNew instVarAt: 1 put: #redButtonPress; yourself); points: ((OrderedCollection new) add: (Point x: 211 y: 106); add: (Point x: 151 y: 197); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Canvas Tool'); to: (stateTable at: 'Menu'); type: (TransitionType basicNew instVarAt: 1 put: #yellowButtonPress; yourself); points: ((OrderedCollection new) add: (Point x: 295 y: 110); add: (Point x: 362 y: 200); yourself); yourself).
	ToolStateMachineEditor openWithStates: states connections: transitions"

	Tool states at: 'Hot Paint Canvas Tool' put: (ToolState name: 'Hot Paint Canvas Tool' command: [:tool :event | 
tool valueAt: #class put: CanvasFigure.
tool cursor: Cursor origin]).
	(Tool stateFor: 'Hot Paint Canvas Tool') redButtonPress: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Create Origin/Corner Figure'); yourself).
	(Tool stateFor: 'Hot Paint Canvas Tool') yellowButtonPress: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Menu'); yourself).!

initializeMaskStates
	"This method was automatically generated by the HotDraw ToolStateMachineEditor.
	To edit this method, evaluate the comment below"

	"| states transitions stateTable |
	states := ((OrderedCollection new) add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Press Mask (HotPaint)'; instVarAt: 3 put: (Text string: '[:tool :event | 
tool valueAt: #figure put: (tool figureAtEvent: event).
tool changeToState: (Tool stateFor: ''Paint Mask (HotPaint)'')
	event: event
]' runs: (RunArray runs: #(149) values: #(nil))); instVarAt: 4 put: (Point x: 111 y: 210); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Paint Mask (HotPaint)'; instVarAt: 3 put: (Text string: '[:tool :event | 
| masks mask figure |
figure := tool valueAt: #figure.
masks := tool valueAt: #masks.
mask := masks at: ((figure width min: masks size) max: 1).
figure paintAt: (tool cursorPointFor: event)
	brushMask: mask]' runs: (RunArray runs: #(224) values: #(nil))); instVarAt: 4 put: (Point x: 125 y: 252); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'End State'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 91 y: 327); instVarAt: 5 put: false; instVarAt: 6 put: true; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Hot Paint Image Tool'; instVarAt: 3 put: (Text string: '[:tool :event | 
tool valueAt: #masks put: HotPaintEditor images]' runs: (RunArray runs: #(65) values: #(nil))); instVarAt: 4 put: (Point x: 76 y: 66); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Hot Paint Mask Tool'; instVarAt: 3 put: (Text string: '[:tool :event | 
tool valueAt: #masks put: HotPaintEditor paintStyles]' runs: (RunArray runs: #(70) values: #(nil))); instVarAt: 4 put: (Point x: 294 y: 74); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Menu'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 452 y: 196); instVarAt: 5 put: false; instVarAt: 6 put: true; yourself); yourself).
	stateTable := Dictionary new.
	states do: [:each | stateTable at: each name put: each].

	transitions := OrderedCollection new.
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Paint Mask (HotPaint)'); to: (stateTable at: 'Paint Mask (HotPaint)'); type: (TransitionType basicNew instVarAt: 1 put: #mouseMove; yourself); points: ((OrderedCollection new) add: (Point x: 256 y: 259); add: (Point x: 309 y: 259); add: (Point x: 309 y: 279); add: (Point x: 262 y: 271); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Paint Mask (HotPaint)'); to: (stateTable at: 'End State'); type: (TransitionType basicNew instVarAt: 1 put: #redButtonRelease; yourself); points: ((OrderedCollection new) add: (Point x: 180 y: 282); add: (Point x: 148 y: 330); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Image Tool'); to: (stateTable at: 'Press Mask (HotPaint)'); type: (FigureTransitionType basicNew instVarAt: 1 put: #redButtonPress; instVarAt: 2 put: ((Array new: 1) at: 1 put: CanvasFigure; yourself); yourself); points: ((OrderedCollection new) add: (Point x: 159 y: 96); add: (Point x: 179 y: 210); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Mask Tool'); to: (stateTable at: 'Press Mask (HotPaint)'); type: (FigureTransitionType basicNew instVarAt: 1 put: #redButtonPress; instVarAt: 2 put: ((Array new: 1) at: 1 put: CanvasFigure; yourself); yourself); points: ((OrderedCollection new) add: (Point x: 334 y: 104); add: (Point x: 203 y: 210); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Mask Tool'); to: (stateTable at: 'Menu'); type: (TransitionType basicNew instVarAt: 1 put: #yellowButtonPress; yourself); points: ((OrderedCollection new) add: (Point x: 373 y: 104); add: (Point x: 464 y: 196); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Image Tool'); to: (stateTable at: 'Menu'); type: (TransitionType basicNew instVarAt: 1 put: #yellowButtonPress; yourself); points: ((OrderedCollection new) add: (Point x: 207 y: 83); add: (Point x: 344 y: 26); add: (Point x: 478 y: 39); add: (Point x: 475 y: 196); yourself); yourself).
	ToolStateMachineEditor openWithStates: states connections: transitions"

	Tool states at: 'Press Mask (HotPaint)' put: (ToolState name: 'Press Mask (HotPaint)' command: [:tool :event | 
tool valueAt: #figure put: (tool figureAtEvent: event).
tool changeToState: (Tool stateFor: 'Paint Mask (HotPaint)')
	event: event
]).
	Tool states at: 'Paint Mask (HotPaint)' put: (ToolState name: 'Paint Mask (HotPaint)' command: [:tool :event | 
| masks mask figure |
figure := tool valueAt: #figure.
masks := tool valueAt: #masks.
mask := masks at: ((figure width min: masks size) max: 1).
figure paintAt: (tool cursorPointFor: event)
	brushMask: mask]).
	Tool states at: 'Hot Paint Image Tool' put: (ToolState name: 'Hot Paint Image Tool' command: [:tool :event | 
tool valueAt: #masks put: HotPaintEditor images]).
	Tool states at: 'Hot Paint Mask Tool' put: (ToolState name: 'Hot Paint Mask Tool' command: [:tool :event | 
tool valueAt: #masks put: HotPaintEditor paintStyles]).
	(Tool stateFor: 'Hot Paint Image Tool') redButtonPress: ((FigureTransitionTable new)  on: CanvasFigure goto: (Tool stateFor: 'Press Mask (HotPaint)'); yourself).
	(Tool stateFor: 'Hot Paint Image Tool') yellowButtonPress: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Menu'); yourself).
	(Tool stateFor: 'Paint Mask (HotPaint)') redButtonRelease: ((SimpleTransitionTable new) goto: (Tool stateFor: 'End State'); yourself).
	(Tool stateFor: 'Paint Mask (HotPaint)') mouseMove: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Paint Mask (HotPaint)'); yourself).
	(Tool stateFor: 'Hot Paint Mask Tool') redButtonPress: ((FigureTransitionTable new)  on: CanvasFigure goto: (Tool stateFor: 'Press Mask (HotPaint)'); yourself).
	(Tool stateFor: 'Hot Paint Mask Tool') yellowButtonPress: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Menu'); yourself).!

initializePaintbrushStates
	"This method was automatically generated by the HotDraw ToolStateMachineEditor.
	To edit this method, evaluate the comment below"

	"| states transitions stateTable |
	states := ((OrderedCollection new) add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Hot Paint Erase Tool'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 93 y: 35); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Hot Paint Paintbrush Tool'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 289 y: 26); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Initial Erase State (HotPaint)'; instVarAt: 3 put: (Text string: '[:tool :event | 
| figure |
figure := tool figureAtEvent: event.
tool valueAt: #color put: figure fillColor.
figure fillColor: ColorValue white.
tool changeToState: (Tool stateFor: ''Start painting (HotPaint)'')
	event: event]' runs: (RunArray runs: #(224) values: #(nil))); instVarAt: 4 put: (Point x: 75 y: 114); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Start painting (HotPaint)'; instVarAt: 3 put: (Text string: '[:tool :event | 
| currentPoint figure |
figure := tool figureAtEvent: event.
currentPoint := tool cursorPointFor: event.
figure paintAt: currentPoint.
tool valueAt: #figure put: figure.
tool valueAt: #lastPoint put: currentPoint
]' runs: (RunArray runs: #(231) values: #(nil))); instVarAt: 4 put: (Point x: 153 y: 175); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Move brush (HotPaint)'; instVarAt: 3 put: (Text string: '[:tool :event | 
| currentPoint |
currentPoint := tool cursorPointFor: event.
(tool valueAt: #figure) paintFrom: (tool valueAt: #lastPoint)
	to: currentPoint.
tool valueAt: #lastPoint put: currentPoint
]' runs: (RunArray runs: #(203) values: #(nil))); instVarAt: 4 put: (Point x: 282 y: 250); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'End painting (HotPaint)'; instVarAt: 3 put: (Text string: '[:tool :event | 
| figure |
figure := tool valueAt: #figure.
figure paintAt: (tool valueAt: #lastPoint).
figure fillColor: (tool valueAt: #color)]' runs: (RunArray runs: #(146) values: #(nil))); instVarAt: 4 put: (Point x: 97 y: 326); instVarAt: 5 put: true; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Initial Paint State (HotPaint)'; instVarAt: 3 put: (Text string: '[:tool :event | 
tool valueAt: #color put: (tool figureAtEvent: event) fillColor.
tool changeToState: (Tool stateFor: ''Start painting (HotPaint)'')
	event: event]' runs: (RunArray runs: #(161) values: #(nil))); instVarAt: 4 put: (Point x: 285 y: 116); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Menu'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 40 y: 184); instVarAt: 5 put: false; instVarAt: 6 put: true; yourself); yourself).
	stateTable := Dictionary new.
	states do: [:each | stateTable at: each name put: each].

	transitions := OrderedCollection new.
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Erase Tool'); to: (stateTable at: 'Initial Erase State (HotPaint)'); type: (FigureTransitionType basicNew instVarAt: 1 put: #redButtonPress; instVarAt: 2 put: ((Array new: 1) at: 1 put: CanvasFigure; yourself); yourself); points: ((OrderedCollection new) add: (Point x: 183 y: 65); add: (Point x: 197 y: 75); add: (Point x: 170 y: 114); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Move brush (HotPaint)'); to: (stateTable at: 'End painting (HotPaint)'); type: (TransitionType basicNew instVarAt: 1 put: #redButtonRelease; yourself); points: ((OrderedCollection new) add: (Point x: 315 y: 279); add: (Point x: 200 y: 327); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Move brush (HotPaint)'); to: (stateTable at: 'Move brush (HotPaint)'); type: (TransitionType basicNew instVarAt: 1 put: #mouseMove; yourself); points: ((OrderedCollection new) add: (Point x: 416 y: 259); add: (Point x: 445 y: 258); add: (Point x: 445 y: 278); add: (Point x: 415 y: 272); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Start painting (HotPaint)'); to: (stateTable at: 'Move brush (HotPaint)'); type: (TransitionType basicNew instVarAt: 1 put: #mouseMove; yourself); points: ((OrderedCollection new) add: (Point x: 257 y: 205); add: (Point x: 327 y: 250); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Start painting (HotPaint)'); to: (stateTable at: 'End painting (HotPaint)'); type: (TransitionType basicNew instVarAt: 1 put: #redButtonRelease; yourself); points: ((OrderedCollection new) add: (Point x: 220 y: 205); add: (Point x: 174 y: 326); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Paintbrush Tool'); to: (stateTable at: 'Initial Paint State (HotPaint)'); type: (FigureTransitionType basicNew instVarAt: 1 put: #redButtonPress; instVarAt: 2 put: ((Array new: 1) at: 1 put: CanvasFigure; yourself); yourself); points: ((OrderedCollection new) add: (Point x: 384 y: 56); add: (Point x: 404 y: 75); add: (Point x: 378 y: 116); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Erase Tool'); to: (stateTable at: 'Menu'); type: (TransitionType basicNew instVarAt: 1 put: #yellowButtonPress; yourself); points: ((OrderedCollection new) add: (Point x: 133 y: 65); add: (Point x: 59 y: 87); add: (Point x: 64 y: 184); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Hot Paint Paintbrush Tool'); to: (stateTable at: 'Menu'); type: (TransitionType basicNew instVarAt: 1 put: #yellowButtonPress; yourself); points: ((OrderedCollection new) add: (Point x: 310 y: 31); add: (Point x: 215 y: 9); add: (Point x: 84 y: 10); add: (Point x: 40 y: 91); add: (Point x: 51 y: 185); yourself); yourself).
	ToolStateMachineEditor openWithStates: states connections: transitions"

	Tool states at: 'Hot Paint Erase Tool' put: (ToolState name: 'Hot Paint Erase Tool' command: [:tool :event | ]).
	Tool states at: 'Hot Paint Paintbrush Tool' put: (ToolState name: 'Hot Paint Paintbrush Tool' command: [:tool :event | ]).
	Tool states at: 'Initial Erase State (HotPaint)' put: (ToolState name: 'Initial Erase State (HotPaint)' command: [:tool :event | 
| figure |
figure := tool figureAtEvent: event.
tool valueAt: #color put: figure fillColor.
figure fillColor: ColorValue white.
tool changeToState: (Tool stateFor: 'Start painting (HotPaint)')
	event: event]).
	Tool states at: 'Start painting (HotPaint)' put: (ToolState name: 'Start painting (HotPaint)' command: [:tool :event | 
| currentPoint figure |
figure := tool figureAtEvent: event.
currentPoint := tool cursorPointFor: event.
figure paintAt: currentPoint.
tool valueAt: #figure put: figure.
tool valueAt: #lastPoint put: currentPoint
]).
	Tool states at: 'Move brush (HotPaint)' put: (ToolState name: 'Move brush (HotPaint)' command: [:tool :event | 
| currentPoint |
currentPoint := tool cursorPointFor: event.
(tool valueAt: #figure) paintFrom: (tool valueAt: #lastPoint)
	to: currentPoint.
tool valueAt: #lastPoint put: currentPoint
]).
	Tool states at: 'End painting (HotPaint)' put: (EndToolState name: 'End painting (HotPaint)' command: [:tool :event | 
| figure |
figure := tool valueAt: #figure.
figure paintAt: (tool valueAt: #lastPoint).
figure fillColor: (tool valueAt: #color)]).
	Tool states at: 'Initial Paint State (HotPaint)' put: (ToolState name: 'Initial Paint State (HotPaint)' command: [:tool :event | 
tool valueAt: #color put: (tool figureAtEvent: event) fillColor.
tool changeToState: (Tool stateFor: 'Start painting (HotPaint)')
	event: event]).
	(Tool stateFor: 'Hot Paint Paintbrush Tool') redButtonPress: ((FigureTransitionTable new)  on: CanvasFigure goto: (Tool stateFor: 'Initial Paint State (HotPaint)'); yourself).
	(Tool stateFor: 'Hot Paint Paintbrush Tool') yellowButtonPress: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Menu'); yourself).
	(Tool stateFor: 'Move brush (HotPaint)') redButtonRelease: ((SimpleTransitionTable new) goto: (Tool stateFor: 'End painting (HotPaint)'); yourself).
	(Tool stateFor: 'Move brush (HotPaint)') mouseMove: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Move brush (HotPaint)'); yourself).
	(Tool stateFor: 'Start painting (HotPaint)') redButtonRelease: ((SimpleTransitionTable new) goto: (Tool stateFor: 'End painting (HotPaint)'); yourself).
	(Tool stateFor: 'Start painting (HotPaint)') mouseMove: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Move brush (HotPaint)'); yourself).
	(Tool stateFor: 'Hot Paint Erase Tool') redButtonPress: ((FigureTransitionTable new)  on: CanvasFigure goto: (Tool stateFor: 'Initial Erase State (HotPaint)'); yourself).
	(Tool stateFor: 'Hot Paint Erase Tool') yellowButtonPress: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Menu'); yourself).! !


