'From VisualWorks(R), Release 2.5.1 of September 26, 1995 on January 8, 1998 at 8:31:20 am'!



Model subclass: #ToolStateTransitionModel
	instanceVariableNames: 'from to type points '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation Models'!


!ToolStateTransitionModel methodsFor: 'accessing'!

from
	^from!

from: aToolStateModel 
	from := aToolStateModel.
	self changed!

label
	^type printString!

points
	^points!

points: aCollection 
	points := aCollection!

to
	^to!

to: aToolStateModel 
	to := aToolStateModel.
	self changed!

type
	^type!

type: aTransitionType 
	type := aTransitionType.
	self changed! !

!ToolStateTransitionModel methodsFor: 'compilation'!

writeContinuedDefinitionOn: codeStream 
	type writeContinuedDefinitionOn: codeStream to: '(Tool stateFor: ''' , to name , ''')'!

writeDefinitionOn: codeStream 
	type writeDefinitionOn: codeStream to: '(Tool stateFor: ''' , to name , ''')'!

writeStoreStringOn: codeStream 
	codeStream
		nextPutAll: ' from: (stateTable at: ''';
		nextPutAll: from name;
		nextPutAll: '''); to: (stateTable at: ''';
		nextPutAll: to name;
		nextPutAll: '''); type: '.
	type storeOn: codeStream.
	codeStream nextPutAll: '; points: '.
	points storeOn: codeStream.
	codeStream nextPutAll: '; yourself'! !

!ToolStateTransitionModel methodsFor: 'initialize-release'!

initialize
	from := to := nil.
	type := TransitionType new! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ToolStateTransitionModel class
	instanceVariableNames: ''!


!ToolStateTransitionModel class methodsFor: 'instance creation'!

new
	^super new initialize! !


Object subclass: #TransitionType
	instanceVariableNames: 'event '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation Models'!


!TransitionType methodsFor: 'accessing'!

characters
	^#()!

characters: aCollection!

event
	^event!

event: aSymbol 
	event := aSymbol!

figureClasses
	^Array with: Figure!

figureClasses: aCollection!

priority
	^SmallInteger maxVal! !

!TransitionType methodsFor: 'compilation'!

writeContinuedDefinitionOn: codeStream to: aString 
	codeStream nextPutAll: '; '.
	self writeMessageSendOn: codeStream to: aString!

writeDefinitionOn: codeStream to: aString 
	codeStream nextPutAll: '(SimpleTransitionTable new) '.
	self writeMessageSendOn: codeStream to: aString!

writeMessageSendOn: codeStream to: aString 
	codeStream
		nextPutAll: 'goto: ';
		nextPutAll: aString! !

!TransitionType methodsFor: 'initialize-release'!

initialize
	event := #redButtonPress! !

!TransitionType methodsFor: 'printing'!

printOn: aStream
	aStream nextPutAll: event! !

!TransitionType methodsFor: 'verifying'!

conflictsWith: aTransitionType 
	^self class == aTransitionType class! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

TransitionType class
	instanceVariableNames: ''!


!TransitionType class methodsFor: 'accessing'!

transition
	^#always! !

!TransitionType class methodsFor: 'instance creation'!

new
	^super new initialize! !


!Figure methodsFor: 'testing'!

isConnectionFigure
	^false!

isStateFigure
	^false! !


ApplicationModel subclass: #ToolStateCommandEditor
	instanceVariableNames: 'source state '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation GUI'!


!ToolStateCommandEditor methodsFor: 'actions'!

acceptCommand
	(self class compilerClass 
		evaluate: self source value
		notifying: (builder componentAt: #source) widget controller
		logged: false) class 
		== [] class ifFalse: [^self].
	state command: self source value.
	self closeRequest! !

!ToolStateCommandEditor methodsFor: 'aspects'!

source
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^source isNil
		ifTrue:
			[source := String new asValue]
		ifFalse:
			[source]! !

!ToolStateCommandEditor methodsFor: 'instance creation'!

state: aToolStateModel 
	state := aToolStateModel.
	self source value: state command! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ToolStateCommandEditor class
	instanceVariableNames: ''!


!ToolStateCommandEditor class methodsFor: 'instance creation'!

state: aToolStateModel 
	^(self new)
		state: aToolStateModel;
		yourself! !

!ToolStateCommandEditor class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Tool state command editor' 
			#bounds: #(#Rectangle 585 446 1017 757 ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#LabelSpec 
					#layout: #(#Point 5 5 ) 
					#label: 'Command:' ) 
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 5 0 30 0 -5 1 -50 1 ) 
					#name: #source 
					#model: #source ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.333333 -5 1 0.5 1 ) 
					#model: #acceptCommand 
					#label: 'OK' 
					#isDefault: false 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.666666 -5 1 0.5 1 ) 
					#model: #closeRequest 
					#label: 'Cancel' 
					#defaultable: true ) ) ) )! !


SimpleDialog subclass: #TransitionEditor
	instanceVariableNames: 'transition eventType figureList charactersHolder characterList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation GUI'!


!TransitionEditor methodsFor: 'accessing'!

type
	| newType |
	newType := (TransitionType withAllSubclasses
				detect: [:each | each transition == self transition value]) new.
	newType event: self eventType value.
	newType figureClasses: self figureList selections asArray.
	newType characters: self charactersForType.
	^newType!

type: aType 
	self eventType value: aType event.
	self transition value: aType class transition.
	self figureList selections: aType figureClasses.
	self selectCharacters: aType characters! !

!TransitionEditor methodsFor: 'aspects'!

characterList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^characterList isNil
		ifTrue:
			[characterList := MultiSelectionInList new]
		ifFalse:
			[characterList]!

charactersHolder
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^charactersHolder isNil
		ifTrue:
			[charactersHolder := String new asValue]
		ifFalse:
			[charactersHolder]!

eventType
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^eventType isNil
		ifTrue:
			[eventType := nil asValue]
		ifFalse:
			[eventType]!

figureList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^figureList isNil
		ifTrue:
			[figureList := MultiSelectionInList new]
		ifFalse:
			[figureList]!

transition
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^transition isNil
		ifTrue:
			[transition := nil asValue]
		ifFalse:
			[transition]! !

!TransitionEditor methodsFor: 'changing'!

changedEvent
	(#(#keyPress #keyRelease) includes: self eventType value) 
		ifTrue: 
			[self
				disableAll: #(#figure);
				enableAll: #(#character)]
		ifFalse: 
			[self
				enableAll: #(#figure);
				disableAll: #(#character)]!

changedTransition
	self transition value == #figure 
		ifTrue: [self enableAll: #(#figureList)]
		ifFalse: [self disableAll: #(#figureList)].
	self transition value == #character 
		ifTrue: [self enableAll: #(#characterList #characters #label)]
		ifFalse: [self disableAll: #(#characterList #characters #label)]! !

!TransitionEditor methodsFor: 'initialize-release'!

buildCharacterList
	| characters |
	characters := OrderedCollection new.
	self symbolKeys 
		do: [:each | characters add: each asString -> (Array with: each)].
	self specialCharacters 
		do: [:each | characters add: each printString -> (Array with: each)].
	characters add: 'Printable' -> self printableCharacters.
	self characterList list: characters!

buildFigureList
	self figureList 
		list: (Figure withAllSubclasses 
				asSortedCollection: [:a :b | a name < b name]) asList!

initialize
	super initialize.
	self
		buildCharacterList;
		buildFigureList! !

!TransitionEditor methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	super postBuildWith: aBuilder.
	self eventType onChangeSend: #changedEvent to: self.
	self transition onChangeSend: #changedTransition to: self.
	self
		changedEvent;
		changedTransition! !

!TransitionEditor methodsFor: 'private'!

charactersForType
	| characters |
	characters := OrderedCollection new.
	self characterList selections do: [:each | characters addAll: each value].
	characters addAll: self charactersHolder value.
	^characters asArray!

disableAll: aSymbolList 
	builder isNil ifTrue: [^self].
	aSymbolList do: 
			[:each | 
			| widget |
			widget := builder componentAt: each.
			widget notNil 
				ifTrue: 
					[widget
						disable;
						beInvisible]]!

enableAll: aSymbolList 
	builder isNil ifTrue: [^self].
	aSymbolList do: 
			[:each | 
			| widget |
			widget := builder componentAt: each.
			widget notNil 
				ifTrue: 
					[widget
						beVisible;
						enable]]!

printableCharacters
	^String withAll: ((32 to: 127) collect: [:each | Character value: each])!

selectCharacters: characters 
	| newSelections charsLeft |
	newSelections := self characterList list 
				reject: [:each | each value contains: [:char | (characters includes: char) not]].
	self characterList selections: newSelections.
	self charactersHolder value: ''.
	charsLeft := characters asOrderedCollection.
	self charactersForType do: [:each | charsLeft remove: each ifAbsent: []].
	self charactersHolder 
		value: (String withAll: (charsLeft reject: [:each | each isSymbol]))!

specialCharacters
	^#(#tab #del #backspace #esc #cr #newPage #lf) 
		collect: [:each | Character perform: each]!

symbolKeys
	^#(#F1 #F2 #F3 #F4 #F5 #F6 #F7 #F8 #F9 #F10 #F11 #F12 #Insert #Home #End #PageUp #PageDown #Up #Down #Left #Right #NumLock)! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

TransitionEditor class
	instanceVariableNames: ''!


!TransitionEditor class methodsFor: 'instance creation'!

onType: aTransitionType 
	^(self new)
		type: aTransitionType;
		yourself! !

!TransitionEditor class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Transition Editor' 
			#bounds: #(#Rectangle 482 371 848 628 ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 50 0 5 0 -5 1 35 0 ) 
					#name: #event 
					#model: #eventType 
					#menu: #eventMenu ) 
				#(#LabelSpec 
					#layout: #(#Point 5 10 ) 
					#label: 'Event:' ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0 40 0 0 1 42 0 ) ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 5 50 ) 
					#name: #always 
					#model: #transition 
					#label: 'Always' 
					#select: #always ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 5 80 ) 
					#name: #figure 
					#model: #transition 
					#label: 'Figure' 
					#select: #figure ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 5 110 ) 
					#name: #character 
					#model: #transition 
					#label: 'Character' 
					#select: #character ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 100 0 50 0 -5 1 -50 1 ) 
					#name: #figureList 
					#flags: 61 
					#model: #figureList 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.666666 -5 1 0.5 1 ) 
					#name: #cancel 
					#model: #cancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.333333 -5 1 0.5 1 ) 
					#name: #accept 
					#model: #accept 
					#label: 'OK' 
					#isDefault: true 
					#defaultable: true ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 175 0 -95 1 -5 1 -65 1 ) 
					#name: #characters 
					#flags: 56 
					#model: #charactersHolder ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 100 0 -90 1 ) 
					#name: #label 
					#flags: 48 
					#label: 'Characters:' ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 100 0 50 0 -5 1 -100 1 ) 
					#name: #characterList 
					#flags: 61 
					#model: #characterList 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) ) ) )! !

!TransitionEditor class methodsFor: 'resources'!

eventMenu
	"UIMenuEditor new openOnClass: self andSelector: #eventMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'mouseMove' 
				#value: #mouseMove ) 
			#(#MenuItem 
				#rawLabel: 'redButtonPress' 
				#value: #redButtonPress ) 
			#(#MenuItem 
				#rawLabel: 'redButtonRelease' 
				#value: #redButtonRelease ) 
			#(#MenuItem 
				#rawLabel: 'keyPress' 
				#value: #keyPress ) 
			#(#MenuItem 
				#rawLabel: 'keyRelease' 
				#value: #keyRelease ) 
			#(#MenuItem 
				#rawLabel: 'doubleClick' 
				#value: #doubleClick ) 
			#(#MenuItem 
				#rawLabel: 'yellowButtonPress' 
				#value: #yellowButtonPress ) 
			#(#MenuItem 
				#rawLabel: 'yellowButtonRelease' 
				#value: #yellowButtonRelease ) ) #(1 2 2 1 2 ) nil ) decodeAsLiteralArray! !


LineFigure subclass: #StateTransitionFigure
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation GUI'!


!StateTransitionFigure methodsFor: 'accessing'!

menuAt: aPoint
	| mb |
	mb := MenuBuilder new.
	mb add: 'Transition type...' -> #changeTransitionType.
	^mb menu! !

!StateTransitionFigure methodsFor: 'actions'!

changeTransitionType
	| editor |
	editor := TransitionEditor onType: model type.
	editor open ifFalse: [^self].
	model type: editor type! !

!StateTransitionFigure methodsFor: 'bounds accessing'!

computePreferredBounds
	^super computePreferredBounds
		merge: (self centerPoint extent: self label extent)! !

!StateTransitionFigure methodsFor: 'changing'!

changed: anAspectSymbol with: aParameter
	model points: points.
	^super changed: anAspectSymbol with: aParameter! !

!StateTransitionFigure methodsFor: 'displaying'!

centerPoint
	| middle |
	middle := points at: points size // 2 + 1.
	^points size odd
		ifTrue: [middle]
		ifFalse: [((points at: points size // 2) + middle) // 2]!

displayFigureOn: aGraphicsContext 
	super displayFigureOn: aGraphicsContext.
	self displayLabelOn: aGraphicsContext!

displayLabelOn: aGraphicsContext 
	self label displayOn: aGraphicsContext at: self centerPoint!

label
	^self model label asComposedText! !

!StateTransitionFigure methodsFor: 'initialize-release'!

initialize
	super initialize.
	self connectable: false.
	self model: ToolStateTransitionModel new! !

!StateTransitionFigure methodsFor: 'testing'!

isConnectionFigure
	^true! !

!StateTransitionFigure methodsFor: 'updating'!

update: anAspectSymbol with: aParameter from: aSender 
	aSender == model ifTrue: [^self recomputePreferredBounds].
	super 
		update: anAspectSymbol
		with: aParameter
		from: aSender! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

StateTransitionFigure class
	instanceVariableNames: ''!


!StateTransitionFigure class methodsFor: 'instance creation'!

fromModel: aToolStateTransitionModel connecting: aFigure to: anotherFigure 
	| figure |
	figure := self new.
	figure
		model: aToolStateTransitionModel;
		points: aToolStateTransitionModel points;
		recomputePreferredBounds.
	aFigure createStartConnectionConstraintFor: figure at: figure startPoint.
	anotherFigure createStopConnectionConstraintFor: figure
		at: figure stopPoint.
	aFigure addDependent: figure.
	anotherFigure addDependent: figure.
	figure addStopArrow.
	^figure! !


Model subclass: #ToolStateModel
	instanceVariableNames: 'name command position isEndState isExternal '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation Models'!


!ToolStateModel methodsFor: 'accessing'!

command
	^command!

command: aString 
	command := aString asString.
	self changed: #command!

isEndState
	^isEndState!

isEndState: aBoolean 
	isEndState := aBoolean.
	self changed: #isEndState!

isExternal
	^isExternal!

isExternal: aBoolean 
	isExternal := aBoolean.
	self changed: #isExternal!

name
	^name!

name: aString 
	name := aString asString.
	self changed: #name!

position
	^position!

position: aPoint 
	position := aPoint! !

!ToolStateModel methodsFor: 'compilation'!

writeDefinitionOn: codeStream 
	isExternal ifTrue: [^self].
	codeStream
		nextPutAll: '	Tool states at: ''';
		nextPutAll: name;
		nextPutAll: ''' put: (';
		nextPutAll: (isEndState ifTrue: ['EndToolState'] ifFalse: ['ToolState']);
		nextPutAll: ' name: ''';
		nextPutAll: name;
		nextPutAll: ''' command: ';
		nextPutAll: command;
		nextPutAll: ').';
		cr! !

!ToolStateModel methodsFor: 'initialize-release'!

initialize
	command := '[:tool :event | ]'.
	name := 'state'.
	position := 0 @ 0.
	isEndState := false.
	isExternal := false! !

!ToolStateModel methodsFor: 'storing'!

storeOn: aStream 
	| deps |
	deps := self myDependents.
	self myDependents: nil.
	[super storeOn: aStream] valueNowOrOnUnwindDo: [self myDependents: deps]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ToolStateModel class
	instanceVariableNames: ''!


!ToolStateModel class methodsFor: 'instance creation'!

new
	^super new initialize! !


TransitionType subclass: #FigureTransitionType
	instanceVariableNames: 'figureClasses '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation Models'!


!FigureTransitionType methodsFor: 'accessing'!

figureClasses
	^figureClasses!

figureClasses: aCollection 
	figureClasses := aCollection!

priority
	^figureClasses inject: 0
		into: [:sum :each | sum + each withAllSubclasses size]! !

!FigureTransitionType methodsFor: 'compilation'!

writeDefinitionOn: codeStream to: aString 
	codeStream nextPutAll: '(FigureTransitionTable new) '.
	self writeMessageSendOn: codeStream to: aString!

writeMessageSendOn: codeStream to: aString 
	figureClasses do: 
			[:each | 
			codeStream
				nextPutAll: ' on: ';
				print: each;
				nextPutAll: ' goto: ';
				nextPutAll: aString]
		separatedBy: [codeStream nextPutAll: '; ']! !

!FigureTransitionType methodsFor: 'initialize-release'!

initialize
	super initialize.
	figureClasses := OrderedCollection new! !

!FigureTransitionType methodsFor: 'printing'!

printOn: aStream 
	super printOn: aStream.
	aStream
		nextPut: $/;
		cr.
	figureClasses do: [:each | aStream print: each]
		separatedBy: [aStream nextPut: $,]! !

!FigureTransitionType methodsFor: 'verifying'!

conflictsWith: aTransitionType 
	^aTransitionType figureClasses
		contains: [:each | figureClasses includes: each]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

FigureTransitionType class
	instanceVariableNames: ''!


!FigureTransitionType class methodsFor: 'accessing'!

transition
	^#figure! !


TransitionType subclass: #CharacterTransitionType
	instanceVariableNames: 'characters '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation Models'!


!CharacterTransitionType methodsFor: 'accessing'!

characters
	^characters!

characters: aString 
	characters := aString!

priority
	^characters size! !

!CharacterTransitionType methodsFor: 'compilation'!

writeDefinitionOn: codeStream to: aString 
	codeStream nextPutAll: '(CharacterTransitionTable new) '.
	self writeMessageSendOn: codeStream to: aString!

writeMessageSendOn: codeStream to: aString 
	codeStream nextPutAll: 'forCharacters: '.
	self storeCharactersOn: codeStream.
	codeStream
		nextPutAll: ' goto: ';
		nextPutAll: aString! !

!CharacterTransitionType methodsFor: 'initialize-release'!

initialize
	super initialize.
	event := #keyPress.
	characters := OrderedCollection new! !

!CharacterTransitionType methodsFor: 'printing'!

printOn: aStream 
	super printOn: aStream.
	aStream
		nextPut: $/;
		cr;
		nextPutAll: 'chars'! !

!CharacterTransitionType methodsFor: 'storing'!

storeCharactersOn: aStream 
	| symbols |
	symbols := characters select: [:each | each isSymbol].
	symbols isEmpty 
		ifTrue: [self writeCharactersOn: aStream]
		ifFalse: 
			[aStream nextPut: $(.
			symbols asArray storeOn: aStream.
			aStream nextPutAll: ' , '.
			self writeCharactersOn: aStream.
			aStream nextPut: $)]!

storeOn: aStream 
	aStream
		nextPut: $(;
		nextPutAll: self class name;
		nextPutAll: ' new event: ';
		print: event;
		nextPutAll: '; characters: '.
	self storeCharactersOn: aStream.
	aStream nextPut: $)!

writeCharactersOn: aStream 
	| chars |
	chars := characters reject: [:each | each isSymbol].
	chars isEmpty 
		ifTrue: 
			[aStream nextPutAll: ''''''.
			^self].
	aStream nextPutAll: '(String fromIntegerArray: '.
	(String withAll: chars) asByteArray storeOn: aStream.
	aStream nextPut: $)! !

!CharacterTransitionType methodsFor: 'verifying'!

conflictsWith: aTransitionType 
	^aTransitionType characters contains: [:each | characters includes: each]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

CharacterTransitionType class
	instanceVariableNames: ''!


!CharacterTransitionType class methodsFor: 'accessing'!

transition
	^#character! !


DrawingEditor subclass: #ToolStateMachineEditor
	instanceVariableNames: 'states connections '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation Models'!


!ToolStateMachineEditor methodsFor: 'accessing'!

addConnection: aToolStateTransitionMetafigure 
	connections add: aToolStateTransitionMetafigure!

addState: aToolStateMetafigure
	states add: aToolStateMetafigure!

connections
	^connections copy!

removeConnection: aToolStateTransitionMetafigure 
	connections remove: aToolStateTransitionMetafigure ifAbsent: []!

removeState: aToolStateMetafigure
	states remove: aToolStateMetafigure!

states
	^states copy! !

!ToolStateMachineEditor methodsFor: 'actions'!

checkForTypeConflictsIn: transitions 
	^transitions contains: 
			[:transition | 
			transitions
				contains: [:each | transition ~~ each and: [transition type conflictsWith: each type]]]!

compileForClass: aClass selector: aSymbol ifFail: aBlock 
	| codeStream string |
	self verifyIfFail: 
			[:error | 
			aBlock value: error.
			^self].
	codeStream := String new writeStream.
	codeStream
		nextPutAll: aSymbol;
		cr.
	self writeCommentOn: codeStream.
	self writeStateDefinitionsOn: codeStream.
	self writeTransitionsOn: codeStream.
	string := codeStream contents.
	aClass 
		compile: string
		classified: #'tool states'
		notifying: nil!

transitionBuckets
	| connectionBuckets |
	connectionBuckets := Dictionary new.
	connections do: 
			[:each | 
			((connectionBuckets at: each from ifAbsentPut: [Dictionary new])
				at: each type event
				ifAbsentPut: 
					[SortedCollection sortBlock: [:a :b | a type priority < b type priority]])
					add: each].
	^connectionBuckets!

verifyIfFail: aBlock 
	| names connectionBuckets |
	names := Set new.
	states do: 
			[:each | 
			(names includes: each name) 
				ifTrue: [aBlock value: each name , ' is defined multiple times']
				ifFalse: [names add: each name]].
	connectionBuckets := self transitionBuckets.
	connectionBuckets keysAndValuesDo: 
			[:state :eventTable | 
			eventTable keysAndValuesDo: 
					[:event :transitions | 
					(self checkForTypeConflictsIn: transitions) 
						ifTrue: 
							[aBlock value: state name , ' has transition conflicts for event ' , event]]]! !

!ToolStateMachineEditor methodsFor: 'compilation'!

writeCommentOn: codeStream 
	codeStream
		nextPutAll: '	"This method was automatically generated by the HotDraw ToolStateMachineEditor.';
		cr;
		nextPutAll: '	To edit this method, evaluate the comment below"';
		cr;
		cr.
	self writeDrawingDefinitionOn: codeStream!

writeDrawingDefinitionOn: codeStream 
	codeStream
		nextPutAll: '	"| states transitions stateTable |';
		cr;
		nextPutAll: '	states := '.
	states storeOn: codeStream.
	codeStream
		nextPut: $.;
		cr;
		nextPutAll: '	stateTable := Dictionary new.';
		cr;
		nextPutAll: '	states do: [:each | stateTable at: each name put: each].';
		cr;
		cr;
		nextPutAll: '	transitions := OrderedCollection new.';
		cr.
	connections do: 
			[:each | 
			codeStream nextPutAll: '	transitions add: (ToolStateTransitionModel new'.
			each writeStoreStringOn: codeStream.
			codeStream
				nextPutAll: ').';
				cr].
	codeStream
		nextPutAll: '	ToolStateMachineEditor openWithStates: states connections: transitions"';
		cr;
		cr!

writeStateDefinitionsOn: codeStream 
	states do: [:each | each writeDefinitionOn: codeStream]!

writeTransitions: transitions on: codeStream 
	transitions first writeDefinitionOn: codeStream.
	2 to: transitions size
		do: [:i | (transitions at: i) writeContinuedDefinitionOn: codeStream].
	codeStream nextPutAll: '; yourself'!

writeTransitionsOn: codeStream 
	self transitionBuckets keysAndValuesDo: 
			[:state :events | 
			events keysAndValuesDo: 
					[:event :transitions | 
					codeStream
						nextPutAll: '	(Tool stateFor: ''';
						nextPutAll: state name;
						nextPutAll: ''') ';
						nextPutAll: event;
						nextPutAll: ': ('.
					self writeTransitions: transitions on: codeStream.
					codeStream
						nextPutAll: ').';
						cr]]! !

!ToolStateMachineEditor methodsFor: 'drawing description'!

drawingClass
	^ToolStateMachineDrawing!

windowName
	^'Tool State Machine Editor'! !

!ToolStateMachineEditor methodsFor: 'initialize-release'!

initialize
	super initialize.
	states := OrderedCollection new.
	connections := OrderedCollection new!

states: toolStateModels connections: toolStateTransitionModels 
	states := toolStateModels.
	connections := toolStateTransitionModels! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ToolStateMachineEditor class
	instanceVariableNames: ''!


!ToolStateMachineEditor class methodsFor: 'instance creation'!

openOnModel: aToolStateMachineModel 
	^self openWithStates: aToolStateMachineModel states
		connections: aToolStateMachineModel connections!

openWithStates: toolStateModels connections: toolStateTransitionModels 
	| figureMapping figures editor |
	figures := OrderedCollection new.
	figureMapping := IdentityDictionary new.
	toolStateModels do: 
			[:each | 
			| figure |
			figure := ToolStateFigure fromModel: each.
			figureMapping at: each put: figure.
			figures add: figure].
	toolStateTransitionModels do: 
			[:each | 
			figures add: (StateTransitionFigure 
						fromModel: each
						connecting: (figureMapping at: each from)
						to: (figureMapping at: each to))].
	editor := self new.
	editor drawing addAll: figures.
	editor open.
	^editor!

states: toolStateModels connections: toolStateTransitionModels 
	^self new states: toolStateModels connections: toolStateTransitionModels! !


Drawing subclass: #ToolStateMachineDrawing
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation GUI'!


!ToolStateMachineDrawing methodsFor: 'accessing'!

menuAt: aPoint 
	| mb |
	mb := MenuBuilder new.
	mb
		add: 'Add state' -> [self addStateAt: aPoint];
		line;
		add: 'Verify' -> #verify;
		add: 'Compile' -> #compile;
		line;
		add: 'Inspect...' -> #inspect.
	^mb menu! !

!ToolStateMachineDrawing methodsFor: 'actions'!

addStateAt: aPoint 
	self add: (ToolStateFigure createAt: aPoint)!

compile
	| selector |
	selector := Dialog request: 'Enter a method name:' initialAnswer: ''.
	selector isEmpty ifTrue: [^self].
	model 
		compileForClass: Tool class
		selector: selector asSymbol
		ifFail: [:error | ^Dialog warn: error].
	(Dialog confirm: 'Do you want to reinitialize the tools?') 
		ifTrue: [Tool reinitialize]!

verify
	model verifyIfFail: [:error | ^Dialog warn: error]! !

!ToolStateMachineDrawing methodsFor: 'adding'!

add: aFigure 
	aFigure isStateFigure ifTrue: [self model addState: aFigure model].
	aFigure isConnectionFigure ifTrue: [self model addConnection: aFigure model].
	^super add: aFigure!

addLast: aFigure 
	aFigure isStateFigure ifTrue: [self model addState: aFigure model].
	aFigure isConnectionFigure ifTrue: [self model addConnection: aFigure model].
	^super addLast: aFigure! !

!ToolStateMachineDrawing methodsFor: 'removing'!

remove: aFigure 
	aFigure isStateFigure ifTrue: [self model removeState: aFigure model].
	aFigure isConnectionFigure
		ifTrue: [self model removeConnection: aFigure model].
	^super remove: aFigure! !


EllipseFigure subclass: #ToolStateFigure
	instanceVariableNames: ''
	classVariableNames: 'NameIndex '
	poolDictionaries: ''
	category: 'HotDraw-Tool Creation GUI'!


!ToolStateFigure methodsFor: 'accessing'!

menuAt: aPoint 
	| mb isEndState isExternal |
	isEndState := model isEndState.
	isExternal := model isExternal.
	mb := MenuBuilder new.
	mb
		add: 'Rename...' -> #rename;
		add: 'Edit command...' -> #editCommand;
		line;
		add: (isEndState ifTrue: ['Normal state'] ifFalse: ['End state']) 
					-> [model isEndState: isEndState not];
		add: (isExternal ifTrue: ['Define here'] ifFalse: ['Define elsewhere']) 
					-> [model isExternal: isExternal not].
	^mb menu!

name
	^self model name! !

!ToolStateFigure methodsFor: 'actions'!

editCommand
	(ToolStateCommandEditor state: model) open!

rename
	| newName |
	newName := Dialog request: 'Enter state name:'
				initialAnswer: self model name.
	newName isEmpty ifTrue: [^self].
	self model name: newName! !

!ToolStateFigure methodsFor: 'changing'!

changed
	model position: self origin.
	super changed! !

!ToolStateFigure methodsFor: 'connection'!

canConnectFromFigure: aFigure 
	^self class = aFigure class!

canConnectToFigure: aFigure 
	^self canBeConnected and: [self class = aFigure class]!

connectFromPoint: myPoint to: aFigure at: figurePoint 
	| newFigure |
	newFigure := super 
				connectFromPoint: myPoint
				to: aFigure
				at: figurePoint.
	self == aFigure 
		ifTrue: 
			[newFigure
				addPoint: self rightCenter + (10 @ 10) beforeIndex: 2;
				addPoint: self rightCenter + (10 @ -10) beforeIndex: 2].
	(newFigure model)
		from: self model;
		to: aFigure model.
	^newFigure!

connectionFigureClass
	^StateTransitionFigure! !

!ToolStateFigure methodsFor: 'displaying'!

displayFigureOn: aGraphicsContext 
	| text |
	super displayFigureOn: aGraphicsContext.
	text := self name asComposedText.
	text displayOn: aGraphicsContext
		at: (self extent - text extent) // 2 + self origin! !

!ToolStateFigure methodsFor: 'initialize-release'!

initialize
	super initialize.
	self model: ToolStateModel new.
	bounds := 0 @ 0 extent: 0 @ 0.
	self opaque!

name: aString at: aPoint 
	bounds := aPoint extent: 0 @ 0.
	(self model)
		name: aString;
		position: aPoint! !

!ToolStateFigure methodsFor: 'testing'!

isStateFigure
	^true! !

!ToolStateFigure methodsFor: 'updating'!

computePreferredBounds
	| newExtent |
	newExtent := self model name asComposedText extent + (10 @ 10).
	^self origin extent: newExtent!

resetEndState
	self lineWidth: (self model isEndState ifTrue: [2] ifFalse: [1])!

resetExternal
	model isExternal
		ifTrue: 
			[self lineWidth: 1.
			self lineColor: ColorValue red]
		ifFalse: 
			[self lineColor: ColorValue black.
			self resetEndState]!

resetFigure
	self
		computePreferredBounds;
		translateTo: model position;
		resetEndState;
		resetExternal!

update: anAspectSymbol with: aParameter from: aSender 
	anAspectSymbol == #position ifTrue: [^self].
	anAspectSymbol == #name ifTrue: [^self recomputePreferredBounds].
	anAspectSymbol == #isEndState ifTrue: [^self resetEndState].
	anAspectSymbol == #isExternal ifTrue: [^self resetExternal].
	^super 
		update: anAspectSymbol
		with: aParameter
		from: aSender! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ToolStateFigure class
	instanceVariableNames: ''!


!ToolStateFigure class methodsFor: 'class initialization'!

initialize
	"self initialize"

	NameIndex := 0! !

!ToolStateFigure class methodsFor: 'instance creation'!

createAt: aPoint 
	| stateName |
	NameIndex := NameIndex + 1.
	stateName := 'state ' , NameIndex printString.
	^(self new)
		name: stateName at: aPoint;
		yourself!

fromModel: aToolStateModel 
	| figure |
	figure := self new.
	figure
		model: aToolStateModel;
		resetFigure.
	^figure! !

ToolStateFigure initialize!


