ThingLabObject subclass: #Thermometer
	instanceVariableNames: 'mercury node line'
	classVariableNames: 'ThermometerPicture'
	poolDictionaries: ''
	category: 'Prototypes'!

Thermometer prototype parts: 'mercury node line'.
Thermometer prototype field: #mercury replaceWith: (30@100 line: 30@150).
Thermometer prototype field: #node replaceWith: #Node clonePrototype.
Thermometer prototype node primitiveSet.value: 50.0 .
Thermometer prototype node primitiveSet.location: 100@200.
Thermometer prototype field: #line replaceWith: (30@150 line: 100@200)!

Thermometer prototype merge: #('mercury point2' 'line point1').
Thermometer prototype merge: #('line point2' 'node location').

Thermometer prototype inserters: #('mercury point2' 'node')!

Constraint owner: Thermometer prototype
	rule: '2.5*(mercury point2 y-mercury point1 y-30) = node value'
	methods: #(
		'mercury point1 y: mercury point2 y - 30 - (node value*0.4)'
		'node primitiveSet.value: 2.5*(mercury point2 y-mercury point1 y-30)'
		'mercury point2 y reference')!

Constraint owner: Thermometer prototype
	rule: 'mercury point1 x = mercury point2 x'
	methods: #('mercury point1 x: mercury point2 x'
		'mercury point2 x reference')!

Thermometer classPool at: #ThermometerPicture put: (Form
	extent: 56@124
	fromArray: #( 0 0 0 0 0 0 0 0 16383 64512 0 0 16383 64512 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 97 34304 12288 3072 146 18688 12288 3072 18 18688 12288 3072 18 18688 12288 3072 34 18688 12288 3135 63554 18688 12288 3072 138 18688 12288 3072 241 34304 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 32 50688 12288 3072 97 2304 12288 3072 33 2304 12288 3072 32 35072 12288 3072 32 18688 12288 3135 63520 18688 12288 3072 34 18688 12288 3072 113 34304 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 33 34304 12288 3072 98 18688 12288 3072 34 18688 12288 3072 34 18688 12288 3072 34 18688 12288 3135 63522 18688 12288 3072 34 18688 12288 3072 113 34304 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 50688 12288 3072 1 2304 12288 3072 1 2304 12288 3072 0 35072 12288 3072 0 18688 12288 3135 63488 18688 12288 3072 2 18688 12288 3072 1 34304 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 1536 12288 3072 0 2304 12288 3072 0 2304 12288 3072 0 2304 12288 3072 0 2304 12288 3135 63488 2304 12288 3072 0 2304 12288 3072 0 1536 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 50688 12288 3072 1 2304 12288 3072 1 2304 12288 3072 0 35072 12288 3072 240 18688 12288 3135 63488 18688 12288 3072 2 18688 12288 3072 1 34304 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 12288 3072 0 0 16383 64512 0 0 16383 64512 0 0 0 0 0 0 0 0 0 0)
	offset: 0@0)!

Thermometer compile:
'showPicture: medium | top r |
	line showPicture: medium.  node showPicture: medium.
	ThermometerPicture displayOn: medium at: mercury point2-(11@122) rule: Form paint.
	top _ mercury point1 max: mercury point2-(0@120).
	r _ top-(3@0) corner: mercury point2+(5@-2).
	medium fillGray: r'
classified: 'showing'.

"Old message - for efficent display of changing thermometers.  Needs to
do something with foreground selectors ..."
Thermometer compile:
'showNewMercury: medium | top r1 r2 |
	r1_mercury point2-(4@120) corner: mercury point2+(4@0).
	medium white: r1.
	top _ mercury point1 max: mercury point2-(0@120).
	r2 _ top-(4@0) corner: mercury point2+(4@0).
	medium gray: r2'
classified: 'showing'.


"The Thermometer icon was made as follows:

	| pictureForm rect pen degrees para textLoc  |
pictureForm _ Form extent: 56@124.
rect _ 2@2 extent: 20@120.
pictureForm white.
pictureForm black: rect.
pictureForm white: (rect insetBy: 2).
pen _ Pen newOnForm: pictureForm.
pen rule: Form paint.
degrees_200.
10 to: 110 by: 20 do:
	[:y |
	pen place: rect origin+(24@y); north; turn: 90; go: 10.
	para_degrees printString asParagraph.  para rightFlush.
	textLoc _ (57@(y-7)) - (para compositionRectangle width@0).
	para displayOn: pictureForm at: textLoc rule: Form under.
	degrees_degrees-50].
pictureForm writeOn: 'Thermometer.form'.
pictureForm displayOn: Display at: 500@600.
"

