ThingLabObject subclass: #TextLabel
	instanceVariableNames: 'text value label'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

TextLabel prototype parts: 'text label'; primitives: 'value'.
TextLabel prototype field: 'text' replaceWith: #TextThing clonePrototype.
"leave value as nil"
TextLabel prototype field: 'label' replaceWith: #TextThing clonePrototype!


TextLabel prototype text primitiveSet.frame: (105@40 extent: 100@20).
TextLabel prototype label primitiveSet.text:  '' asText.
TextLabel prototype label primitiveSet.frame: (60@40 extent: 40@20).
TextLabel prototype label primitiveSet.text:  'x' asText.
TextLabel prototype label flushRight.

TextLabel prototype inserters:  #('text')!

Constraint owner: TextLabel prototype
	rule: 'text text = value thingString asText'
	methods: #('text primitiveSet.text: value thingString asText'
		'self primitiveSet.value: (ThingLabObject readThing: text text)')!


LabelConstraint owner: TextLabel prototype
	label: 'label text string' value: 'value'!

Constraint owner: TextLabel prototype
	rule: 'label frame origin = (text frame origin - (45@0))'
	methods:  #('label frame primitiveSet.origin: text frame origin - (45@0)'
				 'text frame origin reference'
				)!

Constraint owner: TextLabel prototype
	rule: 'label frame corner = (label frame origin + (40@20))'
	methods:  #('label frame primitiveSet.corner: label frame origin + (40@20)'
			'label frame origin reference'
				)!

"make label frame invisible"
TextLabel quickCompile:
'instancePaths: cl 
	cl==Rectangle ifTrue: 
		[^Array with: #(text frame) asPath].
	cl==Point ifTrue: 
		[^Array with: #(text frame origin) asPath with: #(text frame corner) asPath].
	^super instancePaths: cl'!

TextLabel quickCompile:
'showPicture: medium
	text showPicture: medium.
	label showPicture: medium.
	'':'' displayOn: medium at: text frame origin + (-6@2)'!
