ThingLabObject subclass: #PointLabel
	instanceVariableNames: 'point label'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

PointLabel prototype parts: 'point label'.
PointLabel prototype field: 'point' replaceWith: 50@50.
PointLabel prototype field: 'label' replaceWith: #TextThing clonePrototype!

PointLabel prototype label primitiveSet.frame: (60@40 extent: 34@20).
PointLabel prototype label primitiveSet.text:  'p' asText.

PointLabel prototype inserters:  #('point')!

LabelConstraint owner: PointLabel prototype
	label: 'label text string' value: 'point'!

Constraint owner: PointLabel prototype
	rule: 'label frame origin = (point + (10@-10))'
	methods:  #('label frame primitiveSet.origin: (point + (10@-10))'
				 'self primitiveSet.point: label frame origin - (10@-10)'
				)!

Constraint owner: PointLabel prototype
	rule: 'label frame corner = (label frame origin + (34@20))'
	methods:  #('label frame primitiveSet.corner: label frame origin + (34@20)'
			'label frame primitiveSet.origin: label frame corner - (34@20)'
				)!

"make label frame invisible"
PointLabel quickCompile:
'instancePaths: cl 
	cl==Point ifTrue: [^Array with: #(point) asPath].
	^super instancePaths: cl'!
