ThingLabObject subclass: #PointFlexLabel
	instanceVariableNames: 'point label'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

"like a point label, but label is free to move around"

PointFlexLabel prototype parts: 'point label'.
PointFlexLabel prototype field: 'point' replaceWith: 50@50.
PointFlexLabel prototype field: 'label' replaceWith: #TextThing clonePrototype!

PointFlexLabel prototype label primitiveSet.frame: (60@40 extent: 34@20).
PointFlexLabel prototype label primitiveSet.text:  'p' asText.

PointFlexLabel prototype inserters:  #('point' 'label frame')!

LabelConstraint owner: PointFlexLabel prototype
	label: 'label text string' value: 'point'!

Constraint owner: PointFlexLabel prototype
	rule: 'label frame corner = (label frame origin + (34@20))'
	methods:  #('label frame primitiveSet.corner: label frame origin + (34@20)'
			'label frame primitiveSet.origin: label frame corner - (34@20)'
				)!

"make label frame invisible"
PointFlexLabel quickCompile:
'instancePaths: cl 
	cl==Point ifTrue: [^Array with: #(point) asPath].
	^super instancePaths: cl'!
