'From Smalltalk-80 version T2.1.2, of July 23, 1985 on 18 February 1986 at 10:32:00 pm'!

ThingLabObject subclass: #Node
	instanceVariableNames: 'value location '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!


!Node methodsFor: 'showing'!

showPicture: medium
	location showPicture: medium! !


!Node methodsFor: 'moving'!

computedLocation
	"when computing the location, ignore the value"
	^location!

enclosingFrameOrNil
	^location enclosingFrameOrNil!

expandFixedLocation: message planner: planner
	"when fixing a PointNode, only fix the location and not the value"
		| m |
	m _ MessagePlan new
		context: message context
		receiver: (message receiver add: #location)
		constraint: message constraint
		owner: message owner
		keywords: message keywords
		arguments: message arguments
		uniqueState: message uniqueState
		referenceOnly: message referenceOnly
		compileTimeOnly: message compileTimeOnly.
	location expand: m planner: planner!

expandMove: message planner: planner
	"when moving a PointNode, only move the location and not the value"
		| m |
	m _ MessagePlan new
		context: message context
		receiver: (message receiver add: #location)
		constraint: message constraint
		owner: message owner
		keywords: message keywords
		arguments: message arguments
		uniqueState: message uniqueState
		referenceOnly: message referenceOnly
		compileTimeOnly: message compileTimeOnly.
	location expand: m planner: planner!

expandScale: message planner: planner
		| m |
	m _ MessagePlan new
		context: message context
		receiver: (message receiver add: #location)
		constraint: message constraint
		owner: message owner
		keywords: message keywords
		arguments: message arguments
		uniqueState: message uniqueState
		referenceOnly: message referenceOnly
		compileTimeOnly: message compileTimeOnly.
	location expand: m planner: planner!

instancePaths: cl
	"make the value invisible to pointing"
	cl==Point ifTrue: [^Array with: #(location) asPath].
	cl==Node ifTrue: [^Array with: EmptyPath].
	^#()! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Node class
	instanceVariableNames: ''!


!Node class methodsFor: 'initialization'!

initialize
		| p |
	p _ Node prototype.
	p primitives: 'value'; parts: 'location'.
	p field: #location replaceWith: 10@10! !


Node initialize!

