'From Smalltalk-80 of 27 March 1985 [ST80V45.Stretch2] on 6 September 1985 3:53:25 pm PDT (Friday)'!

ThingLabObject subclass: #MethodPrototype
	instanceVariableNames: 'declaration receiver result arg1 arg2 arg3 receiverString resultString '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'ThingLab-ObjectDefiner'!


!MethodPrototype methodsFor: 'compiling'!

compileIn: aClass
	"compile a method in aClass that invokes me.  The method will be something like
		foo: t1
			^(MethodPrototypeClass prototype copy.receiver: self arg1: t1) result
	 "
		| encoder argNames args newSelString newSel prototypeNode copyArgs
		  copyNode resultNode returnNode block methodNode |
	encoder _ Encoder new init: aClass context: nil notifying: nil.
	argNames _ OrderedCollection new.
	newSelString _ 'copy.receiver:' .
	"add all arguments that are not the empty string"
	declaration arg1 size>0 ifTrue: [argNames add: declaration arg1.  newSelString _ newSelString , 'arg1:'].
	declaration arg2 size>0 ifTrue: [argNames add: declaration arg2.  newSelString _ newSelString , 'arg2:'].
	declaration arg3 size>0 ifTrue: [argNames add: declaration arg3.  newSelString _ newSelString , 'arg3:'].
	args _ argNames collect: [:n |  encoder bindTemp: n].
	newSel _ newSelString asSymbol.
	prototypeNode _ MessageNode new
		receiver: (encoder encodeVariable: self class name asString)
		selector: #prototype
		arguments: Array new
		precedence: #prototype precedence
		from: encoder.
	copyArgs _ OrderedCollection new.
	copyArgs add: (encoder encodeVariable: 'self').
	copyArgs addAll: args.
	copyNode _ MessageNode new
		receiver: prototypeNode
		selector: newSel
		arguments: copyArgs
		precedence: newSel precedence
		from: encoder.
	resultNode _ MessageNode new
		receiver: copyNode
		selector: #result
		arguments: Array new
		precedence: #result precedence
		from: encoder.
	returnNode _ ReturnNode new expr: resultNode.
	block _ BlockNode new statements: (Array with: returnNode) returns: true.
	methodNode _ MethodNode new
		selector: declaration selector
		arguments: args
		precedence: declaration selector precedence
		temporaries: #()
		block: block
		encoder: encoder
		primitive: 0.
	methodNode compileIn: aClass!

install
	"compile a method in receiver's class that invokes me.  The method will be something like
		foo: t1
			^(MethodPrototypeClass prototype copy.receiver: self arg1: t1) result
	 "
		| encoder argNames args newSelString newSel prototypeNode copyArgs
		  copyNode resultNode returnNode block methodNode receiverClass |
	receiverClass _ Smalltalk at: declaration receiverName.
	encoder _ Encoder new init: receiverClass context: nil notifying: nil.
	argNames _ OrderedCollection new.
	newSelString _ 'copy.receiver:' .
	"add all arguments that are not the empty string"
	declaration arg1 size>0 ifTrue: [argNames add: declaration arg1.  newSelString _ newSelString , 'arg1:'].
	declaration arg2 size>0 ifTrue: [argNames add: declaration arg2.  newSelString _ newSelString , 'arg2:'].
	declaration arg3 size>0 ifTrue: [argNames add: declaration arg3.  newSelString _ newSelString , 'arg3:'].
	args _ argNames collect: [:n |  encoder bindTemp: n].
	newSel _ newSelString asSymbol.
	prototypeNode _ MessageNode new
		receiver: (encoder encodeVariable: self class name asString)
		selector: #prototype
		arguments: Array new
		precedence: #prototype precedence
		from: encoder.
	copyArgs _ OrderedCollection new.
	copyArgs add: (encoder encodeVariable: 'self').
	copyArgs addAll: args.
	copyNode _ MessageNode new
		receiver: prototypeNode
		selector: newSel
		arguments: copyArgs
		precedence: newSel precedence
		from: encoder.
	resultNode _ MessageNode new
		receiver: copyNode
		selector: #result
		arguments: Array new
		precedence: #result precedence
		from: encoder.
	returnNode _ ReturnNode new expr: resultNode.
	block _ BlockNode new statements: (Array with: returnNode) returns: true.
	methodNode _ MethodNode new
		selector: declaration selector
		arguments: args
		precedence: declaration selector precedence
		temporaries: #()
		block: block
		encoder: encoder
		primitive: 0.
	methodNode compileIn: receiverClass! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MethodPrototype class
	instanceVariableNames: ''!


!MethodPrototype class methodsFor: 'class initialization'!

initializePrototype   "MethodPrototype initializePrototype"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	p parts: 'declaration'; primitives: 'receiver result arg1 arg2 arg3 receiverString resultString'.
	p init.declaration: #MethodDeclaration clonePrototype.
	p init.receiverString: 'receiver'.
	p init.resultString: 'result'.
	"set up label constraints on the argument names"
	LabelConstraint owner: p
		label: 'declaration arg1' value: 'arg1'.
	LabelConstraint owner: p
		label: 'declaration arg2' value: 'arg2'.
	LabelConstraint owner: p
		label: 'declaration arg3' value: 'arg3'.
	LabelConstraint owner: p
		label: 'receiverString' value: 'receiver'.
	LabelConstraint owner: p
		label: 'resultString' value: 'result'! !
