ThingLabObject subclass: #Load
	instanceVariableNames: 'beam stretch text'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

Load prototype parts: 'beam text'; primitives: 'stretch'.
Load prototype field: #beam replaceWith: #Beam clonePrototype.
Load prototype beam primitiveSet.line: (30.0@30.0 line: 30.0@70.0).
Load prototype beam primitiveSet.unstressedLength: 40.0.
Load prototype field: #stretch replaceWith: 0.0!
Load prototype field: #text replaceWith: TextThing prototype recopy.
Load prototype text primitiveSet.frame: (15@40 corner: 45@60).
Load prototype text primitiveSet.text: '0.0' asText.
Load prototype text center.


Load prototype inserters: #('beam line point1')!

"gravity ... methods depend on the state of the relaxer.  ugh."
Constraint owner: Load prototype
	rule: 'beam line length = (beam unstressedLength + stretch)'
	test: '(beam line length - (beam unstressedLength + stretch)) abs < 0.5'
	error: 'beam line length - (beam unstressedLength + stretch)'
	methods: #(
		'beam line primitiveSet.point1: (Incremented ifTrue: [beam line point1]
			ifFalse: [beam line point2 - (0.0 @ (beam unstressedLength+stretch))])'
		'beam line primitiveSet.point2: (Incremented ifTrue: [beam line point2]
			ifFalse: [beam line point1 + (0.0 @ (beam unstressedLength+stretch))])'
		'beam unstressedLength reference'
		'stretch reference')!

"keep the text centered"
Constraint owner: Load prototype
	rule: 'text frame = (beam line location rounded-(15@10) extent: 30@20)'
	methods: #(
		'text primitiveSet.frame: (beam line location rounded-(15@10) extent: 30@20)'
		'beam line reference')!

Constraint owner: Load prototype
	rule: 'stretch = text text asNumber'
	methods: #('self primitiveSet.stretch: text text asNumber'
		'text text reference')!

Load prototype picture: 
	(Form extent: 48@48
	fromArray: #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 448 0 0 2032 0 0 1584 0 0 3096 0 0 3096 0 0 3096 0 0 1584 0 0 32767 0 0 65535 32768 0 65535 32768 1 65535 49152 1 65535 49152 3 65535 57344 3 65535 57344 7 65535 61440 7 65535 61440 15 65535 63488 15 65535 63488 31 65535 64512 31 65535 64512 63 65535 65024 63 65535 65024 0 0 0 0 0 0 )
	offset: -24@-24)
	origin: 'beam line point2' asPath!

Load quickCompile: 'showPicture: medium
	beam line showPicture: medium.
	text showPicture: medium.
	PictureForm displayOn: medium at: beam line point2 rule: Form paint'!

