ThingLabObject subclass: #ListViewThing
	instanceVariableNames: 'list selection text selectionRect'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!


"this defines a primitive sort of ListView-like menu"

ListViewThing prototype primitives: 'list selection'; parts: 'text selectionRect'.
ListViewThing prototype field: 'list' replaceWith: #('item1'  'item2'  'item3').
ListViewThing prototype field: 'selection' replaceWith: 'item1'.
ListViewThing prototype field: 'text' replaceWith: #TextThing clonePrototype.
ListViewThing prototype text primitiveSet.text: 'item1
item2
item3' asText.
ListViewThing prototype text primitiveSet.frame: (10@10 corner: 60@60).

"compute selectionRect"
ListViewThing prototype field: 'selectionRect' replaceWith: 
	(ListViewThing prototype text findSelectionRect: 
		ListViewThing prototype text frame origin).

ListViewThing quickCompile:
'showPicture: medium
	text showPicture: medium.
	(text frame insetBy: (-1@-1 corner: 0@-2)) showPicture: medium.
	medium reverse: selectionRect'!

Constraint owner: ListViewThing prototype
	rule: 'text text = (String streamContents: [:strm | list do:
			[:x | x printOn: strm.  strm cr]]) asText'
	methods: #('text primitiveSet.text: (String streamContents: [:strm | list do:
			[:x | x printOn: strm.  strm cr]]) asText'
		'list reference')!

Constraint owner: ListViewThing prototype
	rule: 'selectionRect = text findSelectionRect: selectionRect center'
	methods: #('self primitiveSet.selectionRect: (text findSelectionRect: selectionRect center)'
		'text reference')!

Constraint owner: ListViewThing prototype
	rule: 'selection = (list at: (text findSelectionIndex: selectionRect list: list))'
	methods: #('self primitiveSet.selection: 
			(list at: (text findSelectionIndex: selectionRect list: list))'
		'list alter'
		'text alter'
		'selectionRect alter')!

