ThingLabObject subclass: #ListConnector
	instanceVariableNames: 'listView listNode selectionNode'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

ListConnector prototype parts: 'listView listNode selectionNode'.
ListConnector prototype field: 'listView' replaceWith: #ListViewThing clonePrototype.
ListConnector prototype field: 'listNode' replaceWith: #Node clonePrototype.
ListConnector prototype field: 'selectionNode' replaceWith: #Node clonePrototype.

ListConnector prototype listNode primitiveSet.location: 80@20.
ListConnector prototype selectionNode primitiveSet.location: 80@50.

ListConnector prototype inserters:  #('listView text frame origin').
ListConnector prototype constrainers:  #('listView').

ListConnector prototype merge: #('listView list'  'listNode value').
ListConnector prototype merge: #('listView selection'  'selectionNode value').

ListConnector quickCompile:
'showPicture: medium
		| frame listPoint selectionPoint |
	frame _ listView text frame.
	listPoint _ frame corner x @ (frame origin y + (frame height//3)).
	selectionPoint _ frame corner x @ (frame origin y + (2*frame height//3)).
	(ThingLabLine point1: listPoint point2: listNode location)
		showPicture: medium.
	(ThingLabLine point1: selectionPoint point2: selectionNode location)
		showPicture: medium.
	listNode showPicture: medium.
	selectionNode showPicture: medium.
	listView showPicture: medium'!

