'From Smalltalk-80 of 20 September 1985 [ST80V48.68K2] on 5 December 1986 11:10:36 am PST (Friday)'!

ThingLabObject subclass: #Expression
	instanceVariableNames: 'center extent value '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!


!Expression methodsFor: 'showing'!

precedence
	^4  "default is a high value"!

showPicture: medium
		| d |
	d _ (extent//2) - (2@2).  "half the extent less an inset"
	medium border: (center-d corner: center+d) width: 1 fillColor: Color black! !

!Expression methodsFor: 'moving'!

computedLocation
	"when computing the location, ignore extent"
	^center!

enclosingFrameOrNil
	^Rectangle origin: center-(extent//2) extent: extent!

expandFixedLocation: message planner: planner
	"when fixing an expression, only fix the center and not the extent"
		| m |
	m _ MessagePlan new
		context: message context
		receiver: (message receiver add: #center)
		constraint: message constraint
		owner: message owner
		keywords: message keywords
		arguments: message arguments
		uniqueState: message uniqueState
		referenceOnly: message referenceOnly
		compileTimeOnly: message compileTimeOnly.
	center expand: m planner: planner!

expandMove: message planner: planner
	"when moving an Expression, only move the center and not the extent"
		| m |
	m _ MessagePlan new
		context: message context
		receiver: (message receiver add: #center)
		constraint: message constraint
		owner: message owner
		keywords: message keywords
		arguments: message arguments
		uniqueState: message uniqueState
		referenceOnly: message referenceOnly
		compileTimeOnly: message compileTimeOnly.
	center expand: m planner: planner!

expandScale: message planner: planner
		| m |
	m _ MessagePlan new
		context: message context
		receiver: (message receiver add: #center)
		constraint: message constraint
		owner: message owner
		keywords: message keywords
		arguments: message arguments
		uniqueState: message uniqueState
		referenceOnly: message referenceOnly
		compileTimeOnly: message compileTimeOnly.
	center expand: m planner: planner!

instancePaths: cl
	"override default behavior to allow for changing classes of holes.
	 Also, make the extent and interior centers invisible to pointing.
	 Assume no merges within expressions."
		| strm subPaths prefix |
	cl==Point ifTrue: [^Array with: #(center) asPath].
	(self isMemberOf: cl) ifTrue: [^Array with: EmptyPath].
	strm _ Array newWriteStream: 10.
	self fieldDescriptions do: [:f | f isPart ifTrue: 
		[subPaths _ (self perform: f name) instancePaths: cl.
		prefix _ f asPath.
		subPaths do: [:p | strm nextPut: (prefix concat: p)]]].
	^strm contents! !

!Expression methodsFor: 'editing'!

addTo: editedObject selectionMerges: selectionMerges attachers: attachers
	"I am being added to some edited object.  Unlike the general addTo: ... method,
	 I insist on retaining a tree structure for expressions"
		| holePath |
	attachers size=1 ifFalse:
		[self error: 'must have exactly one attacher for expressions'].
	holePath _ selectionMerges at: 1.
	holePath isNil ifTrue: 
		[^super addTo: editedObject selectionMerges: selectionMerges attachers: attachers].
	"replace the hole with me"
	editedObject forgetConstraintMethods.
	editedObject replace: holePath with: self.
	^holePath!

hasChangeableParts
	"return true if I have parts that are allowed to be of different classes"
	^true!

stickyPathsForInsert: editedObject
	"I am an attacher for an expression being inserted in editedObject.
	 Return a collection of paths to parts I should stick to.  For expressions, this will
	just be the holes"
	^editedObject instancePaths: ExprHole! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Expression class
	instanceVariableNames: ''!


!Expression class methodsFor: 'initialization'!

initialize   "Expression initialize"
	self prototype parts: 'center extent'.
	self prototype primitives: 'value'.
	self prototype field: 'center' replaceWith: 20@20.
	self prototype field: 'extent' replaceWith: 24@18.
	"leave value as nil"! !

Expression initialize!

Expression subclass: #ExprHole
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!

Expression subclass: #ExprHorizontalOp
	instanceVariableNames: 'exp1 exp2 '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!


!ExprHorizontalOp methodsFor: 'showing'!

exp1NeedsParens
	^exp1 precedence < self precedence!

exp1ParenWidth
	"return the amount of space needed for parentheses for exp1"
	^ self exp1NeedsParens ifTrue: [2*self parenWidth] ifFalse: [0]!

exp2NeedsParens
	^exp2 precedence <= self precedence!

exp2ParenWidth
	"return the amount of space needed for parentheses for exp2"
	^ self exp2NeedsParens ifTrue: [2*self parenWidth] ifFalse: [0]!

operatorName
	^'?'!

operatorWidth
	"return the amount of space needed for the operator"
	^18!

parenWidth
	"return the amount of space needed for 1 parenthesis"
	^5!

precedence
	^1!

showPicture: medium
		| xoffset opcenter |
	"the operator is centered at opcenter"
	xoffset _  exp1 extent x + self exp1ParenWidth + self operatorWidth //2.
	opcenter _ exp1 center + (xoffset@0).
	exp1 showPicture: medium.
	exp2 showPicture: medium.
	self operatorName displayOn: medium at: opcenter - (4@9).
	self exp1NeedsParens ifTrue: 
		['(' displayOn: medium at: center - (extent x//2@0) - (2@10).
		')' displayOn: medium at: opcenter - (12@10)].
	self exp2NeedsParens ifTrue: 
		['(' displayOn: medium at: opcenter + (8@-10).
		')' displayOn: medium at: center + (extent x//2@0) - (2@10)]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprHorizontalOp class
	instanceVariableNames: ''!


!ExprHorizontalOp class methodsFor: 'initialization'!

initialize   "ExprHorizontalOp initialize"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	p parts: 'exp1 exp2'.
	p field: 'exp1' replaceWith: #ExprHole clonePrototype.
	p field: 'exp2' replaceWith: #ExprHole clonePrototype.
	p exp1 primitiveSet.center: 22@40.
	p exp2 primitiveSet.center: 64@40.
	p primitiveSet.center: 43@40.
	p primitiveSet.extent: 66@18.

	"my x extent is the sum of the x extents of exp1 and exp2
		plus the width of the operator plus room for parentheses"
	Constraint owner: p
		rule: 'extent x = (exp1 extent x + exp2 extent x +
				self operatorWidth + self exp1ParenWidth + self exp2ParenWidth)'
		methods: #(
			'extent primitiveSet.x: exp1 extent x + exp2 extent x + 
				self operatorWidth + self exp1ParenWidth + self exp2ParenWidth'
			'exp1 extent x reference'
			'exp2 extent x reference').
	"my y extent is the max of the y extents of exp1 and exp2"
	Constraint owner: p
		rule: 'extent y = (exp1 extent y max: exp2 extent y)'
		methods: #('extent primitiveSet.y: (exp1 extent y max: exp2 extent y)'
			'exp1 extent y reference'
			'exp2 extent y reference').
	
	"make the centers line up horizontally"
	Constraint owner: p
		rule: 'exp1 center y = center y'
		methods: #('exp1 center primitiveSet.y: center y'
			'center y reference').
	Constraint owner: p
		rule: 'exp2 center y = center y'
		methods: #('exp2 center primitiveSet.y: center y'
			'center y reference').

	"make exp1's center be to the left of my center"
	Constraint owner: p
		rule: 'exp1 center x = (center x - (extent x//2) +
								(exp1 extent x//2) + (self exp1ParenWidth//2) )'
		methods: #('exp1 center primitiveSet.x: center x - (extent x//2) +
								(exp1 extent x//2) + (self exp1ParenWidth//2) '
			'exp1 extent x reference'
			'center x reference').
	
	"make exp2's center be to the right of my center"
	Constraint owner: p
		rule: 'exp2 center x = (center x + (extent x//2) -
								(exp2 extent x//2) - (self exp2ParenWidth//2) )'
		methods: #('exp2 center primitiveSet.x: center x + (extent x//2) -
								(exp2 extent x//2) - (self exp2ParenWidth//2) '
			'exp2 extent x reference'
			'center x reference').
	p makeCheckConstraintsMethod.! !

ExprHorizontalOp initialize!



ExprHorizontalOp subclass: #ExprMinus
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!


!ExprMinus methodsFor: 'showing'!

operatorName
	^'-'!

precedence
	^2! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprMinus class
	instanceVariableNames: ''!


!ExprMinus class methodsFor: 'initialization'!

initialize   "ExprMinus initialize"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	Constraint owner: p
		rule: 'exp1 value isNil | exp2 value isNil | value isNil or:
				[exp1 value-exp2 value = value]'
		methods: #(
			'self primitiveSet.value: (exp1 value isNil | exp2 value isNil ifTrue: [nil]
					ifFalse: [exp1 value-exp2 value])'
			'exp1 primitiveSet.value: (value isNil | exp2 value isNil ifTrue: [nil]
					ifFalse: [value+exp2 value])'
			'exp2 primitiveSet.value: (value isNil | exp1 value isNil ifTrue: [nil]
					ifFalse: [exp1 value-value])'
					).
	p makeCheckConstraintsMethod! !

ExprMinus initialize!



ExprHorizontalOp subclass: #ExprEquality
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!


!ExprEquality methodsFor: 'showing'!

operatorName
	^'='!

precedence
	^1! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprEquality class
	instanceVariableNames: ''!


!ExprEquality class methodsFor: 'initialization'!

initialize   "ExprEquality initialize"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	Constraint owner: p
		rule: 'exp1 value = exp2 value'
		methods: #( 'exp1 primitiveSet.value: exp2 value'
			'exp2 primitiveSet.value: exp1 value').
	"my own value is unused"
	p makeCheckConstraintsMethod.! !

ExprEquality initialize!



ExprHorizontalOp subclass: #ExprPlus
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!


!ExprPlus methodsFor: 'showing'!

operatorName
	^'+'!

precedence
	^2! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprPlus class
	instanceVariableNames: ''!


!ExprPlus class methodsFor: 'initialization'!

initialize   "ExprPlus initialize"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	Constraint owner: p
		rule: 'exp1 value isNil | exp2 value isNil | value isNil or:
				[exp1 value+exp2 value = value]'
		methods: #(
			'self primitiveSet.value: (exp1 value isNil | exp2 value isNil ifTrue: [nil]
					ifFalse: [exp1 value+exp2 value])'
			'exp1 primitiveSet.value: (value isNil | exp2 value isNil ifTrue: [nil]
					ifFalse: [value-exp2 value])'
			'exp2 primitiveSet.value: (value isNil | exp1 value isNil ifTrue: [nil]
					ifFalse: [value-exp1 value])'
					).
	p makeCheckConstraintsMethod.


"old constraint (without the nil junk):
	Constraint owner: p
		rule: 'exp1 value+exp2 value = value'
		methods: #('self primitiveSet.value: exp1 value+exp2 value'
			'exp1 primitiveSet.value: value-exp2 value'
			'exp2 primitiveSet.value: value-exp1 value').
"! !

ExprPlus initialize!



"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprHole class
	instanceVariableNames: ''!


!ExprHole class methodsFor: 'initialization'!

initialize   "ExprHole initialize"
	self resetThingLabFields.
	Constraint owner: self prototype
		rule: 'extent = (24@18)'
		methods: #('self primitiveSet.extent: 24@18').
	self prototype makeCheckConstraintsMethod.! !

ExprHole initialize!



Expression subclass: #ExprQuotient
	instanceVariableNames: 'num den '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!


!ExprQuotient methodsFor: 'showing'!

showPicture: medium
	num showPicture: medium.
	den showPicture: medium.
	medium fill: (center - (extent x//2 @ 0) extent: extent x@1) rule: Form over fillColor: Color black! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprQuotient class
	instanceVariableNames: ''!


!ExprQuotient class methodsFor: 'initialization'!

initialize   "ExprQuotient initialize"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	p parts: 'num den'.
	p field: 'num' replaceWith: #ExprHole clonePrototype.
	p field: 'den' replaceWith: #ExprHole clonePrototype.
	p num primitiveSet.center: 34@49.
	p den primitiveSet.center: 34@71.
	p primitiveSet.center: 34@60.
	p primitiveSet.extent: 24@40.

	Constraint owner: p
		rule: 'num value isNil | den value isNil | value isNil or:
				[num value/den value = value]'
		methods: #('self primitiveSet.value: (num value isNil | den value isNil ifTrue: [nil]
					ifFalse: [num value/den value])'
			'num primitiveSet.value: (value isNil | den value isNil ifTrue: [nil]
					ifFalse: [value*den value])'
			'den primitiveSet.value: (value isNil | num value isNil ifTrue: [nil]
					ifFalse: [num value/value])'
					).

	"my y extent is the sum of the y extents of num and den plus space for the bar"
	Constraint owner: p
		rule: 'extent y = (num extent y + den extent y + 4)'
		methods: #('extent primitiveSet.y: num extent y + den extent y + 4'
			'num extent y reference'
			'den extent y reference').
	"my x extent is the max of the x extents of num and den"
	Constraint owner: p
		rule: 'extent x = (num extent x max: den extent x)'
		methods: #('extent primitiveSet.x: (num extent x max: den extent x)'
			'num extent x reference'
			'den extent x reference').
	
	"make the centers line up vertically"
	Constraint owner: p
		rule: 'num center x = center x'
		methods: #('num center primitiveSet.x: center x'
			'center x reference').
	Constraint owner: p
		rule: 'den center x = center x'
		methods: #('den center primitiveSet.x: center x'
			'center x reference').

	"make num's center be above my center"
	Constraint owner: p
		rule: 'num center y = (center y - (num extent y//2) - 2)'
		methods: #('num center primitiveSet.y: center y - (num extent y//2) - 2'
			'num extent y reference'
			'center y reference').
	
	"make den's center be below my center"
	Constraint owner: p
		rule: 'den center y = (center y + (den extent y//2) + 2)'
		methods: #('den center primitiveSet.y: center y + (den extent y//2) + 2'
			'den extent y reference'
			'center y reference').
	p makeCheckConstraintsMethod.! !

ExprQuotient initialize!



Expression subclass: #ExprFactor
	instanceVariableNames: 'text '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!


!ExprFactor methodsFor: 'showing'!

showPicture: medium
	text showPicture: medium! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprFactor class
	instanceVariableNames: ''!


!ExprFactor class methodsFor: 'initialization'!

initialize   "ExprFactor initialize"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	p parts: 'text'.
	p field: #text replaceWith: TextThing prototype recopy.
	p text primitiveSet.frame: (20@20 extent: 24@18).
	p primitiveSet.center: p text frame center.
	p primitiveSet.extent: p text frame extent.

	Constraint owner: p
		rule: 'extent = (text text textExtent + (6@4))'
		methods: #('self primitiveSet.extent: text text textExtent + (6@4)'
				'text text reference').
	Constraint owner: p
		rule: 'text frame origin = (center - (extent //2))'
		methods: #('text frame primitiveSet.origin: center - (extent //2)'
				'center reference'
				'extent reference').
	Constraint owner: p
		rule: 'text frame corner = (center + (extent //2))'
		methods: #('text frame primitiveSet.corner: center + (extent //2)'
				'center reference'
				'extent reference').
	p makeCheckConstraintsMethod.! !

ExprFactor initialize!



ExprHorizontalOp subclass: #ExprTimes
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!


!ExprTimes methodsFor: 'showing'!

operatorName
	^'*'!

precedence
	^3! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprTimes class
	instanceVariableNames: ''!


!ExprTimes class methodsFor: 'initialization'!

initialize   "ExprTimes initialize"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	Constraint owner: p
		rule: 'exp1 value isNil | exp2 value isNil | value isNil or:
				[exp1 value*exp2 value = value]'
		methods: #(
			'self primitiveSet.value: (exp1 value isNil | exp2 value isNil ifTrue: [nil]
					ifFalse: [exp1 value*exp2 value])'
			'exp1 primitiveSet.value: (value isNil | exp2 value isNil ifTrue: [nil]
					ifFalse: [value/exp2 value])'
			'exp2 primitiveSet.value: (value isNil | exp1 value isNil ifTrue: [nil]
					ifFalse: [value/exp1 value])'
					).
	p makeCheckConstraintsMethod.


"old constraint (without the nil junk):
	Constraint owner: p
		rule: 'exp1 value*exp2 value = value'
		methods: #('self primitiveSet.value: exp1 value*exp2 value'
			'exp1 primitiveSet.value: value/exp2 value'
			'exp2 primitiveSet.value: value/exp1 value').
"! !

ExprTimes initialize!



ExprFactor subclass: #ExprConstant
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprConstant class
	instanceVariableNames: ''!


!ExprConstant class methodsFor: 'initialization'!

initialize   "ExprConstant initialize"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	p text primitiveSet.text: '1.0' asText.
	p text center.
	p primitiveSet.value: 1.0 .
	Constraint owner: p
		rule: 'value = text text asNumberOrNil'
		methods: #('self primitiveSet.value: text text asNumberOrNil'
				'text text reference').
	p makeCheckConstraintsMethod.! !

ExprConstant initialize!



ExprFactor subclass: #ExprVariable
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Expressions'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ExprVariable class
	instanceVariableNames: ''!


!ExprVariable class methodsFor: 'initialization'!

initialize   "ExprVariable initialize"
		| p |
	self resetThingLabFields.
	p _ self prototype.
	p text primitiveSet.text: 'x' asText.
	p text center.
	LabelConstraint owner: p
		label: 'text text string' value: 'value'.
	p makeCheckConstraintsMethod! !

ExprVariable initialize!

