"ElectricalSwitch"

"make sure the superclass exists"
#TwoLeadedObject lookupClass!

TwoLeadedObject subclass: #ElectricalSwitch
	instanceVariableNames: 'closed'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

ElectricalSwitch prototype primitives: 'closed'; parts: 'text'.
ElectricalSwitch prototype lead1 node primitiveSet.location: 40@10.
ElectricalSwitch prototype lead2 node primitiveSet.location: 110@40.
ElectricalSwitch prototype field: #closed replaceWith: false!

|trueConstraint falseConstraint|
trueConstraint _ Constraint owner: ElectricalSwitch prototype
	rule: 'lead1 node voltage = lead2 node voltage'
	methods: 
		#('lead1 node primitiveSet.voltage: lead2 node voltage'
		'lead2 node primitiveSet.voltage: lead1 node voltage').

falseConstraint _ Constraint owner: ElectricalSwitch prototype
	rule: 'lead1 current = 0.0'
	methods: 
		#('lead1 primitiveSet.current: 0.0').

ConditionalConstraint owner: ElectricalSwitch prototype
	condition: 'closed'
	ifTrue: (Array with: trueConstraint)
	ifFalse: (Array with: falseConstraint)!

ElectricalSwitch compile: 
'showPicture: medium | center |
	super showPicture: medium.
	center_lead1 node location+lead2 node location//2.
	closed ifTrue: 
		[medium drawLine: (Form dotOfSize: 1) from: center-(20@0) to: center+(20@0)
		rule: Form over fillColor: nil]
	ifFalse: 
		[medium drawLine: (Form dotOfSize: 1) from: center-(20@0) to: center+(20@10)
		rule: Form over fillColor: nil].
	medium drawLine: (Form dotOfSize: 1) from: center-(20@0) to: lead1 node location
		rule: Form over fillColor: nil.
	medium drawLine: (Form dotOfSize: 1) from: center+(20@0) to: lead2 node location
		rule: Form over fillColor: nil.'
classified: 'showing'!
