ThingLabObject subclass: #ElectricalNodeLabel
	instanceVariableNames: 'node label'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

ElectricalNodeLabel prototype parts: 'node label'.
ElectricalNodeLabel prototype field: 'node' replaceWith: #ElectricalNode clonePrototype.
ElectricalNodeLabel prototype field: 'label' replaceWith: #TextThing clonePrototype!

ElectricalNodeLabel prototype label primitiveSet.frame: (20@0 extent: 34@20).
ElectricalNodeLabel prototype label primitiveSet.text:  'n' asText.

ElectricalNodeLabel prototype inserters:  #('node')!

LabelConstraint owner: ElectricalNodeLabel prototype
	label: 'label text string' value: 'node'!

Constraint owner: ElectricalNodeLabel prototype
	rule: 'label frame origin = (node location + (10@-10))'
	methods:  #('label frame primitiveSet.origin: (node location + (10@-10))'
				 'self node primitiveSet.location: label frame origin - (10@-10)'
				)!

Constraint owner: ElectricalNodeLabel prototype
	rule: 'label frame corner = (label frame origin + (34@20))'
	methods:  #('label frame primitiveSet.corner: label frame origin + (34@20)'
			'label frame primitiveSet.origin: label frame corner - (34@20)'
				)!

"make label frame invisible"
ElectricalNodeLabel quickCompile:
'instancePaths: cl 
	cl==Point ifTrue: [^Array with: #(node location) asPath].
	^super instancePaths: cl'!
