"ElectricalNode"

"make sure the superclass exists"
#ElectricalObject lookupClass!

ElectricalObject subclass: #ElectricalNode
	instanceVariableNames: 'voltage currents location'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

ElectricalNode prototype parts: 'currents location'; primitives: 'voltage'.
ElectricalNode prototype field: 'voltage' replaceWith: 0.0 .
ElectricalNode prototype field: 'currents' replaceWith: SetOfPaths new.
ElectricalNode prototype field: 'location' replaceWith: Point prototype recopy.

"If there are zero or more than two currents into the node, the node's picture is a point, otherwise nothing."
ElectricalNode compile: 'showPicture: window
	(currents size=0) | (currents size>2) ifTrue: [location showPicture: window]'
classified: 'showing'.

SetConstraint owner: ElectricalNode prototype 
	rule: 'currents sum = 0'
	set: 'currents'
	element: 'current'
	elementMethod: '0.0 - (currents excluding: current) sum'!
