ThingLabObject subclass: #ElectricalLeadLabel
	instanceVariableNames: 'lead label'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

ElectricalLeadLabel prototype parts: 'lead label'.
ElectricalLeadLabel prototype field: 'lead' replaceWith: #ElectricalLead clonePrototype.
ElectricalLeadLabel prototype field: 'label' replaceWith: #TextThing clonePrototype!

ElectricalLeadLabel prototype label primitiveSet.frame: (60@40 extent: 34@20).
ElectricalLeadLabel prototype label primitiveSet.text:  'lead' asText.

ElectricalLeadLabel prototype inserters:  #('lead')!

LabelConstraint owner: ElectricalLeadLabel prototype
	label: 'label text string' value: 'lead'!

Constraint owner: ElectricalLeadLabel prototype
	rule: 'label frame origin = (lead node location + (10@-10))'
	methods:  #('label frame primitiveSet.origin: (lead node location + (10@-10))'
				 'self lead node primitiveSet.location: label frame origin - (10@-10)'
				)!

Constraint owner: ElectricalLeadLabel prototype
	rule: 'label frame corner = (label frame origin + (34@20))'
	methods:  #('label frame primitiveSet.corner: label frame origin + (34@20)'
			'label frame primitiveSet.origin: label frame corner - (34@20)'
				)!

"make label frame invisible"
ElectricalLeadLabel quickCompile:
'instancePaths: cl 
	cl==Point ifTrue: [^Array with: #(lead node location) asPath].
	^super instancePaths: cl'!
