ThingLabObject subclass: #Conditional
	instanceVariableNames: 'condNode trueNode falseNode resultNode center'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

Conditional prototype parts: 'condNode trueNode falseNode resultNode center'.

Conditional prototype field: 'condNode' replaceWith: #Node clonePrototype.
Conditional prototype field: 'trueNode' replaceWith:  #Node clonePrototype.
Conditional prototype field: 'falseNode' replaceWith: #Node clonePrototype.
Conditional prototype field: 'resultNode' replaceWith: #Node clonePrototype.
Conditional prototype field: 'center' replaceWith: 60@60!

Conditional prototype condNode primitiveSet.location: 60@10.
Conditional prototype trueNode primitiveSet.location: 15@30.
Conditional prototype falseNode primitiveSet.location: 15@90.
Conditional prototype resultNode primitiveSet.location: 100@60.

Conditional prototype inserters:  #('resultNode'  'center'  'trueNode'  'falseNode'  'condNode')!

Constraint owner: Conditional prototype
	rule: 'resultNode value = (condNode value
		ifTrue: [trueNode value] ifFalse: [falseNode value])'
	methods:  #('resultNode primitiveSet.value:
			(condNode value ifTrue: [trueNode value] ifFalse: [falseNode value])'
		'trueNode value reference'
		'falseNode value reference'
		'condNode value reference')!

Conditional quickCompile:
'showPicture: medium
		| p |
	p _ ConstraintPicture new 
		center: center
		name: ''if''
		leftNodes: (Array with: trueNode with: falseNode)
		rightNodes: (Array with: resultNode)
		topNodes: (Array with: condNode)
		bottomNodes: #().
	p showPicture: medium.'!

