ThingLabObject subclass: #BlockThing
	instanceVariableNames: 'arg result text block'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!


BlockThing prototype parts: 'arg result text';
	primitives: 'block'.
BlockThing prototype field: 'arg' replaceWith: #Node clonePrototype.
BlockThing prototype field: 'result' replaceWith: #Node clonePrototype.
BlockThing prototype field: 'text' replaceWith: #TextThing clonePrototype!

BlockThing prototype text primitiveSet.frame: (45@50 extent: 80@20).
BlockThing prototype arg primitiveSet.location: 20@60.
BlockThing prototype result primitiveSet.location: 150@60.
BlockThing prototype text primitiveSet.text:  '' asText.

BlockThing prototype inserters:  #('arg'  'result'  'text')!

"the block is constrained to be the parse of the text"
Constraint owner: BlockThing prototype
	rule: 'block = (Compiler evaluate: text text)'
	methods:  #('self primitiveSet.block: (Compiler evaluate: text text)'
		'text text reference')!

"constraint relating the argument to the result (should be one-way)"
Constraint owner: BlockThing prototype
	rule: 'result value = (block value: arg value)'
	methods:  #('result primitiveSet.value: (block value: arg value)'
		'arg value alter')!

BlockThing quickCompile:
'showPicture: medium
		| f |
	( Smalltalk includesKey: #Function ) ifFalse: [ ^ self ].
	f _ ( Smalltalk at: #Function ) new init.center: text frame center
		name: text text asString
		inputs: (Array with: arg)
		output: result
		inputSide: #top
		outputSide: #bottom.
	f showPicture: medium.
	text frame showPicture: medium.
	text showPicture: medium.'!

