ThingLabObject subclass: #Beam
	instanceVariableNames: 'line unstressedLength'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

Beam prototype parts: 'line'; primitives: 'unstressedLength'.
Beam prototype field: #line replaceWith: (40.0@40.0 line: 88.0@104.0).
Beam prototype field: #unstressedLength replaceWith: 80.0 .

Beam prototype inserters: #('line point1' 'line point2').

(Constraint owner: Beam prototype
	rule: 'line length = unstressedLength'
	test: '(line length - unstressedLength) abs < 0.5'
	error: 'line length - unstressedLength'
	methods: #(
		'line primitiveSet.point1: line point2 + (line point1-line point2*unstressedLength/line length)'
		'line primitiveSet.point2: line point1 + (line point2-line point1*unstressedLength/line length)') ) methodsNotUniqueState!


"To show its label a beam shows the difference between its unstressed length and its line's current length"
Beam quickCompile:
'showPicture: medium
		| displayText |
	line showPicture: medium.
	displayText _ (line length-unstressedLength fixedPrintString: 2) asDisplayText.
	displayText displayOn: medium at: line location - displayText boundingBox center'!

