ThingLabObject subclass: #BarGraph
	instanceVariableNames: 'value bar digits scale'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Prototypes'!

BarGraph prototype parts: 'bar digits'; primitives: 'value scale'.
BarGraph prototype field: #bar replaceWith: (30@50 corner: 50@150).
BarGraph prototype field: #digits replaceWith: #TextThing clonePrototype.
BarGraph prototype digits primitiveSet.text: '10' asText.
BarGraph prototype digits flushRight.
BarGraph prototype digits primitiveSet.frame: (60@60 corner: 95@80).
BarGraph prototype primitiveSet.value: 10; primitiveSet.scale: 10.0!

BarGraph prototype inserters: #('bar' 'digits')!

"keep bar height proportional to value"
Constraint owner: BarGraph prototype
	rule: 'bar origin y = (bar corner y - (scale*value) rounded)'
	methods: #('bar origin y: (bar corner y - (scale*value) rounded)'
		'bar corner y reference'
		'self primitiveSet.value: ((bar corner y-bar origin y) asFloat / scale) rounded')!

Constraint owner: BarGraph prototype
	rule: 'bar width = 20'
	methods: #('bar origin x: bar corner x-20'
		'bar corner x reference')!

Constraint owner: BarGraph prototype
	rule: 'digits text = value printString asText'
	methods: #('digits primitiveSet.text: value printString asText'
		'self primitiveSet.value: digits text asNumber')!


BarGraph quickCompile:
'showPicture: medium
	super showPicture: medium.
	medium fill: (bar insetBy: (2@2 corner: 1@1)) rule: 2 fillColor: Color lightGray '!
