/****************************************************************************
*   PROJECT: Squeak port for Win32 (NT / Win95)
*   FILE:    sqWin32Joystick.c
*   CONTENT: Joystick management
*
*   AUTHOR:  Andreas Raab (ar)
*   ADDRESS: University of Magdeburg, Germany
*   EMAIL:   raab@isg.cs.uni-magdeburg.de
*   RCSID:   $Id: sqWin32Joystick.c,v 2.0.1.3 1998/07/23 19:46:41 raab Exp $
*
*   NOTES:
*     1) Only buttons 1-4 are supported
*     2) No z-Values are supported
*****************************************************************************/
#include <windows.h>
#include "sq.h"

#ifndef NO_JOYSTICK

#ifndef NO_RCSID
  static char RCSID[]="$Id: sqWin32Joystick.c,v 2.0.1.3 1998/07/23 19:46:41 raab Exp $";
#endif

int numJoySticks=0;
JOYCAPS *joySticks = NULL;

int joystickRead(int index)
{ int id;
  JOYINFO joyInfo;
  int xBits,yBits,xMax,yMax;
  int buttons;

  if(numJoySticks < index) return 0;
  switch(index) {
    case 1: id = JOYSTICKID1; break;
    case 2: id = JOYSTICKID2; break;
    default: return 0;
  };

  if(joyGetPos(id,&joyInfo) != JOYERR_NOERROR)
    return 0;

  buttons = joyInfo.wButtons & 0x0F; /* JOYBUTTON1 ... JOYBUTTON4 */
  xMax = joySticks[id].wXmax - joySticks[id].wXmin;
  yMax = joySticks[id].wYmax - joySticks[id].wYmin;
  xBits = ((joyInfo.wXpos - joySticks[id].wXmin) * 0x7FF) / xMax;
  yBits = ((joyInfo.wYpos - joySticks[id].wYmin) * 0x7FF) / yMax;
  return (1 << 27) | (buttons << 22) | (yBits << 11) | xBits;
}

int joystickInit(void)		
{ int i;

  numJoySticks = joyGetNumDevs();
  if(numJoySticks)
    joySticks = calloc(numJoySticks,sizeof(JOYCAPS));
  for(i=0;i<numJoySticks; i++)
    joyGetDevCaps(i,&(joySticks[i]),sizeof(JOYCAPS));
  return 1;
}

#endif /* NO_JOYSTICK */
