/****************************************************************************
*   PROJECT: Squeak port for Win32 (NT / Win95)
*   FILE:    sqWin32ExternalPrims.c
*   CONTENT: External (named) primitive support
*
*   AUTHOR:  Andreas Raab (ar)
*   ADDRESS: University of Magdeburg, Germany
*   EMAIL:   raab@isg.cs.uni-magdeburg.de
*   RCSID:   $Id: sqWin32ExternalPrims.c,v 1.1 1998/10/11 12:39:10 raab Exp raab $
*
*   NOTES:
*     1) Currently, we're looking for DLLs named either sample.dll or sample32.dll
*
*****************************************************************************/
#include <windows.h>
#include <stdio.h>
#include "sq.h"

typedef struct ModuleEntry {
  struct ModuleEntry *next;
  TCHAR name[255];
  HANDLE handle;
} ModuleEntry;

static ModuleEntry *squeakModule = NULL;
static ModuleEntry *firstEntry = NULL;

/* Find the handle for the given module */
ModuleEntry *findModuleEntryNamed(TCHAR *name)
{ 
  ModuleEntry *temp = firstEntry;

  while(temp) {
    if(lstrcmp(temp->name, name) == 0) return temp;
    temp = temp->next;
  }
  return NULL;
}

/* Try to load a given library. Return it's handle or NULL */
HANDLE tryLoading(TCHAR *prefix, TCHAR *baseName, TCHAR *postfix)
{
  TCHAR libName[255];
  HANDLE h;

  lstrcpy(libName,prefix);
  lstrcat(libName,baseName);
  lstrcat(libName,postfix);
  h = LoadLibrary(libName);
#ifndef NDEBUG
  if(h == NULL)
    printLastError(TEXT("LoadLibrary failed"));
#endif
  return h;
}

/* Return the module entry for the given module name */
ModuleEntry *loadModuleEntry(TCHAR *name)
{
  ModuleEntry *temp;
  int ok;

  temp = (ModuleEntry*) calloc(1, sizeof(ModuleEntry));
  lstrcpy(temp->name,name);
  temp->handle = tryLoading(TEXT(""),name,TEXT(""));
  if(!temp->handle) temp->handle = tryLoading(TEXT(""),name,TEXT(".dll"));
  if(!temp->handle) temp->handle = tryLoading(TEXT(""),name,TEXT("32.dll"));
  if(temp->handle)
    { void *fn;
      /* looks ok so far; fetch setInterpreter() function */
      (FARPROC)fn = GetProcAddress(temp->handle,"setInterpreter");
      if(fn) {
        struct VirtualMachine *vm;
        /* get the interpreter proxy */
        vm = sqGetInterpreterProxy();
        /* and call setInterpreter() */
        ok = ((int (*) (struct VirtualMachine *)) fn)(vm);
        if(ok) return temp; /* fine; this worked */
      }
    }
  /* something went wrong - clean up stuff */
  if(temp->handle) FreeLibrary(temp->handle);
  free(temp);
  return NULL;
}

int ioLoadExternalFunctionOfLengthFromModuleOfLength(int functionNameIndex, int functionNameLength, 
                                                     int moduleNameIndex,   int moduleNameLength)
{
  int i;
  ModuleEntry *temp;
  char functionName[256];
  void *fn;

  if(!squeakModule) {
    /* Load the handle for the running VM executable */
    squeakModule = (ModuleEntry *) calloc(1,sizeof(ModuleEntry));
    squeakModule->handle = GetModuleHandle(NULL);
  }

  if(moduleNameLength != 0) 
    {
      TCHAR moduleName[255];

      for(i=0;i<moduleNameLength;i++)
        moduleName[i] = ((unsigned char *)moduleNameIndex)[i];
      moduleName[moduleNameLength] = 0;

      temp = findModuleEntryNamed(moduleName);
      if(!temp) {
        /* new module */
        temp = loadModuleEntry(moduleName);
        if(!temp) return success(false);
        temp->next = firstEntry;
        firstEntry = temp;
      }
    }
  else
    temp = squeakModule;

  /* module has been found; load the function from it */
  for(i=0;i<functionNameLength;i++)
    functionName[i] = ((char *)functionNameIndex)[i];
  functionName[functionNameLength] = 0;

  /* Load the function address from the module handle */
  (FARPROC) fn = GetProcAddress(temp->handle, functionName);

  if(!fn)
    {
      return success(false);
    }
  return (int) fn;
}
