#ifndef SQ_WIN_32_H
#define SQ_WIN_32_H

/* The following is not exported by sq.h but we need it
   since if we don't have CURRENT_VERSION around anymore
   and we may want to check for the image version we need it */

int readableFormat(int imageVersion);

/*************************************************************/
/* NOTE: For a list of possible definitions see file README. */
/*************************************************************/

#ifdef _MSC_VER
/* disable "function XXXX: no return value" */
#pragma warning(disable:4035)
#endif

#ifndef SQ_IMAGE_VERSION_MAJOR
#define SQ_IMAGE_VERSION_MAJOR 2
#endif
#ifndef SQ_IMAGE_VERSION_MINOR
#define SQ_IMAGE_VERSION_MINOR 0
#endif

#if (SQ_IMAGE_VERSION_MAJOR < 2)
#error "These files are only for Squeak >= 2.0"
#endif

/* The following are the names of the default images
   for this particular version */
#define DEFAULT_IMAGE_NAME "Squeak2.3.image"
#define BASE_IMAGE_NAME    "Squeak.image"

/* Definition for Intel Processors */
#ifdef _M_IX86
  #define WIN32_NAME "Win32"
  #define WIN32_OS_NAME (fWindows95 ? "95" : "NT")
  #define WIN32_PROCESSOR_NAME "IX86"

  /* Use console for warnings if possible */
  #ifndef UNICODE
    #define warnPrintf printf
  #endif

  /* We have a faster version for byte reversal with VC++ */
  #ifdef _MSC_VER
    #define NO_STD_BYTE_REVERSAL
  #endif
#endif

#ifdef __GNUC__

  #define WIN32_NAME "Win32"
  #define WIN32_OS_NAME (fWindows95 ? "95" : "NT")
  #define WIN32_PROCESSOR_NAME "IX86"

  /* Use console for warnings if possible */
  #ifndef UNICODE
    #define warnPrintf printf
  #endif

  /* for now just get up and running with Cygnus GCC */ 
  #define MINIMAL
#endif

#ifdef MINIMAL
  /* The hardcoded defs:
     No virtual memory support; no service support; no preferences; no printing */
  #define NO_VIRTUAL_MEMORY
  #define NO_SERVICE
  #define NO_PREFERENCES
  #define NO_PRINTER
  /* Use stub definitions from sqWin32Stubs.c */
  #define NO_SOUND
  #define NO_SERIAL_PORT
  #define NO_NETWORK
  #define NO_JOYSTICK
  #define NO_MIDI
  #define NO_ASYNC_FILES
  /* Do not rely on stdio functions but rather pure Win32 stuff */
  #define WIN32_FILE_SUPPORT
  /* Take out the static strings */
  #define NO_RCSID
  #define NO_WARNINGS
#if 0
  /* Finally, override the warning functions containing static strings */
  #undef printLastError
  #define printLastError
  #undef warnPrintf
  #define warnPrintf
#endif
#endif

/********************************************************/
/* Message hooks for processing out of sqWin32Window.c  */
/********************************************************/
typedef int (*messageHook)(void *, unsigned int, unsigned int, long);
/* the global entry for any message hook */
extern messageHook firstMessageHook;


/********************************************************/
/* Several setup functions                              */
/********************************************************/
void SetupFilesAndPath();
void SetupKeymap();
void SetupWindows();
void SetupPixmaps();
void SetupPrinter();
void SetupTimer();
void SetupPreferences();
void SetupMIDI();


/********************************************************/
/* external SYNCHRONIZED signaling of semaphores        */
/********************************************************/
int synchronizedSignalSemaphoreWithIndex(int semaIndex);

/********************************************************/
/* image reversal functions                             */
/********************************************************/
int reverse_image_words(int *ptr,int d, int w,int h,int x0,int y0,int x1,int y1);
int reverse_image_bytes(int *ptr,int d, int w,int h,int x0,int y0,int x1,int y1);

/********************************************************/
/* Image options / VM options                           */
/********************************************************/
char *GetImageOption(int id);
char *GetVMOption(int id);


/********************************************************/
/* Misc functions                                       */
/********************************************************/
void SetWindowSize();
void ReleaseTimer();
int printUsage(int level);

/********************************************************/
/* Service Stuff                                        */
/********************************************************/
#ifndef NO_SERVICE
/* The external startup point for installing squeak as NT service */
void sqServiceInstall(void);
/* The main() function used by NT services */
int sqServiceMain(void);
/* The generic main() function for starting squeak */
int sqMain(char *lpCmdLine, int nCmdShow);
#endif

/********************************************************/
/********************************************************/
/* Stuff requiring to include windows.h                 */
/********************************************************/
/********************************************************/

#if defined(_WINDOWS_) || defined(_GNU_H_WINDOWS_H)

/********************************************************/
/* Declarations we may need by other modules            */
/********************************************************/
extern char imageName[];		  /* full path and name to image */
extern TCHAR vmPath[];		    /* full path to interpreter's directory */
extern TCHAR vmName[];		    /* name of the interpreter's executable */

#ifndef NO_PREFERENCES
extern HMENU vmPrefsMenu;         /* preferences menu */
#endif

extern HWND  consoleWindow;       /* console */


extern HWND stWindow;	     	         /*	the squeak window */
extern HINSTANCE hInstance;	     /*	the instance of squeak running */
extern HCURSOR currentCursor;	     /*	current cursor displayed by squeak */
extern HPALETTE palette;	     /*	the palette (might be unused) */
extern LOGPALETTE *logPal;	     /*	the logical palette definition */
extern BITMAPINFO *bmi1;	     /*	1 bit depth bitmap info */
extern BITMAPINFO *bmi4;	     /*	4 bit depth bitmap info */
extern BITMAPINFO *bmi8;	     /*	8 bit depth bitmap info */
extern BITMAPINFO *bmi16;	     /*	16 bit depth bitmap info */
extern BITMAPINFO *bmi32;	     /*	32 bit depth bitmap info */
extern BOOL fWindows95;        /* Are we running on Win95 or NT? */

/* Startup options */
extern BOOL  fHeadlessImage;      /* Do we run headless? */
extern BOOL  fRunService;         /* Do we run as NT service? */
extern DWORD dwMemorySize;        /* How much memory do we use? */

extern HANDLE vmSemaphoreMutex;   /* the mutex for synchronization of access to the
                                     external semaphores in the VM */


/* variables for cached display */
extern RECT updateRect;		     /*	the rectangle to update */
extern HRGN updateRgn;	     	     /*	the region to update (more accurate) */
extern BOOL updateRightNow;	     /*	update flag */

/********************************************************/
/* Preference values                                    */
/********************************************************/
extern BOOL fDeferredUpdate; /* I prefer the deferred update*/
extern BOOL fShowConsole;    /* do we show the console window?*/
extern BOOL fDynamicConsole; /* Should we show the console if any errors occur? */
extern BOOL fReduceCPUUsage; /* Should we reduce CPU usage? */
extern BOOL f3ButtonMouse;   /* Should we use a real 3 button mouse mapping? */


/******************************************************/
/* String conversions between Unicode / Ansi / Squeak */
/******************************************************/
/* Note: fromSqueak() and fromSqueak2() are inline conversions
         but operate on two different buffers. The maximum length
         of strings that can be converted is MAX_PATH */
TCHAR*  fromSqueak(const char *sqPtr, int sqLen);   /* Inline Squeak -> C */
TCHAR*  fromSqueak2(const char *sqPtr, int sqLen);  /* 2nd inline conversion */
/* Note: toUnicode() and fromUnicode() are inline conversions
         with for at most MAX_PATH sized strings. If the VM
         is not compiled with UNICODE defined they just return
         the input strings. Also, toUnicode operates on the
         same buffer as fromSqueak() */
TCHAR*  toUnicode(const char *ptr);                 /* Inline Ansi -> Unicode */
char*   fromUnicode(const TCHAR *ptr);              /* Inline Unicode -> Ansi */
/* Note: toUnicodeNew and fromUnicodeNew malloc() new strings.
         It is up to the caller to free these! */
TCHAR*  toUnicodeNew(const char *ptr);                 /* Inline Ansi -> Unicode */
char*   fromUnicodeNew(const TCHAR *ptr);              /* Inline Unicode -> Ansi */

/******************************************************/
/* Output stuff                                       */
/******************************************************/
#ifndef sqMessageBox
int     sqMessageBox(DWORD dwFlags, const TCHAR *titleString, const char* fmt, ...);
#endif

#ifndef warnPrintf
int     warnPrintf(const TCHAR *fmt, ...);
#endif

#ifndef abortMessage
int     abortMessage(const TCHAR *fmt,...);
#endif

/* a neat little helper - print prefix and the GetLastError() meaning */
#ifndef printLastError
void printLastError(TCHAR *prefix);
#endif

/******************************************************/
/* Misc functions                                     */
/******************************************************/
DWORD SqueakImageLength(TCHAR *fileName);


/****************************************************************************/
/* few addtional definitions for those having older include files           */
/****************************************************************************/
#if (WINVER < 0x0400) && !defined(_GNU_H_WINDOWS_H)
/* CreateWindowEx params since Win95/NT4 */
#define WS_EX_WINDOWEDGE        0x00000100L
#define WS_EX_CLIENTEDGE        0x00000200L
#define WS_EX_OVERLAPPEDWINDOW  (WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE)
#define WS_EX_APPWINDOW         0x00040000L
#define WS_EX_TOOLWINDOW        0x00000080L
#define WS_EX_CONTEXTHELP       0x00000400L

/* WM_USERCHANGED since Win95/NT4 */
#define WM_USERCHANGED                  0x0054

/* Shell_NoifiyIcon() for the system tray on Win95/NT4 */
typedef struct _NOTIFYICONDATAA {
        DWORD cbSize;
        HWND hWnd;
        UINT uID;
        UINT uFlags;
        UINT uCallbackMessage;
        HICON hIcon;
        CHAR   szTip[64];
} NOTIFYICONDATA, *PNOTIFYICONDATA;

#define NIM_ADD         0x00000000
#define NIM_MODIFY      0x00000001
#define NIM_DELETE      0x00000002

#define NIF_MESSAGE     0x00000001
#define NIF_ICON        0x00000002
#define NIF_TIP         0x00000004

#endif /* WINVER < 0x0400 */

/******************************************************/
/* Profiling support                                  */
/******************************************************/
#if 0
#define PROFILE           /* if you want some information about times */
#define PROFILE_DISPLAY 1 /* measure times in ioShowDisplay() */
#endif

#ifdef PROFILE
#define PROFILE_BEGIN(condition) if(condition) { DWORD __profileTicks = GetTickCount();
#define PROFILE_END(variable) variable += GetTickCount() - __profileTicks; }
#define PROFILE_SHOW(variable) if(variable) {char s[20]; MessageBox(0,itoa(variable, s, 10), "Milliseconds for " #variable, MB_OK); }
#else
#define PROFILE_BEGIN(condition)
#define PROFILE_END(variable)
#define PROFILE_SHOW(variable)
#endif

#ifdef PROFILE
extern DWORD ticksForReversal; /* time needed for byte/word reversal */
extern DWORD ticksForBlitting; /* time needed for actual blts */
#endif

#endif /* _WINDOWS_ */

#endif /* SQ_WIN_32_H */
