/****************************************************************************
*   PROJECT: Squeak port for Win32 CE (NT / Win95)
*   FILE:    stdio.h
*   CONTENT: stdio.h is not included in the WCE SDK.
*
*   AUTHOR:  Blair McGlashan
*   ADDRESS: Intuitive Systems Ltd, Stevenage, Herts SG1 3EE, UK
*   EMAIL:   blair@intuitive.co.uk
*   RCSID:   
*
*   NOTES:
*			To keep the size of these routines down, they do not implement
*			necessarily implement the full, (or even the same) functionality 
*			as the real C runtime library routine. Error checking, in particular, 
*			is omitted.
*
*****************************************************************************/
#if _MSC_VER > 1000
#pragma once
#endif

#ifndef _INC_STDIO
#define _INC_STDIO

#ifndef _WIN32_WCE
	#error ERROR: For WinCE only!
#endif

#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <winbase.h>

#define EOF     (-1)

#ifndef _FILE_DEFINED
	typedef	void FILE;
	#define _FILE_DEFINED
#endif

/* Prototypes *
*/
int __cdecl printf(const char *, ...);
int __cdecl putchar(int);

int __cdecl fprintf(FILE *, const char *, ...);

// Do nothing for fflush() because we're using Win32 I/O routines directly
#define fflush(d)
int __cdecl fseek(FILE *, long, int);
//#define fseek(s,off,orig) SetFilePointer(s,off,NULL,orig)

int __cdecl fclose(FILE *);
//#define fclose(f) (CloseHandle(f) ? 0 : EOF)

#undef SEEK_SET
#define SEEK_SET FILE_BEGIN

#undef SEEK_END
#define SEEK_END FILE_END

size_t __cdecl fread(void *, size_t, size_t, FILE *);
long __cdecl ftell(FILE *);
size_t __cdecl fwrite(const void *, size_t, size_t, FILE *);
FILE * __cdecl fopen(const char *, const char *);
FILE * __cdecl _wfopen(const wchar_t *, const wchar_t *);
int __cdecl remove(const char *);
int __cdecl rename(const char *, const char *);

FILE *stderr;
FILE *stdout;

#endif  /* _INC_STDIO */
