/****************************************************************************
*   PROJECT: Squeak port for Win32 CE (NT / Win95)
*   FILE:    sqWinCEAlloc.c
*   CONTENT: Time routines is not included in the WCE Memory management.
*
*   AUTHOR:  Alejandro F. Reimondo
*   ADDRESS: Sugar - http://www.sugarWeb.com
*   EMAIL:   aleReimondo@sugarWeb.com
*   RCSID:   
*
*   NOTES:
*
*****************************************************************************/
#include <windows.h>
#include "sq.h"

extern void exit(int status);
//extern int exit(int);

// Reimplement malloc in order to catch out of memory conditions once. This saves
// repeating the code, since there is nowt we can do to recover anyway.
void* malloc(size_t size)
{
	void* pBlock = LocalAlloc(LPTR, size);
	if (pBlock == NULL)
	{
		SHShowOutOfMemory(0,0);
		exit(-1);
	}
	return pBlock;
}

void free(void* memblock)
{
	LocalFree(memblock);
}

void *calloc(size_t num, size_t size)
{
	return malloc(num * size);
}

//
LPVOID GlobalLock(HGLOBAL hMem)
{
	return LocalLock (hMem);
}

//
HGLOBAL GlobalHandle(LPCVOID pMem)
{
	return LocalHandle (pMem);
}

//
BOOL GlobalUnlock(HGLOBAL hMem)
{
	return LocalUnlock (hMem);
}

//
HGLOBAL GlobalAlloc(UINT uFlags,DWORD dwBytes)
{
	return LocalAlloc(LMEM_ZEROINIT, dwBytes);
}

void GlobalFree(void* memblock)
{
	LocalFree(memblock);
}
  
#if defined(NO_VIRTUAL_MEMORY)
// Rather than malloc() enormous block from the heap, grab it straight from lowest
// level allocator. We have to do this for CE anyway because the local heap cannot 
// exceed 1Mb in size
void* sqAllocateMemory(int minHeapSize, int desiredHeapSize)
{
	return VirtualAlloc(NULL, desiredHeapSize, MEM_COMMIT, PAGE_READWRITE);
}
#endif // defined(NO_VIRTUAL_MEMORY)


// Initialize the object memory space
int initializeCEMemorySpace(DWORD imageSize)
{	
	DWORD memSize = (DWORD)-1;

	// Determine the amount of available memory
	MEMORYSTATUS memStats;
	memStats.dwLength = sizeof(memStats);
	GlobalMemoryStatus(&memStats);
	
	// The max. mem. size should leave some free space for other apps
	// and the system
	memSize = memStats.dwAvailPhys - 128*1024;
	
#if defined(NO_VIRTUAL_MEMORY)
	{
		// Allow 512k free working space for the object memory to grow
		DWORD imageBytes = imageSize + 512*1024;
		memSize = min(memSize, imageBytes);
	}
#endif
	
	return memSize;
}
