/* Identification of, and configuration for, various types of Unix platform.
 *
 * Author: Ian Piumarta (ian.piumarta@inria.fr)
 *
 * $Log: sqUnixConfig.h,v $
 * 
 * Revision 1.2+os2 1997/06/01  boris
 *
 * Revision 1.2  1996/11/15  17:34:38  piumarta
 * Added support for HAS_SUN_AUDIO.
 *
 * Revision 1.1  1996/10/24  13:23:50  piumarta
 * Initial revision
 *
 */


/* this file must define the following symbols if appropriate:

   HAS_D_NAMLEN
      defined if struct dirent has d_namlen field and hence directory names
      are not null terminated.  if underfined then directory names are null
      terminated.

   HAS_TIMEZONE
      defined if the external variable timezone is available, containing the
      local offset from GMT in seconds.  if undefined then the tm structure
      must contain the same information in the tm_gmtoff field.

   HAS_ON_EXIT
      defined if cleanup functions are declared with on_exit().  If
      undefined then cleanup functions are declared with atexit().

   HAS_MSB_FIRST
      defined if the most significant byte is first in an int.

   HAS_LSB_FIRST
      defined if the least significant byte is first in an int.
      (Complains if neither of the last two are defined.)

   HAS_SUN_AUDIO
      defined if the platform supports the Sun /dev/audio device.

   DOUBLE_WORD_ALIGNMENT
      defined if the platform CANNOT support double-word accesses at an
      arbitrary word address.
      
   DOUBLE_WORD_ORDER
      defined if the platform stores floats in the opposite order
      to the Squeak image (the image is always PowerPC order).

   SUN_FUN_KEYS
      defined for Sun type 3 or 4 keyboards to enable the editing keys
      (Again, Undo, Copy, Paste, Cut, Find, Stop on the "left keypad",
      and PgUp, PgDn, Home, End keys on the right keypad).
*/

#if defined(sun) && (defined(sparc) || defined(__sparc))
# include <errno.h>
# ifdef ECHRNG					/* Sparc/Solaris */
#  undef  HAS_D_NAMLEN
#  define HAS_TIMEZONE
#  undef  HAS_ON_EXIT
#  define HAS_MSB_FIRST
#  undef  HAS_SUN_AUDIO
#  define DOUBLE_WORD_ALIGNMENT
#  undef  DOUBLE_WORD_ORDER
#  define SUN_FUN_KEYS
# else						/* Sparc/SunOS */
#  define HAS_D_NAMLEN
#  undef  HAS_TIMEZONE
#  define HAS_ON_EXIT
#  define HAS_MSB_FIRST
#  undef  HAS_SUN_AUDIO
#  define DOUBLE_WORD_ALIGNMENT
#  undef  DOUBLE_WORD_ORDER
#  define SUN_FUN_KEYS
# endif
#endif

#if defined(sun) && defined(i386)		/* iX86/Solaris */
# undef  HAS_D_NAMLEN
# define HAS_TIMEZONE
# undef  HAS_ON_EXIT
# define HAS_LSB_FIRST
# undef  HAS_SUN_AUDIO
# undef  DOUBLE_WORD_ALIGNMENT
# undef  DOUBLE_WORD_ORDER
#endif

#if defined(mips) || defined(__mips)
# if defined(_SYSTYPE_SVR4)			/* (SGI)/IRIX */
#  undef  HAS_D_NAMLEN
#  define HAS_TIMEZONE
#  undef  HAS_ON_EXIT
#  define HAS_MSB_FIRST
#  undef  HAS_SUN_AUDIO
#  undef  DOUBLE_WORD_ALIGNMENT
#  undef  DOUBLE_WORD_ORDER
# endif
#endif

#if defined(linux)
# if defined(i386)				/* iX86/Linux */
#  undef  HAS_D_NAMLEN
#  define HAS_TIMEZONE
#  undef  HAS_ON_EXIT
#  define HAS_LSB_FIRST
#  undef  HAS_SUN_AUDIO
#  undef  DOUBLE_WORD_ALIGNMENT
#  define DOUBLE_WORD_ORDER
# endif
#endif

#if defined(__alpha)				/* Alpha/OSF1 */
# define HAS_D_NAMLEN
# undef  HAS_TIMEZONE
# undef  HAS_ON_EXIT
# define HAS_LSB_FIRST
# undef  HAS_SUN_AUDIO
# undef  DOUBLE_WORD_ALIGNMENT
# define DOUBLE_WORD_ORDER
#endif

#if defined(__EMX__) && defined (__GNUC__)
#define ITIMER_POSIX
#define FS_HAS_NO_LINKS
#define HAS_D_NAMLEN
#define HAS_TIMEZONE
#undef  HAS_ON_EXIT
#define HAS_LSB_FIRST
#undef  HAS_SUN_AUDIO
#undef  DOUBLE_WORD_ALIGNMENT
#define DOUBLE_WORD_ORDER
#endif

#if !defined(HAS_LSB_FIRST) && !defined(HAS_MSB_FIRST)
--> test for, and describe, your architecture here.
#endif
