
nil subclass: #MSReadProxy
  instanceVariableNames: 
    ' objectSet realObject '
  classVariableNames: ''
  poolDictionaries: '' !
MSReadProxy subclass: #MSMultiObjectReadProxy
  instanceVariableNames: 
    ' ids '
  classVariableNames: ''
  poolDictionaries: ''  !
MSReadProxy subclass: #MSSingleObjectReadProxy
  instanceVariableNames: 
    ' id '
  classVariableNames: ''
  poolDictionaries: ''  !
Error subclass: #MSError
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''  !
MSError subclass: #MSBranchAboutToMorphException
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''  !
MSError subclass: #MSDBObjectHasChanged
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''   !
MSError subclass: #MSDeletedLeafException
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: '' !
Object subclass: #MinneStore
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''  !
MinneStore subclass: #MinneStoreDB
  instanceVariableNames: 
    ' objectSets path duringTransaction persistenceCreationMethod uniqueObjectSets '
  classVariableNames: ''
  poolDictionaries: ''    !
MinneStore subclass: #MSAspect
  instanceVariableNames: 
    ' name getter setter objectSetName '
  classVariableNames: ''
  poolDictionaries: ''    !
MSAspect subclass: #MSMultiObjectAspect
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''   !
MSAspect subclass: #MSSingleObjectAspect
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''  !
MinneStore subclass: #MSBranch
  instanceVariableNames: 
    ' leaves maximumValue leavesFileId parent maximumLeavesPerBranch leafPersistence '
  classVariableNames: ''
  poolDictionaries: ''  !
MinneStore subclass: #MSHighValue
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: '' !
MinneStore subclass: #MSLeaf
  instanceVariableNames: 
    ' value ids '
  classVariableNames: ''
  poolDictionaries: '' !
MinneStore subclass: #MSNilValue
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''  !
MinneStore subclass: #MSObjectSet
  instanceVariableNames: 
    ' name path indexes aspects myPersistence objectPersistence database cache persistenceCreationMethod hasChangedMethod afterStoringMethod beforeStoringMethod afterReadingMethod getAllOrOne andOr result recursion '
  classVariableNames: ''
  poolDictionaries: '' !
MinneStore subclass: #MSStorageProxy
  instanceVariableNames: 
    ' objectSetName '
  classVariableNames: ''
  poolDictionaries: '' !
MSStorageProxy subclass: #MSMultiObjectStorageProxy
  instanceVariableNames: 
    ' ids '
  classVariableNames: ''
  poolDictionaries: ''    !
MSStorageProxy subclass: #MSSingleObjectStorageProxy
  instanceVariableNames: 
    ' id '
  classVariableNames: ''
  poolDictionaries: ''    !
MinneStore subclass: #MSText
  instanceVariableNames: 
    ' textString '
  classVariableNames: ''
  poolDictionaries: ''    !
MinneStore subclass: #MSTreeHolder
  instanceVariableNames: 
    ' name getter setter path domain owner indexTree indexTreePersistence maximumLeavesPerBranch lastLeafValueFound indexTreeChanges persistenceCreationMethod '
  classVariableNames: ''
  poolDictionaries: ''    !
MinneStore subclass: #MSTrunk
  instanceVariableNames: 
    ' leftTrunkOrBranch rightTrunkOrBranch maximumValue parent '
  classVariableNames: ''
  poolDictionaries: '' !
MinneStore subclass: #MSUnitOfWork
  instanceVariableNames: 
    ' workSteps '
  classVariableNames: ''
  poolDictionaries: ''   !
MinneStore subclass: #MSWorkStep
  instanceVariableNames: 
    ' workBlock successBlock failureBlock '
  classVariableNames: ''
  poolDictionaries: ''   !


!MSReadProxy class methods !
 
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
MinneStore

    ^true! !



!MSMultiObjectReadProxy class methods !
   
Copyright
	"Copyrighted (c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."! !



!MSSingleObjectReadProxy class methods !

Copyright
	"Copyrighted (c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."! !



!MSError class methods !

MinneStore

    ^true! !



!MSBranchAboutToMorphException class methods ! !



!MSDBObjectHasChanged class methods ! !



!MSDeletedLeafException class methods ! !



!MinneStore class methods !
   
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
initializePath: aString
	"Create path.  If it already exists, remove all files in it."

	| dir |
	dir := Directory pathName: aString.
	dir exists
		ifFalse: [ dir create ]
		ifTrue: [ dir isEmpty ifFalse: [ dir allFilesDo: [ :each | each remove ] ]].!
  
MinneStore!
 
new
	"Answer a new initialized instance of myself."

	^super new initialize.! !



!MinneStoreDB class methods !
 
Comments
"
	Anything stored is not really stored until the transaction is committed.
	In other words, if you store something and then change that object
	before committing the transaction, the changes will be stored too when
	the transaction is committed.
"!

Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
fileName

	^'MSDB.obj'!
   
newOn: aString
	"Public - Instantiate myself and set path to aString."

	self initializePath: aString.
	^self basicNew
		path: aString;
		initialize;
		yourself.!
   
openOn: pathName
	"Public - Load an instance of myself from pathName."

	| path |
	path := (pathName last = $\
		ifTrue: [pathName]
		ifFalse: [pathName , '\']).
	^ObjectFiler loadFromPathName: path , self fileName.! !



!MSAspect class methods !
  
Comments
"
	an Aspect contains meta-data about an ObjectSets relationship 
	to another ObjectSet.  An aspect knows how to get an aspect value
	from an object in an ObjectSet.

		For example: 
			ObjectSet named #Person has an aspect named #address which 
			holds one or many objects that are stored in ObjectSet named #Address
"!
 
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
newName: nameSymbol
getter: getterSymbol
setter: setterSymbol
objectSetName: osnSymbol
	"Answer a new instance of myself with everything filled in."

	^self new
		name: nameSymbol;
		getter: getterSymbol;
		setter: setterSymbol;
		objectSetName: osnSymbol;
		yourself.! !



!MSMultiObjectAspect class methods !
  
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."! !



!MSSingleObjectAspect class methods !
  
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."! !



!MSBranch class methods !
  
Comment
"
	Branches hold Leaves.
	Branches are held by Trunks.
"!
   
constructEventsTriggered
        "Private - answer the set of events that instances of the
        receiver can trigger."
    ^super constructEventsTriggered
		add: #aboutToMorph;
		yourself.!
   
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
newOn: aPathName parent: aTreeHolder
	"This will be used when creating the first branch in a new tree."

	self initializePath: aPathName.
	^self new
		parent: aTreeHolder;
		maximumValue: MSHighValue;
		leafPersistence:
			(DOMultiObjectService newMultiUser
				fileNamePattern: 'INDX9999.OBJ';
				pathName: aPathName;
				yourself);
		yourself.!
 
test1

	self testExample.
	
	self testExample allLeaves.
	
	self testExample leafGreaterThanOrEqualTo: 'Renee'.
	!
   
testExample
	"Answer a small index tree for testing."

	^(self newOn: 'C:\HI')
		addLeafValue: 'Jonathan' id: 31;
		addLeafValue: 'Debra' id: 32;
		addLeafValue: 'Diane' id: 34;
		addLeafValue: 'Dan' id: 30;
		addLeafValue: 'Doug' id: 35;
		addLeafValue: 'Kristen' id: 28;
		addLeafValue: 'Renee' id: 29;
		addLeafValue: 'Andrea' id: 23;
		addLeafValue: 'Bret' id: 37;
		addLeafValue: 'Craig' id: 29;
		addLeafValue: 'Casper' id: 33;
		addLeafValue: 'Ronald' id: 54;
		addLeafValue: 'David' id: 36;
		yourself.! !



!MSHighValue class methods !
  
< anObject

    ^true!

<= anObject

    ^true!
   
= anObject

    ^false!
   
> anObject

    ^true!

>= anObject

    ^false!
  
Copyright
	"Copyrighted (c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."! !



!MSLeaf class methods !
 
Comment
"
	Leaves are held by branches.
"!
   
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
newValue: anObject id: anInteger

	^self new
		value: anObject 
		id: anInteger
		
		! !



!MSNilValue class methods !
   
< anObject

	^(self >= anObject) not!
 
<= anObject

	^true!
  
= anObject
	
	^self == anObject!
  
> anObject

    ^(self <= anObject) not!
  
>= anObject

    ^self == anObject!
   
Copyright
	"Copyrighted (c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
  
isMSNilValue

	^true! !



!MSObjectSet class methods !
   
Comments
"
This class represents the interface for storing/retrieving an Object into/from
a set of like objects.  Like objects are distinguished by their class or their
class group.  Like objects must have the same index interface (In other 
words, have the same index value getter methods).
"
!
  
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
fileName
    "Private - Answer a string with the file name where I am stored."

    ^'MSObjSet.obj'!
 
myPersistenceFileName
	"Private - Answer the file name for my persistence 'manager' ."

	^'DOPrstnc.obj'!

new
    "Do not use this method.  Use #newOn:  "

    Error signal: 'Do not use #new.  Use #newOn: pathName'!

newOn: aString
	"Public - Instantiate myself and set path to aString."

	self initializePath: aString.
	^self basicNew
		path: aString;
		initialize;
		yourself.!
   
newOn: aString for: aMinneStoreDB
	"Public - Instantiate myself and set path to aString."

	self initializePath: aString.
	^self basicNew
		database: aMinneStoreDB;
		path: aString;
		initialize;
		yourself.!

openOn: pathName
	"Public - Load an instance of myself from pathName."

	| fullFileName dbm path tempPersistence |
	path := (pathName last = $\
		ifTrue: [pathName]
		ifFalse: [pathName , '\']).
	tempPersistence := (DOService openOn: path , self myPersistenceFileName).
	dbm := tempPersistence read.
	dbm isNil
		ifTrue: [FileError signal].
	dbm myPersistence: tempPersistence.
	^dbm.! !



!MSStorageProxy class methods !
  
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."! !



!MSMultiObjectStorageProxy class methods !
 
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
newFor: aCollection and: anMSObjectSet
	"Create a new instance of myself using aCollection and anMSObjectSet.
	This method is being called right before saving an object to disk."

	^self new
		ids: (aCollection collect: [ :each | anMSObjectSet idFor: each ]);
		yourself.! !



!MSSingleObjectStorageProxy class methods !
 
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
newFor: anObject and: anMSObjectSet
	"Create a new instance of myself using anObject and anMSObjectSet."

	^self new
		id: (anMSObjectSet idFor: anObject);
		yourself.
	! !



!MSText class methods !
   
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
lowValue
	"Answer the lowest possible value to be used in place of nil."

	^String new!
  
newOn: aString
	"Public - use this instead of new"

	^self new textString: aString.! !



!MSTreeHolder class methods !
  
Comment
"
	Instances of this class hold an index tree for Smalltalk objects.  Think of 
	this index tree as an index on a column in a relational table.
	
	Each table row represents an object instance.
	Each table column represents an aspect or attribute of that object.
"!
 
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
newOn: aPathName owner: anMSObjectSet
    "Public - Answer a new instance of myself with path
    set to aString."

    ^(self basicNew)
		path: aPathName;
		owner: anMSObjectSet;
		initialize;
		yourself.!
  
test

	| path tmp |
	path := 'C:\JUNK'.
	DOService initializeTestPath: path.
	tmp := (self newOn: path)
		addValue: 'Hi' id: 5;
		addValue: 'bye' id: 9;
		addValue: 'cu' id: 10;
		addValue: 'pow-wow' id: 11;
		addValue: 'jon' id: 31;
		addValue: 'deb' id: 32;
		addValue: 'kris' id: 28;
		addValue: 'paul' id: 60;
		addValue: 'rosalie' id: 54;
		yourself.
	^tmp! !



!MSTrunk class methods !

Comment
"
	Trunk hold Trunks and Branches.
	Branches hold Leaves.
"!

Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
newOn: anMSBranch parent: aTreeHolderOrTrunk
	"Answer a new instance of myself with aBranch split between my right and left branches."

	^self new
		left: anMSBranch asLeftBranch
		right: anMSBranch asRightBranch
		parent: aTreeHolderOrTrunk! !



!MSUnitOfWork class methods !
 
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
exampleFailure
	"Example of how to create and start a Unit of Work."

	^self new
		add: MSWorkStep exampleSuccessful;
		add: MSWorkStep exampleFailure;
		add: MSWorkStep exampleSuccessful;
		start;
		yourself.!
  
exampleSuccessful
	"Example of how to create and start a Unit of Work."

	^self new
		add: MSWorkStep exampleSuccessful;
		add: MSWorkStep exampleSuccessful;
		add: MSWorkStep exampleSuccessful;
		start;
		yourself.!

new
	"Answer a new initialized instance of myself."

	^super new initialize.! !



!MSWorkStep class methods !
   
Copyright
	"Copyright(c) 1997  Jonathan A. Carlson.   Please read the full text of the 
	GNU General Public License. It can be found in GNUGPL.HTM on the 
	distribution diskette."!
 
exampleFailure
	"Example of how to create a work step.
	The #onSuccessDo: and #onFailureDo: methods are not required."

	^self new
		work: 
			[Transcript show: 'Working.';cr.  
			1 dfdf. "Will fail with DoesNotUnderstand." ];
		onSuccessDo: [ Transcript show: 'All steps were successful.  I''m committing my changes.';cr ];
		onFailureDo: [ Transcript show: 'A step failed!!  I''m rolling back my changes.';cr ];
		yourself.!
   
exampleSuccessful
	"Example of how to create a work step.
	The #onSuccessDo: and #onFailureDo: methods are not required."

	^self new
		work: [ Transcript show: 'Working.';cr ];
		onSuccessDo: [ Transcript show: 'All steps were successful.  I''m committing my changes.';cr ];
		onFailureDo: [ Transcript show: 'A step failed!!  I''m rolling back my changes.';cr ];
		yourself.! !



!MSReadProxy methods !
   
basicRealObject

	^realObject!

class

	^self realObject class!
   
doesNotUnderstand: aMessage
	"Read in and become my real object.  Reimplemented by my subclasses."

	^self realObject
		perform: aMessage selector
		withArguments: aMessage arguments.!
   
getRealObject
	"This is common code used my subimplementers."

	realObject == nil
		ifTrue: [realObject := #error].!

inspect

	self realObject inspect.!
   
isMSProxy
	"Answer true."

	^true!
   
isMSReadProxy
	"Answer true"

	^true!

objectSet

	^objectSet!
   
objectSet: anMSObjectSet

	objectSet := anMSObjectSet!

printString

	^'a MSReadProxy{', self basicRealObject printString, '}'!
   
realObject

	realObject == #error
		ifTrue: [^#ThereWasAProblemInstantiatingThisObject].
	self realObjectIsInstantiated
		ifFalse: [self getRealObject].
	^realObject!

realObjectIsInstantiated

	^realObject ~~ nil!

vmInterrupt: aSymbol
        "Private - Process virtual machine interrupt.  This method is called
        by the virtual machine.  It is entered with interrupts disabled.  The
        interrupt handler should enable interrupts at the appropriate time."
    Process perform: aSymbol.
    ^self! !



!MSMultiObjectReadProxy methods !
   
asMSStorageProxy

	^MSMultiObjectStorageProxy new
		ids: ids;
		objectSetName: objectSet name;
		yourself.!

getRealObject

	realObject := objectSet readForIds: ids.
	super getRealObject.!
  
ids

	^ids!
   
ids: aCollection

	ids := aCollection! !



!MSSingleObjectReadProxy methods !

asMSStorageProxy

	^MSSingleObjectStorageProxy new
		id: id;
		objectSetName: objectSet name;
		yourself.!
 
getRealObject

	realObject := objectSet readForId: id.
	super getRealObject.!

id

	^id!
 
id: anInteger

	id := anInteger! !



!MSError methods ! !



!MSBranchAboutToMorphException methods !

isResumable

    ^true! !



!MSDBObjectHasChanged methods ! !



!MSDeletedLeafException methods ! !



!MinneStore methods !

initialize
	"Default to nothing.  Subclasses should override if needed."!
  
isMSTreeHolder

	^false! !



!MinneStoreDB methods !
 
addObjectSetNamed: aSymbol
	"Public"

	| objectSet pathName |
	uniqueObjectSets isNil
		ifTrue: [uniqueObjectSets := OrderedCollection new].
	pathName := path , (File fileName: aSymbol extension: ''), '\'.
	uniqueObjectSets do: [:each |
		each path = pathName
			ifTrue:[Error signal: 'This object set name is too close to ', each name]].
	objectSet := MSObjectSet newOn: pathName for: self.
	objectSet name: aSymbol.
	uniqueObjectSets add: objectSet.
	^objectSets
		at: aSymbol
		put: objectSet.
"****** Not using the save-immediately feature right now.
	self save.
	^self objectSetNamed: aSymbol.
*******"!
 
beginTransaction
	"Public - Begin this transaction."

	uniqueObjectSets
		do: [:each | 
			each isDOService
				ifTrue: [self readObjectSetUsing: each].
			each beginTransaction].
	duringTransaction := true.
	!
 
commitTransaction
	"Public - Begin this transaction."

	uniqueObjectSets
		do: [:each | each commitTransaction].
	duringTransaction := false.
	!
  
fileName

	^self class fileName.!
 
getAll: anObjectSetName
	"Public - Start an object read query."

	^(self objectSetNamed: anObjectSetName) getAll!

getOne: anObjectSetName
	"Public - Start an object read query."

	^(self objectSetNamed: anObjectSetName) getOne!

idFor: anObject
	"Public - Answer the database id for anObject or nil if it has none."

	^(self objectSetFor: anObject class) basicIdFor: anObject!
  
initialize

	duringTransaction := false.
	objectSets := IdentityDictionary new.!
 
objectSetFor: aClass
	"Public - Answer the object set that stores and retrieves aClass."

	^self objectSetsAt: aClass!
   
objectSetNamed: aSymbol
	"Public - Answer the object set that is named aSymbol."

	^self objectSetsAt: aSymbol!
  
objectSetsAt: aClassOrSymbol
	"Private - If the object at aClassOrSymbol is a disk object manager then
	use it to read the object set and replace it with the object set."

	| temp objectSet |
	temp := (objectSets 
						at: aClassOrSymbol 
						ifAbsent: [Error signal: 'This objectSet has not been defined: ' , aClassOrSymbol printString]).
	^temp isDOService
		ifTrue: [self readObjectSetUsing: temp]
		ifFalse: [temp]  "Then it is an MSObjectSet"!
   
objectSetsAt: aClassOrSymbol put: anMSObjectSet
	"Private"

	^objectSets 
			at: aClassOrSymbol
			put: anMSObjectSet
	!
  
path: aString
	"Private - Set the path instance variable."

	path := (aString last = $\)
		ifTrue: [aString]
		ifFalse: [aString , '\'].
	!
   
persistence
	"Private - Answer an instance of DOSingleObjectService."

	^DOSingleObjectService
			perform: self persistenceCreationMethod
			with: path, self fileName!

persistenceCreationMethod
	"Private - Answer the method used to create persistence managers."

	persistenceCreationMethod == nil
		ifTrue: [self supportSingleUser].
	^persistenceCreationMethod.!
 
readObjectSetUsing: aDOManager
	"Answer an MSObjectSet after reading it from the database."

	| objectSet |
	objectSet := aDOManager read.
	objectSet database: self.
	objectSet myPersistence: aDOManager shallowCopy.  "So it's not affected by the become:"
	aDOManager become: objectSet.
	^objectSet!
  
removeFromCache: anObject
	"Public - Remove this object from the object identity cache."

	^(self objectSetsAt: anObject class)
		removeFromCache: anObject.!
   
rollbackTransaction
	"Public - Begin this transaction."

	uniqueObjectSets
		do: [:each | each rollbackTransaction].
	duringTransaction := false.
	!
  
save
	"Private - Save my changes to disk.  This method should be used only during the initial
	database definition and after other miscellaneous definition changes have been made."

	#needsWork. "needs to have a unit of work here."
	uniqueObjectSets do: [:each |
		each isDOService
			ifFalse: [
				each save.
				"I do a 'become:' below because there are a lot of
				places where I reference an ObjectSet"
				each become: each myPersistence].
		].
	self persistence store: self.!

store: anObject
	"Public - Store one object."

	| objectSet |
	objectSet := (self objectSetsAt: anObject class).
	duringTransaction
		ifTrue: [objectSet store: anObject]
		ifFalse:
			[self beginTransaction.
			[objectSet store: anObject]
				on: Error
				do:
					[:exception |
					self rollbackTransaction.
					exception pass].
			self commitTransaction].
	!
 
storeAll: aCollection
	"Public - Store a collection of objects.  They need not be the same class."

	| commitAfterSaving |
	duringTransaction
		ifTrue:
			[commitAfterSaving := false]
		ifFalse:
			[commitAfterSaving := true.
			self beginTransaction].
	aCollection
		do: [:each | self store: each].
	commitAfterSaving
		ifTrue: [self commitTransaction].
	!
 
supportMultipleUsers
	"Public - "

	persistenceCreationMethod := #newMultiUserOn:!
   
supportSingleUser
	"Public - "

	persistenceCreationMethod := #newSingleUserOn:! !



!MSAspect methods !

getter

	^getter!
 
getter: aSymbol

	^getter := aSymbol!
 
name

	^name!
 
name: aSymbol

	^name := aSymbol!
 
objectSetName
	"Answer the name of the object set this aspect represents."

	^objectSetName!
 
objectSetName: aSymbol
	"Setter"

	objectSetName := aSymbol!
 
setReadProxyFor: anObject
with: anMSObjectSet
	"This is called after reading an object.  anMSObjectSet is the object set for the aspect, not the object."

	| proxy |
	objectSetName == anMSObjectSet name
		ifFalse: [Error signal].		#Assertion.
	proxy := anObject perform: getter.
	proxy == nil
		ifTrue: [^self].
	proxy isMSStorageProxy
		ifTrue:
			"Change it to a read proxy."
			[proxy := proxy asMSReadProxy.
			proxy objectSet: anMSObjectSet.
			anObject perform: setter with: proxy].
	!
 
setStorageProxyFor: anObject with: anMSObjectSet
	"This is called before storing an object.  anMSObjectSet is the object set for the aspect, not the object."

	| aspectValue proxy |
	objectSetName == anMSObjectSet name
		ifFalse: [Error signal]. #Assertion.
	aspectValue := anObject perform: getter.
	aspectValue == nil
		ifTrue: [^self].
	aspectValue isMSStorageProxy
		ifTrue: [^self].  "This should be true only if something went wrong."
	aspectValue isMSReadProxy
		ifTrue:
			[aspectValue realObjectIsInstantiated
				ifTrue: [self storeAspect: aspectValue realObject using: anMSObjectSet].
			proxy := aspectValue asMSStorageProxy]
		ifFalse: 
			[self storeAspect: aspectValue using: anMSObjectSet.
			proxy := self storageProxyClass newFor: aspectValue and: anMSObjectSet].
	anObject perform: setter with: proxy.!

setter

	^setter!
 
setter: aSymbol

	^setter := aSymbol!
 
storageProxyClass

	^self implementedBySubclass! !



!MSMultiObjectAspect methods !
  
storageProxyClass

    ^MSMultiObjectStorageProxy!

storeAspect: aspectValue using: anMSObjectSet
	"Private - Store multiple objects."

	anMSObjectSet storeAll: aspectValue.! !



!MSSingleObjectAspect methods !
  
storageProxyClass

    ^MSSingleObjectStorageProxy!
   
storeAspect: aspectValue using: anMSObjectSet
	"Private - store a single object."

	anMSObjectSet store: aspectValue.! !



!MSBranch methods !
  
addLeafValue: anObject
id: anInteger
	"Add this leaf value/id combo to my leaves.  This is the only method leaves are to be added with."

	| existingLeaf |
	existingLeaf := self leafEqualTo: anObject.
	(existingLeaf == nil)
		ifTrue:
			[self leaves add: (MSLeaf newValue: anObject id: anInteger).
			(self leaves size >= maximumLeavesPerBranch)
				ifTrue: [^self morphIntoATrunk]]
		ifFalse:
			[existingLeaf addId: anInteger].
	[self saveLeaves]
		on: DOInvalidVersionError , DOObjectIsDeletedError
		do:
			[:exception |
			exception class == DOInvalidVersionError
				ifTrue:
					[leaves := nil.
					self addLeafValue: anObject id: anInteger]
				ifFalse:
					[parent reapplyChanges].
			].!
  
addLeavesTo: aCollection
	"Add all my leaves to a collection."

	aCollection addAll: self leaves!

asLeftBranch
	"Answer the left half of my leaves."

	| leftLeaves branch |
	leftLeaves := (self leaves copyFrom: 1 to: (leaves size // 2)).
	branch := self class new leaves: leftLeaves.
	branch maximumValue: (leftLeaves last value).
	branch leafPersistence: leafPersistence.
	^branch!

asRightBranch
	"Answer the right half of my leaves."

	| rightLeaves branch size |
	size := self leaves size.
	rightLeaves := leaves copyFrom: (size//2)+1 to: size.
	branch := self class new leaves: rightLeaves.
	branch maximumValue: maximumValue.
	branch leafPersistence: leafPersistence.
	^branch!

beforeSaving
	"Wipe out any reference to my tree holder and leaves."

	parent isMSTreeHolder
		ifTrue: [parent := nil].
	leavesFileId isNil
		ifTrue: [self saveLeaves].
	leaves := nil.!

beginTransaction
	"Tell leafPersistence to begin the transaction."

	leafPersistence beginTransaction.!
  
commitTransaction
	"Tell leafPersistence to commit the transaction."

	leafPersistence commitTransaction.!
   
firstBranch
	"Answer the first branch in my tree."

	^self!
  
firstLeaf
	"Answer the very first (lowest value) leaf that I hold."

	self leaves isEmpty
		ifTrue: [^nil].
	^self leaves first!
   
gtBinarySearchFor: anObject		"value - can be either string or integer"
between: integer1							"integer1 must be less than integer2"
and: integer2
	"Private -  Answer a leaf.  Binary search myself for a leaf with the next greater value."

	| mid midValue |
	integer2 < integer1 ifTrue: [ ^nil ].
	(integer2 - integer1) < 2 ifTrue: [
		(self object: anObject isLT: (self leaves at: integer1) value)		"This line is different from #gteBinary..."
			ifTrue: [ ^(leaves at: integer1) ].
		(self object: anObject isGTE: (self leaves at: integer2) value)   "This line is different from #gteBinary..."
			ifTrue: [ ^nil ].  "There are none greater"
		^(self leaves at: integer2) ].
	mid := (integer1 + integer2) // 2.
	(self object: anObject isLT: (midValue := (self leaves at: mid) value))
		ifTrue: [ ^self gtBinarySearchFor: anObject between: integer1 and: mid ].
	(self object: anObject isGTE: midValue)									"This line is different from #gteBinary..."
		ifTrue: [ ^self gtBinarySearchFor: anObject between: mid+1 and: integer2 ].
	" It matches exactly "
	^(self leaves at: mid).
	!
   
gteBinarySearchFor: anObject		"value - can be either string or integer"
between: integer1							"integer1 must be less than integer2"
and: integer2
	"Private -  Answer a leaf.  Binary search myself for a leaf with the next greater or equal value."

	| mid midValue |
	integer2 < integer1 ifTrue: [ ^nil ].
	(integer2 - integer1) < 2 ifTrue: [
		(self object: anObject isLTE: (self leaves at: integer1) value)		"This line is different from #gtBinary..."
			ifTrue: [ ^(leaves at: integer1) ].
		(self object: anObject isGT: (self leaves at: integer2) value)   "This line is different from #gtBinary..."
			ifTrue: [ ^nil ].  "There are none greater"
		^(self leaves at: integer2) ].
	mid := (integer1 + integer2) // 2.
	(self object:anObject isLT: (midValue := (self leaves at: mid) value))
		ifTrue: [ ^self gteBinarySearchFor: anObject between: integer1 and: mid ].
	(self object: anObject isGT: midValue)									"This line is different from #gtBinary..."
		ifTrue: [ ^self gteBinarySearchFor: anObject between: mid+1 and: integer2 ].
	" It matches exactly "
	^(self leaves at: mid).
	!

initialize

	leaves := #new.
	maximumLeavesPerBranch := 4. "Low for testing purposes.  It will be much higher."!
 
isEmpty
	"Answer true or false.  If I hold no leaves, answer true."

	^self leaves isEmpty!
  
leafEqualTo: anObject
	"Answer a leaf that is = an Object."

	| leaf |
	leaf := self 
		gteBinarySearchFor: anObject 
		between: 1 
		and: self leaves size.
	leaf == nil 
		ifTrue: [^nil].
	leaf value = anObject
		ifTrue: [^leaf].
	^nil.!
  
leafGreaterThan: anObject
	"Answer a leaf that is > an Object."

	^self 
		gtBinarySearchFor: anObject 
		between: 1 
		and: self leaves size.!
   
leafGreaterThanOrEqualTo: anObject
	"Answer a leaf that is >= an Object."

	^self 
		gteBinarySearchFor: anObject 
		between: 1 
		and: self leaves size.!

leafPersistence: aDOManager
	"Set the leafPersistence instance variable."

	leafPersistence := aDOManager!
   
leaves
	"Answer a sorted collection of leaves."

	leaves == #new
		ifTrue: [leaves := SortedCollection sortBlock: [ :a :b | a value < b value]].
	leaves == nil
		ifTrue: [leaves := leafPersistence readId: leavesFileId].
	leaves == #deleted  "If true, we read a deleted file."
		ifTrue: [MSDeletedLeafException signal].
	^leaves!
   
leaves: aSortedCollection
	"Set the maximumValue instance variable."

	leaves := aSortedCollection.

!
 
maximumLeavesPerBranch: anInteger
	"Set the maximum number of leaves allowed in a single branch before splitting."

	maximumLeavesPerBranch := anInteger!

maximumValue
	"Answer the maximumValue instance variable."

	^maximumValue!
  
maximumValue: anObject
	"Set the maximumValue instance variable."

	maximumValue := anObject!

morphIntoATrunk
	"Morph myself into a trunk with my leaves split between its two branches."

	| trunk |
	MSBranchAboutToMorphException signal.
	leavesFileId ~~ nil  "If my leaves have been saved to disk before."
		ifTrue: [leafPersistence delete: leaves]   "DOObjectIsDeletedError if leaves have already been been deleted."
		ifFalse: [Error signal: 'Oops, I guess this does happen'].
	trunk := (MSTrunk newOn: self parent: parent).
	trunk saveLeaves.
	self become: trunk.
	parent saveIndexTree.  "The tree has changed, so store it."!
   
object: object1 isGT: object2
	"Answer true if object1 is greater than object2.
	I had to implement these methods because most things don't compare with MSNilValue"

	^object1 isMSNilValue
		ifTrue: [object1>object2]
		ifFalse: [object2<object1].!
   
object: object1 isGTE: object2
	"Answer true if object1 is greater than or equal to object2.
	I had to implement these methods because most things don't compare with MSNilValue"

	^object1 isMSNilValue
		ifTrue: [object1>=object2]
		ifFalse: [object2<=object1].!

object: object1 isLT: object2
	"Answer true if object1 is less than object2.
	I had to implement these methods because most things don't compare with MSNilValue"

	^object1 isMSNilValue
		ifTrue: [object1<object2]
		ifFalse: [object2>object1].!
  
object: object1 isLTE: object2
	"Answer true if object1 is less than or equal to object2.
	I had to implement these methods because most things don't compare with MSNilValue"

	^object1 isMSNilValue
		ifTrue: [object1<=object2]
		ifFalse: [object2>=object1].!
   
parent: aTreeHolderOrTrunk
	"Set the instance variable."

	parent := aTreeHolderOrTrunk!
 
removeLeafValue: anObject
id: anInteger
	"Add this leaf value/id combo to my leaves.  This is the only method leaves are to be added with."

	| existingLeaf |
	existingLeaf := self leafEqualTo: anObject.
	(existingLeaf == nil)
		ifFalse:
			[existingLeaf removeId: anInteger.
			existingLeaf isEmpty
				ifTrue: [self leaves remove: existingLeaf]].
	[self saveLeaves]
		on: DOInvalidVersionError
		do:
			[leaves := nil.
			self removeLeafValue: anObject id: anInteger].
	!
   
rollbackTransaction
	"Tell leafPersistence to rollback the transaction."

	leafPersistence rollbackTransaction.!
 
saveLeaves
	"Save my leaves to disk."

	leafPersistence store: self leaves.
	leavesFileId == nil
		ifTrue: [leavesFileId := leafPersistence basicIdFor: self leaves].	! !



!MSHighValue methods ! !



!MSLeaf methods !
 
addId: anInteger
	"Set my database id number that goes with the key."
    
	ids == nil ifTrue: [ 
		ids := anInteger.
"		hasChanged := true."
		^self. ].
	ids isInteger ifTrue: [
		ids = anInteger
			ifTrue: [ ^self ]
			ifFalse: [
				ids := OrderedCollection with: ids with: anInteger.
"				hasChanged := true."
				^self ] ].
	(ids includes: anInteger) ifFalse: [
"		hasChanged := true."
		ids add: anInteger ].!
 
ids
	"Public - Answer a collection of ids that I hold."

	ids == nil
		ifTrue: [^Array new].
	ids isInteger
		ifTrue: [^Array with: ids].
	^ids.!

isEmpty
	"Answer true or false.  Answer true if I hold no ids."

	^ids == nil!
   
printOn: aStream
	"Public - Print a textual representation of  myself onto aStream."

	super printOn: aStream.
	aStream nextPut: $( .
	value printOn: aStream.
	aStream nextPut: $: .
	"Print up to 3 of the database Ids associated with the index key."
	1 to: self ids size do: [ :x |
		x = 4	ifTrue: [ aStream nextPutAll: '...' ] .
		x < 4 ifTrue: [ aStream nextPutAll: (self ids at: x) asString; nextPut: $  ] ] .
	aStream	nextPut: $)!
   
removeId: anInteger
	"Remove my database id number that goes with my value.
	When ids gets empty, it is set back to nil."
    
	ids isNil ifTrue: [ ^self ].
	ids isInteger ifTrue: [
		ids = anInteger
			ifTrue: [ 
"				hasChanged := true."
				^ids := nil ]
			ifFalse: [ ^self ]. ].
	(ids includes: anInteger) ifTrue: [
"		hasChanged := true."
		ids remove: anInteger.
		ids isEmpty
			ifTrue: [^ids := nil].
		ids size = 1 
			ifTrue: [ids := ids first] ] .!
   
value
	"Public - Answer my value instance variable."

	^value!
   
value: anObject id: anInteger
	"Private - set the value and ids instance variables."

	value := anObject.
	ids := anInteger.! !



!MSNilValue methods ! !



!MSObjectSet methods !

afterReading: anObject
	"Private - If the afterReadingMethod selector is not nil, send it to anObject."
	
	afterReadingMethod == nil
		ifFalse: [anObject perform: afterReadingMethod].!

afterReadingMethod: aSymbol
	"Public - This method selector (aSymbol) is sent to an object 
	after it has been read from the database."

	afterReadingMethod := aSymbol!

afterStoring: anObject
	"Private - If the afterStoringMethod selector is not nil, send it to anObject."

	afterStoringMethod == nil
		ifFalse: [anObject perform: afterStoringMethod].!
 
afterStoringMethod: aSymbol
	"Public - This method selector (aSymbol) is sent to an object
	after it has been stored to the database (but before the commit)."

	afterStoringMethod := aSymbol!
 
and
    "Public - use this method between #where... methods"

    andOr := #and!
 
and: indexName eq: anObject
    "Public - Specifying a search criteria where index value is equal to anObject."

    ^self and;
        selectFor: indexName
        selector: #equals:
        criteria: anObject!
   
and: indexName gt: anObject
    "Public - Specifying a search criteria where index value is greater than anObject."

    ^self and;
        selectFor: indexName
        selector: #greaterThan:
        criteria: anObject!
  
and: indexName gte: anObject
    "Public - Specifying a search criteria where index value is greater than or equal to anObject."

    ^self and;
        selectFor: indexName
        selector: #greaterThanOrEqualTo:
        criteria: anObject!

and: indexName hasAllWords: aCollectionOfStrings
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self and;
        selectFor: indexName
        selector: #hasAllWords:
        criteria: aCollectionOfStrings!
 
and: indexName hasSomeWords: aCollectionOfStrings
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self and;
        selectFor: indexName
        selector: #hasSomeWords:
        criteria: aCollectionOfStrings!
   
and: indexName hasWord: aString
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self and;
        selectFor: indexName
        selector: #startsWith:
        criteria: aString asLowercase!

and: indexName includes: aString
    "Public - Specifying a search criteria.  Use only when the key is a string."

    ^self and;
        selectFor: indexName
        selector: #includes:
        criteria: aString!

and: indexName isBetween: anObject1 and: anObject2
    "Public - Specifying a search criteria"

    ^self and;
        selectFor: indexName
        selector: #between:and:
        criteria: (Array with: anObject1 with: anObject2)!

and: indexName lt: anObject
    "Public - Specifying a search criteria where index value is less than anObject."

    ^self and;
        selectFor: indexName
        selector: #lessThan:
        criteria: anObject!

and: indexName lte: anObject
    "Public - Specifying a search criteria where index value is less than or equal to anObject."

    ^self and;
        selectFor: indexName
        selector: #lessThanOrEqualTo:
        criteria: anObject!
  
and: indexName ne: anObject
    "Public - Specifying a search criteria where index value is not equal to anObject."

    ^self and;
        selectFor: indexName
        selector: #doesNotEqual:
        criteria: anObject!
 
aspect: aspectName
getter: getterName
setter: setterName
holdsMany: objectSetName

	aspects
		at: aspectName
		put:
			(MSMultiObjectAspect
				newName: aspectName
				getter: getterName
				setter: setterName
				objectSetName: objectSetName).!
   
aspect: aspectName
getter: getterName
setter: setterName
holdsOne: objectSetName

	aspects
		at: aspectName
		put:
			(MSSingleObjectAspect
				newName: aspectName
				getter: getterName
				setter: setterName
				objectSetName: objectSetName).!
   
aspect: aspectName
holdsMany: objectSetName

	self
		aspect: aspectName
		getter: aspectName
		setter: (aspectName, ':') asSymbol
		holdsMany: objectSetName!

aspect: aspectName
holdsOne: objectSetName

	self
		aspect: aspectName
		getter: aspectName
		setter: (aspectName, ':') asSymbol
		holdsOne: objectSetName!
  
aspectNamed: aSymbol

	^self 
		aspectNamed: aSymbol 
		ifAbsent:[Error signal: 'This aspect has not been defined: ', aSymbol].!

aspectNamed: aSymbol ifAbsent: aBlock
	"Answer a MSAspect."

	^aspects 
		at: aSymbol
		ifAbsent: aBlock.!
 
aspects

	^aspects!
   
basicIdFor: anObject
	"Answer the database id for anObject.  Answer nil if it has none."

	^objectPersistence basicIdFor: anObject.!
 
beforeStoring: anObject
	"Private - If the beforeStoringMethod selector is not nil, send it to anObject."
	
	beforeStoringMethod == nil
		ifFalse: [anObject perform: beforeStoringMethod].!

beforeStoringMethod: aSymbol
	"Public - This method selector (aSymbol) is sent to an object before it has been stored."

	beforeStoringMethod := aSymbol!

beginTransaction

	objectPersistence beginTransaction.
	indexes
		do: [:each | each beginTransaction].
	!
  
cache
	"Answer the instance identity cache for this ObjectSet."

	cache == nil
		ifTrue: [cache := WeakKeyedRegistry new ].
	^cache!
   
commitTransaction

	objectPersistence commitTransaction.
	indexes
		do: [:each | each commitTransaction].!
  
database: aMinneStoreDB
	"Private"

	database := aMinneStoreDB!
  
execute
    "Public - Execute the query that started with get..."

	| answer |
	getAllOrOne == nil
		ifTrue: [Error signal: '#getAll: or #getOne: must be sent before execute.'].
	answer := self perform: getAllOrOne.
	getAllOrOne := nil.
	^answer.!
 
fileName
	"Private - Answer the file name where I am stored.  Get it from my class method."

	^self class fileName
	!
   
getAll
    "Private - set the getAllOrOne instance variable"

	getAllOrOne := #returnAll!

getCount
    "Private - set the getAllOrOne instance variable"

	getAllOrOne := #returnCount!

getIds
    "Private - set the getAllOrOne instance variable"

	getAllOrOne := #returnIds!

getOne
    "Private - set the getAllOrOne instance variable"

	getAllOrOne := #returnOne!

hasChanged: anObject
	"Private - Answer true or false.  True if anObject has changed since reading 
	or hasn't been saved to the database yet.  
	If no method selector was specified then assume true."

	hasChangedMethod == nil
		ifTrue: [^true].
	(self basicIdFor: anObject) == nil
		ifTrue: [^true]. "It has never been saved yet."
	^anObject perform: hasChangedMethod.!
 
hasChangedMethod: aSymbol
	"Public - This method selector is used to find out if an object to be stored has changed or not.
	If it hasn't changed, we won't store it."

	hasChangedMethod := aSymbol!
   
idFor: anObject
	"Private - Answer the database id for anObject.  If it has none, assign it one."

	^objectPersistence idFor: anObject.!
 
indexNamed: aSymbol
	"Private - Answer the index with name of aSymbol"

	^indexes at: aSymbol ifAbsent: [Error signal: 'There is no index named ' , aSymbol]!

indexOn: indexSymbol domain: aClass
	"Public - create an index named indexSymbol for domain of aClass.
	Assume the getter is the same as the index name."

	self 
		newIndexNamed: indexSymbol
		getter: indexSymbol
		domain: aClass!
   
indexOn: indexSymbol domain: aClass getter: getterMethodSymbol
	"Public - create an index named indexSymbol for domain of aClass."

	self 
		newIndexNamed: indexSymbol
		getter: getterMethodSymbol
		domain: aClass!

initialize
    "Private"

	indexes := IdentityDictionary new.
	aspects := IdentityDictionary new.
	myPersistence := DOSingleObjectService perform: self persistenceCreationMethod with: path, self fileName.
	myPersistence storeMyselfOn: path, self myPersistenceFileName.
	objectPersistence := DOMultiObjectService perform: self persistenceCreationMethod with: path.!
 
isMSObjectSet
	"Answer true"

	^true!

myPersistence
	"Answer an MSDiskObjectManager."

	^myPersistence
	!
 
myPersistence: aDOManager
	"Set the myPersistence instance variable to a disk object manager."

	myPersistence := aDOManager
	!
 
myPersistenceFileName
	"Private - Answer the file name for my persistence 'manager'.  Get it from my class method."

	^self class myPersistenceFileName
	!
  
name

	^name!
 
name: aSymbol

	name := aSymbol!
  
newIndexNamed: indexName
getter: getterMethodName
domain: aClass
	"Private - Create a new index with name of indexName.
    Application -- Watch for the error MSInvalidDomainError.  This
    occurs when the domain class does not respond to #lowValue"

	| holder holderPathName |
	indexName isSymbol
		ifFalse: [Error signal: 'Index name must be a symbol'].
	getterMethodName isSymbol
		ifFalse: [Error signal: 'Getter method name must be a symbol'].
	holderPathName := path , (File fileName: indexName extension: '').
	indexes do: [:each |
		each path = holderPathName
			ifTrue:[Error signal: 'Your index name is too similar to ', each name]].
	holder := MSTreeHolder newOn: holderPathName owner: self.
	holder name: indexName.
	holder getter: getterMethodName.
	holder domain: aClass.
	indexes at: indexName put: holder.
	self save.!

objectsPerFile: anInteger
	"Public - Set the number of objects to be stored in each file.
	This method may only be used during db initialization."

	objectPersistence objectsPerFile: anInteger.!
  
or
    "Public - use this method between #where... methods"

    andOr := #or!
   
or: indexName eq: anObject
    "Public - Specifying a search criteria where index value is equal to anObject."

    ^self or;
        selectFor: indexName
        selector: #equals:
        criteria: anObject!
 
or: indexName gt: anObject
    "Public - Specifying a search criteria where index value is greater than anObject."

    ^self or;
        selectFor: indexName
        selector: #greaterThan:
        criteria: anObject!

or: indexName gte: anObject
    "Public - Specifying a search criteria where index value is greater than or equal to anObject."

    ^self or;
        selectFor: indexName
        selector: #greaterThanOrEqualTo:
        criteria: anObject!
  
or: indexName hasAllWords: aCollectionOfStrings
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self or;
        selectFor: indexName
        selector: #hasAllWords:
        criteria: aCollectionOfStrings!
   
or: indexName hasSomeWords: aCollectionOfStrings
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self or;
        selectFor: indexName
        selector: #hasSomeWords:
        criteria: aCollectionOfStrings!
 
or: indexName hasWord: aString
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self or;
        selectFor: indexName
        selector: #startsWith:
        criteria: aString asLowercase!
  
or: indexName includes: aString
    "Public - Specifying a search criteria.  Use only when the key is a string."

    ^self or;
        selectFor: indexName
        selector: #includes:
        criteria: aString!
  
or: indexName isBetween: anObject1 and: anObject2
    "Public - Specifying a search criteria"

    ^self or;
        selectFor: indexName
        selector: #between:and:
        criteria: (Array with: anObject1 with: anObject2)!
  
or: indexName lt: anObject
    "Public - Specifying a search criteria where index value is less than anObject."

    ^self or;
        selectFor: indexName
        selector: #lessThan:
        criteria: anObject!
  
or: indexName lte: anObject
    "Public - Specifying a search criteria where index value is less than or equal to anObject."

    ^self or;
        selectFor: indexName
        selector: #lessThanOrEqualTo:
        criteria: anObject!

or: indexName ne: anObject
    "Public - Specifying a search criteria where index value is not equal to anObject."

    ^self or;
        selectFor: indexName
        selector: #doesNotEqual:
        criteria: anObject!
   
or: indexName startsWith: aString
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self or;
        selectFor: indexName
        selector: #startsWith:
        criteria: aString!
   
path

	^path!
 
path: aString
	"Set the path instance variable."

	path := (aString last = $\)
		ifTrue: [aString]
		ifFalse: [aString , '\'].
	!
 
persistenceCreationMethod

	persistenceCreationMethod == nil
		ifTrue: [persistenceCreationMethod := database persistenceCreationMethod].
	^persistenceCreationMethod.!
 
printOn: aStream

	super printOn: aStream.
	aStream 
		nextPut: $(;
		nextPutAll: name;
		nextPut: $).!
   
privateStore: anObject
	"Private - Store anObject to disk, and update the indexes.
	If anObject is deemed unchanged, it won't be stored."

	| id |
	self validateObject: anObject.
	(self hasChanged: anObject)
		ifTrue: 
			[self beforeStoring: anObject.
			self updateIndexesFor: anObject.
			self setStorageProxiesFor: anObject.
			objectPersistence store: anObject.
			self setReadProxiesFor: anObject.
			self afterStoring: anObject.].
"		ifFalse: [self setStorageProxiesFor: anObject].  Why??? Shouldn't this be #setReadProxiesFor:?"
	^self cache
		at: (self basicIdFor: anObject)
		put: anObject.!
  
readAll
	"Public - Answer all of the object in this object set.
    Answer is nil if the object does not exist."

	| all |
	all := objectPersistence readAll.
	^all 
		collect:
			[:each |
			self cache
				at: (self basicIdFor: each)
				ifAbsentPut:
					[self setReadProxiesFor: each.
					self afterReading: each.					
					each].
			]!
  
readForId: anInteger
	"Public - Answer the object in this object set with an id of anInteger.
    Answer is nil if the object does not exist."

	| object | 
	^self cache
		at: anInteger
		ifAbsent:
			[(object := objectPersistence readId: anInteger) == nil
				ifTrue: "don't save nil in the cache"
					[nil]
				ifFalse:
					[self setReadProxiesFor: object.
					self afterReading: object.					
					cache at: anInteger put: object].
			].!
  
readForIds: aCollection
	"Public - Answer the object in this object set with an id of anInteger.
    Answer is nil if the object does not exist."

	^aCollection collect: [:each | self readForId: each].!
  
removeFromCache: anObject
	"Public - Remove this object from the object identity cache."

	^self cache 
		removeKey: (self basicIdFor: anObject) 
		ifAbsent: [nil]!
   
returnAll
	"Private - Answer a collection of objects that match the criteria"

	| answer |
	[ "Start of ensure block"
	result isNil
		ifTrue: "Return all objects."
			[answer := self readAll].
	answer := result
		collect:
			[:each |
			self readForId: each].
	]
		ensure:
			[result := nil.
			andOr := nil.
			].
	^answer.!
  
returnCount
    "Private - Answer the number of stored objects whose indexes
    match the previously specified criteria."

    ^self getIds size
        !

returnIds
    "Answer a collection of ids whose objects match the previously specified criteria."

    | answer |
    answer := result.
    result := nil.
    andOr := nil.
    ^answer.!
   
returnOne
	"Private - Answer the first object that matches or nil."

	| answer |
	[ "Start of the ensure block"
	result isNil
		ifTrue: [^nil].
	result isEmpty
		ifTrue: [^result := nil].
	answer := self readForId: result first.
	]
		ensure:
			[result := nil.
			andOr := nil].
	^answer.!
 
rollbackTransaction

	objectPersistence rollbackTransaction.
	indexes
		do:
			[:each |
			each rollbackTransaction].
	!
 
save
	"Private - Clean things up and Save myself to disk."

	| temp1 temp2 temp3 temp4 |
	indexes
		do: [:each | each beforeSaving].
	temp1 := myPersistence.
	temp2 := database.
	temp3 := cache.
	myPersistence := nil.
	database := nil.
	cache := nil.
	[temp1 store: self]
		ensure:
			[myPersistence := temp1.
			database := temp2.
			cache := temp3].!

selectFor: indexName
selector: aSelector
criteria: anObject
	"Private - Send aSelector with anObject to index named indexName.
    Based on the andOr variable, union or intersect the results.
    This method is used by #where:equals , #where:startsWith:, etc...
    result variable will be nil the first time this is called."

	| anOC |
	(result notNil and: [andOr = nil])
		ifTrue:
			[result := nil.
			andOr := nil.
			MSError signal: 'Use the #and or #or method between #where:.. methods'].
	(result isCollectionOtherThanString and: [result isEmpty and: [andOr = #and]])
		ifTrue:
			[ "This is for efficiency.  No reason to go on."
			andOr := nil.
			^result].
	[ " Start of the #on:do: block "
	(anObject isCollectionOtherThanString and: [#(equals: hasAllWords: hasSomeWords:) doesNotInclude: aSelector])
		ifTrue: [anOC := (self indexNamed: indexName) perform: aSelector withArguments: anObject]
		ifFalse: [anOC := (self indexNamed: indexName) perform: aSelector with: anObject].
	]
		on: Error
		do:
			[:excp |
			result := nil.
			andOr := nil.
			excp pass.
			"excp class signal: excp messageText. Resignal the message"
			].
	result isNil
		ifTrue:
			[andOr := nil.
			^result := anOC].
	(andOr = #and)
		ifTrue:
			[andOr := nil.
			anOC isEmpty
				ifTrue: [^result := OrderedCollection new].
			^result := anOC intersectionOf: result.].
	(andOr = #or)
		ifTrue:
			[andOr := nil.
			anOC isEmpty
				ifTrue: [^result].
			^result := result uniqueUnionOf: anOC].
	Error signal: 'Oops, I didn''t think it could get this far'.
	result := nil.
	andOr := nil.
	MSError signal: 'Use the #and or #or method between #where:.. methods'.
	!
   
setReadProxiesFor: anObject
	"Private - Replace anObjects related objects (aspects) with proxy objects.
	If an aspect is 'dependent', then it should not be an aspect, but should be stored with the object."

	| temp |
	self aspects
		do: [:eachAspect |
			temp := database objectSetNamed: eachAspect objectSetName.
			eachAspect setReadProxyFor: anObject with: temp].!
 
setStorageProxiesFor: anObject
	"Private - Replace anObjects related objects (aspects) with proxy objects.
	If an aspect is 'dependent', then it should not be an aspect, but should be stored with the object.
	In the process of setting the aspect proxies, the aspects get stored as well."

	| temp |
	self aspects
		do: [:eachAspect |
			temp := database objectSetNamed: eachAspect objectSetName. 
			eachAspect setStorageProxyFor: anObject with: temp].!
  
store: anObject
	"Public - Check for recursive stores of the same object before storing it to disk.
	Application--watch for the exception MSDBObjectHasBeenChanged."

	recursion == nil
		ifTrue:
			[recursion := Set new.
			recursion add: anObject.
			self privateStore: anObject.
			recursion := nil]
		ifFalse:
			[(recursion includes: anObject)
				ifTrue: [^anObject].
			recursion add: anObject.
			self privateStore: anObject]!
  
storeAll: aCollection
	"Public - store a collection of object to disk."

	aCollection
		do: [:each | self store: each].
	!
 
storesClass: aClass
	"Public - Definition protocol"

	database objectSetsAt: aClass put: self.!
  
storesClasses: aCollection
	"Public - Definition protocol"

	aCollection do: [ :each |
		database objectSetsAt: each put: self].!
   
updateIndexesFor: anObject
	"Private - "

	| key oldKey oldObject id |
	oldObject := objectPersistence read: anObject.
	id := self idFor: anObject.
	indexes
		do:
			[:each |
			key := (Message receiver: anObject selector: each getter) evaluate.
			oldObject notNil
				ifTrue:
					[[oldKey := (Message receiver: oldObject selector: each getter) evaluate]
						on: MessageNotUnderstood
						do: 
							[ :exception |  "we are probably indexing with info from an aspect."
							exception message receiver isMSStorageProxy
								ifTrue: [Error signal: 'You have taken an index value from an aspect. ObjectSet: ', name, ' Index: ', each name]
							].
					each removeValue: oldKey id: id.
					].
			each addValue: key id: id.
			].!
   
validateObject: anObject
    "Private - Validate anObject for the proper index protocol before storing it."

    indexes do: [ :each |
        (anObject respondsTo: each getter)
            ifFalse: [ Error signal: 'Object does not respond to: ', each getter ] ].    !
   
where: indexName eq: anObject
    "Public - Specifying a search criteria. Equivalent to #where:equals:"

    ^self
        selectFor: indexName
        selector: #equals:
        criteria: anObject!

where: indexName gt: anObject
    "Public - Specifying a search criteria. Equivalent to #where:isGreaterThan:"

    ^self
        selectFor: indexName
        selector: #greaterThan:
        criteria: anObject!

where: indexName gte: anObject
    "Public - Specifying a search criteria Equivalent to #where:isGreaterThanOrEqualTo:"

    ^self
        selectFor: indexName
        selector: #greaterThanOrEqualTo:
        criteria: anObject!
  
where: indexName hasAllWords: aCollectionOfStrings
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self
        selectFor: indexName
        selector: #hasAllWords:
        criteria: aCollectionOfStrings!

where: indexName hasSomeWords: aCollectionOfStrings
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self
        selectFor: indexName
        selector: #hasSomeWords:
        criteria: aCollectionOfStrings!
  
where: indexName hasWord: aString
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self
        selectFor: indexName
        selector: #startsWith:
        criteria: aString asLowercase!
   
where: indexName includes: aString
    "Public - Specifying a search criteria.  Use only when the key is a string."

    ^self
        selectFor: indexName
        selector: #includes:
        criteria: aString!
   
where: indexName isBetween: anObject1 and: anObject2
    "Public - Specifying a search criteria"

    ^self
        selectFor: indexName
        selector: #between:and:
        criteria: (Array with: anObject1 with: anObject2)!
   
where: indexName lt: anObject
    "Public - Specifying a search criteria. Equivalent to #where:isLessThan:"

    ^self
        selectFor: indexName
        selector: #lessThan:
        criteria: anObject!
  
where: indexName lte: anObject
    "Public - Specifying a search criteria. Equivalent to #where:isLessThanOrEqualTo:"

    ^self
        selectFor: indexName
        selector: #lessThanOrEqualTo:
        criteria: anObject!
   
where: indexName ne: anObject
    "Public - Specifying a search criteria where index value is not equal to anObject."

    ^self
        selectFor: indexName
        selector: #doesNotEqual:
        criteria: anObject!

where: indexName startsWith: aString
    "Public - pecifying a search criteria.  Use only when the key is a string."

    ^self
        selectFor: indexName
        selector: #startsWith:
        criteria: aString! !



!MSStorageProxy methods !
 
asMSReadProxy
	"Answer an instance of MSReadProxy with my pertinent info in it.
	Implemented by my subclasses."!
  
isMSProxy
	"Answer true."

	^true!
   
isMSStorageProxy
	"Answer true."

	^true!

objectSetName

	^objectSetName!
   
objectSetName: aSymbol

	objectSetName := aSymbol!

printOn: aStream

	super printOn: aStream.
	aStream
		nextPut: $(;
		print: objectSetName;
		nextPutAll: ' - ';
		yourself.! !



!MSMultiObjectStorageProxy methods !
   
asMSReadProxy
	"See superimplementor comments"

	| proxy |
	proxy := MSMultiObjectReadProxy new.
	proxy ids: ids.
	^proxy!

ids

	ids == nil
		ifTrue: [ids := OrderedCollection new].
	^ids!
   
ids: aCollection

	ids := aCollection.!
   
printOn: aStream

	super printOn: aStream.
	aStream 
		print: ids;
		nextPut: $).! !



!MSSingleObjectStorageProxy methods !
  
asMSReadProxy
	"See superimplementor comments"

	| proxy |
	proxy := MSSingleObjectReadProxy new.
	proxy id: id.
	^proxy!
 
id

	^id!
 
id: anInteger

	id := anInteger!
  
printOn: aStream

	super printOn: aStream.
	aStream 
		print: id;
		nextPut: $).! !



!MSText methods !
   
asMSText

	^self!
 
isMSText

	^true!
 
printOn: aStream

	super printOn: aStream.
	aStream nextPut: $(.
	textString printOn: aStream.
	aStream nextPut: $).!
  
textString: aString

	textString := aString.!
 
words
	"Answer a collection of words found in this text"

	| stream word coll |
	coll := OrderedCollection new.
	textString isNil ifTrue: [ ^coll ].
	stream := ReadStream on: textString.
	[ (word := stream nextWord) isNil ]
		whileFalse: [ coll add: word ].
	^coll
	!
   
wordsDo: aOneArgumentBlock
	"For each word in my string execute aOneArgumentBlock"

	| stream word |
	textString isNil ifTrue: [ ^self ].
	stream := ReadStream on: textString.
	[ (word := stream nextWord) isNil ] 
		whileFalse: [ aOneArgumentBlock evaluateFor: word ].
	! !



!MSTreeHolder methods !

addRedoBlock: aBlock

	indexTreeChanges ~= nil
		ifTrue: [indexTreeChanges add: aBlock].!

addValue: aValue
id: anInteger
	"Public - Record this change and execute it."

	self addRedoBlock: [self privateAddValue: aValue id: anInteger].
	self privateAddValue: aValue id: anInteger.!
 
atMSText: aString remove: anId
    "Private -"

	#needsWork.
    aString asMSText wordsDo: [ :eachWord |
        self removeValue: eachWord asLowercase id: anId ].!
   
beforeSaving
	"Do some stuff before saving."

	indexTree := nil.!

beginTransaction

	indexTreePersistence beginTransaction.
	self indexTree beginTransaction.
	indexTreeChanges == nil
		ifTrue: [indexTreeChanges := OrderedCollection new].!
   
between: anObject1 and: anObject2
    "Public - Answer a collection of ids that have values between
    anObject1 and anObject2 (inclusive)."

    | result anOC object1 object2 |
    anObject1 isNil ifTrue: [ object1 := MSNilValue ]
        ifFalse: [ object1 := anObject1 ].
    anObject2 isNil ifTrue: [ object2 := MSNilValue ]
        ifFalse: [ object2 := anObject2 ].
    anOC := OrderedCollection new.
    object1 > object2 ifTrue: [ ^anOC ].
    result := self leafGreaterThanOrEqualTo: object1.
    [ result isNil or: [result value > object2] ] whileFalse: [
        anOC addAll: result ids.
        result := self nextLeaf.].
    ^anOC.!
   
commitTransaction

	self indexTree commitTransaction.
	indexTreePersistence commitTransaction.
	indexTreeChanges := nil.!
   
domain: aClass
    "Private - Setter.  A Domain must respond to the method #lowValue."

	domain := aClass.!
  
equals: aValue
	"Public -    Answer a collection of object ids that have this key value."

	| leaf value ids anOC |
	aValue isCollectionOtherThanString
		ifTrue:
			[anOC := OrderedCollection new.
			aValue do:[:each | anOC addAll: (self equals: each)].
			^anOC].
	aValue isNil
		ifTrue: [value := MSNilValue]
		ifFalse: [value := aValue].
	leaf := self indexTree leafEqualTo: value.
	ids := (leaf == nil
		ifTrue: [OrderedCollection new]
		ifFalse: [leaf ids asOrderedCollection]).
	lastLeafValueFound := "Set the last leaf value found instance variable."
		(leaf == nil
			ifTrue: [nil]
			ifFalse: [leaf value]).
	^ids.!

firstLeaf
	"Answer the first (lowest value) leaf in my indexTree."

	| leaf |
	leaf := self indexTree firstLeaf.
	lastLeafValueFound :=
		(leaf == nil
			ifTrue: [nil]
			ifFalse: [leaf value]).
	^leaf.!

getter
    "Answer the getter method to use to get the value used in this index."

    ^getter!
  
getter: aSymbol
    "Public - set the getter method that answers the value used by this index."

    getter := aSymbol!
  
greaterThan: anObject
	"Public - Answer a collection of ids that have key values
    greater than anObject."

	| result anOC object |
	anObject isNil
		ifTrue: [object := MSNilValue]
		ifFalse: [object := anObject].
	result := self leafGreaterThan: object.
	anOC := OrderedCollection new.
	[result isNil]
		whileFalse:
			[anOC addAll: result ids.
			result := self nextLeaf.
			].
	^anOC.!
   
greaterThanOrEqualTo: anObject
	"Public - Answer a collection of ids that have key values
    greater than or equal to anObject."

	| result anOC object |
	anObject isNil
		ifTrue: [object := MSNilValue]
		ifFalse: [object := anObject].
	result := self leafGreaterThanOrEqualTo: object.
	anOC := OrderedCollection new.
	[result isNil]
		whileFalse:
			[anOC addAll: result ids.
			result := self nextLeaf.
			].
	^anOC.!
 
hasAllWords: aStringOrArrayOfStrings
    "Public - Answer a collection of ids that have all the words in anArrayOfStrings."

    | mainColl subColl arrayOfStrings |
    (domain == MSText or: [MSText subclasses includes: domain])
        ifFalse: [MSError signal: 'Use #where:hasAllWords: method only on an MSText index'].
    (aStringOrArrayOfStrings isString or: [aStringOrArrayOfStrings isMSText])
        ifTrue: [arrayOfStrings := aStringOrArrayOfStrings asMSText words]
        ifFalse: [arrayOfStrings := aStringOrArrayOfStrings].
    arrayOfStrings isCollection
        ifFalse: [^MSError signal: 'Invalid collection parameter: ' , arrayOfStrings printString].
    mainColl := OrderedCollection new.
    arrayOfStrings
        do:
            [:eachWord |
            eachWord isString
                ifFalse: [^MSError signal: 'Invalid String parameter: ' , eachWord printString].
            mainColl isEmpty "true on first time thru"
                ifTrue:
                    [subColl := mainColl := self startsWith: eachWord asLowercase]
                ifFalse:
                    [subColl := self startsWith: eachWord asLowercase.
                    mainColl := mainColl intersectionOf: subColl].
            mainColl isEmpty
                ifTrue: [^mainColl].
            ].
    ^mainColl.!
   
hasSomeWords: aStringOrArrayOfStrings
    "Public - Answer a collection of ids that have at least one of the
    words in aStringOrArrayOfStrings.  Ids will be sorted by descending
    number of words matched."

    | bag result numWordsFound max arrayOfStrings |
    (domain == MSText or: [MSText subclasses includes: domain])
        ifFalse: [MSError signal: 'Use #where:hasSomeWords: method only on an MSText index'].
    (aStringOrArrayOfStrings isString or: [aStringOrArrayOfStrings isMSText])
        ifTrue: [arrayOfStrings := aStringOrArrayOfStrings asMSText words] "change string to an array of words"
        ifFalse: [arrayOfStrings := aStringOrArrayOfStrings].
    arrayOfStrings isCollection
        ifFalse: [^MSError signal: 'Invalid collection parameter: ' , arrayOfStrings printString].
    bag := Bag new.
    numWordsFound := 0.
    arrayOfStrings
        do:
            [:eachWord |
            eachWord isString
                ifFalse: [^MSError signal: 'Invalid String parameter: ' , eachWord printString].
            (result := self startsWith: eachWord asLowercase) isEmpty
                ifFalse:
                    [numWordsFound := numWordsFound + 1.
                    bag addAll: result.
                    ].
            ].
    ^bag asArrayByDescendingOccurrences.!
   
includes: aString
    "Public - Answer a collection of ids that have values including aString.
    The whole index must be searched to find these."

    | result anOC |
    (domain == String or: [ String subclasses includes: domain ])
        ifFalse: [ MSError signal: 'Use #where:includes: method only on a string index' ].
    aString isString ifFalse: [ ^MSError signal: 'Invalid string parameter:', aString printString ].
    result := self firstLeaf.
    anOC := OrderedCollection new.
    [ result isNil ] whileFalse: [
        (result value indexOfString: aString) > 0
            ifTrue: [ anOC addAll: result ids ].
        result := self nextLeaf.].
    ^anOC.!
  
indexTree

	indexTree == nil
		ifTrue: [self readIndexTree].
	^indexTree.!
  
initialize
	"Initialize my instance variables."

	indexTree := MSBranch newOn: path parent: self.
	indexTreePersistence := DOSingleObjectService perform: self persistenceCreationMethod with: (path, 'Tree.obj').
	indexTreePersistence allowChangesBeforeCommit.
	self saveIndexTree.!
  
isMSTreeHolder

	^true!
   
leafGreaterThan: anObject
    "Private - Answer an MSLeaf greater than anObject.	
	If none is found, answer nil."

	| leaf |
	leaf := self indexTree leafGreaterThan: anObject.
	lastLeafValueFound :=
		(leaf == nil
			ifTrue: [nil]
			ifFalse: [leaf value]).
	^leaf.!

leafGreaterThanOrEqualTo: anObject
    "Private - Answer an MSLeaf greater than or equal to anObject.	
	If none is found, answer nil."

	| leaf |
	leaf := self indexTree leafGreaterThanOrEqualTo: anObject.
	lastLeafValueFound :=
		(leaf == nil
			ifTrue: [nil]
			ifFalse: [leaf value]).
	^leaf.!
  
lessThan: anObject
    "Public - Answer a collection of ids that have values
    greater than anObject."

    | result anOC object |
    anObject isNil ifTrue: [ ^Array new ]. "Nothing less than nil"
    result := self firstLeaf.
    anOC := OrderedCollection new.
    [ result isNil ] whileFalse: [
        result value >= anObject ifTrue: [ ^anOC ].
        anOC addAll: result ids.
        result := self nextLeaf.].
    ^anOC.!
 
lessThanOrEqualTo: anObject
    "Public - Answer a collection of ids that have key values
    greater than anObject."

    | result anOC |
    anObject isNil ifTrue: [ ^self equals: nil ].  "Nothing is less than nil"
    result := self firstLeaf.
    anOC := OrderedCollection new.
    [ result isNil ] whileFalse: [
        result value > anObject ifTrue: [ ^anOC ].
        anOC addAll: result ids.
        result := self nextLeaf.].
    ^anOC.!
 
maximumLeavesPerBranch: anInteger
	"Set the maximum number of leaves allowed in a single branch before splitting.
	Push this info down to the branches."

	self indexTree maximumLeavesPerBranch: anInteger.!
   
name
    "Answer the name of the index I hold."

    ^name!
  
name: aSymbol
    "Public - setter"

    name := aSymbol.!
   
nextLeaf
	"Answer the next leaf after the last leaf found."

	lastLeafValueFound == nil
		ifTrue: [^nil].
	^self leafGreaterThan: lastLeafValueFound.
	!
  
owner: anMSObjectSet

	owner := anMSObjectSet!

path
	"Answer my path name."

	^path!

path: aString
	"Set the path instance variable."

	path := (aString last = $\)
		ifTrue: [aString]
		ifFalse: [aString , '\'].
	!
 
persistenceCreationMethod

	persistenceCreationMethod == nil
		ifTrue: [persistenceCreationMethod := owner persistenceCreationMethod].
	^persistenceCreationMethod.!

printOn: aStream

    super printOn: aStream.
    aStream
        nextPut: $( ;
        nextPutAll: self name ;
        nextPut: $) .!

private2AddValue: aValue
id: anInteger
	"Private - This method is used by privateAddValue:id:"

	[^self indexTree addLeafValue: aValue id: anInteger]
		on: MSBranchAboutToMorphException
		do:
			[:exception |
			[indexTreePersistence lock: indexTree] 
				on: DOInvalidVersionError do: [^self reapplyChanges].
			exception resume. "The locking was successful."
			].	!
 
private2RemoveValue: aValue
id: anInteger
	"Private - pass this message on to my indexTree."

	^self indexTree removeLeafValue: aValue id: anInteger.!
  
privateAddValue: aValue
id: anInteger
	"Private - Do some MSText testing and call private2AddValue:id:"

	| value |
	aValue isNil
		ifTrue:
			[value := MSNilValue]
		ifFalse:
			[value := aValue.
			domain == MSText
				ifTrue:
					[^value asMSText
						wordsDo:
							[:each | self private2AddValue: each id: anInteger].].
			].
	self private2AddValue: value id: anInteger.
	!
  
privateRemoveValue: aValue
id: anInteger
	"Private - Do some MSText testing and call private2RemoveValue:id:"

	| value |
	aValue isNil
		ifTrue:
			[value := MSNilValue]
		ifFalse:
			[value := aValue.
			domain == MSText
				ifTrue:
					[^value asMSText
						wordsDo:
							[:each | self private2RemoveValue: each id: anInteger].].
			].
	^self private2RemoveValue: aValue id: anInteger.!
   
readIndexTree

	indexTree := indexTreePersistence read.
	indexTree parent: self.!

reapplyChanges
	"Re-read my index and reapply all the changes since the beginning of the transaction."
	"Assumption: This will be a read for update because we'll be inside a transaction."

	self readIndexTree.
	indexTreeChanges
		do: [:each | each value].!
  
removeValue: aValue id: anInteger
	"Public - pass this message on to my indexTree."

	self addRedoBlock: [self privateRemoveValue: aValue id: anInteger].
	self privateRemoveValue: aValue id: anInteger.!
  
rollbackTransaction

	self indexTree rollbackTransaction.
	indexTreePersistence rollbackTransaction.
	indexTreeChanges := nil.!
 
saveIndexTree
	"Save my index tree to disk."

	indexTree beforeSaving.
	indexTreePersistence store: indexTree.
	indexTree parent: self.!
   
setter
    "Answer the setter method to use to get the value used in this index."

    ^setter!
  
setter: aSymbol
    "Public - set the setter method that answers the value used by this index."

    setter := aSymbol!
  
startsWith: aString
    "Public - Answer a collection of ids that have values starting with aString."

    | result anOC |
    (domain == String or: [ domain == MSText ])
        ifFalse: [ MSError signal: 'Use #where:startsWith: method only on a string index' ].
    aString isString ifFalse: [ ^MSError signal: 'Invalid string parameter:', aString printString ].
    result := self leafGreaterThanOrEqualTo: aString.
    anOC := OrderedCollection new.
    [ result isNil ] whileFalse: [
        (result value startsWith: aString)
            ifTrue: [ anOC addAll: result ids ]
            ifFalse: [ ^anOC ].
        result := self nextLeaf.].
    ^anOC.! !



!MSTrunk methods !

addLeafValue: anObject id: anInteger
	"Add a leaf value/id to my trunks or branches."

	leftTrunkOrBranch maximumValue >= anObject
		ifTrue: [leftTrunkOrBranch addLeafValue: anObject id: anInteger]
		ifFalse: [rightTrunkOrBranch addLeafValue: anObject id: anInteger]!

addLeavesTo: aCollection

	leftTrunkOrBranch addLeavesTo: aCollection.
	rightTrunkOrBranch addLeavesTo: aCollection.!

allLeaves

	| oc |
	oc := OrderedCollection new.
	self addLeavesTo: oc.
	^oc.!
 
beforeSaving

	parent isMSTreeHolder
		ifTrue: [parent := nil].
	leftTrunkOrBranch beforeSaving.
	rightTrunkOrBranch beforeSaving.!

beginTransaction
	"Only do this to the first branch because all branches share the same leaf DOManager."

	self firstBranch beginTransaction.
	!

commitTransaction
	"Only do this to the first branch because all branches share the same leaf DOManager."

	self firstBranch commitTransaction.
	!
  
firstBranch
	"Answer the first branch in my tree."

	^leftTrunkOrBranch firstBranch.!

firstLeaf
	"Answer the very first (lowest value) leaf that I hold."

	^leftTrunkOrBranch isEmpty
		ifTrue: [rightTrunkOrBranch firstLeaf]
		ifFalse: [leftTrunkOrBranch firstLeaf].!
   
isEmpty
	"Answer true or false.  If both left and right trunk/branches are empty, answer true."

	^leftTrunkOrBranch isEmpty and: [rightTrunkOrBranch isEmpty]!
  
leafEqualTo: anObject
	"Answer a leaf that is = an Object."

	^leftTrunkOrBranch maximumValue >= anObject
		ifTrue: [leftTrunkOrBranch leafEqualTo: anObject]
		ifFalse: [rightTrunkOrBranch leafEqualTo: anObject]!
   
leafGreaterThan: anObject
	"Answer a leaf that is > an Object."

	leftTrunkOrBranch maximumValue > anObject
		ifTrue:
			[leftTrunkOrBranch isEmpty  "may be empty from removing stuff."
				ifFalse: [^leftTrunkOrBranch leafGreaterThan: anObject]].
	^rightTrunkOrBranch leafGreaterThan: anObject.!
  
leafGreaterThanOrEqualTo: anObject
	"Answer a leaf that is >= an Object."

	leftTrunkOrBranch maximumValue >= anObject
		ifTrue: 
			[leftTrunkOrBranch isEmpty   "may be empty from removing stuff."
				ifFalse: [^leftTrunkOrBranch leafGreaterThanOrEqualTo: anObject]].
	^rightTrunkOrBranch leafGreaterThanOrEqualTo: anObject.!
   
left: leftBranch
right: rightBranch
parent: aTreeHolderOrTrunk
	"Set my left and right branches."

	leftTrunkOrBranch := (leftBranch parent: self).
	rightTrunkOrBranch := (rightBranch parent: self).
	parent := aTreeHolderOrTrunk.!
   
maximumLeavesPerBranch: anInteger
	"Set the maximum number of leaves allowed in a single branch before splitting.
	Push this info down to the branches."

	leftTrunkOrBranch maximumLeavesPerBranch: anInteger.
	rightTrunkOrBranch maximumLeavesPerBranch: anInteger.!

maximumValue
	"Instance variable getter.  If nil, set to max value of my right trunk or branch."

	maximumValue == nil
		ifTrue: [maximumValue := rightTrunkOrBranch maximumValue].
	^maximumValue.!
   
parent: anMSTreeHolder

	parent := anMSTreeHolder!

reapplyChanges
	"Send this message up to my parent."

	^parent reapplyChanges!
   
removeLeafValue: anObject id: anInteger
	"Remove this leaf value/id from my branches."

	leftTrunkOrBranch maximumValue >= anObject
		ifTrue: [leftTrunkOrBranch removeLeafValue: anObject id: anInteger]
		ifFalse: [rightTrunkOrBranch removeLeafValue: anObject id: anInteger]!
 
rollbackTransaction
	"Only do this to the first branch because all branches share the same leaf DOManager."

	self firstBranch rollbackTransaction.
	!
  
saveIndexTree
	"Pass this message along to my parent Trunk or TreeHolder."

	parent saveIndexTree!
   
saveLeaves
	"Ask (politely) my trunks or branches to save themselves."

	leftTrunkOrBranch saveLeaves.
	rightTrunkOrBranch saveLeaves.! !



!MSUnitOfWork methods !

addWorkStep: aWorkStep
	"Add a work step."

	workSteps add: aWorkStep.!
  
failedOn: exception
	"Inform the steps in process that something has failed, then resignal the exception."

	workSteps
		do:
			[:each |
			each failure].
	exception pass.!
 
initialize
	"Initialize the workSteps variable to a collection."

	workSteps := OrderedCollection new.!
  
start
	"Execute each work step.  If one fails, execute the failure part of each work step.
	If they all succeed, execute the success part of each work step."

	workSteps
		do: [:each | [each work] on: Error do: [ :exception | ^self failedOn: exception]].
	workSteps
		do: [:each | each successful].	! !



!MSWorkStep methods !
  
do: aBlock
	"Set the workBlock instance variable.  This is synonymous with the #work: method."

	workBlock := aBlock!

failure
	"Do the failure block."

	failureBlock == nil
		ifFalse: [failureBlock value]!
 
onFailureDo: aBlock
	"Set the failureBlock instance variable."

	failureBlock := aBlock.!

onSuccessDo: aBlock
	"Set the successBlock instance variable."

	successBlock := aBlock.!

successful
	"Do the success block."

	successBlock == nil
		ifFalse: [successBlock value].!
 
work
	"Do the work block."

	workBlock value!

work: aBlock
	"Set the workBlock instance variable."

	workBlock := aBlock! !



!Object methods !
   
isMSReadProxy
	"Answer false"

	#MinneStore.
	^false! !



!Object methods !

isMSText
	"Answer false."

	#MinneStore.
	^false! !



!Object methods !

isMSProxy
	"Answer false"

	#MinneStore.
	^false! !



!Object methods !

isMSObjectSet
	"Answer false"

	#MinneStore.
	^false! !



!Object methods !

isCollectionOtherThanString
	"Answer true if receiver is an instance of class Collection
	or one of its subclasses other than String, else answer false."

	#MinneStore.
    ^false! !



!Object methods !

isMSNilValue
	"Answer false."

	#MinneStore.
	^false! !



!Object methods !

isMSStorageProxy
	"Answer false"

	#MinneStore.
	^false! !



!Object class methods !
   
isMSNilValue

	#MinneStore.
	^false! !



!Collection methods !
  
asArrayCollect: aBlock
        "Answer an Array containing all the elements of the receiver."

    | answer index |
	#MinneStore.  "Created for efficiency"
    answer := Array new: self size.
    index := 1.
    self do: [ :element |
        answer at: index put: (aBlock value: element).
        index := index + 1].
    ^answer! !



!Collection methods !
 
intersectionOf: aCollection
	"Answer the elements that are also in aCollection"

	#MinneStore.
	self == aCollection ifTrue: [ ^self ].
	^self select: [ :each | aCollection includes: each ].! !



!Collection methods !
  
doesNotInclude: anObject
        "Answer true if the receiver contains an
         element equal to anObject, else answer false."
	#MinneStore.
	^(self includes: anObject) not! !



!Collection methods !
 
isCollectionOtherThanString
	"Answer true if receiver is an instance of class Collection
	or one of its subclasses other than String, else answer false."

	#MinneStore.
    ^true! !



!Collection methods !
 
uniqueUnionOf: aCollection
	"Answer the union of unique elements of myself and aCollection."

	| anOC |
	#MinneStore.
	anOC := self asOrderedCollection.
	aCollection do: [ :each |
		(self includes: each)
			ifFalse: [ anOC add: each ] ].
	^anOC.! !



!Collection methods !
  
max
	"Answer the largest element in this collection."

	| max |
	#MinneStore.
	self isEmpty ifTrue: [ ^nil ].
	max := self first.
	self do: [ :each | 
		each > max ifTrue: [ max := each ] ].
	^max.! !



!Bag methods !
 
asArrayByDescendingOccurrences

	| sc dict |	
	#MinneStore.
    sc := SortedCollection sortBlock: [ :a :b | a value > b value ].
    self elements associationsDo: [ :assoc | sc add: assoc ].
    ^sc asArrayCollect: [ :assoc | assoc key ].
! !



!Bag methods !
 
maxOccurrences
	"Answer the maximum number of
	occurences of an element in myself."

	| max |
	#MinneStore.
	max := 0.
	elements do: [ :each |
		max < each ifTrue: [ max := each ]].
	^max.! !



!Bag methods !
  
elementsWithOccurrences: anInteger

	| oc |
	#MinneStore.
	oc := OrderedCollection new.
	elements associationsDo: [ :association |
		association value = anInteger
			ifTrue: [ oc add: association key ]].
	^oc! !



!String methods !

asMSText
	"Answer myself inside an MSText object."

	#MinneStore.
	^MSText newOn: self.! !



!String methods !
 
isCollectionOtherThanString
	"Answer true if receiver is an instance of class Collection
	or one of its subclasses other than String, else answer false."

	#MinneStore.
    ^false! !



!String methods !

startsWith: aString
	"Answer true if my first characters match aString."

	#MinneStore.
	aString size > self size ifTrue: [ ^false ].
	1 to: aString size do: [ :x |
		(self at: x) = (aString at: x)
			ifFalse: [ ^false ] ].
	^true.
	! !



!WriteStream methods !
 
print: anObject

	#MinneStore.
    anObject printOn: self.! !



!ReadWriteStream methods !
  
dumpToNewFile: aString

	| char file fileStream |
	#MinneStore.
	self reset.
	file := File fromPath: aString.
	file exists ifTrue: [ file remove ].
	file create.
	fileStream := file binaryWriteStream.
"	self setFileType: fileStream file."
	[[self atEnd]
		whileFalse:
			[fileStream nextPut: self next].
	] ensure: [fileStream close].! !



!TextWindow methods !
 
print: anObject

	#MinneStore.
    anObject printOn: self.! !
