

TextWindow
	subclass: #TGenTextWindow
	instanceVariableNames: 'model saveSelector contentsSelector'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Gui'!
   
MDIViewManager
	subclass: #TranslatorGeneratorView
	instanceVariableNames: 'model transcript'
	classVariableNames: ''
	poolDictionaries: 'ColorConstants VirtualKeyConstants'
	category: 'TGen Gui'!

!TGenTextWindow methodsFor: 'as yet unclassified' !

contentsSelector: aSymbol
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    contentsSelector := aSymbol!

openOn: aString frame: parentFrame
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"
    self addView: (
        MDIChild new
            frame: parentFrame;
            owner: self).
    super openOn: aString.!
   
saveSelector: aSymbol
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    saveSelector := aSymbol!

saveString: aPane
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    saveSelector notNil
        ifTrue: [
            aPane modified:
                (model perform: saveSelector
                            withArguments: (Array with: (aPane contents
                                                                            strippedFor: 10 asCharacter)
                                                                 with: aPane)
                ) not
        ]
        ifFalse: [aPane modified: false]!

stringContents: aPane
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"
    contentsSelector isNil
        ifTrue: [aPane contents: '']
        ifFalse: [aPane contents: (model perform: contentsSelector)]!
   
translator: aTGen
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model := aTGen! !

!TGenTextWindow class methodsFor: 'as yet unclassified' !
  
classHeader
^'----------------------------------------------------------
TextWindow subclass: #TGenTextWindow

Date        By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------'! !

!TranslatorGeneratorView methodsFor: 'as yet unclassified' !
  
checkGrammarMode: mode
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    (self menuTitled: '&Grammar Type')
        uncheckAllTGEN;
        checkItem: mode.!
 
checkTranslationMode: mode
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    (self menuTitled: 'T&ranslation')
        uncheckAllTGEN;
        checkItem: mode.!
  
close: aPane
"-----------------------------------------------------------
Date           By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model release.
    self release.
    ^nil!
 
defineScannerClass
"Callback for the menu item titled 'Define Scanner Class'.
     (Generated by WindowBuilder)"

    model defineScannerClass!
 
defineTreeBuilderClass
"Callback for the menu item titled 'Define Tree Builder Class'.
     (Generated by WindowBuilder)"
    model defineTreeBuilderClass!
  
generator: aGenerator
"-----------------------------------------------------------
Date           By      Description
06/04/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model := aGenerator!

grammarType: aPane
"Callback for the #select event in the ComboBox named 'parserType'.
     (Generated by WindowBuilder)"
    aPane selectedIndex isNil ifTrue: [^self].
    model setGrammarMode:
        (model perform: (#(llModeMarker slr1ModeMarker lalr1ModeMarker lr1ModeMarker defaultModeMarker)
            at: aPane selectedIndex)).!

inspectGrammar
"Callback for the menu item titled 'Inspect Grammar'.
     (Generated by WindowBuilder)"
    model inspectGrammar!

inspectParser
"Callback for the menu item titled 'InspectParser'.
     (Generated by WindowBuilder)"

    model inspectParser!
  
inspectResult
"Callback for the menu item titled 'Inspect Result'.
     (Generated by WindowBuilder)"
    model inspectResult!
   
installScannerAndParser
"Callback for the menu item titled 'Install Scanner And Parser'.
     (Generated by WindowBuilder)"
    model installScannerAndParserClasses!

mdiMenu:anMDIFrame
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"        "Private - Create the MDI menus"

    anMDIFrame mdiMenuWindow addMenu: (
        MDIMenu new
            owner: self;
            appendItem: 'Inspect Result' selector: #inspectResult;
            appendItem: 'Define Tree Builder Class' selector: #defineTreeBuilderClass;
            appendItem: 'Inspect Grammar' selector: #inspectGrammar;
            appendItem: 'Inspect Parser' selector: #inspectParser;
            appendItem: 'Define Scanner Class' selector: #defineScannerClass;
            appendItem: 'Install Scanner and Parser' selector: #installScannerAndParser;
            title: '&T-Gen';
            yourself).
    anMDIFrame mdiMenuWindow addMenu: (
        MDIMenu new
            owner: self;
            appendItem: 'LL(1)' selector: #setLL1;
            appendItem: 'SLR(1)' selector: #setSLR1;
            appendItem: 'LALR(1)' selector: #setLALR1;
            appendItem: 'LR(1)' selector: #setLR1;
            appendItem: 'Don''t Care' selector: #setDontCare;
            title: '&Grammar Type';
            yourself).
    anMDIFrame mdiMenuWindow addMenu: (
        MDIMenu new
            owner: self;
            appendItem: 'Derivation' selector: #setDerivation;
            appendItem: 'Trace' selector: #setTrace;
            appendItem: 'Sham AST' selector: #setShamAST;
            appendItem: 'AST' selector: #setAST;
            title: 'T&ranslation';
            yourself).
    anMDIFrame mdiMenuWindow addMenu:self class mdiMenu owner:self.!
 
open
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

     | v newMdiFrame |
     
    newMdiFrame := MDIFrame new.

    self addView: (
        self frame: (newMdiFrame
            owner: self;
                when: #closed send: #close: to: self;
                when: #mdiMenuBarBuilt send: #mdiMenu: to: self with: newMdiFrame;
            labelWithoutPrefix: 'T-Gen';
            yourself
        )
    ).

    self openWindow.

    self dependsOn: (model := TranslatorGenerator new).

    self addView: (
        TGenTextWindow new
            translator: model;
            saveSelector: #acceptGrammarSpec:from:;
            contentsSelector: #grammarSpecification;
            openOn: '' frame: self frame;
            labelWithoutPrefix: 'Grammar Specification';
            yourself
    ).

    self addView: (
        TGenTextWindow new
            translator: model;
            saveSelector: #acceptInputText:from:;
            contentsSelector: #inputText;
            openOn: '' frame: self frame;
            labelWithoutPrefix: 'Test Input';
            yourself
    ).

    self addView: (
        v := TGenTextWindow new
                    translator: model;
                    saveSelector: #acceptTokenSpec:from:;
                    contentsSelector: #tokenSpecification;
                    openOn: '' frame: self frame;
                    labelWithoutPrefix: 'Token Specification';
                    yourself
    ).

    self addView: (
        transcript := (TGenTextWindow new
                                translator: model;
                                contentsSelector: #statusTextBuffer;
                                openOn: '' frame: self frame;
                                labelWithoutPrefix: 'T-Gen Transcript';
                                yourself)
    ).

    model tokenSpecController: v pane.
    self mdiTile.
    self
        setDerivation;
        setDontCare.
!
 
outputType: aPane
"Callback for the #select event in the ComboBox named 'outputType'.
     (Generated by WindowBuilder)"

    aPane selectedIndex isNil ifTrue: [^self].
    model setParserMode:
        (model perform: (#(defaultModeMarker traceModeMarker shamAstModeMarker astModeMarker)
            at: aPane selectedIndex)).!
  
setAST
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model setParserMode: model astModeMarker.
    self checkTranslationMode: #setAST.!

setDerivation
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model setParserMode: model defaultModeMarker.
    self checkTranslationMode: #setDerivation.!
  
setDontCare
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model setGrammarMode: model defaultModeMarker.
    self checkGrammarMode: #setDontCare.!
 
setLALR1
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model setGrammarMode: model lalr1ModeMarker.
    self checkGrammarMode: #setLALR1.!
 
setLL1
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model setGrammarMode: model llModeMarker.
    self checkGrammarMode: #setLL1.!

setLR1
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model setGrammarMode: model lr1ModeMarker.
    self checkGrammarMode: #setLR1.!
   
setShamAST
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model setParserMode: model shamAstModeMarker.
    self checkTranslationMode: #setShamAST.!

setSLR1
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model setGrammarMode: model slr1ModeMarker.
    self checkGrammarMode: #setSLR1.!

setTrace
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    model setParserMode: model traceModeMarker.
    self checkTranslationMode: #setTrace.!
  
statusTextBuffer
"-----------------------------------------------------------
Date           By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    transcript nextPutAll: model statusTextBuffer!
   
update: aSymbol
"-----------------------------------------------------------
Date           By      Description
06/07/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    self perform: aSymbol! !

!TranslatorGeneratorView class methodsFor: 'as yet unclassified' !

mdiMenu
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"        "Private - Answer the standard MDI Window menu"
    ^MDIMenu new
        appendItem: '&Cascade	Shift+F5' selector: #mdiCascade accelKey: F5Key accelBits: AfVirtualkey|AfShift ;
        appendItem: '&Tile	Shift+F4' selector: #mdiTile accelKey: F4Key accelBits: AfVirtualkey|AfShift ;
        appendItem: 'Arrange &Icons' selector: #mdiArrange;
        appendItem: 'Close &All' selector: #mdiCloseAll;
        title: '&Window'.!
  
open
"-----------------------------------------------------------
Date           By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    ^self new open!
  
wbCreated

    ^true! !

!TextPane methodsFor: 'as yet unclassified' !
  
insertAndSelectTGEN: aString at: aPosition
"-----------------------------------------------------------
Date           By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    | origin corner box location |

    self selectBefore: (textHolder getPointAt: (location := aPosition max: 1)).
    selection hide.

    box := self replaceWithText: aString.

    selection := textHolder getSelectionFrom: location to: location + aString size - 1.
    selection pane: self.
     self   forceSelectionOntoDisplay.
! !

!Menu methodsFor: 'as yet unclassified' !

uncheckAllTGEN
"Added by C&P"

    items do: [:i | self uncheckItem: i selector ].! !