

Array
	variableSubclass: #A
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
Object
	subclass: #AbstractParser
	instanceVariableNames: 'scanner prevToken requestor failBlock'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

Object
	subclass: #AbstractScanner
	instanceVariableNames: 'source nextChar token tokenType buffer'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
Object
	subclass: #DLGParser
	instanceVariableNames: 'dlgScanner errorBlock'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
Object
	subclass: #DLGScanner
	instanceVariableNames: 'inputStream tokenValue tokenType errorBlock'
	classVariableNames: 'AtomDictionary MetaCharDictionary'
	poolDictionaries: ''
	category: 'TGen Base'!
 
AbstractScanner
	subclass: #FSABasedScanner
	instanceVariableNames: 'fsa'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

FSABasedScanner class instanceVariableNames: 'fsa'!
 
FSABasedScanner
	subclass: #FSABasedScannerWithOneTokenLookahead
	instanceVariableNames: 'savePosition'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
FSABasedScanner
	subclass: #FSABasedScannerWithTwoTokenLookahead
	instanceVariableNames: 'stateStack saveState saveChar savePosition'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

Object
	variableSubclass: #Grammar
	instanceVariableNames: 'nonterminals terminals productions startSymbol nullableNonterminals firstSets followSets'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

Object
	variableSubclass: #GrammarProduction
	instanceVariableNames: 'leftHandSide rightHandSide'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

OrderedCollection
	subclass: #Graph
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
Graph
	subclass: #DirectedGraph
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
Object
	subclass: #GraphNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
GraphNode
	subclass: #DirectedGraphNode
	instanceVariableNames: 'predecessors'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
GraphNode
	subclass: #EdgeLabeledDigraphNode
	instanceVariableNames: 'edgeLabelMap'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
EdgeLabeledDigraphNode
	subclass: #FSAState
	instanceVariableNames: 'stateID'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

FSAState class instanceVariableNames: 'noTransitionSignal'!
 
FSAState
	subclass: #BidirectionalEdgeLabeledDigraphNode
	instanceVariableNames: 'predecessorLabelMap'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
FSAState
	subclass: #FSAFinalState
	instanceVariableNames: 'literalTokens tokenClasses'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
FSABasedScanner
	subclass: #GrSpecScanner
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
AbstractScanner
	subclass: #HandCodedScanner
	instanceVariableNames: 'charTypeTable'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
HandCodedScanner class instanceVariableNames: 'charTypeTable'!
  
Set
	subclass: #ItemSet
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
DirectedGraph
	subclass: #LabeledDigraph
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
LabeledDigraph
	subclass: #FirstFollowGraph
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
Dictionary
	subclass: #LLParserTable
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
Object
	variableSubclass: #LR0Item
	instanceVariableNames: 'leftHandSide preDotSymbols postDotSymbols translationSymbol'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
LR0Item
	variableSubclass: #LR1Item
	instanceVariableNames: 'lookahead'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
BidirectionalEdgeLabeledDigraphNode
	variableSubclass: #LRParserState
	instanceVariableNames: 'reduceMap'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

DirectedGraphNode
	subclass: #NodeLabeledDigraphNode
	instanceVariableNames: 'label'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
NodeLabeledDigraphNode
	subclass: #FstFllwGraphNode
	instanceVariableNames: 'terminals'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
FSABasedScanner
	subclass: #OptimizedScanner
	instanceVariableNames: 'finalStateTable fsaCurrentState'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
OptimizedScanner class instanceVariableNames: 'tokenTable finalStateTable noTransitionSignal'!
  
OptimizedScanner
	subclass: #OptimizedScannerWithOneTokenLookahead
	instanceVariableNames: 'savePosition'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

OptimizedScanner
	subclass: #OptimizedScannerWithTwoTokenLookahead
	instanceVariableNames: 'stateStack saveState saveChar savePosition'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
OrderedCollection
	subclass: #OrderedChildren
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
Object
	subclass: #OrderedPair
	instanceVariableNames: 'x y'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
Object
	subclass: #ParseTreeBuilder
	instanceVariableNames: 'stack'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
ParseTreeBuilder
	subclass: #AbstractSyntaxTreeBuilder
	instanceVariableNames: 'shamMode'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

ParseTreeBuilder
	subclass: #DerivationTreeBuilder
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

Object
	subclass: #PartitionTransitionMap
	instanceVariableNames: 'partition transitionMap'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
Object
	subclass: #ProductionPartition
	instanceVariableNames: 'leftHandSide problemProductions otherProductions'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

AbstractParser
	subclass: #RecursiveDescentParser
	instanceVariableNames: 'here hereType hereMark prevMark class encoder parseNode lastTempMark correctionDelta'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
FileStream
	subclass: #RetractableFileStream
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
ReadStream
	subclass: #RetractableReadStream
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
WriteStream
	subclass: #RetractableWriteStream
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

Dictionary
	subclass: #SetDictionary
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
Array
	variableSubclass: #Stack
	instanceVariableNames: 'topPtr'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
AbstractParser
	subclass: #TableDrivenParser
	instanceVariableNames: 'parseTable transcript treeBuilder'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
TableDrivenParser class instanceVariableNames: 'parseTable'!

TableDrivenParser
	subclass: #LL1Parser
	instanceVariableNames: 'startSymbol'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

LL1Parser class instanceVariableNames: 'startSymbol'!
   
TableDrivenParser
	subclass: #LR1Parser
	instanceVariableNames: 'finalState'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
LR1Parser class instanceVariableNames: 'finalState'!

LR1Parser
	subclass: #GrammarSpecParser
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
LL1Parser
	subclass: #OptimizedLL1Parser
	instanceVariableNames: 'nonterminals terminals'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

OptimizedLL1Parser class instanceVariableNames: 'terminals nonterminals'!
   
LR1Parser
	subclass: #OptimizedLR1Parser
	instanceVariableNames: 'tokenTypeTable'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

OptimizedLR1Parser class instanceVariableNames: 'tokenTypeTable'!
   
Exception
	subclass: #TGenException
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
TGenException
	subclass: #GrammarNotReduced
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
TGenException
	subclass: #ParserTransitionError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
TGenException
	subclass: #ScannerTransitionError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
TGenException
	subclass: #SyntaxError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
Object
	variableSubclass: #TokenClassification
	instanceVariableNames: 'tokenType action'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

Object
	subclass: #TokenSpecificationRule
	instanceVariableNames: 'tokenClass regExpr directive'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
LR1Parser
	subclass: #TokenSpecParser
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
FSABasedScanner
	subclass: #TokenSpecScanner
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
Object
	subclass: #TokenTypeActionHolder
	instanceVariableNames: 'type action'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
GrammarProduction
	variableSubclass: #TransductionGrammarProduction
	instanceVariableNames: 'translationSymbol'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
Object
	subclass: #TranslatorGenerator
	instanceVariableNames: 'grammar transformedGrammar isLL1 isSLR1 isLALR1 isLR1 parser statusTextBuffer tokenSpecification grammarSpecification inputText grammarMode parserMode parserResult tokenSpecController scannerClass treeBuilderClass oldScannerSpec oldScannerLits oldScanner'
	classVariableNames: 'TokenSpecMetaChars'
	poolDictionaries: ''
	category: 'TGen Base'!

TranslatorGenerator class instanceVariableNames: 'grammarSpecParser tokenSpecParser'!
   
Object
	subclass: #TreNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

TreNode
	subclass: #ParseTreeNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
ParseTreeNode
	subclass: #DerivationTreeNode
	instanceVariableNames: 'symbol children'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
ParseTreeNode
	subclass: #GrammarParseTreeNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

GrammarParseTreeNode
	subclass: #GrammarLeafNode
	instanceVariableNames: 'symbol'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

GrammarParseTreeNode
	subclass: #GrammarNode
	instanceVariableNames: 'productions'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
GrammarLeafNode
	subclass: #NonterminalNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
GrammarParseTreeNode
	subclass: #ProductionNode
	instanceVariableNames: 'leftHandSide rightHandSides'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

ParseTreeNode
	subclass: #RegularExpressionNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
RegularExpressionNode
	subclass: #BinaryRegExprNode
	instanceVariableNames: 'leftChild rightChild'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
RegularExpressionNode
	subclass: #CharacterNode
	instanceVariableNames: 'charSpec'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
RegularExpressionNode
	subclass: #CharRangeNode
	instanceVariableNames: 'firstChar lastChar'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
CharacterNode
	subclass: #DecimalCharNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
RegularExpressionNode
	subclass: #EnnaryRegExprNode
	instanceVariableNames: 'children'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
EnnaryRegExprNode
	subclass: #AlternationNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
EnnaryRegExprNode
	subclass: #AlternationRangeNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

AlternationRangeNode
	subclass: #ComplementedAlternationRangeNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
EnnaryRegExprNode
	subclass: #ConcatenationNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
RegularExpressionNode
	subclass: #EpsilonNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
CharacterNode
	subclass: #EscapedCharNode
	instanceVariableNames: ''
	classVariableNames: 'SpecialCharMap'
	poolDictionaries: ''
	category: 'TGen Base'!
   
CharacterNode
	subclass: #HexadecimalCharNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
BinaryRegExprNode
	subclass: #ListNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

CharacterNode
	subclass: #OctalCharNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
GrammarParseTreeNode
	subclass: #RightHandSideNode
	instanceVariableNames: 'symbols translationSymbol'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
ProductionNode
	subclass: #RRPGProductionNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
RightHandSideNode
	subclass: #RRPGRightHandSideNode
	instanceVariableNames: 'regexpr'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

GrammarLeafNode
	subclass: #TerminalNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
ParseTreeNode
	subclass: #TokenSpecParseNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
TokenSpecParseNode
	subclass: #TokenSpecLeafNode
	instanceVariableNames: 'symbol'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

TokenSpecLeafNode
	subclass: #DirectiveNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
TokenSpecLeafNode
	subclass: #TokenClassNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
TokenSpecParseNode
	subclass: #TokenSpecNode
	instanceVariableNames: 'specRules'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
TokenSpecParseNode
	subclass: #TokenSpecRuleNode
	instanceVariableNames: 'tokenClass regExpr directive'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
GrammarLeafNode
	subclass: #TranslationNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
RegularExpressionNode
	subclass: #UnaryRegExprNode
	instanceVariableNames: 'onlyChild'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
   
UnaryRegExprNode
	subclass: #OptionalNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
 
UnaryRegExprNode
	subclass: #PlusClosureNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!
  
UnaryRegExprNode
	subclass: #StarClosureNode
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'TGen Base'!

!A methodsFor: 'as yet unclassified' !

a: anInteger p: anObject
"-----------------------------------------------------------
Date           By      Description
06/12/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    ^super at: anInteger put: anObject!
  
y
"-----------------------------------------------------------
Date           By      Description
06/12/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"
    ^self! !

!A class methodsFor: 'as yet unclassified' !
  
classHeader
^'----------------------------------------------------------
Array subclass: #A

Date        By      Description
06/12/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------'!
  
n: anInteger
"-----------------------------------------------------------
Date           By      Description
06/12/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    ^super new: anInteger! !

!AbstractParser methodsFor: 'as yet unclassified' !
  
endOfInput
    "Some parsers may use the eof token while others may use the eof token type."

    self subclassResponsibility!
   
endOfInputToken
    "Answer the token used by my scanner to represent the end of the input."

    ^self scanner endOfInputToken!
 
endOfInputTokenType
    "Answer the token type used by my scanner to represent the end of the input."

    ^self scanner endOfInputTokenType!

failBlock

    ^failBlock!

failBlock: argument

    failBlock := argument!
   
init

    self scanner: self scannerClass new!

initScannerFile: aFile
    "The scanner is responsible for scanning the first token (i.e. for priming the token
    buffers)."

    self scanner scannerFile: aFile!

initScannerPathName: aFileName
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 Anamet Laboratories, Inc.  All Rights Reserved.
-----------------------------------------------------------"
    ^self initScannerPathName: aFileName in: Disk!
  
initScannerPathName: aFileName in: aDirectory
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 Anamet Laboratories, Inc.  All Rights Reserved.
-----------------------------------------------------------"
        | file anArray |
    anArray := File splitPath: aFileName in: aDirectory.
    file := File
                open: (anArray at: 3)
                in: (Directory new
                        drive: (anArray at: 1);
                        pathName: (anArray at: 2)).
    self initScannerFile: file.
    ^file!
   
initScannerSource: aString
    "The scanner is responsible for scanning the first token (i.e. for priming the token
    buffers)."

    self scanner scanSource: aString!
   
nextToken

    ^self scanner tokenType!
   
nextTokenValue

    ^self scanner token!
  
prevToken

    ^prevToken!

prevToken: argument

    prevToken := argument!
   
requestor

    ^requestor!

requestor: argument

    requestor := argument!
   
scanner

    ^scanner!

scanner: argument

    scanner := argument!
   
scannerClass
    "Answer the preferred class of scanners for this kind of parser."

    self subclassResponsibility!
 
scanToken
    "Subclasses may not always want the previous token value and may override this
    method for efficiency."

    self prevToken: self nextTokenValue.
    self scanner scanToken! !

!AbstractParser class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class represents abstract parsing behavior.

Instance Variables:

    scanner <a scanner class>    - this parser''s scanner
    prevToken <String + Symbol>    - the last token scanned
    requestor <Controller + Object>    - the object invoking the parser, errors are reported to this object
    failBlock <Block>        - this block is evaluated before the parse is aborted'!
 
new

    ^super new init! !

!AbstractScanner methodsFor: 'as yet unclassified' !
   
atEnd

    ^self nextChar = self endOfInputToken!
 
backspaceSource
    "When the source is at the end, 'source current' is the last character."

    self atEnd ifFalse: [self source backspace].
    self nextChar: self source current!
  
buffer

    ^buffer!
  
buffer: argument

    buffer := argument!
 
contents

    ^self source contents!
  
endOfInputToken
    "Answer a token representing the end of the input."

    self subclassResponsibility!

endOfInputTokenType
    "Answer the token type representing the end of the input."

    self subclassResponsibility!
 
errorPosition
    "Answer the source position of the last acceptable character."

    ^source position + (self atEnd
            ifTrue: [1]
            ifFalse: [0]) max: 1!
 
getNextChar
    "Source will answer an empty string when no more input is available.
    Subclasses may override this to avoid unnecessary buffering."

    self buffer nextPut: self nextChar.
    self nextChar: self source next!
   
init

    self buffer: (RetractableWriteStream on: (String new: 32))!
 
nextChar

    ^nextChar!
  
nextChar: argument

    nextChar := argument!
 
position

    ^self source position!
  
putBackChar
    "Remove the last character in the buffer and backspace the source.
    Subclasses may override this to avoid unnecessary buffering."

    self buffer backspace.
    self backspaceSource!
 
reset
    "Reset the initial state of the scanner before scanning a new source."

    self buffer reset.
    self token: nil.
    self tokenType: nil.
    self nextChar: nil!

scannerFile: aFile
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 Anamet Laboratories, Inc.  All Rights Reserved.
-----------------------------------------------------------"
    self reset.
    self source: (RetractableFileStream on: aFile).
    self nextChar: self source next.
    self scanToken!
 
scanSource: aString
    "Convert the input string to a read stream and scan the first token."

    self reset.
    self source: (RetractableReadStream on: aString).
    self nextChar: self source next.
    self scanToken!
 
scanToken
    "Subclasses must compute values for token and tokenType here."

    self subclassResponsibility!
   
signalEndOfInput
    "Set scanner to the end-of-input state."

    self tokenType: self endOfInputTokenType.
    self token: self endOfInputToken!
  
source

    ^source!
  
source: argument

    source := argument!
 
token

    ^token!

token: argument

    token := argument!
   
tokenType

    ^tokenType!

tokenType: argument

    tokenType := argument! !

!AbstractScanner class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I scan a source string and break it up into tokens using mechanisms provided in concrete subclasses.

Instance Variables:
    source            <ReadStream> - character input stream.
    nextChar        <Character + UndefinedObject> - one-character lookahead buffer for source, nil if no input left.
    token            <String> - current token buffer.
    tokenType    <String + Symbol> - current token type buffer.
    buffer            <WriteStream> - character accumulation buffer for tokens.
'!
 
new

    ^super new init!
 
scanFrom: aString

    | newScanner |
    newScanner := self new.
    newScanner scanSource: aString.
    ^newScanner! !

!AbstractSyntaxTreeBuilder methodsFor: 'as yet unclassified' !
 
init

    super init.
    self setNormalMode!

insertCatNode: node1 with: node2

    | tempNode catNode |
    node2 isEpsilonNode
        ifTrue: [^node1]
        ifFalse:
            [node2 isCatNode
                ifTrue:
                    [node2 children addFirst: node1.
                    ^node2].
            node1 isCatNode
                ifTrue:
                    [node1 children addLast: node2.
                    ^node1]
                ifFalse:
                    [tempNode := OrderedCollection new.
                    tempNode add: node1; add: node2.
                    catNode := ConcatenationNode new addChildrenInitial: tempNode.
                    ^catNode]]!
  
insertNode: node1 with: node2

    | tempNode catNode |
    node2 isEpsilonNode
        ifTrue: [^node1]
        ifFalse:
            [node2 isCatNode
                ifTrue:
                    [node2 children addFirst: node1.
                    ^node2].
            node1 isCatNode
                ifTrue:
                    [node1 children addLast: node2.
                    ^node1]
                ifFalse:
                    [tempNode := OrderedCollection new.
                    tempNode add: node1; add: node2.
                    catNode := ConcatenationNode new addChildrenInitial: tempNode.
                    ^catNode]]!
 
insertRHSNode: node1 with: node2

    | tempNode altNode |
    node2 isAltNode
        ifTrue:
            [node2 children addFirst: node1.
            ^node2]
        ifFalse:
            [tempNode := OrderedCollection new.
            tempNode add: node1; add: node2.
            altNode := AlternationNode new addChildrenInitial: tempNode.
            ^altNode]!

makeNewNode: stringOrSymbol
    "The argument represents the name of a node class. If in sham mode answer a
    new derivation tree node for the argument, otherwise answer a new instance of
    that class."

    ^self shamMode
        ifTrue: [DerivationTreeNode symbol: stringOrSymbol]
        ifFalse: [(Smalltalk at: stringOrSymbol asSymbol ifAbsent: [self error: 'no class named ' , stringOrSymbol]) new]!

reset
    "Empty the node stack and set to normal mode."

    self init!
 
setNormalMode

    self shamMode: false!
  
setShamMode

    self shamMode: true!
 
shamMode

    ^shamMode!
  
shamMode: argument

    shamMode := argument! !

!AbstractSyntaxTreeBuilder class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I build parse trees by creating specific objects for each kind of node as indicated by the parser directives in grammar productions.  Parser directives currently fall into one of three groups: node (class) names, special directives, and arbitrary message selectors. For a node name, a new instance of the specified node is created and given the values associated with the right-hand side nonterminals, if any, as its children. The special directive ''nil'' simply returns nil. The directive liftRightChild adds any nodes preceeding the right-most node as children to the right-most node, and returns the right-most node. The directive liftLeftChild works in an analogous fashion. Arbitrary message selectors must take the same number of arguments as there are right-hand-side nodes and are invoked as a builder message, thus allowing users to define their own tree-building messages.

Productions of the form ''A -> <tc> => symbol'' are treated specially. The symbol can be either a node name or a one-argument message selector. If it is a node name then create a new instance of that node with the specified attribute value. If it is a message selector then invoke the corresponding operation on the builder with the specified value.

Instance Variables:
    shamMode    <Boolean> - If true DerivationTreeNode-based ASTs are built, otherwise specific ParseTreeNode-based ASTs are built.'! !

!AlternationNode methodsFor: 'as yet unclassified' !
 
asFSAStartingAt: startState endingAt: finalState

    self children do: [:child | child asFSAStartingAt: startState endingAt: finalState]!

createNewProduction: lhsNode and: node

    | prodChildren rule |
    prodChildren := OrderedCollection new.
    rule := OrderedCollection new.
    rule add: lhsNode; add: node.
    ^prodChildren add: (RRPGProductionNode new addChildrenInitial: rule)!
   
createNewRHS: lhs with: alpha with: gamma
    | aCollection prods |
    aCollection := OrderedCollection new.
    prods := OrderedCollection new.
    children do:
        [:child |
        alpha isEmpty ifFalse: [child addAllFirst: alpha].
        gamma isEmpty ifFalse: [aCollection addAllLast: gamma].
        prods add: (self createNewProduction: lhs with: child)].
    ^prods!
   
hasBeenTransformed
    ^false!
 
isAltNode

    ^true!
 
isCatNode

    ^false!

needTransforming
    ^false!
   
performTransformation: lhs with: alpha with: gamma

    | prods node catNode index |
    (alpha isEmpty and: [gamma isEmpty])
        ifTrue: [^self processTransformation: lhs]
        ifFalse:
            [prods := OrderedCollection new.
            node := OrderedCollection new.
            node addAll: alpha; addAll: gamma.
            index := alpha size.
            children do: [:child | child isCatNode
                    ifTrue:
                        [(child children) addAllFirst: alpha; addAllLast: gamma.
                        prods add: (self createNewProduction: lhs with: child)]
                    ifFalse:
                        [node add: child beforeIndex: index + 1.
                        catNode := ConcatenationNode new addChildrenInitial: node.
                        node remove: child.
                        prods add: (self createNewProduction: lhs with: catNode)]].
            ^prods]!
  
printOn: aStream

    aStream nextPut: $(.
    self children do:
        [:child |
        child printOn: aStream.
        child == self children last ifFalse: [aStream nextPutAll: ' | ']].
    aStream nextPut: $)!
   
processTransformation: lhsNode with: lhsNames

    | prods newProds |
    prods := OrderedCollection new.
    newProds := OrderedCollection new.
    children do: [:child | prods add: (self createNewProduction: lhsNode deepCopy and: child)].
    prods do: [:ea | (newProds addAll: (ea rightHandSides processTransformation: ea leftHandSide with: lhsNames)) isEmpty ifTrue: [newProds add: ea]].
    ^newProds! !

!AlternationNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent the alternation of two or more regular expressions, i.e. child1 | child2 | ... | childN.'! !

!AlternationRangeNode methodsFor: 'as yet unclassified' !

addChildrenInitial: anOrderedCollection

    anOrderedCollection size = 1
        ifTrue: [self children: anOrderedCollection removeFirst]
        ifFalse: [self error: 'wrong number of children']!
   
asPureRegExpr
    "Answer a new version of the receiver consisting of only characters,
    concatenations, alternations, and (star) closures. Also, eliminate single
    child alternations and concatenations."

    | kids |
    kids := OrderedChildren new.
    self characters do: [:char | kids add: (self makeCharNodeFor: char)].
    ^self alternationNodeClass children: kids!

characters
    "Answer the Set of Characters I represent."

    | chars |
    chars := Set new.
    self childrenDo: [:child | child addCharsTo: chars].
    ^chars!
  
makeCharNodeFor: aChar
    "Answer a new CharacterNode for aChar."

    ^self characterNodeClass charSpec: (String with: aChar)!
 
printOn: aStream

    aStream nextPut: $[.
    self children do: [:child | child printOn: aStream].
    aStream nextPut: $]! !

!AlternationRangeNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent the alternation of two or more atomic regular expressions.  My specification encorporates the use of character ranges, e.g. [a-z] (= a | b | c | ... | z).  My children are either simple characters or character ranges, e.g. [a-z0-9!!@#] or [aeiou] (vowels).'! !

!BidirectionalEdgeLabeledDigraphNode methodsFor: 'as yet unclassified' !
 
addPredecessor: node withEdgeLabeled: label

    self predecessorLabelMap at: label add: node!

init

    super init.
    self predecessorLabelMap: SetDictionary new!
   
predecessorLabelMap

    ^predecessorLabelMap!

predecessorLabelMap: argument

    predecessorLabelMap := argument!
   
predecessors

    ^self predecessorLabelMap elements!
 
predecessorsDo: aBlock

    self predecessors do: aBlock!
 
predecessorsExceptSelfDo: aBlock

    (self predecessors reject: [:pred | pred = self])
        do: aBlock! !

!BidirectionalEdgeLabeledDigraphNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent a node in an edge-labeled digraph.  I maintain edges in both directions, i.e. I can follow edges forwards or backwards.

Instance Variables:

    predecessorLabelMap        <SetDictionary from: labels to: predecessors>'! !

!BinaryRegExprNode methodsFor: 'as yet unclassified' !
 
addChildrenFirst: anOrderedCollection

    anOrderedCollection size = 1
        ifTrue: [self leftChild: anOrderedCollection removeFirst]
        ifFalse: [self error: 'wrong  number of children']!
   
addChildrenInitial: anOrderedCollection

    anOrderedCollection size = 2
        ifTrue:
            [self leftChild: anOrderedCollection removeFirst.
            self rightChild: anOrderedCollection removeFirst]
        ifFalse: [anOrderedCollection size = 1
                ifTrue: [self rightChild: anOrderedCollection removeFirst]
                ifFalse: [self error: ' wrong  number of children']]!
   
childrenDo: aBlock
    "Evaluate aBlock for each of my children."

    aBlock value: self leftChild.
    aBlock value: self rightChild!
 
leftChild

    ^leftChild!

leftChild: argument

    leftChild := argument!
   
rightChild

    ^rightChild!
  
rightChild: argument

    rightChild := argument!
 
updateChildrenUsing: aBlock
    "Replace my children according to the value of aBlock."

    self leftChild: (aBlock value: self leftChild).
    self rightChild: (aBlock value: self rightChild)! !

!BinaryRegExprNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a binary regular expression.

Instance Variables:

    leftChild    <RegExprNode>
    rightChild    <RegExprNode>'!

leftChild: arg1 rightChild: arg2

    | newMe |
    newMe := self new.
    newMe leftChild: arg1.
    newMe rightChild: arg2.
    ^newMe! !

!CharacterNode methodsFor: 'as yet unclassified' !
 
addCharsTo: aCollection
    "Add each character in my range to aCollection."

    aCollection add: self myChar!
  
addNonemptyLeavesTo: aSet

    aSet add: self myChar!
 
addPureCharNodesTo: childNodes

    childNodes add: self!
 
asciiValue

    ^self myChar asciiValue!
  
asFSAStartingAt: startState endingAt: finalState

    startState goto: finalState on: self myChar!

charSpec

    ^charSpec!
  
charSpec: argument

    charSpec := argument!
 
myChar
    "Answer the Character represented by the receiver."

    self charSpec size = 1
        ifTrue: [^self charSpec first]
        ifFalse: [self error: 'Only single character regular expressions atoms are currently supported.']!
   
printOn: aStream

    self charSpec printOn: aStream!
 
setAttribute: value

    self charSpec: value! !

!CharacterNode class methodsFor: 'as yet unclassified' !
  
charSpec: arg1

    | newMe |
    newMe := self new.
    newMe charSpec: arg1.
    ^newMe!
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a atomic character of a regular expression.

Instance Variables:
    charSpec    <String> - contains the character atom specification for this node (different types of specifications are represented by subclasses).'! !

!CharRangeNode methodsFor: 'as yet unclassified' !
 
addCharsTo: aCollection
    "Add each character in my range to aCollection."

    self firstChar asciiValue to: self lastChar asciiValue do: [:ascii | aCollection add: (Character value: ascii)]!
   
addChildrenInitial: anOrderedCollection

    anOrderedCollection size = 2
        ifTrue:
            [self firstChar: anOrderedCollection removeFirst.
            self lastChar: anOrderedCollection removeFirst]
        ifFalse: [self error: 'wrong number of children']!

addPureCharNodesTo: childNodes
    "Add CharacterNodes for each character in my range to childNodes."

    self firstChar asciiValue to: self lastChar asciiValue do: [:ascii | childNodes add: (self makeCharNodeFor: (Character value: ascii))]!
   
firstChar

    ^firstChar!

firstChar: argument

    firstChar := argument!
   
lastChar

    ^lastChar!
  
lastChar: argument

    lastChar := argument!
 
makeCharNodeFor: aChar
    "Answer a new CharacterNode for aChar."

    ^self characterNodeClass charSpec: (String with: aChar)!
 
printOn: aStream

    self firstChar printOn: aStream.
    aStream nextPut: $-.
    self lastChar printOn: aStream! !

!CharRangeNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent the alternations of each atomic character in a range.  I.e. ''firstChar-lastChar'' = ''firstChar | ... | lastChar''.  I may only appear as a child of a AlternationRangeNode or a ComplementedAlternationRangeNode.

Instance Variables:
    firstChar    <CharacterNode>
    lastChar    <CharacterNode>'! !

!ComplementedAlternationRangeNode methodsFor: 'as yet unclassified' !
   
characters
    "Answer the Set of Characters I represent."

    | chars |
    chars := self characterUniverse.
    chars removeAll: super characters ifAbsent:[].
    ^chars!
 
characterUniverse
    "Answer a collection of printable characters."

    ^((32 to: 126)
        collect: [:ea | Character value: ea]) asSet!
   
printOn: aStream

    aStream nextPut: $~.
    super printOn: aStream! !

!ComplementedAlternationRangeNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent the alternation of two or more atomic regular expressions (specified as the complement of an alternation range).  I take the complement of the universe of printable characters only, e.g. ~[aeiou] (all non-vowel printable characters).'! !

!ConcatenationNode methodsFor: 'as yet unclassified' !
  
asFSAStartingAt: startState endingAt: finalState

    | prevState newState |
    prevState := startState.
    self children do: [:child | child == self children last
            ifTrue: [child asFSAStartingAt: prevState endingAt: finalState]
            ifFalse:
                [newState := self fsaStateClass new.
                child asFSAStartingAt: prevState endingAt: newState.
                prevState := newState]]!
  
collectSymbol

    ^self children collect: [:sym | sym asGrammarSymbol]!
  
createNewRule: lhsNode with: alpha

    | rule |
    rule := OrderedCollection new.
    rule add: lhsNode; add: (RRPGRightHandSideNode new symbols: (ConcatenationNode new addChildrenInitial: alpha)).
    ^RRPGProductionNode new addChildrenInitial: rule!
  
isAltNode

    ^false!

isCatNode

    ^true!
 
isEpsilonNode

    ^false!

printOn: aStream

    self children do:
        [:child |
        child printOn: aStream.
        child == self children last ifFalse: [aStream space]]!
   
processTransformation: lhs with: lhsNames

    | newProd1 |
    (newProd1 := self traverseChildren: lhs with: lhsNames) isEmpty
        ifTrue: [^self transformAlternationNode: lhs with: lhsNames]
        ifFalse: [^newProd1]!
 
transformAlternationNode: lhs with: lhsNames

    | alpha gamma newProd collection productions |
    alpha := OrderedCollection new.
    gamma := OrderedCollection new.
    newProd := OrderedCollection new.
    productions := OrderedCollection new.
    children reverseDo: [:node | node hasBeenTransformed
            ifTrue: [gamma addFirst: node]
            ifFalse:
                [alpha := children copyWithout: node.
                alpha removeAll: gamma.
                newProd addAll: (node
                        performTransformation: lhs
                        with: alpha
                        with: gamma).
                newProd do: [:prod | (collection := prod rightHandSides processTransformation: prod leftHandSide with: lhsNames) isEmpty
                        ifTrue: [productions addLast: prod]
                        ifFalse: [productions addAllLast: collection]].
                ^productions]].
    ^productions!
   
traverseChildren: lhs with: lhsNames

    | alpha gamma lhsNode newProd collection productions |
    alpha := OrderedCollection new.
    gamma := OrderedCollection new.
    newProd := OrderedCollection new.
    productions := OrderedCollection new.
    lhsNode := lhs.
    alpha addAll: children.
    children
        reverseDo:
            [:node |
            alpha removeLast.
            node needTransforming
                ifTrue:
                    [alpha isEmpty
                        ifFalse:
                            [lhsNode := self newNonterminal: lhs symbol , 'P' with: lhsNames.
                            alpha addLast: lhsNode.
                            newProd add: (self createNewRule: lhs with: alpha)].
                    newProd addAll: (node
                            performTransformation: lhsNode
                            with: gamma
                            with: lhsNames).
                    newProd do: [:prod | (collection := prod rightHandSides processTransformation: prod leftHandSide with: lhsNames) isEmpty
                            ifTrue: [productions addLast: prod]
                            ifFalse: [productions addAllLast: collection]].
                    ^productions]
                ifFalse: [gamma addFirst: node]].
    ^productions! !

!ConcatenationNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent the concatenation of two or more regular expressions, i.e. child1 child2 ... childN.'! !

!DecimalCharNode methodsFor: 'as yet unclassified' !
 
myChar
    "Answer the Character represented by the receiver.
    The spec is of the form '\ddd'."

    | spec |
    spec := self charSpec.
    (spec size = 4 and: [spec first = $\])
        ifTrue: [^Character value: (spec copyFrom: 2 to: 4) asInteger]
        ifFalse: [self error: 'Decimal character specifications must be of the form ''\ddd''.']! !

!DecimalCharNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a atomic character of a regular expression.  I am specified by a String of the form ''\ddd'' where each d is a decimal digit and ddd is my corresponding ASCII value.

'! !

!DerivationTreeBuilder methodsFor: 'as yet unclassified' !
 
epsilon
    "Answer an object used to represent the empty string (epsilon)."

    ^'<epsilon>'!
  
processProduction: grammarProd forParser: parser
    "This is simple and straightforward to implement, so do it all here."

    | parent child |
    parent := DerivationTreeNode symbol: grammarProd leftHandSide.
    grammarProd rightHandSide isEmpty
        ifTrue:
            [child := DerivationTreeNode symbol: self epsilon.
            parent addChild: child]
        ifFalse: [parser performsLeftmostDerivation
                ifTrue: [grammarProd rightHandSide do:
                        [:sym |
                        child := sym isTerminal
                                    ifTrue: [DerivationTreeNode symbol: sym]
                                    ifFalse: [self popStack].
                        parent addChild: child]]
                ifFalse: [grammarProd rightHandSide
                        reverseDo:
                            [:sym |
                            child := sym isTerminal
                                        ifTrue: [DerivationTreeNode symbol: sym]
                                        ifFalse: [self popStack].
                            parent addFirstChild: child]]].
    self pushStack: parent! !

!DerivationTreeBuilder class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This concrete class is used for building derivation trees for a parse.  It uses homogeneous DerivationTreeNodes for all nodes and a specialized production processor.'! !

!DerivationTreeNode methodsFor: 'as yet unclassified' !
 
addChild: aNode

    self addLastChild: aNode!

addChildrenFirst: anOrderedCollection

    anOrderedCollection reverseDo: [:child | self addFirstChild: child]!
   
addChildrenInitial: anOrderedCollection

    self children: anOrderedCollection copy!
 
addChildrenLast: anOrderedCollection

    anOrderedCollection reverseDo: [:child | self addLastChild: child]!
 
addFirstChild: aNode

    self children addFirst: aNode!
  
addLastChild: aNode

    self children addLast: aNode!

children

    ^children!
  
children: argument

    children := argument!
 
childrenDo: aBlock

    self children do: aBlock!
 
init

    self children: OrderedCollection new!
   
isNonterminal

    ^self symbol isNonterminal!

isTerminal

    ^self symbol isTerminal!
  
printOn: aStream

    self printOn: aStream level: 0!
 
printOn: aStream dots: anInteger

    anInteger timesRepeat: [aStream nextPutAll: ' . ']!
 
printOn: aStream level: level

    self printOn: aStream dots: level.
    self symbol printOn: aStream.
    aStream cr.
    self childrenDo: [:child | child printOn: aStream level: level + 1]!
   
setAttribute: value

    self symbol: value!
  
symbol

    ^symbol!
  
symbol: argument

    symbol := argument!
 
updateChildrenUsing: aBlock
    "Replace my children according to the value of aBlock."

    self children: (self children collect: [:child | aBlock value: child])! !

!DerivationTreeNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent an arbitrary node in a derivation or abstract tree.  (It would be nice to expand this concept so that heterogeneous parse trees could be built.)

Instance Variables:
    symbol    <String> - node attribute.
    children    <OrderedCollection of: DerivationTreeNode>'!
  
symbol: aSymbol

    | newNode |
    newNode := self new init.
    newNode symbol: aSymbol.
    ^newNode! !

!DirectedGraph methodsFor: 'as yet unclassified' !
  
addEdgeFrom: node1 to: node2

    node2 addPredecessor: node1!

nodesDo: aBlock

    self do: aBlock! !

!DirectedGraph class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class represents a directed graph.'! !

!DirectedGraphNode methodsFor: 'as yet unclassified' !

addPredecessor: node

    self predecessors add: node!

init

    self predecessors: OrderedCollection new!
   
predecessors

    ^predecessors!
  
predecessors: argument

    predecessors := argument!
 
predecessorsDo: aBlock
    "Evaluate aBlock with each of my predecessors."

    self predecessors do: aBlock!

removePredecessor: node

    self predecessors remove: node ifAbsent: [self error: 'precedessor not found']!
  
removePredecessor: node ifAbsent: aBlock

    self predecessors remove: node ifAbsent: [^aBlock value]! !

!DirectedGraphNode class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I maintain a collection of my predecessor nodes.

Instance Variables:
    predecessors        <OrderedCollection of: DirectedGraphNode>'!
 
new

    ^super new init! !

!DirectiveNode methodsFor: 'as yet unclassified' !
 
asMessageSelector
    "My symbol is a string of the form '{selector}'.
    Trim the braces and answer the selector symbol."

    ^(self symbol copyFrom: 2 to: self symbol size - 1) asSymbol! !

!DirectiveNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I hold the token class directive.'! !

!DLGParser methodsFor: 'as yet unclassified' !
  
buildFSAFrom: typeRegExprDict

    ^self buildFSAFrom: typeRegExprDict and: #()!
  
buildFSAFrom: rules and: literals

    | startState |
    startState := FSAState new.
    rules do: [:rule | rule regExpr
            asFSAWithType: rule tokenClass
            andAction: rule directive
            startingAt: startState].
    literals do: [:lit | (self convertToRegExpr: lit)
            asFSAWithLiteral: (lit copyWithout: $\)
            startingAt: startState].
    ^startState asNearMinimalDFSAWithUniqueTokenClasses!
  
convertToRegExpr: aString

    | rules |
    self dlgScanner inputStream: (ReadStream on: '<x> = ' , aString , ' %%').
    self dlgScanner scanToken.
    rules := self parseRuleList.
    ^rules first regExpr!
  
dlgScanner

    ^dlgScanner!
  
dlgScanner: argument

    dlgScanner := argument!
 
doError: errorString
    "Does error handling for the parser. Currently writes to the transcript, should
    return to calling process."

    Transcript show: 'error in parser:'; space.
    Transcript show: errorString; cr.
    self errorBlock value!

errorBlock

    ^errorBlock!
  
errorBlock: argument

    errorBlock := argument!
 
execute
    "Parse the stream of tokens coming from the dlgScanner instance variable"

    | rules |
    self dlgScanner scanToken.
    [self dlgScanner nextTokenType = #action]
        whileTrue: [self dlgScanner scanToken].
    self dlgScanner nextTokenType = #delimiter ifFalse: [self doError: 'expected delimiter'].
    self dlgScanner scanToken.
    rules := self parseRuleList.
    self dlgScanner nextTokenType = #delimiter ifFalse: [self doError: 'expected delimiter'].
    self dlgScanner scanToken.
    [self dlgScanner nextTokenType = #action]
        whileTrue: [self dlgScanner scanToken].
    self dlgScanner nextTokenType = #atEnd ifFalse: [self doError: 'expected atEnd'].
    ^rules!
 
parse: inputString onError: returnBlock
    "Takes the input string, and creates a scanner to scan tokens from the string.
    Also set the errorBlock instance variable to returnBlock."

    dlgScanner := DLGScanner scan: inputString onError: returnBlock.
    self errorBlock: returnBlock!
  
parseAndExpression
    "This parses a series of expression, terminated by a pipe, an action, a close
    paren, a close curly brace, the next type or the end delimiter."

    | newNode returnNode |
    returnNode := self parseExpression.
    [#(type delimiter pipe action closeParen closeCurlyBrace ) includes: self dlgScanner nextTokenType]
        whileFalse:
            [newNode := self parseExpression.
            returnNode := ConcatenationNode children: (OrderedCollection with: returnNode with: newNode)].
    ^returnNode!
   
parseAtomList
    "Set up alternation tree over range of characters."

    | returnNode kids |
    returnNode := CharacterNode charSpec: self dlgScanner nextTokenValue.
    self dlgScanner scanToken.
    self dlgScanner nextTokenType = #minus
        ifTrue:
            [self dlgScanner scanToken.
            self dlgScanner nextTokenType = #atom ifFalse: [self doError: 'Expected atom'].
            kids := OrderedCollection with: returnNode.
            returnNode asciiValue + 1 to: self dlgScanner nextTokenValue first asciiValue do: [:ascii | kids add: (CharacterNode charSpec: (String with: (Character value: ascii)))].
            returnNode := AlternationNode children: kids.
            self dlgScanner scanToken].
    ^returnNode!
   
parseExpression
    "This invokes one of the four methods which can handle all expression
    occurrences. It returns a RegExpNode describing the expression that was read."

    self dlgScanner nextTokenType = #tilde
        ifTrue: [^self parseExpressionOne]
        ifFalse: [self dlgScanner nextTokenType = #openBracket
                ifTrue: [^self parseExpressionOne]
                ifFalse: [self dlgScanner nextTokenType = #openParen
                        ifTrue: [^self parseExpressionTwo]
                        ifFalse: [self dlgScanner nextTokenType = #openCurlyBrace
                                ifTrue: [^self parseExpressionThree]
                                ifFalse: [self dlgScanner nextTokenType = #atom
                                        ifTrue: [^self parseExpressionFour]
                                        ifFalse: [self doError: 'Expected valid expression']]]]]!

parseExpressionFour
    "parses all occurrences of the fourth expression, building a tree of Cat nodes."

    | headNode kids |
    headNode := CharacterNode charSpec: self dlgScanner nextTokenValue.
    self dlgScanner scanToken.
    self dlgScanner nextTokenType = #atom
        ifTrue:
            [kids := OrderedCollection with: headNode.
            [self dlgScanner nextTokenType = #atom]
                whileTrue:
                    [kids add: (CharacterNode charSpec: self dlgScanner nextTokenValue).
                    self dlgScanner scanToken].
            headNode := ConcatenationNode children: kids].
    ^headNode!
 
parseExpressionOne
    "parses occurrences of the first expression."

    | newNode returnNode negateFlag allChars subSet kids |
    self dlgScanner nextTokenType = #tilde
        ifTrue:
            [dlgScanner scanToken.
            negateFlag := True]
        ifFalse: [negateFlag := False].
    self dlgScanner scanToken.
    self dlgScanner nextTokenType = #atom ifFalse: [self doError: 'expected atom'].
    returnNode := self parseAtomList.
    [self dlgScanner nextTokenType = #atom]
        whileTrue:
            [newNode := self parseAtomList.
            returnNode := AlternationNode children: (OrderedCollection with: returnNode with: newNode)].
    self dlgScanner nextTokenType = #closeBracket ifFalse: [self doError: 'expected closeBracket'].
    negateFlag = True
        ifTrue:
            [allChars := ((32 to: 126)
                        collect: [:ea | Character value: ea]) asSet.
            subSet := Set new.
            returnNode collectNonemptyLeavesIn: subSet.
            allChars removeAll: subSet.
            kids := OrderedCollection new.
            allChars do: [:ch | kids add: (CharacterNode charSpec: (String with: ch))].
            returnNode := AlternationNode children: kids].
    self dlgScanner scanToken.
    self dlgScanner nextTokenType = #star
        ifTrue:
            [self dlgScanner scanToken.
            returnNode := StarClosureNode onlyChild: returnNode]
        ifFalse: [self dlgScanner nextTokenType = #plus
                ifTrue:
                    [self dlgScanner scanToken.
                    returnNode := ConcatenationNode children: (OrderedCollection with: returnNode with: (StarClosureNode onlyChild: returnNode))]].
    ^returnNode!
   
parseExpressionThree
    "Parses all occurrences of the third expression. The third expression is that curly
    braces enclose (and make optional) a regular expression, so we read the
    openCurlyBrace, read the regular expression inside, and then look
    for a repeat symbol. Because the contents of the curly braces are optional, we
    create an AltNode, with the contents and an Epsilon as the left and right
    children. If there is a repeat char we put the Alt under a closure."

    | returnNode |
    self dlgScanner scanToken.
    returnNode := self parseRegularExpression.
    returnNode := AlternationNode children: (OrderedCollection with: returnNode with: EpsilonNode new).
    self dlgScanner nextTokenType = #closeCurlyBrace ifFalse: [self doError: 'expected closeCurlyBrace'].
    self dlgScanner scanToken.
    self dlgScanner nextTokenType = #star
        ifTrue:
            [self dlgScanner scanToken.
            returnNode := StarClosureNode onlyChild: returnNode]
        ifFalse: [self dlgScanner nextTokenType = #plus
                ifTrue:
                    [self dlgScanner scanToken.
                    returnNode := ConcatenationNode children: (OrderedCollection with: returnNode with: (StarClosureNode onlyChild: returnNode))]].
    ^returnNode!
   
parseExpressionTwo
    "Parses all occurrences of the second expression. Parenthesis are used for
    precedence, so we read the openParen, read expressions until we see a
    closeParen, and then look for a repeat symbol."

    | returnNode |
    self dlgScanner scanToken.
    returnNode := self parseRegularExpression.
    self dlgScanner nextTokenType = #closeParen ifFalse: [self doError: 'expected closeParen'].
    self dlgScanner scanToken.
    self dlgScanner nextTokenType = #star
        ifTrue:
            [self dlgScanner scanToken.
            returnNode := StarClosureNode onlyChild: returnNode]
        ifFalse: [self dlgScanner nextTokenType = #plus
                ifTrue:
                    [self dlgScanner scanToken.
                    returnNode := ConcatenationNode children: (OrderedCollection with: returnNode with: (StarClosureNode onlyChild: returnNode))]].
    ^returnNode!
  
parseRegularExpression
    "This parses a regular expression, which is a collection of rules. We are looking
    for simple alternation, denoted by pipes (vertical bar). We read expressions until
    we see a close paren, close curly brace, an action, the next type or the end
    delimiter. As we read
    expressions, if we see a pipe we create an AltNode, with firstRule and
    secondRule as left and right children. Otherwise, we simply return firstRule."

    | returnNode secondExpression |
    returnNode := self parseAndExpression.
    [#(type delimiter action closeParen closeCurlyBrace ) includes: self dlgScanner nextTokenType]
        whileFalse:
            [self dlgScanner nextTokenType = #pipe ifFalse: [self doError: 'Expected pipe'].
            self dlgScanner scanToken.
            secondExpression := self parseAndExpression.
            returnNode := AlternationNode children: (OrderedCollection with: returnNode with: secondExpression)].
    ^returnNode!
 
parseRuleList
    "This invokes a method to parse one regular expression at a time, and then read
    the subsequent action."

    | newExpression rules type action |
    rules := OrderedCollection new.
    [self dlgScanner nextTokenType = #delimiter]
        whileFalse:
            [self dlgScanner nextTokenType = #type
                ifTrue: [type := self dlgScanner nextTokenValue]
                ifFalse: [self doError: 'expected type name'].
            self dlgScanner scanToken.
            self dlgScanner nextTokenType = #equal
                ifTrue: [self dlgScanner scanToken]
                ifFalse: [self doError: 'expected ='].
            newExpression := self parseRegularExpression.
            self dlgScanner nextTokenType = #action
                ifTrue:
                    [action := self dlgScanner nextTokenValue asSymbol.
                    self dlgScanner scanToken]
                ifFalse: [action := nil].
            rules add: (TokenSpecRuleNode
                    tokenClass: type
                    regExpr: newExpression
                    directive: action)].
    ^rules! !

!DLGParser class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This is a hand-coded token specification parser used solely to bootstrap the token specification translator and the grammar specification translator for T-gen (see class initialization methods in TokenSpecParser and GrammarSpecParser).  IT SHOULD NOT BE USED FOR ANY OTHER PURPOSE, as it may eventually be eliminated from the implementation.'!
  
example1
    "DLGParser example1"

    | temp |
    temp := self parse: '
        %%
        <1> = [a-cf-h]
        <2> = [p-s]*
        <3> = ~[a-zA-Z0-9]
        <4> = (abc)+
        <5> = {def | xyz}
        <6> = ghijklm
        %%' onError: [^nil].
    temp notNil ifTrue: [^temp execute]!
 
example2
"DLGParser example2"

    | parser dict fsa scanner |
    parser := self parse: '
        %%
        <1> = abc
        %%' onError: [^nil].
    parser notNil
        ifTrue:
            [dict := parser execute.
            fsa := parser buildFSAFrom: dict.
            scanner := self scanFrom: (Prompter prompt: 'type a test input string' default: 'abc')
                        fsa: fsa.
            self testScanner: scanner]!

example3
    "DLGParser example3"

    | parser dict fsa scanner |
    parser := self parse: '
        %%
        <1> = b{a}c
        %%' onError: [^nil].
    parser notNil
        ifTrue:
            [dict := parser execute.
            fsa := parser buildFSAFrom: dict.
            scanner := self scanFrom: (Prompter prompt: 'type a test input string' default: 'bacbcbac')
                        fsa: fsa.
            self testScanner: scanner]!
 
example4
    "DLGParser example4"

    | dict fsa scanner parser |
    parser := self parse: '
        %%
        <CAT> = cat
        <DOG> = dog
        <SPACE> = \         <<ignoreDelimiter>>
        %%' onError: [^nil].
    parser notNil
        ifTrue:
            [dict := parser execute.
            fsa := parser buildFSAFrom: dict and: #('hello' 'bye' ).
            scanner := self scanFrom: (Prompter prompt: 'type a test input string' default: 'hello cat dog cat bye')
                        fsa: fsa.
            self testScanner: scanner]!
   
example5
    "DLGParser example5"

    | dict fsa scanner parser |
    parser := self parse: '
        %%
        <ID> = [a-z]+
        <NUM> = [0-9]+
        <SPACE> = [\ ]+            <<ignoreDelimiter>>
        %%' onError: [^nil].
    parser notNil
        ifTrue:
            [dict := parser execute.
            fsa := parser buildFSAFrom: dict.
            scanner := self scanFrom: (Prompter prompt: 'type a test input string' default: 'here are some words and 45 digits')
                        fsa: fsa.
            self testScanner: scanner]!
  
example6
    "DLGParser example6"

    | dict fsa scanner parser |
    parser := self parse: '
        %%
        <ID> = [a-z]+
        <SPACE> = [\ ]+            <<ignoreDelimiter>>
        %%' onError: [^nil].
    parser notNil
        ifTrue:
            [dict := parser execute.
            fsa := parser buildFSAFrom: dict and: #('cat' 'dog' ).
            scanner := self scanFrom: (Prompter prompt: 'type a test input string' default: 'the cat ran away with the dog')
                        fsa: fsa.
            self testScanner: scanner]!
 
example7
    "DLGParser example7"

    | parser dict fsa scanner |
    parser := self parse: '
        %%
        <short> = abc
        <long> = aabc
        <space> = [\ ]+        <<ignoreDelimiter>>
        %%' onError: [^nil].
    parser notNil
        ifTrue:
            [dict := parser execute.
            fsa := parser buildFSAFrom: dict.
            scanner := self scanFrom: (Prompter prompt: 'type a test input string' default: 'abc aabc')
                        fsa: fsa.
            self testScanner: scanner]!

example8
    "DLGParser example8"

    | dict fsa scanner parser |
    parser := self parse: '
        %%
        <word> = [a-z]+
        <id> = [a-z][a-z0-9]*
        <space> = [\ ]+        <<ignoreDelimiter>>
        %%' onError: [^nil].
    parser notNil
        ifTrue:
            [dict := parser execute.
            fsa := parser buildFSAFrom: dict and: #('cat' 'dog' ).
            scanner := self scanFrom: (Prompter prompt: 'type a test input string' default: 'the cat ra9n aw77ay with2 the dog')
                        fsa: fsa.
            self testScanner: scanner]!

parse: inputString onError: returnBlock
    "Answer an instance of the receiver with inputString initialized from the argument"

    ^self new parse: inputString onError: returnBlock!
  
scanFrom: aString fsa: fsa
    "Create a temporary demo scanner for an example."

    | newScanner |
    newScanner := FSABasedScanner new fsa: fsa.
    newScanner scanSource: aString.
    ^newScanner!
 
testScanner: scanner

    Transcript cr; show: '**** begin scanner test ****'.
    [scanner atEnd]
        whileFalse:
            [scanner scanToken.
            Transcript
                 cr;
                 show: scanner token;
                 show: ' : ';
                 show: scanner tokenType].
    Transcript
         cr;
         show: '**** end scanner test ****';
         cr! !

!DLGScanner methodsFor: 'as yet unclassified' !
  
advance
    "Answer the next character in the stream."

    inputStream atEnd
        ifTrue: [^#atEnd]
        ifFalse: [^inputStream next]!
  
atEnd
    "Answer if the scanner has reached the end of the source."

    ^self inputStream atEnd!
   
driver
    "This runs the LexScanner on the previously initialized inputStream. Output is to
    the Transcript."

    Transcript
         printString;
         cr;
         cr.
    self scanToken.
    [self atEnd = true]
        whileFalse:
            [tokenValue := self nextTokenValue.
            Transcript show: tokenValue printString; space.
            tokenType := self nextTokenType.
            Transcript show: tokenType printString; cr.
            self scanToken].
    tokenValue := self nextTokenValue.
    Transcript show: tokenValue printString; space.
    tokenType := self nextTokenType.
    Transcript show: tokenType printString; cr!
  
errorBlock

    ^errorBlock!
  
errorBlock: argument

    errorBlock := argument!
 
inputStream

    ^inputStream!

inputStream: argument

    inputStream := argument!
   
mark

    self notYetImplemented!
 
nextTokenType
    "Answer the type of the current token."

    ^self tokenType!
  
nextTokenValue
    "Answer the value of the current token."

    ^self tokenValue contents!
  
parseAction
    "This method is called when the scanner detects the start of an action (by
    reading '<<'). The method reads through the action until it finds a '>>'. The
    method puts the action (minus the < and >) into tokenValue."

    | readChar |
    readChar := self advance.
    self tokenType: nil.
    [self tokenType isNil]
        whileTrue:
            [readChar := self advance.
            readChar = #atEnd
                ifTrue:
                    [self tokenType: #error.
                    ^nil].
            readChar = $>
                ifTrue:
                    [readChar := self advance.
                    readChar = $> ifTrue: [self tokenType: #action]]
                ifFalse: [self tokenValue nextPut: readChar]]!
   
parseTypeName
    "This method is called when the scanner detects the start of a token type name
    (by reading '<'). The method reads through the action until it finds a '>'. The
    method puts the token type (plus the < and >) into tokenValue."

    | readChar |
    self tokenValue nextPut: $<.
    self tokenType: nil.
    [self tokenType isNil]
        whileTrue:
            [readChar := self advance.
            readChar = #atEnd
                ifTrue:
                    [self tokenType: #error.
                    ^nil].
            readChar = $>
                ifTrue:
                    [self tokenValue nextPut: readChar.
                    self tokenType: #type]
                ifFalse: [self tokenValue nextPut: readChar]]!
  
position
    "Answer the position of the source stream."

    ^self inputStream position!

reset
    "Move back to the start of the source."

    inputStream reset!

scan: inputString onError: aBlock
    "Takes the input string, converts it to a stream, and puts the stream in instance
    data. Also declares initial space for tokenValue. The argument aBlock is stored
    as an instance variable, and if an error is encountered the block is evaluated."

    inputStream := ReadStream on: inputString.
    tokenValue := WriteStream on: (String new: 50).
    self errorBlock: aBlock!

scanToken
    "Scan the next token, and place the resulting type in instance variable
    tokenType. If the token is an action or an atom, place the token value in
    tokenValue."

    | readChar |
    self tokenValue reset.
    self skipSeparators.
    readChar := self advance.
    readChar = #atEnd
        ifTrue: [self tokenType: #atEnd]
        ifFalse: [readChar = $<
                ifTrue: [inputStream peek = $<
                        ifTrue: [self parseAction]
                        ifFalse: [self parseTypeName]]
                ifFalse: [readChar = $\
                        ifTrue:
                            [readChar := self advance.
                            self tokenType: (MetaCharDictionary at: readChar ifAbsent: [#error]).
                            self tokenType = #error
                                ifFalse:
                                    [self tokenValue nextPut: readChar.
                                    self tokenType: #atom]
                                ifTrue: [self tokenValue nextPutAll: 'bad char']]
                        ifFalse: [readChar = $%
                                ifTrue: [inputStream peek = $%
                                        ifTrue:
                                            [self tokenType: #delimiter.
                                            inputStream next.
                                            self tokenValue nextPut: $%.
                                            self tokenValue nextPut: $%]]
                                ifFalse:
                                    [self tokenType: (MetaCharDictionary at: readChar ifAbsent: [AtomDictionary at: readChar ifAbsent: [#error]]).
                                    self tokenType = #error ifFalse: [self tokenValue nextPut: readChar]]]]].
    "Transcript show: self nextTokenValue printString; space.
    Transcript show: tokenType printString; cr."
    ^self!

skipSeparators
    "Skip over separators in the inputStream"

    self inputStream skipSeparators!
   
tokenType

    ^tokenType!

tokenType: argument

    tokenType := argument!
   
tokenValue

    ^tokenValue!
  
tokenValue: argument

    tokenValue := argument! !

!DLGScanner class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This is a hand-coded token specification scanner used solely to bootstrap the token specification translator and the grammar specification translator for T-gen (see class initialization methods in TokenSpecParser and GrammarSpecParser).  IT SHOULD NOT BE USED FOR ANY OTHER PURPOSE, as it may eventually be eliminated from the implementation.'!
 
initialize
    "Set up the dictionary of characters and tokens."
    "DLGScanner initialize."

    | chars |
    MetaCharDictionary := Dictionary new.
    AtomDictionary := Dictionary new.
    MetaCharDictionary at: Character tab put: #tab.
    MetaCharDictionary at: Character cr put: #cr.
    MetaCharDictionary at: Character space put: #space.
    MetaCharDictionary at: $( put: #openParen.
    MetaCharDictionary at: $) put: #closeParen.
    MetaCharDictionary at: $* put: #star.
    MetaCharDictionary at: $+ put: #plus.
    MetaCharDictionary at: $- put: #minus.
    MetaCharDictionary at: $< put: #openAngle.
    MetaCharDictionary at: $= put: #equal.
    MetaCharDictionary at: $> put: #closeAngle.
    MetaCharDictionary at: $[ put: #openBracket.
    MetaCharDictionary at: $\ put: #backslash.
    MetaCharDictionary at: $] put: #closeBracket.
    MetaCharDictionary at: ${ put: #openCurlyBrace.
    MetaCharDictionary at: $| put: #pipe.
    MetaCharDictionary at: $} put: #closeCurlyBrace.
    MetaCharDictionary at: $~ put: #tilde.
    chars := (33 to: 126)
                collect: [:ea | Character value: ea].
    chars do: [:element | AtomDictionary at: element put: #atom]!
 
scan: inputString onError: returnBlock
    "Answer an instance of the receiver with inputString initialized from the argument"

    ^self new scan: inputString onError: returnBlock! !

!EdgeLabeledDigraphNode methodsFor: 'as yet unclassified' !
   
addSuccessor: node withEdgeLabeled: label

    self edgeLabelMap at: label add: node!
 
edgeLabelMap

    ^edgeLabelMap!
  
edgeLabelMap: argument

    edgeLabelMap := argument!
 
init

    self edgeLabelMap: SetDictionary new!
   
printOn: aStream

    self hash printOn: aStream.
    aStream nextPutAll: ': '; crtab.
    self edgeLabelMap
        associationsDo:
            [:assoc |
            assoc key printOn: aStream.
            aStream nextPutAll: ' ==> '.
            assoc value hash printOn: aStream.
            aStream crtab]!

spaceOptimizeMap
    "Assumes self edgeLabelMap isDeterministic.
    Note: doing this will dissable the messages #successors,
    #addSuccessor:withEdgeLabeled:, and any senders of them,
    since they assume a SetDictionary."

    self edgeLabelMap: self edgeLabelMap asDictionary!

successors

    ^self edgeLabelMap elements!
  
successorsDo: aBlock

    self successors do: aBlock!
 
successorsExceptSelfDo: aBlock

    (self successors reject: [:succ | succ = self])
        do: aBlock! !

!EdgeLabeledDigraphNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent a node in an edge-labeled digraph.

Instance Variables:

    edgeLabelMap        <SetDictionary from: labels to: successors>'!
   
new

    ^super new init! !

!EnnaryRegExprNode methodsFor: 'as yet unclassified' !
 
addChildrenFirst: anOrderedCollection

    self children addAllFirst: anOrderedCollection!

addChildrenInitial: anOrderedCollection

    self children addAll: anOrderedCollection!
   
asPureRegExpr
    "Answer a new version of the receiver consisting of only characters,
    concatenations, alternations, and (star) closures. Also, eliminate single
    child alternations and concatenations."

    | newKids |
    self children size = 1 ifTrue: [^self children first asPureRegExpr].
    newKids := OrderedChildren new.
    self childrenDo: [:child | newKids add: child asPureRegExpr].
    ^self species children: newKids!
  
children

    ^children!
  
children: argument

    children := argument!
 
childrenDo: aBlock
    "Evaluate aBlock for each of my children."

    self children do: aBlock!
 
init

    self children: OrderedCollection new!
   
updateChildrenUsing: aBlock
    "Replace my children according to the value of aBlock."

    self children: (self children collect: aBlock)! !

!EnnaryRegExprNode class methodsFor: 'as yet unclassified' !
   
children: arg1

    | newMe |
    newMe := self new.
    newMe children: arg1.
    ^newMe!
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent an n-ary regular expression.'!
   
new

    ^super new init! !

!EpsilonNode methodsFor: 'as yet unclassified' !
   
asFSAStartingAt: startState endingAt: finalState

    startState goto: finalState on: self epsilon!
   
collectSymbol

    ^OrderedCollection new!

hasBeenTransformed
    ^true!
  
isEpsilonNode

    ^true!
 
needTransforming
    ^false!
   
printOn: aStream

    aStream nextPutAll: '<epsilon>'!

processTransformation: prod with: lhsNames

    ^OrderedCollection new! !

!EpsilonNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent the empty regular expression.'!
  
epsilon
    "Answer an object used to represent the empty string."

    ^Character endOfInput! !

!EscapedCharNode methodsFor: 'as yet unclassified' !
 
myChar
    "Answer the Character represented by the receiver.
    The spec is of the form '\c' where some c's are special (see class comment)."

    | spec char |
    spec := self charSpec.
    (spec size = 2 and: [spec first = $\])
        ifTrue:
            [char := spec last.
            ^self specialChars at: char ifAbsent: [char]]
        ifFalse: [self error: 'Escaped character specifications must be of the form ''\c''.']!
 
specialChars

    ^SpecialCharMap! !

!EscapedCharNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a atomic character of a regular expression.  I am specified by a String of the form ''\c'' where each c is some character.  Normally, the character I represent is just c, however, some specifications have special meanings (see comment in class initialization method).'!
   
initialize
    "The following characters are special:

    spec    ascii    character
    ----    ----    --------
    \0        0        null
    \b        8        backspace
    \t        9        horizontal tab
    \n        10        linefeed (UNIX newline \n)
    \f        12        form feed
    \r        13        carriage return (Smalltalk cr)
    \e        27        escape
    \s        32        space
    \d        127    delete"
    "EscapedCharNode initialize"

    | dict |
    dict := Dictionary new.
    dict
         at: $0 put: (Character value: 0);
         at: $b put: (Character value: 8);
         at: $t put: (Character value: 9);
         at: $n put: (Character value: 10);
         at: $f put: (Character value: 12);
         at: $r put: (Character value: 13);
         at: $e put: (Character value: 27);
         at: $s put: (Character value: 32);
         at: $d put: (Character value: 127).
    SpecialCharMap := dict! !

!FirstFollowGraph methodsFor: 'as yet unclassified' !

addTerminal: term toNodeLabeled: label

    (self detect: [:node | node label = label])
        addTerminal: term!
   
nodeSetMap
    "Answer a map from node names (nonterminals) to sets of terminals, representing
    either the first or follow sets."

    | map |
    map := SetDictionary new.
    self nodesDo: [:node | map add: node asAssociation].
    ^map!
   
propagateSetUnions
    "For each of my nodes, replace its node set with the union of its old node set
    and the node sets along all incoming edges. Repeat until no more changes."

    | changes |
    changes := true.
    [changes]
        whileTrue: [changes := self inject: false into: [:chngs :node | chngs | node unionWithPredecessorsChangesMe]]! !

!FirstFollowGraph class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a graph consisting of FstFllwGraphNodes used in the computation of first and follow sets.  I serve as the public interface to my nodes.'!
   
preferredNodeClass

    ^FstFllwGraphNode! !

!FSABasedScanner methodsFor: 'as yet unclassified' !
  
at: state tokenTypeAndActionFor: tok

    ^state tokenTypeAndActionFor: tok!
  
at: state transitionFor: char

    ^state transitionFor: char!

classInitializationMethodTextForClassNamed: name spec: tokenSpec

    ^self subclassResponsibility!
   
compactDoubleApostrophes
    "Compact all two apostrophe sequences in my current token into a single
    apostrophe."

    | readStream writeStream ch nextCh |
    readStream := ReadStream on: self token.
    writeStream := WriteStream on: (String new: 20).
    [readStream atEnd]
        whileFalse:
            [writeStream nextPut: (ch := readStream next).
            (ch = $' and: [(nextCh := readStream peek) notNil and: [nextCh = $']])
                ifTrue: [readStream skip: 1]].
    self token: writeStream contents!
 
createScannerClassNamed: name category: category spec: tokenSpec

    | scannerClass |
    scannerClass := self defaultScannerClass
                subclass: name asSymbol
                instanceVariableNames: ''
                classVariableNames: ''
                poolDictionaries: ''.
    scannerClass class compileMethod: (self classInitializationMethodTextForClassNamed: name spec: tokenSpec).
    scannerClass initialize.
    ^scannerClass!
 
defaultOptimizedScannerClass

    ^OptimizedScanner!
  
defaultScannerClass

    ^self class!
 
endOfInputToken
"Answer a token representing the end of the input."

    ^Character endOfInput!
  
endOfInputTokenType
    "Answer the token type representing the end of the input."

    ^self endOfInputToken!
   
fastScanner

    ^self defaultOptimizedScannerClass buildFrom: self!
  
fsa

    ^fsa!

fsa: argument

    fsa := argument!
   
ignoreComment

    self scanToken.
    !
 
ignoreDelimiter

    self scanToken!
  
init

    super init.
    self fsa: self myFsa!
  
myFsa

    ^self class fsa!
   
scanToken
"Scan the next token and compute its token type."

    | state nextState tok typeAction |
    self atEnd
        ifTrue: [self signalEndOfInput]
        ifFalse:
            [state := self startState.
            [(nextState := self at: state transitionFor: self nextChar) isNil]
                whileFalse:
                    [state := nextState.
                    self getNextChar].
            tok := self buffer contents.
            typeAction := self at: state tokenTypeAndActionFor: tok.
            self tokenType: typeAction type.
            self token: tok.
            self buffer reset.
            typeAction action notNil ifTrue: [self perform: typeAction action]]!
  
startState

    ^self fsa! !

!FSABasedScanner class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class of scanner that scans a source string and breaks it up into tokens using a minimal deterministic finite-state automata (FSA).  Each token is also given a type by its associated final state in the FSA.  Specific FSAs are stored in class instance variables of my concrete subclasses.

Instance Variables:
    fsa                <FSAState> - a local reference to the token recognizer, in minimal deterministic form, for this class of scanner.
'!

fsa

    ^fsa!

fsa: argument

    fsa := argument!
   
initialize
    "Concrete subclasses must somehow provide a fsa. Subclasses created by
    automatic means may simply 'plug-in' a dynamically computed fsa. However, if a
    class that can be filed-out is desired then it is worthwhile to override this
    initialization method with one that can build the appropriate fsa directly."
    "FSABasedScanner initialize"

    self fsa: nil! !

!FSABasedScannerWithOneTokenLookahead methodsFor: 'as yet unclassified' !
  
defaultOptimizedScannerClass

    ^OptimizedScannerWithOneTokenLookahead!
 
errorPosition
    "Answer the source position of the last acceptable character."

    ^self savePosition max: 1!
 
savePosition

    ^savePosition!
  
savePosition: argument

    savePosition := argument!
 
scanToken
    "Scan the next token and compute its token type."

    | nextState tok typeAction stateStack saveChar saveState |
    stateStack := Stack new.
    self atEnd
        ifTrue: [self signalEndOfInput]
        ifFalse:
            [stateStack push: self startState.
            [(nextState := stateStack top transitionFor: self nextChar ifNone: [nil]) isNil]
                whileFalse:
                    [stateStack push: nextState.
                    self getNextChar].
            stateStack top isFSAFinalState
                ifFalse:
                    ["save the current position for error notification"
                    saveChar := self nextChar.
                    saveState := stateStack top.
                    self savePosition: self position + (self atEnd
                                ifTrue: [1]
                                ifFalse: [0]).
                    "backup to the previous final state or to the start state"
                    [stateStack size = 1 or: [stateStack top isFSAFinalState]]
                        whileFalse:
                            [stateStack pop.
                            self putBackChar].
                    stateStack size = 1 ifTrue:
                        ["backed up to the start state so signal an error"
                        saveState transitionFor: saveChar]].
            "answer the newly scanned token"
            tok := self buffer contents.
            typeAction := stateStack top tokenTypeAndActionFor: tok.
            self tokenType: typeAction type.
            self token: tok.
            self buffer reset.
            typeAction action notNil ifTrue: [self perform: typeAction action]]! !

!FSABasedScannerWithOneTokenLookahead class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class needs a comment.'! !

!FSABasedScannerWithTwoTokenLookahead methodsFor: 'as yet unclassified' !
 
checkForTokenIn: newStateStack buffer: charBuffer
    "Scan the input using the arguments. Answer true if a legal token (or no illegal token) was
    found and false otherwise."

    | nextState |
    self atEnd
        ifFalse:
            [newStateStack push: self startState.
            "look for longest possible token"
            [(nextState := newStateStack top transitionFor: self nextChar ifNone: [nil]) isNil]
                whileFalse:
                    [newStateStack push: nextState.
                    "getNextChar for local vars"
                    charBuffer nextPut: self nextChar.
                    self nextChar: self source next].
            newStateStack top isFSAFinalState
                ifFalse:
                    ["save the current position for error notification"
                    self saveChar: self nextChar.
                    self saveState: newStateStack top.
                    self savePosition: self position + (self atEnd
                                ifTrue: [1]
                                ifFalse: [0]).
                    "backup to the previous final state or to the start state"
                    [newStateStack size = 1 or: [newStateStack top isFSAFinalState]]
                        whileFalse:
                            [newStateStack pop.
                            "putBackChar for local vars"
                            charBuffer backspace.
                            self backspaceSource].
                    newStateStack size = 1 ifTrue:
                        ["backed up to the start state"
                        self stateStack == newStateStack
                            ifTrue:
                                ["this is the first token, so signal an error (abort and return)"
                                self saveState transitionFor: self saveChar]
                            ifFalse:
                                ["we may be able to backup in the previous token"
                                ^false]]]].
    ^true!
  
defaultOptimizedScannerClass

    ^OptimizedScannerWithTwoTokenLookahead!
 
errorPosition
    "Answer the source position of the last acceptable character."

    ^self savePosition max: 1!
 
reset
    "Reset the initial state of the scanner before scanning a new source."

    super reset.
    self stateStack: Stack new.
    self savePosition: 0!
   
saveChar

    ^saveChar!
  
saveChar: argument

    saveChar := argument!
 
savePosition

    ^savePosition!
  
savePosition: argument

    savePosition := argument!
 
saveState

    ^saveState!

saveState: argument

    saveState := argument!
   
scanSource: aString
    "Convert the input string to a read stream and scan the first token."

    self reset.
    self source: (RetractableReadStream on: aString).
    self nextChar: self source next.
    self checkForTokenIn: self stateStack buffer: self buffer.
    self scanToken!
 
scanToken
    "Scan the next token and compute its token type."

    | tok typeAction newStateStack charBuffer |
    newStateStack := Stack new.
    charBuffer := RetractableWriteStream on: (String new: 32).
    (self checkForTokenIn: newStateStack buffer: charBuffer)
        ifTrue:
            ["either a legal token or the end on input was found"
            self stateStack isEmpty ifTrue: [self atEnd
                    ifTrue: [^self signalEndOfInput]
                    ifFalse: [self error: 'no more vaild tokens']].
            tok := self buffer contents.
            typeAction := self stateStack top tokenTypeAndActionFor: tok.
            self tokenType: typeAction type.
            self token: tok.
            self buffer: charBuffer.
            self stateStack: newStateStack.
            typeAction action notNil ifTrue: [self perform: typeAction action]]
        ifFalse:
            ["an illegal token was found, try to look for earlier final state in current token buffers"
            charBuffer size timesRepeat:
                ["put back illegal token chars"
                self backspaceSource].
            "backup in current token to next smallest legal token"
            [self stateStack size = 1
                or:
                    [self stateStack pop.
                    self putBackChar.
                    self stateStack top isFSAFinalState]] whileFalse.
            self stateStack size = 1
                ifTrue:
                    ["no smaller legal token so signal error"
                    self saveState transitionFor: self saveChar]
                ifFalse:
                    ["try again"
                    self scanToken]]!
   
stateStack

    ^stateStack!
  
stateStack: argument

    stateStack := argument! !

!FSABasedScannerWithTwoTokenLookahead class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class needs a comment.'! !

!FSAFinalState methodsFor: 'as yet unclassified' !

addLiteralToken: literal

    self literalTokens add: literal!

addTokenClass: tokenClass
    "Don't add the same tokenClass twice."

    self tokenClasses detect: [:tc | tc tokenType = tokenClass tokenType]
        ifNone: [self tokenClasses size ~~ 0
                ifTrue: [self error: 'Current implementation only handles non-overlapping token classes.']
                ifFalse: [self tokenClasses add: tokenClass]]!

init

    super init.
    self literalTokens: Set new.
    self tokenClasses: OrderedCollection new!

isFSAFinalState

    ^true!
   
literalTokens

    ^literalTokens!

literalTokens: argument

    literalTokens := argument!
   
tokenClasses

    ^tokenClasses!
  
tokenClasses: argument

    tokenClasses := argument!
 
tokenTypeAndActionFor: aString
    "The current implementation does not handle overlapping token classes. Hence, a final state
    can only represent a literal or a single token class. Therefore, if not a literal then it must be
    the token class."

    | tc |
    ((self literalTokens includes: aString)
        or: [aString size = 0])
        ifTrue: [^self typeActionHolderClass type: aString action: nil].
    tc := self tokenClasses first.
    ^self typeActionHolderClass type: tc tokenType action: tc action!
  
transitionFor: aSymbol
    "The default for final states is to not raise an exception
    if no transitions are possible, rather, they answer nil."

    ^self transitionFor: aSymbol ifNone: [nil]!

typeActionHolderClass

    ^TokenTypeActionHolder! !

!FSAFinalState class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a final state of a finite state automata.  If I''m part of a minimal deterministic fsa then it is possible that I represent several final states of some original non-deterministic fsa.  My instance variables are used to distinguish between these various different final states.  Final states for literal tokens (keywords) are represented by name in literalTokens.  Final states for larger token classes are represented by TokenClassifications.  When a token is recognized by this final state, it is first checked against the list of literal tokens.  If not found, it is then classified as belonging to the one token class of which it is a member.  The current implementation does not support overlapping token classes, hence, there can only really be one element in the OrderedCollection.  However, in the future we hope to be able to support overlapping token classes.

Instance Variables:
    literalTokens        <Set of: String> - the literal tokens I recognize.
    tokenClasses     <OrderedCollection of: TokenClassification> - the token classes I recognize.'! !

!FSAState methodsFor: 'as yet unclassified' !
   
asDeterministicFSA
    "Answer a new deterministic version of myself.

    Based on Algorithm 3.1 from 'Principles of Compiler Design',
    by Aho and Ullman, 1977."

    | multiStateMap unprocessedStates newStartState currState ch transitStates multiState epsilonClosures newMultiState newState |
    epsilonClosures := self computeEpsilonClosures.
    multiStateMap := Dictionary new.
    unprocessedStates := Set new.
    newStartState := self newDFSAStateFor: (epsilonClosures at: self).
    multiStateMap at: (epsilonClosures at: self)
        put: newStartState.
    unprocessedStates add: newStartState.
    [unprocessedStates isEmpty]
        whileFalse:
            [currState := unprocessedStates removeFirst.
            multiState := multiStateMap keyAtValue: currState.
            (self computeTransitionMapFor: multiState)
                associationsDo:
                    [:assoc |
                    ch := assoc key.
                    transitStates := assoc value.
                    newMultiState := self stateSetClass new.
                    transitStates do: [:ts | newMultiState addAll: (epsilonClosures at: ts)].
                    (multiStateMap includesKey: newMultiState)
                        ifTrue:
                            ["previously encountered state"
                            newState := multiStateMap at: newMultiState]
                        ifFalse:
                            ["make a new state"
                            newState := self newDFSAStateFor: newMultiState.
                            multiStateMap at: newMultiState put: newState.
                            unprocessedStates add: newState].
                    currState goto: newState on: ch]].
    ^newStartState spaceOptimize!

asMinimalDFSA
    "Answer a new minimal deterministic version of myself.

    Based on Algorithm 3.3 from 'Principles of Compiler Design',
    by Aho and Ullman, 1977."

    | dfsa states statePartitionMap oldPartition newPartition |
    dfsa := self asDeterministicFSA.
    states := dfsa states.
    newPartition := self computeInitialPartitionFor: states.
    oldPartition := Set new.
    [newPartition size = oldPartition size]
        whileFalse:
            [oldPartition := newPartition.
            statePartitionMap := self computeStatePartitionMapFor: states using: oldPartition.
            self computePartitionTransitionsFor: states using: statePartitionMap.
            newPartition := self computeNewPartitionFor: oldPartition using: statePartitionMap].
    ^self
        computeNewDFSAFor: oldPartition
        using: statePartitionMap
        startState: dfsa!
   
asNearMinimalDFSAWithUniqueTokenClasses
    "Answer a new almost minimal deterministic version of myself. The result is not always
    minimal due to the extra constraint that final state partitions containing final states for two
    different token classes must be split. This allows the DFSA to properly handle overlapping
    token classes.

    Based on Algorithm 3.3 from 'Principles of Compiler Design',
    by Aho and Ullman, 1977."

    | dfsa states statePartitionMap oldPartition newPartition |
    dfsa := self asDeterministicFSA.
    states := dfsa states.
    newPartition := self computeNearMinimalInitialPartitionFor: states.
    oldPartition := Set new.
    [newPartition size = oldPartition size]
        whileFalse:
            [oldPartition := newPartition.
            statePartitionMap := self computeStatePartitionMapFor: states using: oldPartition.
            self computePartitionTransitionsFor: states using: statePartitionMap.
            newPartition := self computeNewPartitionFor: oldPartition using: statePartitionMap].
    ^self
        computeNewDFSAFor: oldPartition
        using: statePartitionMap
        startState: dfsa!
 
collectStatesIn: stateSet
    "Add myself and all states reachable from me to stateSet.
    If I'm the start state of an fsa then all my states are added."

    (stateSet includes: self)
        ifFalse:
            [stateSet add: self.
            self successorsExceptSelfDo: [:succ | succ collectStatesIn: stateSet]]!
 
computeEpsilonClosureOf: stateSet
    "Answer the set of states that can be reached from those in stateSet by epsilon
    transitions alone."

    (stateSet includes: self)
        ifFalse:
            [stateSet add: self.
            (self edgeLabelMap at: self epsilon ifAbsent: [^self])
                do: [:state | state computeEpsilonClosureOf: stateSet]]!
  
computeEpsilonClosures
    "Answer a Dictionary from states to their corresponding closures."

    | closures |
    closures := Dictionary new.
    self states do: [:state | closures at: state put: state epsilonClosure].
    ^closures!
   
computeInitialPartitionFor: states
    "Partition states into final and nonfinal states."

    | finalStates nonFinalStates |
    finalStates := states select: [:state | state isFSAFinalState].
    nonFinalStates := states reject: [:state | state isFSAFinalState].
    ^nonFinalStates isEmpty
        ifTrue: [Set with: finalStates]
        ifFalse: [Set with: nonFinalStates with: finalStates]!
 
computeNearMinimalInitialPartitionFor: states
    "Partition states into nonfinal, literal final, and common token class final state partitions."

    | finalStates nonFinalStates partition tokenClasses literalTokens tc |
    finalStates := states select: [:state | state isFSAFinalState].
    nonFinalStates := states reject: [:state | state isFSAFinalState].
    partition := nonFinalStates isEmpty
                ifTrue: [Set new]
                ifFalse: [Set with: nonFinalStates].
    tokenClasses := SetDictionary new.
    literalTokens := Set new.
    finalStates do:
        [:finalState |
        (tc := finalState tokenClasses) size > 1 ifTrue: [self error: 'multiple token class states are not currently supported'].
        tc size = 0
            ifTrue: [literalTokens add: finalState]
            ifFalse: [tokenClasses at: tc first tokenType add: finalState]].
    partition add: literalTokens.
    partition addAll: tokenClasses.
    ^partition!
 
computeNewDFSAFor: partition using: statePartitionMap startState: startState
    "Answer a new dfsa whose states represent partitions and whose transitions are
    computed from the statePartitionMap. The state for the partition containing
    startState is the new start state."

    | newStateMap partitionRepresentativeState newState ch st newStartState |
    newStateMap := IdentityDictionary new.
    partition do: [:part | newStateMap at: part put: (self newDFSAStateFor: part)].
    partition do:
        [:part |
        partitionRepresentativeState := part first.
        newState := newStateMap at: part.
        (statePartitionMap at: partitionRepresentativeState) transitionMap
            associationsDo:
                [:assoc |
                ch := assoc key.
                st := newStateMap at: assoc value.
                newState goto: st on: ch]].
    newStartState := newStateMap at: (statePartitionMap at: startState) partition.
    ^newStartState spaceOptimize!
 
computeNewPartitionFor: oldPartition using: statePartitionMap
    "Answer a new state partition that is a refinement of oldPartition based on
    partition transitions. An old partition is split into partitions of states with
    equivalent partition transition maps."

    | newPartition partCopy initialState newPart |
    newPartition := Set new.
    oldPartition do:
        [:part |
        partCopy := part copy.
        [partCopy isEmpty]
            whileFalse:
                [initialState := partCopy removeFirst.
                newPart := self stateSetClass with: initialState.
                partCopy copy do: [:state | ((statePartitionMap at: initialState)
                        hasSameTransitionMapAs: (statePartitionMap at: state))
                        ifTrue:
                            [partCopy remove: state.
                            newPart add: state]].
                newPartition add: newPart]].
    ^newPartition!
  
computePartitionTransitionsFor: states using: statePartitionMap
    "For each state in states compute its partition-based transition map,
    i.e. a transition map from characters to partitions."

    | char targetPartition |
    states do: [:state | state edgeLabelMap
            associationsDo:
                [:assoc |
                char := assoc key.
                targetPartition := (statePartitionMap at: (state transitionFor: char)) partition.
                (statePartitionMap at: state)
                    goto: targetPartition on: char]]!
 
computeStatePartitionMapFor: states using: partition
    "Answer a Dictionary mapping each state to an object containing its
    corresponding partition and a partition-based transition map for the state."

    | statePartitionMap |
    statePartitionMap := Dictionary new.
    states do: [:state | statePartitionMap at: state put: (self partitionTransitionMapClass forPartition: (partition detect: [:par | par includes: state]))].
    ^statePartitionMap!
  
computeTransitionMapFor: multiState
    "Answer a transition map (minus any epsilon transitons) for multiState,
    a collection of states."

    | newMap |
    newMap := SetDictionary new.
    multiState do: [:state | state copyTransitionsTo: newMap].
    newMap removeKey: self epsilon ifAbsent: [].
    ^newMap!
  
copyTransitionsTo: transitionMap

    self edgeLabelMap associationsDo: [:assoc | transitionMap at: assoc key addAll: assoc value]!
   
dfsaFinalStateClass

    ^FSAFinalState!
  
dfsaStateClass

    ^FSAState!

endOfInputErrorString

    ^'end of input encountered'!
   
endOfInputToken
    "Answer a token representing the end of the input."

    ^Character endOfInput!
  
epsilon
    "Answer an object used to represent the empty string (epsilon)."

    ^EpsilonNode epsilon!
  
epsilonClosure
    "Answer the set of states that can be reached from me by epsilon transitions
    alone."

    | states |
    states := self stateSetClass new.
    self computeEpsilonClosureOf: states.
    ^states!
 
goto: aState on: transitionSymbol

    self addSuccessor: aState withEdgeLabeled: transitionSymbol!
   
hasStateID

    ^self stateID notNil!
 
newDFSAStateFor: multiState
    "Answer a new dfsa state that will represent the argument, a collection of states.
    Make sure to transfer any final state information to the new state."

    | newFinalState finalStates |
    (finalStates := multiState select: [:state | state isFSAFinalState]) isEmpty
        ifTrue: [^self dfsaStateClass new]
        ifFalse:
            [newFinalState := self dfsaFinalStateClass new.
            finalStates do:
                [:fs |
                fs literalTokens do: [:lit | newFinalState addLiteralToken: lit].
                fs tokenClasses do: [:tc | newFinalState addTokenClass: tc]].
            ^newFinalState]!

nilOutStateIDs
    "Set my stateID to nil, likewise with all my successors."

    self stateID notNil
        ifTrue:
            [self stateID: nil.
            self successorsDo: [:succ | succ nilOutStateIDs]]!
  
partitionTransitionMapClass

    ^PartitionTransitionMap!
 
raiseNoTransitionExceptionErrorString: aString

    ScannerTransitionError signalWith: aString!
   
spaceOptimize

    self states do: [:state | state spaceOptimizeMap]!
 
standardErrorString

    ^'illegal character encountered:  '!
 
stateID

    ^stateID!

stateID: id

    stateID := id!
   
states
    "Answer the Set states reachable from here.
    If I am the start state this is all my states."

    | states |
    states := self stateSetClass new.
    self collectStatesIn: states.
    ^states!
  
stateSetClass

    ^ItemSet!
  
transitionFor: aSymbol

    ^self transitionFor: aSymbol ifNone: [self raiseNoTransitionExceptionErrorString: (aSymbol = self endOfInputToken
                ifTrue: [self endOfInputErrorString]
                ifFalse: [self standardErrorString , '''' , aSymbol printString , ''''])]!
   
transitionFor: aSymbol ifNone: aBlock

    ^self edgeLabelMap at: aSymbol ifAbsent: [^aBlock value]! !

!FSAState class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a general state in a finite state automata.'!
   
initialize
    "FSAState initialize"
    
    self noTransitionSignal: 
        (TGenException new messageText: 'Class: ', self name, ' noTransitionSymbol').
!

new

    ^super new init!
 
noTransitionSignal
    ^noTransitionSignal
!

noTransitionSignal: anObject

    noTransitionSignal := anObject.
! !

!FstFllwGraphNode methodsFor: 'as yet unclassified' !
   
addTerminal: term

    self terminals add: term!
  
asAssociation

    ^Association key: self label value: self terminals!

init

    super init.
    self terminals: Set new!
   
terminals

    ^terminals!

terminals: argument

    terminals := argument!
   
unionWithPredecessorsChangesMe
    "Answer true if adding the terminals of my predecessors changes my terminals
    and false otherwise."

    | myTerms initialSize |
    myTerms := self terminals.
    initialSize := myTerms size.
    self predecessorsDo: [:pred | myTerms addAll: pred terminals].
    ^initialSize ~= myTerms size! !

!FstFllwGraphNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent a nonterminal of a grammar for the purpose of first and follow set computation.

Instance Variables:
    terminals    <Set of: Symbols> - the first or follow set of my nonterminal.'! !

!Grammar methodsFor: 'as yet unclassified' !
  
computeFirstSets

    | graph |
    graph := self firstFollowGraph.
    self productions do: [:prod | prod computeFirstIn: self using: graph].
    graph propagateSetUnions.
    self firstSets: graph nodeSetMap!

computeFollowSets

    | graph |
    graph := self firstFollowGraph.
    self productions do: [:prod | prod computeFollowIn: self using: graph].
    graph addTerminal: self epsilon toNodeLabeled: self startSymbol.        "used to denote end-of-input symbol"
    graph propagateSetUnions.
    self followSets: graph nodeSetMap!
   
computeNullableNonterminals
    "Compute the set of nonterminals that can derive epsilon in one or more steps."

    | nullables prevNullables |
    nullables := ((self productions select: [:prod | prod rightHandSide isEmpty])
                collect: [:prod | prod leftHandSide]) asSet.
    prevNullables := Set new.
    [nullables size ~= prevNullables size]
        whileTrue:
            [prevNullables := nullables.
            nullables := prevNullables union: ((self productions select: [:prod | prod rightHandSideComprisedOf: prevNullables])
                            collect: [:prod | prod leftHandSide]) asSet].
    self nullableNonterminals: nullables!
   
computeProductionMap
    "Answer a dictionary from nonterminals to sets of their corresponding
    productions."

    | prodMap |
    prodMap := SetDictionary new.
    self productions do: [:prod | prodMap at: prod leftHandSide add: prod].
    ^prodMap!

copyForManipulation
    "Answer a copy of myself that can be manipulated without affecting me."

    ^self species buildGrammarWithProductions: self productions deepCopy!
   
emptyRHS
    "Answer a right hand side that can be used in productions like A -> <epsilon>."

    ^Array new: 0!
 
epsilon
    "Answer an object used to represent the empty string (epsilon)."

    ^EpsilonNode epsilon!
  
factorCommonPrefixes

    | prodMap aSet oldSet |
    prodMap := self computeProductionMap.
    aSet := Set new.
    "On the first pass, process all production, collecting new nonterminals in aSet."
    prodMap copy do: [:prodSet | self
            leftFactor: prodSet
            fromMap: prodMap
            collectingNewNontsIn: aSet].
    "Iterate over new nonterminals until no more factoring can be done."
    [aSet isEmpty]
        whileFalse:
            [oldSet := aSet.
            aSet := Set new.
            oldSet do: [:nt | self
                    leftFactor: (prodMap at: nt)
                    fromMap: prodMap
                    collectingNewNontsIn: aSet]].
    self replaceProductionsWith: prodMap!

firstFollowGraph

    ^self firstFollowGraphClass withNodesLabeled: self nonterminals!

firstFollowGraphClass

    ^FirstFollowGraph!
 
firstOfSymbolString: symbolString
    "Answer the set of terminals that could appear at the beginning of the argument
    string at some stage of a derivation. This set will include epsilon only if the
    whole string could derive epsilon."

    | first |
    first := Set new.
    symbolString do:
        [:sym |
        first := first union: (self firstSetOf: sym).
        (self isNullable: sym)
            ifFalse: [^first]].
    first add: self epsilon.
    ^first!
  
firstSetOf: symbol

    ^self firstSets at: symbol ifAbsent:
        ["terminal"
        Set with: symbol]!
 
firstSets

    ^firstSets!

firstSets: argument

    firstSets := argument!
   
followSetOf: symbol

    ^self followSets at: symbol ifAbsent:
        ["terminals don't have follow sets"
        Set new]!

followSets

    ^followSets!
  
followSets: argument

    followSets := argument!
 
generableNonterminals
    "Answer a set of the generable nonterminals of this grammar."

    | generable prodMap prods prod |
    generable := Set with: self startSymbol.
    prodMap := self computeProductionMap.
    prods := OrderedCollection new.
    prods addAll: (prodMap at: self startSymbol).
    [prods isEmpty]
        whileFalse:
            [prod := prods removeFirst.
            prod rightHandSide do: [:sym | (sym isNonterminal and: [(generable includes: sym) not])
                    ifTrue:
                        [generable add: sym.
                        prods addAll: (prodMap at: sym ifAbsent: [Set new])]]].
    ^generable!
  
grammarProductionClass

    ^GrammarProduction!
   
init

    self initSymbols.
    self isReduced ifTrue: [self initFirstAndFollow]!

initFirstAndFollow

    self computeNullableNonterminals.
    self computeFirstSets.
    self computeFollowSets!

initSymbols
    | terms nonterms |
    terms := Set new.
    nonterms := Set new.
    self productions do:
        [:prod |
        nonterms add: prod leftHandSide.
        prod rightHandSide do: [:sym | sym isTerminal
                ifTrue: [terms add: sym]
                ifFalse: [nonterms add: sym]]].
    self terminals: terms.
    self nonterminals: nonterms!
  
isNullable: symbol

    ^symbol isTerminal
        ifTrue: [false]
        ifFalse: [self nullableNonterminals includes: symbol]!
   
isReduced
    "Answer true if this grammar contains no non-generable nonterminals and
    no non-terminable nonterminals.  Raise an exception and answer false otherwise."

    | nongen nonterm errorString |
    nongen := self nonterminals copy.
    nongen removeAll: self generableNonterminals.
    nonterm := self nonterminals copy.
    nonterm removeAll: self terminableNonterminals.
    ^nongen isEmpty & nonterm isEmpty
        ifTrue: [true]
        ifFalse:
            [errorString := ('grammar is not reduced,
   non-generable nonterminals: ' , nongen printString , '
    non-terminable nonterminals: ' , nonterm printString , '.
').
            self raiseNotReducedExceptionErrorString: errorString.
            false]!
   
leftFactor: prodSet fromMap: prodMap collectingNewNontsIn: aSet

    | partition newProds nont suffix newNont n newBaseProd rhs reallyNewProds |
    (partition := self partitionProdSetForLeftFactoring: prodSet) anyProblems
        ifTrue:
            ["The partition contains problem productions of the form
            A -> <prefix> <stuff1> | <prefix> <stuff2> and other productions without
            the common <prefix>. To factor the common prefix, replace the problem
            productions with A -> <prefix> An and An -> <stuff1> | <stuff2>. Note,
            where a prefix has been factored from more than three productions it
            is possible that a new common prefix exists in the new productions.
            Thus, this process may need to be repeated (done by sender)."
            newProds := partition otherProductions.
            nont := partition leftHandSide.
            suffix := 0.
            partition problemProductions do:
                [:set |
                newNont := self nonterminalDerivedFrom: nont withSuffix: suffix printString.
                aSet add: newNont.
                suffix := suffix + 1.
                n := self maxCommonPrefixFor: set.
                newBaseProd := self makeProductionWithLeftHandSide: nont rightHandSide: (OrderedCollection with: newNont).
                rhs := set first rightHandSide.
                n
                    to: 1
                    by: -1
                    do: [:i | newBaseProd rightHandSide addFirst: (rhs at: i)].
                newProds add: newBaseProd.
                reallyNewProds := Set new.
                set do:
                    [:prod |
                    prod leftHandSide: newNont.
                    prod rightHandSide removeFirst: n.
                    reallyNewProds add: prod].
                prodMap at: newNont put: reallyNewProds].
            prodMap at: nont put: newProds]!

literalTerminals
    "Answer a collection of my non-token class terminals."

    ^self terminals reject: [:term | term isTokenClassTerminal]!

lr1LookaheadSetFor: lr1Item

    ^self firstOfSymbolString: lr1Item lookaheadTail!

makeLL1Transformations

    self removeLeftRecursion.
    self factorCommonPrefixes!
 
makeProductionWithLeftHandSide: lhs rightHandSide: rhs

    ^self grammarProductionClass leftHandSide: lhs rightHandSide: rhs!

maxCommonPrefixFor: prodSet
    "Answer the maximum number of symbols the productions in prodSet share as a
    common prefix. This method assumes more than one element in prodSet, no
    dupilcate productions, and the first symbols are all the same."

    | n more key target |
    n := 2.
    more := true.
    key := prodSet first rightHandSide.
    [more]
        whileTrue:
            [n <= key size
                ifTrue: [prodSet do:
                        [:prod |
                        target := prod rightHandSide.
                        n <= target size
                            ifTrue: [(key at: n)
                                    = (target at: n) ifFalse: [more := false]]
                            ifFalse: [more := false]]]
                ifFalse: [more := false].
            n := n + 1].
    ^n - 2!
   
nonterminalDerivedFrom: aSymbol withSuffix: aString
    "Answer a new nonterminal built from the arguments and add it to my
    nonterminals."

    | newNont |
    newNont := (aSymbol , aString) asSymbol.
    self nonterminals add: newNont.
    ^newNont!
   
nonterminals

    ^nonterminals!
  
nonterminals: argument

    nonterminals := argument!
 
nullableNonterminals

    ^nullableNonterminals!
  
nullableNonterminals: argument

    nullableNonterminals := argument!
 
partitionProdSetForLeftFactoring: prodSet

    ^self productionPartitionClass partitionProdSetForLeftFactoring: prodSet!
  
partitionProdSetForLeftRecursion: prodSet

    ^self productionPartitionClass partitionProdSetForLeftRecursion: prodSet!
  
printOn: aStream

    self productions do:
        [:prod |
        prod printOn: aStream.
        aStream nextPutAll: ' ;'.
        aStream cr]!
 
productionPartitionClass

    ^ProductionPartition!
   
productions

    ^productions!

productions: argument

    productions := argument!
   
raiseNotReducedExceptionErrorString: aString

    GrammarNotReduced signalWith: aString!
  
removeLeftRecursion

    | prodMap partition nont newNont |
    prodMap := self computeProductionMap.
    prodMap copy do: [:prodSet | (partition := self partitionProdSetForLeftRecursion: prodSet) anyProblems
            ifTrue:
                ["The partition contains problem productions of the form
                A -> A <stuff1> and other productions of the form A -> <stuff2>.
                To remove the left recursion, change the other productions to
                the form A -> <stuff2> A@ and the problem productions to the
                form A@ -> <stuff1> A@ | <epsilon>."
                nont := partition leftHandSide.
                newNont := self nonterminalDerivedFrom: nont withSuffix: '@'.
                prodMap at: nont put: (partition otherProductions
                        collect:
                            [:prod |
                            prod rightHandSide addLast: newNont.
                            prod]).
                prodMap at: newNont put: (partition problemProductions
                        collect:
                            [:prod |
                            prod leftHandSide: newNont.
                            prod rightHandSide removeFirst.
                            prod rightHandSide addLast: newNont.
                            prod]).
                (prodMap at: newNont)
                    add: (self makeProductionWithLeftHandSide: newNont rightHandSide: self emptyRHS)]].
    self replaceProductionsWith: prodMap!
  
replaceProductionsWith: prodMap
    "The argument maps each nonterminal to a set of corresponding productions."

    | newProds |
    newProds := OrderedCollection new.
    prodMap do: [:prodSet | newProds addAll: prodSet].
    self productions: newProds.
    self initFirstAndFollow!
 
selectSets
    "The select set of a production is the set of terminals that signal selection
    of that production in a top-down (LL(1)) parse of the input. Select sets
    are used in construction of the LL(1) parser table."

    | select first |
    select := Dictionary new.
    self productions do:
        [:prod |
        first := self firstOfSymbolString: prod rightHandSide.
        (first includes: self epsilon)
            ifTrue:
                [first remove: self epsilon.
                first addAll: (self followSetOf: prod leftHandSide)].
        select at: prod put: first].
    ^select!
  
startSymbol

    ^startSymbol!

startSymbol: argument

    startSymbol := argument!
   
terminableNonterminals
    "Answer a set of the terminable nonterminals of this grammar."

    | terminable again |
    terminable := Set new.
    again := true.
    [again]
        whileTrue:
            [again := false.
            self productions do: [:prod | (terminable includes: prod leftHandSide)
                    ifFalse: [(prod rightHandSideHasAllNontermsIn: terminable)
                            ifTrue:
                                [terminable add: prod leftHandSide.
                                again := true]]]].
    ^terminable!
   
terminals

    ^terminals!

terminals: argument

    terminals := argument! !

!Grammar class methodsFor: 'as yet unclassified' !
   
buildGrammarFrom: anArray

    | newGrammar |
    newGrammar := self new.
    newGrammar productions: OrderedCollection new.
    anArray do: [:prod | prod size = 3
            ifTrue: [newGrammar productions add: (TransductionGrammarProduction
                        leftHandSide: (prod at: 1)
                        rightHandSide: (prod at: 2) asOrderedCollection
                        translationSymbol: (prod at: 3))]
            ifFalse: [prod size = 2
                    ifTrue: [newGrammar productions add: (GrammarProduction leftHandSide: (prod at: 1)
                                rightHandSide: (prod at: 2) asOrderedCollection)]
                    ifFalse: [self error: 'wrong sized production array']]].
    newGrammar startSymbol: ((anArray at: 1)
            at: 1).
    newGrammar init.
    ^newGrammar!
  
buildGrammarWithProductions: prods
    "Assume that the left-hand side of the first production is the start symbol."

    ^self buildGrammarWithProductions: prods startSymbol: prods first leftHandSide!

buildGrammarWithProductions: prods startSymbol: aSymbol

    | newGrammar |
    newGrammar := self new.
    newGrammar productions: prods.
    newGrammar startSymbol: aSymbol.
    newGrammar init.
    ^newGrammar!

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent a context-free grammar.  My two main responsibilities are to compute my first and follow sets and to perform certain grammar manipulations sometimes needed to construct certain classes of parsers.  The two grammar manipulations currently supported are removal of left-recursion and common prefixes (left-factoring).

Instance Variables:
    nonterminals            <Set of: Symbol> - nonterminals are represented by Symbols.
    terminals                <Set of: String> - terminals are represented by Strings.
    productions            <OrderedCollection of: GrammarProduction> - order is only important from a logical point of veiw (i.e. for printing).
    startSymbol            <Symbol> - a nonterminal.
    nullableNonterminals    <Set of: Symbol> - those nonterminals that can derive epsilon in zero or more steps.
    firstSets                <SetDictionary from: Symbol to: Strings> - for each nonterminal, the terminals that could begin a sentence derivable from that nonterminal.
    followSets            <SetDictionary from: Symbol to: Strings> - for each nonterminal, the terminals that could appear immediately to the right of that nonterminal in some sentential form in some valid derivation sequence.'!
 
initialize
    "Grammar initialize"
    "
    self notReducedSignal: (Signal new nameClass: self message: #notReducedSymbol)
    "! !

!GrammarLeafNode methodsFor: 'as yet unclassified' !
   
printOn: aStream

    self symbol printOn: aStream!
   
setAttribute: value

    self symbol: value!
  
symbol

    ^symbol!
  
symbol: argument

    symbol := argument! !

!GrammarLeafNode class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class for grammar tree leaf nodes.

Instance Variables:

    symbol    <Symbol + String>    - a terminal, nonterminal, or transduction symbol.'! !

!GrammarNode methodsFor: 'as yet unclassified' !
  
addChildrenFirst: anOrderedCollection

    self productions addAllFirst: anOrderedCollection!
 
addChildrenInitial: anOrderedCollection

    self productions addAll: anOrderedCollection!

asGrammar
    "Answer the Grammar representation of myself."

    | prods lhsNames |
    prods := OrderedCollection new.
    lhsNames := Set new.
    self childrenDo: [:prod | prods addAll: (prod asProductions: lhsNames)].
    ^Grammar buildGrammarWithProductions: prods!
  
childrenDo: aBlock
    "Evaluate aBlock for each of my children."

    ^self productions do: aBlock!
 
init

    self productions: OrderedCollection new!

printOn: aStream

    self productions do:
        [:prod |
        prod printOn: aStream.
        aStream cr]!

productions

    ^productions!

productions: argument

    productions := argument!
   
updateChildrenUsing: aBlock
    "Replace my children according to the value of aBlock."

    ^self productions: (self productions collect: aBlock)! !

!GrammarNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am the root of the grammar tree.

Instance Variables:

    productions    <OrderedCollection>    - the productions of the grammar.'!
   
new

    ^super new init! !

!GrammarNotReduced class methodsFor: 'as yet unclassified' !
   
classHeader
^'----------------------------------------------------------
Signal subclass: #GrammarNotReduced

Date        By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------'! !

!GrammarParseTreeNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class is an abstract class for grammar parse tree nodes.'! !

!GrammarProduction methodsFor: 'as yet unclassified' !
  
= aProd

    ^aProd isGrammarProduction
        ifTrue: [self leftHandSide = aProd leftHandSide and: [self rightHandSide = aProd rightHandSide]]
        ifFalse: [false]!
  
asInitialLR0Item

    ^self lr0ItemClass
        leftHandSide: self leftHandSide
        preDotSymbols: OrderedCollection new
        postDotSymbols: self rightHandSide copy!
 
asInitialLR1ItemWithLookahead: terminal

    ^self lr1ItemClass
        leftHandSide: self leftHandSide
        preDotSymbols: OrderedCollection new
        postDotSymbols: self rightHandSide copy
        lookahead: terminal!
 
asNonLalrSuffixedProduction
    "Assuming I am of the form 'A.<stuff1>* -> B.<stuff2>* C.<stuff3>*',
    answer the prefix production 'A -> B C'."

    | separator lhs rhs |
    separator := self symbolSuffixSeparatorChar.
    lhs := self leftHandSide copyUpTo: separator.
    rhs := self rightHandSide collect: [:sym | sym copyUpTo: separator].
    ^self species leftHandSide: lhs rightHandSide: rhs!
   
computeFirstIn: grammar using: graph
    "Build dependency graph for first sets and initialize first sets. Starting at the left
    end of my right hand side, symbols are processed until a terminal or non-nullable
    nonterminal is encountered. Any terminal encountered is added to the first set
    associated with my left hand side node in the graph. Any nonterminal
    encountered means that I must include its first set in mine. This accomplished
    (indirectly) by adding an edge in the graph from the nonterminal's node to my lhs
    node. The actual first set unioning will be done after the graph is complete (see
    sender)."

    self rightHandSide do:
        [:sym |
        sym isTerminal
            ifTrue:
                [graph addTerminal: sym toNodeLabeled: self leftHandSide.
                ^self].
        graph addEdgeFromNodeLabeled: sym toNodeLabeled: self leftHandSide.
        (grammar isNullable: sym)
            ifFalse: [^self]]!
  
computeFollowIn: grammar using: graph
    "Build dependency graph for follow sets and initialize follow sets. This method
    performs two distinct parts of the algorithm. First, each nonterminal in my right
    hand side is checked to what symbols can follow it. Those symbols are added to
    the follow set for the nonterminal's graph node. Second, starting at the right end
    of my right hand side, symbols are processed until a terminal or non-nullable
    nonterminal is encountered. Any nonterminal encountered means that my follow
    set should also be included in its follow set. This accomplished (indirectly) by
    adding an edge in the graph from my lhs node to the nonterminal's node. The
    actual follow set unioning will be done after the graph is complete (see sender)."

    | n currSym more j nextSym |
    n := self rightHandSide size.
    1 to: n - 1 do: [:i | (currSym := self rightHandSide at: i) isNonterminal
            ifTrue:
                [more := true.
                j := i + 1.
                [j <= n & more]
                    whileTrue:
                        [nextSym := self rightHandSide at: j.
                        (grammar firstSetOf: nextSym)
                            do: [:sym | graph addTerminal: sym toNodeLabeled: currSym].
                        j := j + 1.
                        more := grammar isNullable: nextSym]]].
    self rightHandSide
        reverseDo:
            [:sym |
            sym isTerminal ifTrue: [^self].
            graph addEdgeFromNodeLabeled: self leftHandSide toNodeLabeled: sym.
            (grammar isNullable: sym)
                ifFalse: [^self]]!
   
computeResultNodeFor: builder withArgNodes: nodes
    "Productions without translation symbols can only pass on a single argument
    node."

    nodes size = 1 ifFalse: [self error: 'Productions without translation symbols can only
pass on results from a single right-hand side nonterminal'].
    ^builder answerArgument: nodes first!
   
computeResultNodeFor: builder withTokenClassValue: value
    "See this method in class TransductionGrammarProduction."

    self error: 'No translation has been specified that would
create a place to store the token class value.'!
  
constructItsContentOn: aStream using: tokenTable
"Emit lhs and #( rhs ) on aStream"

    | array |

    array := Array with: (tokenTable indexOf: self leftHandSide)
                           with: (Array new: self rightHandSide size).

    self rightHandSide inject: 1 into: [:i :ea |
        (array at: 2) at: i put: (tokenTable indexOf: ea).
        i + 1
    ].

    array reconstructOn: aStream.

    "
    (tokenTable indexOf: self leftHandSide)
        reconstructOn: aStream.
    aStream
         space;
         poundSign;
         leftParenthesis.
    self rightHandSide do:
        [:ea |
        (tokenTable indexOf: ea)
            reconstructOn: aStream.
        aStream space].
    aStream rightParenthesis
    "!

hash
    "This is redefined because = is redefined."

    ^self leftHandSide hash bitXor: self rightHandSide hash!
   
hasSingleTokenClassRhs
    "Answer true if my right hand side consists solely of
    a single token class terminal symbol and false otherwise."

    ^self rightHandSide size = 1 and: [self rightHandSide first isTokenClassTerminal]!
 
hasTranslation
    "See class TransductionGrammarProduction."

    ^false!
   
isEpsilonProduction
    "Answer true if I am a production of the form S -> <epsilon> (i.e. if my right hand
    side is empty) and false otherwise."

    ^self rightHandSide isEmpty!
  
isGrammarProduction

    ^true!
   
leftHandSide

    ^leftHandSide!
  
leftHandSide: argument

    leftHandSide := argument!
 
lr0ItemClass

    ^LR0Item!
   
lr1ItemClass

    ^LR1Item!
   
lrParserStateClass

    ^LRParserState!
   
numberOfRhsNonterminals
    "Answer the number of nonterminals in my right-hand side."

    ^(self rightHandSide select: [:sym | sym isNonterminal]) size!
   
printOn: aStream

    self printSymbol: self leftHandSide on: aStream.
    aStream
         nextPutAll: '    ';
         nextPutAll: ' : ';
         nextPutAll: '    '.
    self rightHandSide do:
        [:sym |
        self printSymbol: sym on: aStream.
        aStream space]!

printSymbol: sym on: aStream
    "Render the given grammar symbol (terminal or nonterminal) on aStream.
    This is provided so that grammars are printed in T-gen specification form."

    sym isTerminal
        ifTrue:
            [aStream nextPut: $'.
            sym do: [:ch | aStream nextPut: ch].
            aStream nextPut: $']
        ifFalse: [sym do: [:ch | aStream nextPut: ch]]!

reconstructOn: aStream
"Emit #( productions ) on aStream"

    | array |

    array := Array with: (self symbolTable at: self leftHandSide)
                           with: (Array new: self rightHandSide size).

    self rightHandSide inject: 1 into: [:i :ea |
        (array at: 2) at: i put: (self symbolTable at: ea).
        i + 1
    ].

    array reconstruct on: aStream.

    "
    aStream poundSign; leftParenthesis.
    (self symbolTable at: self leftHandSide)
        reconstructOn: aStream.
    aStream
         space;
         poundSign;
         leftParenthesis.
    self rightHandSide do:
        [:ea |
        (self symbolTable at: ea)
            reconstructOn: aStream.
        aStream space].
    aStream
         rightParenthesis;
         rightParenthesis;
         space
    "!
 
reconstructOn: aStream using: tokenTable
"| array |

    array := Array new: self rightHandSide size + 1.
    array at: 1 put: (self symbolTable at: self leftHandSide).

    self rightHandSide inject: 2 into: [:i :ea |
        array at: i put: (self symbolTable at: ea).
    ].

    array reconstruct on: aStream."

    self constructItsContentOn: aStream using: tokenTable.

    "
    aStream poundSign; leftParenthesis.
    self constructItsContentOn: aStream using: tokenTable.
    aStream rightParenthesis; space
    "!
   
rightHandSide

    ^rightHandSide!

rightHandSide: argument

    rightHandSide := argument!
   
rightHandSideComprisedOf: aSet
    "Answer true if all symbols in my right-hand side
    are included in aSet and false otherwise."

    self rightHandSide detect: [:sym | (aSet includes: sym) not]
        ifNone: [^true].
    ^false!

rightHandSideHasAllNontermsIn: aSet
    "Answer true if all nonterminals in my right-hand side
    are included in aSet and false otherwise."

    self rightHandSide detect: [:sym | sym isNonterminal and: [(aSet includes: sym) not]]
        ifNone: [^true].
    ^false!
 
symbolSuffixSeparatorChar

    ^self lrParserStateClass symbolSuffixSeparatorChar! !

!GrammarProduction class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent one production of a context-free grammar.  I am responsible for some parts of the first/follow set computation algorithm and for converting myself between various related representations (e.g. LR(0) items).

Instance Variables:
    leftHandSide        <Symbol>
    rightHandSide     <OrderedCollection of: (String + Symbol)>'!
   
leftHandSide: arg1 rightHandSide: arg2

    | newMe |
    newMe := self new.
    newMe leftHandSide: arg1.
    newMe rightHandSide: arg2.
    ^newMe! !

!GrammarSpecParser methodsFor: 'as yet unclassified' !
 
scannerClass

    ^GrSpecScanner! !

!GrammarSpecParser class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a parser for T-gen grammar specifications.'!

grammar
"-----------------------------------------------------------
Date           By      Description
06/04/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    ^Grammar buildGrammarFrom:
        ((Array new: 25)
            at: 1 put: (
                Array
                    with: #Gram
                    with: #(Rule Gram )
                    with: #liftRightChild );
            at: 2 put: (
                Array
                    with: #Gram
                    with: #()
                    with: #GrammarNode );
            at: 3 put: (
                Array
                    with: #Rule
                    with: #(Nonterm ':' RightParts ';' )
                    with: #RRPGProductionNode );
            at: 4 put: (
                Array
                    with: #Nonterm
                    with: #('<id>' )
                    with: #NonterminalNode );
            at: 5 put: (
                Array
                    with: #RightParts
                    with: #(RegExpr '|' RightParts )
                    with: #insertRHSNode:with: );
            at: 6 put: (
                Array
                    with: #RightParts
                    with: #(RegExpr ) );
            at: 7 put: (
                Array
                    with: #RegExpr
                    with: #(CatExpr Trans )
                    with: #RRPGRightHandSideNode );
            at: 8 put: (
                Array
                    with: #CatExpr
                    with: #(Expr CatExpr )
                    with: #insertNode:with: );
            at: 9 put: (
                Array
                    with: #CatExpr
                    with: #()
                    with: #EpsilonNode );
            at: 10 put: (
                Array
                    with: #Expr
                    with: #(BaseExpr '*' )
                    with: #StarClosureNode );
            at: 11 put: (
                Array
                    with: #Expr
                    with: #(BaseExpr '+' )
                    with: #PlusClosureNode );
            at: 12 put: (
                Array
                    with: #Expr
                    with: #(BaseExpr '?' )
                    with: #OptionalNode );
            at: 13 put: (
                Array
                    with: #Expr
                    with: #(BaseExpr 'list' BaseExpr )
                    with: #ListNode );
            at: 14 put: (
                Array
                    with: #Expr
                    with: #(BaseExpr ) );
            at: 15 put: (
                Array
                    with: #BaseExpr
                    with: #(Nonterm ) );
            at: 16 put: (
                Array
                    with: #BaseExpr
                    with: #(Term ) );
            at: 17 put: (
                Array
                    with: #BaseExpr
                    with: #('(' RregExpr ')' ) );
            at: 18 put: (
                Array
                    with: #RregExpr
                    with: #(RregExpr '|' CatExpr )
                    with: #insertRHSNode:with: );
            at: 19 put: (
                Array
                    with: #RregExpr
                    with: #(CatExpr ) );
            at: 20 put: (
                Array
                    with: #Trans
                    with: #('{' TransSym '}' ) );
            at: 21 put: (
                Array
                    with: #Trans
                    with: #()
                    with: #nil );
            at: 22 put: (
                Array
                    with: #TransSym
                    with: #('<id>' )
                    with: #TranslationNode );
            at: 23 put: (
                Array
                    with: #TransSym
                    with: #('<keyword>' )
                    with: #TranslationNode );
            at: 24 put: (
                Array
                    with: #Term
                    with: #('<literal>' )
                    with: #TerminalNode );
            at: 25 put: (
                Array
                    with: #Term
                    with: #('<tokenClass>' )
                    with: #TerminalNode );
            yourself
    ).!
   
initialize
"GrammarSpecParser initialize"
    "grammar:
    gram            -> rule gram                        => liftRightChild .
    gram         ->                                     => GrammarNode .
    rule            -> nonterm ':' rightparts ';'    => RRPGProductionNode .
    nonterm        -> <id>                                => NonterminalNode .
    rightparts        -> regexpr '|' rightparts        => insertRHSNode:with: .
    rightparts        -> regexpr .
    regexpr        -> catexpr trans                    => RRPGRightHandSideNode.
    catexpr        -> expr catexpr                    => liftRightChild.
    catexpr        ->                                    => ConcatenationNode .
    expr            -> baseexpr '*'                    => StarClosureNode.
    expr            -> baseexpr '+'                    => PlusClosureNode.
    expr            -> baseexpr '?'                    => OptionalNode.
    expr            -> baseexpr 'list' baseexpr        => ListNode.
    expr            -> baseexpr.
    baseexpr        -> term.
    baseexpr        -> nonterm.
    baseexpr        -> '(' rregexpr ')'.
    baseexpr        ->                                    => nil.
    rregexpr        -> catexpr '|' rregexpr            => insertRHSNode:with:
    rregexpr        -> catexpr .
    trans            -> '{' transsym '}'.
    trans            ->                                    => nil.
    transsym        -> <id>                                =>TranslationNode
    transsym        -> <keyword>                        => TranslationNode.
    term            -> <tokenclass>         => TerminalNode .
    term            -> <literal>                        => TerminalNode.


    status: SLR(1) and LL(1), with transformations"

    | newPG parser rules fsa par |
    parser := DLGParser parse: '
        %%
        <id> = [a-zA-Z_][a-zA-Z_0-9]*
        <keyword> = ([a-zA-Z_][a-zA-Z_0-9]*:)+
        <literal> = ''(~[''] | '''')+''        <<compactDoubleApostrophes>>
        <tokenClass> = \<[a-zA-Z_][a-zA-Z_0-9]*\>
        <comment> = "(~["]|""|[\ \    \
])*"            <<ignoreComment>>
        <space> = [\ \    \
]+            <<ignoreDelimiter>>
        %%' onError: [self halt].
    parser notNil
        ifTrue:
            [rules := parser execute.
            fsa := parser buildFSAFrom: rules and: #(':' ';' '\|' '\*' '\+' '?' 'list' '\(' '\)' '\{' '\}' ).
            GrSpecScanner fsa: fsa.
            newPG := TranslatorGenerator new.
            newPG grammar: self grammar.
            newPG generateLRParser.
            Transcript cr; show: newPG grammarClassification.
            par := newPG parser.
            par scanner: GrSpecScanner new.
            self parseTable: par parseTable.
            self finalState: par finalState]! !

!Graph class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class of graphs.'!
  
preferredNodeClass

    ^self subclassResponsibility!
 
withNodesLabeled: aCollection

    | newGraph |
    aCollection size ~= aCollection asSet size ifTrue: [self notify: 'warning:  duplicate node names specifed for graph'].
    newGraph := self new: aCollection size.
    aCollection do: [:nodeName | newGraph add: (self preferredNodeClass label: nodeName)].
    ^newGraph! !

!GraphNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class of graph nodes.'! !

!GrSpecScanner class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a scanner for T-gen grammar specifications.'! !

!HandCodedScanner methodsFor: 'as yet unclassified' !

atStartOfComplexToken
    "Answer true if the first character of the tokenType is an $x and false otherwise."

    ^(self tokenType at: 1)
        = $x!

charTypeTable

    ^charTypeTable!

charTypeTable: argument

    charTypeTable := argument!
   
endOfInputToken
    "Answer a token representing the end of the input."

    ^nil!
   
endOfInputTokenType
    "Answer the token type representing the end of the input."

    ^#doIt!
  
init

    super init.
    self charTypeTable: self myTypeTable!
  
myTypeTable

    ^self class charTypeTable!
   
scanToken
    "Scan the next token and compute its token type.  This may be
    overridden in subclasses for efficiency and customization."


    [self atEnd ifTrue: [^self signalEndOfInput].
    self tokenType: (self charTypeTable at: self nextChar asciiValue).
    self tokenType == #xDelimiter]
        whileTrue:
            ["Skip delimiters fast, there almost always is one."
            self getNextChar].
    self atStartOfComplexToken
        ifTrue:
            ["perform to compute token & type"
            self perform: tokenType]
        ifFalse:
            ["else just the character"
            self token: self nextChar.
            self getNextChar]! !

!HandCodedScanner class methodsFor: 'as yet unclassified' !

charTypeTable

    ^charTypeTable!

charTypeTable: argument

    charTypeTable := argument!
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class of scanner that scans a source string and breaks it up into tokens using a character type table and hand-coded scanner methods.  Specific type tables are stored in class instance variables of my concrete subclasses.

Instance Variables:
    charTypeTable    <Array of: Symbol> - a local reference to the type table for this class of scanner; the ascii value of each character is mapped to a symbol token type.
'!
  
initialize
    "Concrete subclasses must provide a character type table."
    "HandCodedScanner initialize"

    | newTable |
    newTable := Array new: 256 withAll: #xDefault.        "default"
    self charTypeTable: newTable! !

!HexadecimalCharNode methodsFor: 'as yet unclassified' !
 
myChar
    "Answer the Character represented by the receiver.
    The spec is of the form '\xHH'."

    | spec |
    spec := self charSpec.
    (spec size = 4 and: [spec first = $\ and: [(spec at: 2)
                = $x]])
        ifTrue: [^Character value: ('16r' , (spec copyFrom: 3 to: 4)) asNumber]
        ifFalse: [self error: 'Hexadecimal character specifications must be of the form ''\xHH''.']! !

!HexadecimalCharNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a atomic character of a regular expression.  I am specified by a String of the form ''\xHH'' where each H is a hexadecimal digit (0-9, a-f or A-F) and HH is my corresponding ASCII value.

'! !

!ItemSet methodsFor: 'as yet unclassified' !
  
= anItemSet

    self == anItemSet ifTrue: [^true].
    ^anItemSet isItemSet
        ifTrue: [
            self size = anItemSet size and: [
                anItemSet do: [:each |
                    (self includes: each) ifFalse: [^false].
                ].
                true.
            ]
        ]
        ifFalse: [false]!
 
hash
"Make sure equal sets hash equally."
    "A good and fast hashing function will require some more thought. I used to use
    'self size bitXor: self first hash' but there is no guarantee that the first's of
    equal sets will be the same element (even if their basicSizes are the same, due
    to the temporal ordering of hash collisions). If simply 'size' doesn't give
    reasonable performance, then try 'self inject: 0 into: [:max :each
    | max max: each hash]'."

    ^self isEmpty
        ifTrue: [151515]
        ifFalse: ["self size"
            self inject: 0 into: [:max :each | max max: each hash].
        ]!
   
isItemSet

    ^true! !

!ItemSet class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

ItemSets are equal if they contain equal elements.'! !

!LabeledDigraph methodsFor: 'as yet unclassified' !

addEdgeFromNodeLabeled: label1 toNodeLabeled: label2

    | node1 node2 |
    label1 ~= label2
        ifTrue:
            ["self edges are implicit and not represented"
            node1 := self detect: [:node | node label = label1].
            node2 := self detect: [:node | node label = label2].
            self addEdgeFrom: node1 to: node2]! !

!LabeledDigraph class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class represents a directed graph whose edges are labeled.'!

preferredNodeClass

    ^NodeLabeledDigraphNode! !

!ListNode methodsFor: 'as yet unclassified' !
   
createCatNode: lhs with: gamma

    | catNode beta |
    catNode := OrderedCollection new.
    gamma isEmpty ifTrue: [gamma add: EpsilonNode new].
    rightChild isCatNode
        ifTrue: [rightChild children addLast: lhs]
        ifFalse:
            [beta := OrderedCollection new.
            beta add: rightChild; add: lhs].
    catNode add: (ConcatenationNode new addChildrenInitial: beta); addLast: (ConcatenationNode new addChildrenInitial: gamma).
    ^catNode!

createNewRHS: lhs with: gamma
    | aCollection1 aCollection2 |
    aCollection1 := OrderedCollection new.
    aCollection2 := OrderedCollection new.
    aCollection1 add: self leftChild.
    aCollection2
         add: self leftChild;
         add: self rightChild;
         add: lhs.
    gamma isEmpty ifFalse: [aCollection1 addAll: gamma].
    ^super
        createNewRHS: lhs
        with: aCollection1
        with: aCollection2!
  
createNewRHS: lhs with: alpha with: gamma
    | aCollection1 aCollection2 |
    aCollection1 := OrderedCollection new.
    aCollection2 := OrderedCollection new.
    aCollection1 addAll: self leftChild.
    aCollection2
         addAll: self leftChild;
         addAll: self rightChild;
         add: lhs.
    gamma isEmpty ifFalse: [aCollection1 addAll: gamma].
    ^super
        createNewRHS: lhs
        with: aCollection1
        with: aCollection2!
 
hasBeenTransformed
    ^true!
  
isAltNode

    ^false!

isCatNode

    ^false!

isEpsilonNode

    ^false!

needTransforming
    ^true!

performTransformation: lhs with: gamma with: lhsNames

    | rhsNode newLHS newProd catNode |
    leftChild isTerminalNode
        ifTrue:
            [rhsNode := self createNewRHS: lhs with: gamma.
            ^self createNewProduction: lhs and: rhsNode]
        ifFalse:
            [newProd := OrderedCollection new.
            newLHS := self newNonterminal: lhs symbol , 'P' with: lhsNames.
            leftChild isCatNode
                ifTrue:
                    [leftChild children addLast: newLHS.
                    newProd add: (self createNewProduction: lhs with: leftChild)]
                ifFalse:
                    [catNode := OrderedCollection new.
                    catNode add: leftChild; add: newLHS.
                    newProd add: (self createNewProduction: lhs with: (ConcatenationNode new addChildrenInitial: catNode))].
            rhsNode := self createCatNode: lhs with: gamma.
            newProd addAllLast: (self createNewProduction: newLHS and: rhsNode).
            ^newProd]!

printOn: aStream
    aStream nextPut: $(.
    self leftChild printOn: aStream.
    aStream nextPutAll: 'list'.
    self rightChild printOn: aStream.
    aStream nextPut: $)! !

!ListNode class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an instance of the regular expression ''a list b'' which is equivalent to a(ba)*.'! !

!LL1Parser methodsFor: 'as yet unclassified' !
 
classInitializationMethodTextForClassNamed: name spec: grammarSpec

    | ws |
    ws := WriteStream on: (String new: 256).
    ws nextPutAll: 'initialize "' , name , ' initialize  " '.
    ws cr.
    ws nextPutAll: ' "  ' , grammarSpec , ' " '.
    ws nextPut: $".
    grammarSpec do:
        [:ch |
        "double embedded double-quote characters"
        ws nextPut: ch.
        ch = $" ifTrue: [ws nextPut: $"]].
    ws nextPut: $".
    ws nextPutAll: ' |  llParserTable table gp | '.
    ws nextPutAll: self parseTable buildParseTable.
    ws nextPutAll: ' self parseTable:  llParserTable  . '.
    ws nextPutAll: ' self startSymbol:   '.
    self startSymbol storeOn: ws.
    ^ws contents!
 
epsilon
    "Answer an object used to represent the empty string (epsilon)."

    ^'<epsilon>'!
  
fastParser

    ^OptimizedLL1Parser buildFrom: self!
  
init

    super init.
    self startSymbol: self myStartSymbol!
  
myStartSymbol

    ^self class startSymbol!
   
parse

    | stack prod |
    stack := Stack new.
    stack push: self startSymbol.
    [stack isEmpty]
        whileFalse: [stack top isTerminal
                ifTrue: [stack top = self nextToken
                        ifTrue:
                            [stack pop.
                            self scanToken]
                        ifFalse: [self raiseExceptionExpectedToken: stack top symbol]]
                ifFalse:
                    [prod := self productionAtNonterminal: stack pop andTerminal: self nextToken.
                    prod rightHandSide reverseDo: [:sym | stack push: sym]]].
    self nextToken = self endOfInput ifFalse: [self raiseExceptionUnparsedTokens]!
 
parseForDerivationTreeAlternative
    "Derivation trees can be build efficiently during a top-down parse.
    This method implements this option (see parseForDerivationTree)."

    | stack prod root parent node |
    stack := Stack new.
    root := DerivationTreeNode symbol: self startSymbol.
    stack push: root.
    [stack isEmpty]
        whileFalse: [stack top isTerminal
                ifTrue: [stack top symbol = self nextToken
                        ifTrue:
                            [stack pop.
                            self scanToken]
                        ifFalse: [self raiseExceptionExpectedToken: stack top symbol]]
                ifFalse:
                    [prod := self productionAtNonterminal: stack top symbol andTerminal: self nextToken.
                    parent := stack pop.
                    prod rightHandSide isEmpty
                        ifTrue:
                            [node := DerivationTreeNode symbol: self epsilon.
                            parent addChild: node]
                        ifFalse: [prod rightHandSide
                                reverseDo:
                                    [:sym |
                                    node := DerivationTreeNode symbol: sym.
                                    parent addFirstChild: node.
                                    stack push: node]]]].
    self nextToken = self endOfInput ifFalse: [self raiseExceptionUnparsedTokens].
    ^root!
 
parseWithTreeBuilder: parseTreeBuilder
    "Rather than building the tree top-down during the parse, it's easier to save
    the productions on a stack and build the tree bottom-up after parsing."

    | stack productionStack |
    productionStack := Stack new.
    stack := Stack new.
    stack push: self startSymbol.
    [stack isEmpty]
        whileFalse: [stack top isTerminal
                ifTrue:
                    ["cancel matching tokens"
                    stack top = self nextToken
                        ifTrue:
                            [stack pop.
                            self scanToken]
                        ifFalse: [self raiseExceptionExpectedToken: stack top]]
                ifFalse:
                    ["expand nonterminal"
                    productionStack push: (self productionAtNonterminal: stack pop andTerminal: self nextToken)
                            @ self nextTokenValue.
                    productionStack top x rightHandSide reverseDo: [:sym | stack push: sym]]].
    self nextToken = self endOfInput ifFalse: [self raiseExceptionUnparsedTokens].
    productionStack do:
        [:prod |
        self prevToken: prod y.
        parseTreeBuilder processProduction: prod x forParser: self].
    ^parseTreeBuilder result!
   
performsLeftmostDerivation

    ^true!

productionAtNonterminal: nont andTerminal: term
    ^self parseTable productionAtNonterminal: nont andTerminal: term!
  
raiseExceptionExpectedToken: aString

    self raiseNoTransitionExceptionErrorString: 'expecting ' , aString!
 
raiseExceptionUnparsedTokens

    self raiseNoTransitionExceptionErrorString: 'unparsed tokens remaining in input'!
   
raiseNoTransitionExceptionErrorString: aString

    ParserTransitionError signalWith: aString!

startSymbol

    ^startSymbol!

startSymbol: argument

    startSymbol := argument!
   
traceParse

    | stack prod |
    self
         cr;
         cr;
         showCR: 'LL Parser trace of:  ' , self scanner contents;
         cr.
    stack := OrderedCollection new.
    stack addFirst: self startSymbol.
    [stack isEmpty]
        whileFalse: [stack first isTerminal
                ifTrue: [stack first = self nextToken
                        ifTrue:
                            [self showCR: 'cancel ''' , stack first asString, ''' from input'.
                            stack removeFirst.
                            self scanToken]
                        ifFalse: [self error: 'raise exception:  top of stack = ''' , stack first asString , ''' next token = ''' , self nextToken asString, '''']]
                ifFalse:
                    [prod := self productionAtNonterminal: stack first andTerminal: self nextToken.
                    self showCR: 'apply production ' , prod printString.
                    stack removeFirst.
                    prod rightHandSide reverseDo: [:sym | stack addFirst: sym]]].
    self nextToken = self endOfInput ifFalse: [self raiseExceptionUnparsedTokens]! !

!LL1Parser class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an LL(1) parser.

Instance Variables:
    parseTable*    <LL1ParserTable> - basic parsing mechanism.
    startSymbol  <Symbol> - my grammars start symbol.

* inherited from AbstractParser'!
 
parseTable: table startSymbol: sym

    | newParser |
    newParser := self new.
    newParser parseTable: table.
    newParser startSymbol: sym.
    ^newParser!
 
startSymbol

    ^startSymbol!

startSymbol: argument

    startSymbol := argument! !

!LLParserTable methodsFor: 'as yet unclassified' !
   
atNonterminal: nont andTerminal: term addProduction: prod

    | row |
    row := self at: nont ifAbsent: [self at: nont put: self newRow].
    ^row at: term add: prod!

isDeterministic

    self detect: [:row | row isDeterministic not]
        ifNone: [^true].
    ^false!
 
newRow

    ^self rowClass new!
   
productionAtNonterminal: nont andTerminal: term

    | row |
    row := self at: nont ifAbsent: [self raiseNoTransitionExceptionErrorString: 'illegal nonterminal symbol encountered:  ' , nont printString].
    ^row at: term ifAbsent: [self raiseNoTransitionExceptionErrorString: 'expecting one of ' , row keys printString , ' but encountered:  ''' , term printString, '''']!
  
raiseNoTransitionExceptionErrorString: aString

    ParserTransitionError signalWith: aString!

rowClass

    ^SetDictionary!
 
spaceOptimize
    "Assumes self isDeterministic."

    self associationsDo: [:assoc | self at: assoc key put: assoc value asDictionary]! !

!LLParserTable class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I implement a two dimensional LL(1) parser table with rows indexed by nonterminals, columns indexed by terminals, and with production table entries.  At the top level I''m a Dictionary from nonterminals to rows; each row is a SetDictionary from terminals to productions.  In deterministic tables (tables without multiple entries) the SetDictionaries can be (and are) converted into simple Dictionaries.'!
 
initialize
    "LLParserTable initialize"
   "
    self noTransitionSignal: (Signal new nameClass: self message: #noTransitionSymbol)
  "! !

!LR0Item methodsFor: 'as yet unclassified' !

= anItem

    ^anItem isLR0Item
        ifTrue: [self leftHandSide = anItem leftHandSide and: [self preDotSymbols = anItem preDotSymbols and: [self postDotSymbols = anItem postDotSymbols]]]
        ifFalse: [false]!
 
asGrammarProduction

    | rhs |
    rhs := OrderedCollection new.
    rhs addAll: self preDotSymbols.
    rhs addAll: self postDotSymbols.
    ^self makeGrammarProductionWithLeftHandSide: self leftHandSide rightHandSide: rhs!

atEnd

    ^self postDotSymbols isEmpty!
  
augmentedGrammarStartSymbol

    ^self class augmentedGrammarStartSymbol!
 
endOfInputSymbol

    ^self class endOfInputSymbol!
   
hash
    "This is redefined because = is redefined."

    ^self leftHandSide hash bitXor: (self preDotSymbols hash bitXor: self postDotSymbols hash)!

isFinalStateItem
    "A final state item is of the form '@@ -> S <endOfInput> . '."

    ^self atEnd and: [self leftHandSide = self augmentedGrammarStartSymbol]!

isLR0Item

    ^true!
 
leftHandSide

    ^leftHandSide!
  
leftHandSide: argument

    leftHandSide := argument!
 
makeGrammarProductionWithLeftHandSide: lhs rightHandSide: rhs

    ^self translationSymbol isNil
        ifTrue: [GrammarProduction leftHandSide: lhs rightHandSide: rhs]
        ifFalse: [TransductionGrammarProduction
                leftHandSide: lhs
                rightHandSide: rhs
                translationSymbol: self translationSymbol]!
   
nextSymbol
    "Answer the symbol immediately to the right of the dot and nil if none."

    ^self postDotSymbols isEmpty
        ifTrue: [nil]
        ifFalse: [self postDotSymbols first]!
  
postDotSymbols

    ^postDotSymbols!
  
postDotSymbols: argument

    postDotSymbols := argument!
 
preDotSymbols

    ^preDotSymbols!

preDotSymbols: argument

    preDotSymbols := argument!
   
printOn: aStream

    self leftHandSide printOn: aStream.
    aStream nextPutAll: ' -> '.
    self preDotSymbols do:
        [:sym |
        sym printOn: aStream.
        aStream space].
    aStream nextPutAll: '. '.
    self postDotSymbols do:
        [:sym |
        sym printOn: aStream.
        aStream space]!
  
shift
    "Conceptually move the dot past the next symbol."

    self atEnd ifFalse: [self preDotSymbols addLast: self postDotSymbols removeFirst]!
  
translationSymbol

    ^translationSymbol!

translationSymbol: argument

    translationSymbol := argument! !

!LR0Item class methodsFor: 'as yet unclassified' !
   
augmentedGrammarStartSymbol

    ^#@@!

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent a context-free grammar production with a ''dot'' somewhere in the right hand side.  I''m used in the construction of LR(0), SLR(1), and LALR(1) parsers.

    leftHandSide -> <preDotSymbols> . <postDotSymbols> => <translationSymbol>


Instance Variables:
    leftHandSide            <Symbol>
    preDotSymbols        <OrderedCollection of: (String + Symbol)>
    postDotSymbols        <OrderedCollection of: (String + Symbol)>
    translationSymbol    <String + Symbol> - used for generating abstract syntax trees.'!
 
endOfInputSymbol

    ^Character endOfInput!
  
initialItemForGrammar: grammar
    "After conceptually augment the grammar with the production
    '@@ -> S <endOfInput>', answer the initial item for construction
    of the LR CFSM."

    ^self
        leftHandSide: self augmentedGrammarStartSymbol
        preDotSymbols: OrderedCollection new
        postDotSymbols: (OrderedCollection with: grammar startSymbol with: self endOfInputSymbol)!
  
leftHandSide: arg1 preDotSymbols: arg2 postDotSymbols: arg3

    | newMe |
    newMe := self new.
    newMe leftHandSide: arg1.
    newMe preDotSymbols: arg2.
    newMe postDotSymbols: arg3.
    ^newMe!
   
leftHandSide: arg1 preDotSymbols: arg2 postDotSymbols: arg3 translationSymbol: arg4

    | newMe |
    newMe := self new.
    newMe leftHandSide: arg1.
    newMe preDotSymbols: arg2.
    newMe postDotSymbols: arg3.
    newMe translationSymbol: arg4.
    ^newMe! !

!LR1Item methodsFor: 'as yet unclassified' !
 
= anItem

    ^anItem isLR1Item
        ifTrue: [self lookahead = anItem lookahead and: [super = anItem]]
        ifFalse: [false]!
 
hash
    "This is redefined because = is redefined."

    ^(self leftHandSide hash bitXor: self lookahead hash)
        bitXor: (self preDotSymbols hash bitXor: self postDotSymbols hash)!
 
isLR1Item

    ^true!
 
lookahead

    ^lookahead!

lookahead: argument

    lookahead := argument!
   
lookaheadTail
    "For an lr1 item 'B -> <alpha> . A <beta> : lookahead' answer
    the string '<beta> lookahead'."

    | string |
    string := self postDotSymbols copy.
    string removeFirst.
    string addLast: self lookahead.
    ^string!

printOn: aStream

    super printOn: aStream.
    aStream nextPutAll: ': '.
    self lookahead printOn: aStream! !

!LR1Item class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I associate a lookahead symbol with a context-free grammar production with a ''dot'' somewhere in the right hand side.  I''m used in the construction of LR(1) parsers.

    leftHandSide -> <preDotSymbols> . <postDotSymbols> : <lookahead> => <translationSymbol>


Instance Variables:
    lookahead            <Symbol>'!
 
initialItemForGrammar: grammar
    "After conceptually augment the grammar with the production
    '@@ -> S <endOfInput>', answer the initial item for construction
    of the LR CFSM."

    ^self
        leftHandSide: self augmentedGrammarStartSymbol
        preDotSymbols: OrderedCollection new
        postDotSymbols: (OrderedCollection with: grammar startSymbol with: self endOfInputSymbol)
        lookahead: self endOfInputSymbol!

leftHandSide: arg1 preDotSymbols: arg2 postDotSymbols: arg3 lookahead: arg4

    | newMe |
    newMe := self new.
    newMe leftHandSide: arg1.
    newMe preDotSymbols: arg2.
    newMe postDotSymbols: arg3.
    newMe lookahead: arg4.
    ^newMe!
   
leftHandSide: arg1 preDotSymbols: arg2 postDotSymbols: arg3 lookahead: arg4 translationSymbol: arg5

    | newMe |
    newMe := self new.
    newMe leftHandSide: arg1.
    newMe preDotSymbols: arg2.
    newMe postDotSymbols: arg3.
    newMe lookahead: arg4.
    newMe translationSymbol: arg5.
    ^newMe! !

!LR1Parser methodsFor: 'as yet unclassified' !
   
acceptSymbol

    ^self lrParserStateClass acceptSymbol!
  
actionAt: currState

    ^currState actionFor: self nextToken!

at: state transitionFor: symbol

    ^state transitionFor: symbol!

fastParser

    ^OptimizedLR1Parser buildFrom: self!
  
finalState

    ^finalState!
  
finalState: argument

    finalState := argument!
 
init

    super init.
    self finalState: self myFinalState!

lalr1AnalyzeConflicts: stateSet originalGrammar: aGrammar

    ^self parseTable lalr1AnalyzeConflicts: stateSet originalGrammar: aGrammar!

lrParserStateClass

    ^LRParserState!
   
myFinalState

    ^self class finalState!
 
parse

    | stack action currState |
    stack := Stack new.
    currState := self startState.
    stack push: currState.
    [currState = self finalState or: [(action := self actionAt: currState) = self acceptSymbol]]
        whileFalse:
            [currState := action isGrammarProduction
                        ifTrue:
                            ["reduce"
                            stack pop: action rightHandSide size.
                            self at: stack top transitionFor: action leftHandSide]
                        ifFalse:
                            ["shift"
                            self scanToken.
                            action].
            stack push: currState]!
 
parseWithTreeBuilder: parseTreeBuilder

    | stack currState action |
    stack := Stack new.
    currState := self startState.
    stack push: currState.
    [currState = self finalState or: [(action := self actionAt: currState) = self acceptSymbol]]
        whileFalse:
            [currState := action isGrammarProduction
                        ifTrue:
                            ["reduce"
                            stack pop: action rightHandSide size.
                            parseTreeBuilder processProduction: action forParser: self.
                            self at: stack top transitionFor: action leftHandSide]
                        ifFalse:
                            ["shift"
                            self scanToken.
                            action].
            stack push: currState].
    ^parseTreeBuilder result!

performsRightmostDerivation

    ^true!
   
startState

    ^self parseTable!
 
traceParse

    | stack action currState nextState |
    self
         cr;
         cr;
         showCR: 'LR Parser trace of:  ' , self scanner contents;
         cr.
    stack := Stack new.
    currState := self startState.
    stack push: currState.
    [currState = self finalState or: [(action := self actionAt: currState) = self acceptSymbol]]
        whileFalse:
            [currState := action isGrammarProduction
                        ifTrue:
                            ["reduce"
                            stack pop: action rightHandSide size.
                            nextState := self at: stack top transitionFor: action leftHandSide.
                            self showCR: 'reduce by ' , action printString , ' then goto state ' , nextState hash printString.
                            nextState]
                        ifFalse:
                            ["shift"
                            self showCR: 'shift on ''' , self nextToken asString, ''' to state ' , action hash printString.
                            self scanToken.
                            action].
            stack push: currState]! !

!LR1Parser class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an LR parser.

Instance Variables:
    parseTable*    <LRParserState> - basic parsing mechanism, a CFSM.
    finalState        <LRParserState> - final state of my CFSM.

* inherited from AbstractParser'!
   
finalState

    ^finalState!
  
finalState: argument

    finalState := argument!
 
parseTable: table finalState: state

    | newParser |
    newParser := self new.
    newParser parseTable: table.
    newParser finalState: state.
    ^newParser! !

!LRParserState methodsFor: 'as yet unclassified' !
   
acceptSymbol

    ^self class acceptSymbol!
   
actionFor: aTerminal

    | action |
    (action := self reductionFor: aTerminal) isNil ifTrue: [(action := self transitionFor: aTerminal) isNil ifTrue: [action := self acceptSymbol]].
    ^action!
   
addSuccessor: node withEdgeLabeled: label
    "overridden for Dictionary edgeLabelMap"

    (self edgeLabelMap includesKey: label)
        ifTrue: [self error: 'check it out'].
    self edgeLabelMap at: label put: node!

appendHashTo: sym
    "Answer a new nonterminal or terminal with my hash value appended."

    | newSym |
    newSym := sym , self symbolSuffixSeparatorString , self hash printString.
    ^sym isNonterminal
        ifTrue: [newSym asNonterminal]
        ifFalse: [newSym]!
 
buildGrammarWithProductions: prods startSymbol: aSymbol

    ^self grammarClass buildGrammarWithProductions: prods startSymbol: aSymbol!
  
buildLalrGrammarWith: stateDict originalGrammar: aGrammar
    "Answer my corresponding LALR(1) grammar. The new productions will not be in any
    particular order so we must be sure to locate and explicitly specify the new start symbol."

    | productions startSymbol pattern startProds |
    productions := OrderedCollection new.
    self
        collectLalrProductionsIn: productions
        andProdMapsIn: stateDict
        traversedStates: Set new.
    pattern := aGrammar startSymbol , self symbolSuffixSeparatorString , '*'.
    startProds := productions select: [:prod | pattern match: prod leftHandSide].
    startProds size = 1
        ifTrue: [startSymbol := startProds first leftHandSide]
        ifFalse: [^nil "self error: 'multiple start symbols in LALR grammar'"].
    ^self buildGrammarWithProductions: productions startSymbol: startSymbol!
   
collectLalrProductionsIn: aCollection andProdMapsIn: stateDict traversedStates: aSet

    | newProds |
    (aSet includes: self)
        ifFalse:
            [aSet add: self.
            self isReduceState ifTrue: [self
                    reductionsDo:
                        [:prod |
                        newProds := self makeLalrProductionFor: prod.
                        (stateDict includesKey: self)
                            ifTrue:
                                ["only need to retain data for conflict states"
                                newProds do: [:np | (stateDict at: self)
                                        at: prod add: np leftHandSide]].
                        aCollection addAll: newProds]].
            self successorsExceptSelfDo: [:state | state
                    collectLalrProductionsIn: aCollection
                    andProdMapsIn: stateDict
                    traversedStates: aSet]]!

goto: aState on: transitionSymbol

    self addSuccessor: aState withEdgeLabeled: transitionSymbol.
    aState addPredecessor: self withEdgeLabeled: transitionSymbol!
   
grammarClass

    ^Grammar!
   
grammarProductionClass

    ^GrammarProduction!
   
hasReduceReduceConflict
    "Answer true if there is a reduce/reduce conflict in this state, and false
    otherwise."

    ^self reduceMap isDeterministic not!

hasShiftReduceConflict
    "Answer true if there is a shift/reduce conflict in this state, and false
    otherwise."

    | reduceSyms shiftSyms |
    reduceSyms := self reduceMap keys.
    shiftSyms := self edgeLabelMap keys.
    ^reduceSyms size + shiftSyms size ~= (reduceSyms union: shiftSyms) size!
  
init

    super init.
    self edgeLabelMap: Dictionary new.        "overrides use of SetDictionary in superclass"
    self reduceMap: SetDictionary new!
   
isReduceState

    ^self reduceMap isEmpty not!
   
lalr1AnalyzeConflicts: stateSet originalGrammar: aGrammar

    | conflictStateMap newGrammar prodMap prod follows conflictStates |
    conflictStates := Set new.
    conflictStateMap := Dictionary new: stateSet size.
    stateSet do: [:state | conflictStateMap at: state put: SetDictionary new].
    (newGrammar := self buildLalrGrammarWith: conflictStateMap originalGrammar: aGrammar) isNil
        ifTrue: [^false].
    "rebuild reduce maps for inconsistent states"
    stateSet do:
        [:state |
        state reduceMap: SetDictionary new.
        prodMap := conflictStateMap at: state.
        prodMap
            associationsDo:
                [:assoc |
                prod := assoc key.
                follows := Set new.
                assoc value do: [:nonterm | (newGrammar followSetOf: nonterm)
                        do: [:term | follows add: (term copyUpToLast: self symbolSuffixSeparatorChar)]].
                follows do: [:term | state reduceBy: prod on: term]].
        state hasReduceReduceConflict | state hasShiftReduceConflict ifTrue: [conflictStates add: state]].
    ^conflictStates isEmpty!
   
makeLalrProductionFor: prod

    | stateSet rhs newProds lhs currState |
    stateSet := Set with: self.
    prod rightHandSide reverseDo: [:sym | stateSet := stateSet inject: Set new into: [:set :state | set union: (state predecessorLabelMap at: sym)]].
    newProds := Set new.
    stateSet do:
        [:state |
        lhs := state appendHashTo: prod leftHandSide.
        currState := state.
        rhs := OrderedCollection new.
        prod rightHandSide do:
            [:sym |
            rhs add: (currState appendHashTo: sym).
            currState := currState transitionFor: sym].
        newProds add: (self makeProductionWithLeftHandSide: lhs rightHandSide: rhs)].
    ^newProds!
  
makeProductionWithLeftHandSide: lhs rightHandSide: rhs

    ^self grammarProductionClass leftHandSide: lhs rightHandSide: rhs!

printOn: aStream

    super printOn: aStream.
    aStream cr.
    self reduceMap printOn: aStream!
  
reduceBy: aProduction on: aTerminal

    self reduceMap at: aTerminal add: aProduction!
   
reduceMap

    ^reduceMap!

reduceMap: argument

    reduceMap := argument!
   
reductionFor: aSymbol

    ^self reduceMap
        at: aSymbol
        ifAbsent: [nil]
        ifNotUnique: [self error: 'reduce/reduce conflict in parser']!
  
reductionsDo: aBlock
    "Evaluate aBlock for each of my reduce productions."

    self reduceMap elementsDo: aBlock!

spaceOptimizeMap
    "Predecessors are only needed for LALR(1) analysis."

    super spaceOptimizeMap.
    self predecessorLabelMap: nil!
   
standardErrorString

    ^'unexpected token encountered:  '!
  
successors
    "overriden for Dictionary edgeLabelMap"

    ^self edgeLabelMap values!
   
symbolSuffixSeparatorChar

    ^self class symbolSuffixSeparatorChar!
 
symbolSuffixSeparatorString

    ^String with: self symbolSuffixSeparatorChar! !

!LRParserState class methodsFor: 'as yet unclassified' !
  
acceptSymbol

    ^#accept!
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent a node in an LR parser characteristic finite state machine.

Instance Variables:

    edgeLabelMap        <Dictionary from: symbols to: successors> - overridden from EdgeLabeledDigraphNode for efficiency since only deterministic FSAs are constructed.
    reduceMap        <SetDictionary from: symbols to: productions>'!
 
initialize
    "LRParserState initialize"
    "
    self noTransitionSignal: (Signal new nameClass: self message: #noTransitionSymbol)
    "!
   
symbolSuffixSeparatorChar

    ^$.! !

!NodeLabeledDigraphNode methodsFor: 'as yet unclassified' !
  
label

    ^label!

label: argument

    label := argument! !

!NodeLabeledDigraphNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I add labels to my nodes.  Node labels are assumed to be unique (see LabeledDigraph) although hashing and such is still done based on the node itself.

Instance Variables:
    label    <String>'!
   
label: arg1

    | newMe |
    newMe := self new.
    newMe label: arg1.
    ^newMe! !

!NonterminalNode methodsFor: 'as yet unclassified' !
 
asGrammarSymbol
    "Answer my symbol as a Nonterminal (Symbol)."

    ^self symbol asSymbol!

collectSymbol

    | regexpr |
    regexpr := OrderedCollection new.
    regexpr add: self asGrammarSymbol.
    ^regexpr!
  
doTransformingNow

    ^false!

hasBeenTransformed
    ^true!
  
isAltNode

    ^false!

isCatNode

    ^false!

isEpsilonNode

    ^false!

isTerminalNode

    ^false!
   
needTransforming
    ^false!
   
processTransformation: prod with: lhsNames

    ^OrderedCollection new! !

!NonterminalNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I hold a nonterminal.'! !

!OctalCharNode methodsFor: 'as yet unclassified' !
  
myChar
    "Answer the Character represented by the receiver.
    The spec is of the form '\oOOO'."

    | spec |
    spec := self charSpec.
    (spec size = 5 and: [spec first = $\ and: [(spec at: 2)
                = $o]])
        ifTrue: [^Character value: ('8r' , (spec copyFrom: 3 to: 5)) asNumber]
        ifFalse: [self error: 'Octal character specifications must be of the form ''\oOOO''.']! !

!OctalCharNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a atomic character of a regular expression.  I am specified by a String of the form ''\oOOO'' where each O is a octal digit (0-7) and OOO is my corresponding ASCII value.

'! !

!OptimizedLL1Parser methodsFor: 'as yet unclassified' !
   
changeToObjectTable: llParseTable

    | terms objectTable |
    self nonterminals: llParseTable keys asOrderedCollection asArray.
    terms := Set new.
    llParseTable do: [:row | terms addAll: row keys].
    self terminals: terms asOrderedCollection asArray.
    objectTable := Array new: self nonterminals size.
    ^self convert: llParseTable to: objectTable!

classInitializationMethodTextForClassNamed: name spec: grammarSpec
    | ws |
    ws := WriteStream on: (String new: 2048).
    ws
        nextPutAll: 'initialize';
        crtab;
        nextPut: $";
        nextPutAll: name;
        nextPutAll: ' initialize"';
        crtab;
        nextPut: $".
    grammarSpec do:
        [:ch |
        "double embedded double-quote characters"
        ws nextPut: ch.
        ch = $" ifTrue: [ws nextPut: $"]].
    ws
        nextPut: $";
        cr;
        crtab;
        nextPutAll: '| table prodTable |';
        crtab.
    self reconstructOn: ws.
    ^ws contents!

convert: llParseTable to: objectTable
    | nonterms terms row |
    nonterms := self nonterminals.
    terms := self terminals.
    llParseTable
        associationsDo:
            [:assoc1 |
            row := Array new: terms size.
            objectTable at: (nonterms indexOf: assoc1 key)
                put: row.
            assoc1 value associationsDo: [:assoc2 | row at: (terms indexOf: assoc2 key)
                    put: assoc2 value]].
    ^objectTable!
  
convertToTable: ll1Parser

    self scanner: ll1Parser scanner fastScanner.
    self parseTable: (self changeToObjectTable: ll1Parser parseTable).
    self treeBuilder:  ll1Parser treeBuilder.
    self startSymbol: ll1Parser startSymbol!
  
endOfInputErrorString

    ^'end of input encountered'!
   
init

    super init.
    self nonterminals: self myNonterminals.
    self terminals: self myTerminals!
 
mapProductionToInteger
    "Answer an Array of all grammar symbols - nonterminals, terminals,
    and translation symbols."

    | transSyms |
    transSyms := Set new.
    parseTable do: [:row | row do: [:ea | ea isGrammarProduction ifTrue: [ea hasTranslation ifTrue: [transSyms add: ea translationSymbol]]]].
    ^self nonterminals , self terminals , transSyms asOrderedCollection asArray!
  
myNonterminals

    ^self class nonterminals!
 
myTerminals

    ^self class terminals!
   
myTokenTypeTable

    ^self class tokenTypeTable!
 
nonterminals
    ^nonterminals!

nonterminals: arg
    nonterminals := arg!
 
parseError

    self raiseNoTransitionExceptionErrorString:
        (scanner tokenType == self endOfInputToken
            ifTrue: [self endOfInputErrorString]
            ifFalse: [self standardErrorString , '''' , scanner tokenType printString , ''''])!

productionAtNonterminal: nont andTerminal: term
    | nontIndex termIndex prod |
    nontIndex := self nonterminals indexOf: nont.
    termIndex := self terminals indexOf: term.
    ^(prod := (self parseTable at: nontIndex)
                at: termIndex) isNil
        ifTrue: [self raiseNoTransitionExceptionErrorString: (term = self endOfInputToken
                    ifTrue: [self endOfInputErrorString]
                    ifFalse: [self standardErrorString , '''' , term printString , ''''])]
        ifFalse: [prod]!

raiseNoTransitionExceptionErrorString: aString

    ParserTransitionError signalWith: aString!

reconstructOn: aStream

    | prodTable n |
    prodTable := self mapProductionToInteger.
    aStream nextPutAll: 'prodTable := '.
    prodTable reconstructOn: aStream.
    aStream
        period;
        crtab;
        nextPutAll: 'self nonterminals:  (prodTable copyFrom: 1 to:  ';
        nextPutAll: (n := self nonterminals size) printString;
        nextPutAll: ').';
        crtab;
        nextPutAll: 'self terminals:  (prodTable copyFrom: ';
        nextPutAll: (n + 1) printString;
        nextPutAll: ' to: ';
        nextPutAll: (self terminals size + n) printString;
        nextPutAll: ').';
        crtab;
        nextPutAll: 'table := '.
    self parseTable reconstructOn: aStream using: prodTable.
    aStream
        period;
        crtab;
        nextPutAll: 'self constructParseTable: table  with: prodTable.';
        crtab;
        nextPutAll: 'self startSymbol: '.
    self startSymbol storeOn: aStream!

scannerErrorSignal

    ^OptimizedScanner noTransitionSignal!
 
standardErrorString

    ^'unexpected token encountered:  '!
  
terminals
    ^terminals!
  
terminals: arg
    terminals := arg! !

!OptimizedLL1Parser class methodsFor: 'as yet unclassified' !

buildFrom: ll1Parser

    ^self new convertToTable: ll1Parser!

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an LL(1) parser represented efficiently in Array table format.

Instance variables:
    tokenTypeTable <Array of: String>    - the integer mapping for terminals and nonterminals'!
  
constructGrammarProduction: arg with: prodTable

    | rhs |
    (arg at: 2) isEmpty
        ifTrue: [rhs := OrderedCollection new]
        ifFalse:
            [rhs := OrderedCollection new.
            (arg at: 2)
                do: [:ea | rhs addLast: (prodTable at: ea)]].
    ^GrammarProduction
        leftHandSide: (prodTable at: (arg at: 1))
        rightHandSide: rhs!
   
constructParseTable: table with: prodTable

    | ea row |
    parseTable := Array new: table size.
    1 to: table size do:
        [:index |
        row := Array new: (table at: index) size.
        parseTable at: index put: row.
        1 to: (table at: index) size do:
            [:i |
            ea := (table at: index)
                        at: i.
            ea isNil ifFalse: [ea isInteger
                    ifTrue: [row at: i put: ea]
                    ifFalse: [ea size == 2
                            ifTrue: [row at: i put: (self constructGrammarProduction: ea with: prodTable)]
                            ifFalse: [row at: i put: (self constructTransductionGrammarProduction: ea with: prodTable)]]]]]!

constructTransductionGrammarProduction: arg with: prodTable

    | rhs |
    (arg at: 2) isEmpty
        ifTrue: [rhs := OrderedCollection new]
        ifFalse:
            [rhs := OrderedCollection new.
            (arg at: 2)
                do: [:ea | rhs addLast: (prodTable at: ea)]].
    ^TransductionGrammarProduction
        leftHandSide: (prodTable at: (arg at: 1))
        rightHandSide: rhs
        translationSymbol: (prodTable at: (arg at: 3))!
   
initialize
    "OptimizedLL1Parser initialize"

    "self noTransitionSignal: (Signal new nameClass: self message: #noTransitionSymbol)
     "!
 
nonterminals
    ^nonterminals!

nonterminals: arg
    nonterminals := arg!
 
terminals
    ^terminals!
  
terminals: arg
    terminals := arg! !

!OptimizedLR1Parser methodsFor: 'as yet unclassified' !
  
actionAt: currState

    | action index |
    ((index := tokenTypeTable indexOf: self nextToken) = 0 or: [
            (action := (parseTable at: currState) at: index) isNil]) ifTrue: [
        (scanner finalStateTable includes: currState)
            ifTrue: [^#accept]
            ifFalse: [self parseError]].
    ^action!

assignNextIDAfter: id toSuccessorOf: state

    | nextID nextState |
    nextID := id + 1.
    state edgeLabelMap
        associationsDo:
            [:assoc |
            tokenTypeTable add: assoc key.
            nextState := assoc value.
            nextState stateID isNil
                ifTrue:
                    [nextState stateID: nextID.
                    nextID := self assignNextIDAfter: nextID toSuccessorOf: nextState]].
    state reduceMap associationsDo: [:assoc | tokenTypeTable add: assoc key].
    ^nextID!
  
at: currState transitionFor: symbol

    | value |
    (value := (parseTable at: currState)
                at: (tokenTypeTable indexOf: symbol)) isNil ifTrue: [self raiseNoTransitionExceptionErrorString: (symbol = self endOfInputToken
                ifTrue: [self endOfInputErrorString]
                ifFalse: [self standardErrorString , '''' , symbol printString , ''''])].
    ^value!
   
changeToObjectTable: lrParserState

    | sizePlusOne objectTable |
    lrParserState stateID notNil ifTrue: [lrParserState nilOutStateIDs].
    lrParserState stateID: self startState.
    self tokenTypeTable: Set new.
    sizePlusOne := self assignNextIDAfter: self startState toSuccessorOf: lrParserState.
    self tokenTypeTable: tokenTypeTable asOrderedCollection asArray.
    objectTable := Array new: sizePlusOne - 1.
    ^self convert: lrParserState to: objectTable!
  
classInitializationMethodTextForClassNamed: name spec: grammarSpec
    | ws |
    ws := WriteStream on: (String new: 2048).
    ws
        nextPutAll: 'initialize';
        crtab;
        nextPut: $";
        nextPutAll: name;
        nextPutAll: ' initialize"';
        crtab;
        nextPut: $".
    grammarSpec do:
        [:ch |
        "double embedded double-quote characters"
        ws nextPut: ch.
        ch = $" ifTrue: [ws nextPut: $"]].
    ws
        nextPut: $";
        cr;
        crtab;
        nextPutAll: '| table prodTable |';
        crtab.
    self reconstructOn: ws.
    ^ws contents!

convert: state to: objectTable
    "I try to create a table that maps state ( represented by integer ) to state or state to
    production"

    | arr nextState |
    arr := Array new: self tokenTypeTable size.
    objectTable at: state stateID put: arr.
    state edgeLabelMap
        associationsDo:
            [:assoc |
            nextState := assoc value.
            (objectTable at: nextState stateID) isNil ifTrue: [self convert: nextState to: objectTable].
            arr at: (tokenTypeTable indexOf: assoc key)
                put: nextState stateID].
    state reduceMap associationsDo: [:assoc | arr at: (tokenTypeTable indexOf: assoc key)
            put: assoc value first].
    ^objectTable!

convertToTable: lr1Parser

    self scanner: lr1Parser scanner fastScanner.
    self parseTable: (self changeToObjectTable: lr1Parser parseTable).
    self treeBuilder:  lr1Parser treeBuilder.
    self finalState: lr1Parser finalState stateID!

endOfInputErrorString

    ^'end of input encountered'!
   
init

    super init.
    self tokenTypeTable: self myTokenTypeTable!

mapProductionToInteger
    "Answer an Array of all grammar symbols - nonterminals, terminals,
    and translation symbols."

    | transSyms |
    transSyms := Set new.
    parseTable do: [:row | row do: [:ea | ea isGrammarProduction ifTrue: [ea hasTranslation ifTrue: [transSyms add: ea translationSymbol]]]].
    ^self tokenTypeTable , transSyms asOrderedCollection asArray!
 
myTokenTypeTable

    ^self class tokenTypeTable!
 
parseError

    self raiseNoTransitionExceptionErrorString: (scanner tokenType == self endOfInputToken
            ifTrue: [self endOfInputErrorString]
            ifFalse: [self standardErrorString , '''' , scanner tokenType printString , ''''])!
 
raiseNoTransitionExceptionErrorString: aString

    ParserTransitionError signalWith: aString!

reconstructOn: aStream
    "Recreate a parse table and a token type table"

    | prodTable |
    prodTable := self mapProductionToInteger.
    aStream nextPutAll: 'prodTable := '.
    prodTable reconstructOn: aStream.
    aStream
        period;
        crtab;
        nextPutAll: 'self tokenTypeTable:  (prodTable copyFrom: 1 to:  ';
        nextPutAll: tokenTypeTable size printString;
        nextPutAll: ').';
        crtab;
        nextPutAll: 'table := '.
    self parseTable reconstructOn: aStream using: prodTable.
    aStream
        period;
        crtab;
        nextPutAll: 'self constructParseTable: table  with: prodTable.';
        crtab;
        nextPutAll: 'self finalState: '.
    self finalState storeOn: aStream!
 
scannerErrorSignal

    ^OptimizedScanner noTransitionSignal!
 
standardErrorString

    ^'unexpected token encountered:  '!
  
startState

    ^1!
   
tokenTypeTable

    ^tokenTypeTable!
  
tokenTypeTable: arg

    tokenTypeTable := arg! !

!OptimizedLR1Parser class methodsFor: 'as yet unclassified' !

buildFrom: fsaParser

    ^self new convertToTable: fsaParser!

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an LR parser represented efficietly in Array table form.

Instance variables:
    tokenTypeTable <Array of: String>    - the integer mapping of terminals and nonterminals'!
 
constructGrammarProduction: arg with: prodTable

    | rhs |
    (arg at: 2) isEmpty
        ifTrue: [rhs := OrderedCollection new]
        ifFalse:
            [rhs := OrderedCollection new.
            (arg at: 2)
                do: [:ea | rhs addLast: (prodTable at: ea)]].
    ^GrammarProduction leftHandSide: (prodTable at: (arg at: 1))
        rightHandSide: rhs!

constructParseTable: table with: prodTable

    | ea row |
    parseTable := Array new: table size.
    1 to: table size do:
        [:index |
        row := Array new: (table at: index) size.
        parseTable at: index put: row.
        1 to: (table at: index) size do:
            [:i |
            ea := (table at: index)
                        at: i.
            ea isNil ifFalse: [ea isInteger
                    ifTrue: [row at: i put: ea]
                    ifFalse: [ea size == 2
                            ifTrue: [row at: i put: (self constructGrammarProduction: ea with: prodTable)]
                            ifFalse: [row at: i put: (self constructTransductionGrammarProduction: ea with: prodTable)]]]]]!

constructTransductionGrammarProduction: arg with: prodTable

    | rhs |
    (arg at: 2) isEmpty
        ifTrue: [rhs := OrderedCollection new]
        ifFalse:
            [rhs := OrderedCollection new.
            (arg at: 2)
                do: [:ea | rhs addLast: (prodTable at: ea)]].
    ^TransductionGrammarProduction
        leftHandSide: (prodTable at: (arg at: 1))
        rightHandSide: rhs
        translationSymbol: (prodTable at: (arg at: 3))!
   
initialize
    "OptimizedLR1Parser initialize"
    "
    self noTransitionSignal: (Signal new nameClass: self message: #noTransitionSymbol)
    "!
  
tokenTypeTable

    ^tokenTypeTable!
  
tokenTypeTable: arg

    tokenTypeTable := arg! !

!OptimizedScanner methodsFor: 'as yet unclassified' !

assignNextIDAfter: id toSuccessorOf: state
    "I try to assing a number to fsa in order to create a fsa table."

    | nextID nextState |
    nextID := id + 1.
    state edgeLabelMap
        associationsDo:
            [:assoc |
            nextState := assoc value.
            nextState stateID isNil
                ifTrue:
                    [nextState stateID: nextID.
                    nextState isFSAFinalState ifTrue: [(finalStateTable includes: nextState)
                            ifFalse: [finalStateTable at: nextID put: nextState]].
                    nextID := self assignNextIDAfter: nextID toSuccessorOf: nextState]].
    ^nextID!

at: state tokenTypeAndActionFor: aString
    "The current implementation does not handle overlapping token classes. Hence, a final state
    can only represent a literal or a single token class. Therefore, if not a literal then it must be
    the token class."

    | tc arr |
    ((arr := (finalStateTable at: state) at: 1) isNil or: [arr includes: aString])
        ifTrue: [^TokenTypeActionHolder type: aString action: nil].
    tc := ((finalStateTable at: state)
                at: 2) first .
    ^TokenTypeActionHolder type: tc tokenType action: tc action!

at: currState transitionFor: symbol

    | value |

    (value := (fsa at: currState) at: symbol asciiValue + 1) isNil ifTrue: [
        (finalStateTable at: currState) isNil ifTrue: [
            self raiseNoTransitionExceptionErrorString:
                (symbol == self endOfInputToken
                    ifTrue: [self endOfInputErrorString]
                    ifFalse: [self standardErrorString , '''' , symbol printString , '''']).
        ].
    ].
    ^value!

atEnd

    ^nextChar == self endOfInputToken        "end-of-file character"!
  
changeFSAToObjectTable: fsaState

    | sizePlusOne objectTable  |
    fsaState stateID notNil ifTrue: [fsaState nilOutStateIDs].
    fsaState stateID:  self startState.
    self finalStateTable: Dictionary new.
    sizePlusOne := self assignNextIDAfter: self startState toSuccessorOf: fsaState.
    objectTable := Array new: sizePlusOne - 1.
    self convert: fsaState to: objectTable.
    self modifyFSAFinalStates: sizePlusOne - 1.        "convert Dictionary to Array for speed"
    ^objectTable!
   
classInitializationMethodTextForClassNamed: name spec: tokenSpec
    | ws |

    ws := WriteStream on: (String new: 2048).
    ws
        nextPutAll: 'initialize';
        crtab;
        nextPut: $";
        nextPutAll: name;
        nextPutAll: ' initialize"';
        crtab;
        nextPut: $".
    tokenSpec do:
        [:ch |
        "double embedded double-quote characters"
        ws nextPut: ch.
        ch = $" ifTrue: [ws nextPut: $"]].
    ws
        nextPut: $";
        cr;
        crtab;
        nextPutAll: '| table |';
        crtab.
    self reconstructOn: ws.
    ^ws contents!

convert: state to: objectTable
"I try to create a table that maps state ( represented by integer ) to state"

    | arr nextState |
    arr := Array new: 256.
    objectTable at: state stateID put: arr.
    state edgeLabelMap
        associationsDo:
            [:assoc |
            nextState := assoc value.
            (objectTable at: nextState stateID) isNil ifTrue: [self convert: nextState to: objectTable].
            arr at: assoc key asciiValue + 1 put: nextState stateID].
    ^objectTable!
  
convertToTable: fsaScanner

    self fsa: (self changeFSAToObjectTable: fsaScanner fsa)!
  
endOfInputErrorString

    ^'end of input encountered'!
   
finalStateTable

    ^finalStateTable!

finalStateTable: arg

    finalStateTable := arg!
 
fsaCurrentState

    ^fsaCurrentState!

fsaCurrentState: arg

    fsaCurrentState := arg!
 
getNextChar
    "Source will answer an eof char when no more input is available.
    Subclasses may override this to avoid unnecessary buffering."

    buffer nextPut: nextChar.
    nextChar := source next!
 
init

    super init.
    self finalStateTable: self myFinalStateTable.
    self fsaCurrentState: self startState!
  
modifyFSAFinalStates: index
    "Convert Dictionary and its values to Array of Array"

    | tokenSet table |
    table := Array new: index.
    finalStateTable do:
        [:st |
        tokenSet := Array new: 2.
        tokenSet at: 1 put: st literalTokens asOrderedCollection asArray; at: 2 put: st tokenClasses asArray.
        table at: st stateID put: tokenSet].
    self finalStateTable: table!
 
myFinalStateTable

    ^self class finalStateTable!
   
raiseNoTransitionExceptionErrorString: aString

    ScannerTransitionError signalWith: aString!
   
reconstructFinalStateTableOn: aStream

    aStream nextPutAll: 'table := '.
    finalStateTable reconstructOn: aStream.
    aStream
        period;
        crtab;
        nextPutAll: 'self constructFinalStateTable: table'!
   
reconstructFSAOn: aStream

    aStream nextPutAll: 'self fsa: '.
    fsa reconstructOn: aStream.
    aStream period; crtab!
 
reconstructOn: aStream
    "Recreate fsa and final state tables"

    self reconstructFSAOn: aStream.
    self reconstructFinalStateTableOn: aStream!
   
signalEndOfInput
    "Set scanner to the end-of-input state."

    tokenType := token := self endOfInputToken!
   
standardErrorString

    ^'illegal character encountered:  '!
 
startState

    ^1!
   
transitionFor: symbol

    | value |
    (value := (fsa at: fsaCurrentState)
                at: symbol asciiValue) isNil
        ifTrue:
            [(finalStateTable at: fsaCurrentState) isNil ifTrue: [self raiseNoTransitionExceptionErrorString: (symbol == self endOfInputToken
                        ifTrue: [self endOfInputErrorString]
                        ifFalse: [self standardErrorString , '''' , symbol printString , ''''])].
            ^false]
        ifFalse:
            [fsaCurrentState := value.
            ^true]!
  
typeActionHolderClass

    ^TokenTypeActionHolder! !

!OptimizedScanner class methodsFor: 'as yet unclassified' !
   
buildFrom: fsaScanner

    ^self new convertToTable: fsaScanner!
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class of scanner that scans a source string and breaks it up into tokens
using a table created by converting FSA to integer.

instance Variables:
    finalStateTable        - a table that maps integer ( represented as final state ) to
                           literal tokens and token classes.
    fsaCurrennState    - a current state of FSA'!

constructFinalStateTable: arg

    | row |
    finalStateTable := Array new: arg size.
    1 to: arg size do:
        [:index |
        row := Array new: 2.
        (arg at: index) isNil
            ifFalse:
                [row at: 1 put: ((arg at: index)
                        at: 1).
                row at: 2 put: (self constructTokenClassification: ((arg at: index)
                            at: 2))].
        finalStateTable at: index put: row]!

constructTokenClassification: aCollection

    | tc ea arr |
    aCollection size == 1
        ifTrue:
            [tc := aCollection first.
            ^Array with: (TokenClassification
                    tokenType: (tc at: 1)
                    action: (tc at: 2))]
        ifFalse:
            [arr := Array new: aCollection size.
            1 to: aCollection size do:
                [:index |
                ea := aCollection at: index.
                arr at: index put: (TokenClassification
                        tokenType: (ea at: 1)
                        action: (ea at: 2))].
            ^arr]!
   
finalStateTable

    ^finalStateTable!

finalStateTable: arg

    finalStateTable := arg!
 
initialize
    "OptimizedScanner initialize"
    
    self noTransitionSignal: 
        (TGenException new messageText: 'Class: ', self name, ' noTransitionSymbol').
!

noTransitionSignal
    ^noTransitionSignal
!

noTransitionSignal: anObject

    noTransitionSignal := anObject.!

tokenTable

    ^tokenTable!
  
tokenTable: arg

    tokenTable := arg! !

!OptimizedScannerWithOneTokenLookahead methodsFor: 'as yet unclassified' !
   
errorPosition
    "Answer the source position of the last acceptable character."

    ^self savePosition max: 1!
 
isFSAFinalState: aState
    "Answer true if aState is a final state, false otherwise."

    ^((self finalStateTable at: aState) at: 1) notNil!
   
savePosition

    ^savePosition!
  
savePosition: argument

    savePosition := argument!
 
scanToken
    "Scan the next token and compute its token type."

    | nextState tok typeAction stateStack saveChar saveState |
    stateStack := Stack new.
    self atEnd
        ifTrue: [self signalEndOfInput]
        ifFalse:
            [stateStack push: self startState.
            [(nextState := self at: stateStack top transitionFor: self nextChar) isNil]
                whileFalse:
                    [stateStack push: nextState.
                    self getNextChar].
             (self isFSAFinalState: stateStack top)
                ifFalse:
                    ["save the current position for error notification"
                    saveChar := self nextChar.
                    saveState := stateStack top.
                    self savePosition: self position + (self atEnd
                                ifTrue: [1]
                                ifFalse: [0]).
                    "backup to the previous final state or to the start state"
                    [stateStack size = 1 or: [self isFSAFinalState: stateStack top]]
                        whileFalse:
                            [stateStack pop.
                            self putBackChar].
                    stateStack size = 1 ifTrue:
                        ["backed up to the start state so signal an error"
                        saveState transitionFor: saveChar]].
            "answer the newly scanned token"
            tok := self buffer contents.
            typeAction := self at: stateStack top tokenTypeAndActionFor: tok.
            self tokenType: typeAction type.
            self token: tok.
            self buffer reset.
            typeAction action notNil ifTrue: [self perform: typeAction action]]! !

!OptimizedScannerWithOneTokenLookahead class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class needs a comment.'! !

!OptimizedScannerWithTwoTokenLookahead class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class should be implemented analagously to the way in which OptimizedScannerWithOneTokenLookahead was implemented from FSABasedScannerWithOneTokenLookahead.  This is left as an exercise for the reader.'! !

!OptionalNode methodsFor: 'as yet unclassified' !
  
asPureRegExpr
    "Answer a new version of the receiver consisting of only characters,
    concatenations, alternations, and (star) closures."

    ^self alternationNodeClass children: (OrderedChildren with: self onlyChild asPureRegExpr with: self epsilonNodeClass new)!
  
createCatNode: lhs with: gamma

    | catNode |
    catNode := OrderedCollection new.
    gamma isEmpty
        ifTrue:
            [catNode add: onlyChild; add: EpsilonNode new.
            ^catNode]
        ifFalse:
            [onlyChild children addAllLast: gamma.
            catNode add: onlyChild; add: (ConcatenationNode new addChildrenInitial: gamma).
            ^catNode]!
  
createNewRHS: lhs with: gamma
    | aCollection1 aCollection2 |
    aCollection1 := OrderedCollection new.
    aCollection2 := OrderedCollection new.
    aCollection1 add: self onlyChild.
    gamma isEmpty
        ifTrue: [aCollection2 add: EpsilonNode new]
        ifFalse:
            [aCollection1 addAll: gamma.
            aCollection2 addAll: gamma].
    ^super
        createNewRHS: lhs
        with: aCollection1
        with: aCollection2!
   
createNewRHS: lhs with: alpha with: gamma
    | aCollection1 aCollection2 |
    aCollection1 := OrderedCollection new.
    aCollection2 := OrderedCollection new.
    aCollection1 add: self onlyChild.
    gamma isEmpty
        ifTrue: [aCollection2 add: EpsilonNode new]
        ifFalse:
            [aCollection1 addAll: gamma.
            aCollection2 addAll: gamma].
    ^super
        createNewRHS: lhs
        with: aCollection1
        with: aCollection2!
   
printOn: aStream

    aStream nextPut: ${.
    self onlyChild printOn: aStream.
    aStream nextPut: $}! !

!OptionalNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent the regular expression ''{expr}'' which denotes ''expr | <epsilon>''.'! !

!OrderedChildren methodsFor: 'as yet unclassified' !

addChildrenFirst: anOrderedCollection

    self addAllFirst: anOrderedCollection!
 
addChildrenInitial: anOrderedCollection

    self addAll: anOrderedCollection!

addChildrenLast: anOrderedCollection

    self addAllLast: anOrderedCollection!
   
setAttribute: value

    self shouldNotImplement! !

!OrderedChildren class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

It is often helpful to create a node that has a arbitrary (but flat) collection of nodes as a child.  My instances provide containers for these "collection children".  In other words, I am a collection that acts like a single parse tree node.'! !

!OrderedPair methodsFor: 'as yet unclassified' !
   
= anOrderedPair
    "answers whether two OrderedPairs are equal"

    ^self species = anOrderedPair species
        and: [(x = anOrderedPair x) & (y = anOrderedPair y)]!
   
hash
    "answer the receiver's hash value"

    ^(x hash bitShift: -1) + (y hash bitShift: -2)!
 
printOn: aStream
    "Append to the argument aStream a sequence of characters that identifies the receiver."

    x printOn: aStream.
    aStream nextPutAll: ' @ '.
    y printString printOn: aStream.!
  
x
    "answer the first element of the pair"

    ^x!

x: anObject y: anotherObject
    "initializes an OrderedPair"

    x := anObject.
    y := anotherObject.!
  
y
    "answer the second element of the pair"

    ^y! !

!OrderedPair class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

An OrderedPair extends the concept of a Point from Numbers to Objects. It is often
convenient to associate two objects together or to return a pair of objects from a
method.  OrderedPair provides the mechanism to do this without the inconvenience
of verbose syntax (as would be required if an Array or OrderedCollection were used).
The main instance creation method for OrderedPairs is the binary operator @.  This
operator is defined in Object and (now) overridden in Number so that numerical
points are treated and created in the traditional manner.

instance variables:
    x    <Object>    the first component of the pair
    y    <Object>    the second component of the pair
'!

x: anObject y: anotherObject
    "Answer a new OrderedPair whose x element is anObject and whose y element is anotherObject."

    ^self new x: anObject y: anotherObject! !

!ParserTransitionError class methodsFor: 'as yet unclassified' !
 
classHeader
^'----------------------------------------------------------
Signal subclass: #ParserTransitionError

Date        By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------'! !

!ParseTreeBuilder methodsFor: 'as yet unclassified' !
  
addChildrenFirst: children to: aNode
    "Add children, as the new first children, to aNode and answer aNode."

    aNode addChildrenFirst: children.
    ^aNode!
   
addChildrenLast: children to: aNode
    "Add children, as the new last children, to aNode and answer aNode."

    aNode addChildrenLast: children.
    ^aNode!
  
answerArgument: arg

    ^arg!

answerNil

    ^nil!
  
init

    self stack: Stack new!
  
makeNewNode: stringOrSymbol
    "Answer a new parse tree node representing the argument."

    self subclassResponsibility!
  
makeNewNode: stringOrSymbol withAttribute: value
    "Answer a new parse tree node and initialize its attribute value using the
    setAttribute: message."

    | newNode |
    newNode := self makeNewNode: stringOrSymbol.
    newNode setAttribute: value.
    ^newNode!
 
makeNewNode: stringOrSymbol withChildren: children
    "Answer a new parse tree node and initialize its children using the
    addChildrenInitial: message."

    | newNode |
    newNode := self makeNewNode: stringOrSymbol.
    newNode addChildrenInitial: children.
    ^newNode!
   
popArgNodesForProduction: grammarProd fromParser: parser
    "Answer a collection of nodes from my stack required for processing
    grammarProd. The order for collecting nodes is parser dependent."

    | nodes |
    nodes := OrderedCollection new.
    grammarProd numberOfRhsNonterminals timesRepeat: (parser performsLeftmostDerivation
            ifTrue: [[nodes add: self popStack]]
            ifFalse: [[nodes addFirst: self popStack]]).
    ^nodes!

popStack

    ^self stack pop!

processProduction: grammarProd forParser: parser
    "This is the main driver for production processing. The actual production
    processing messages are sent indirectly by grammarProd."

    self pushStack: (grammarProd hasSingleTokenClassRhs
            ifTrue: [grammarProd computeResultNodeFor: self withTokenClassValue: parser prevToken]
            ifFalse: [grammarProd computeResultNodeFor: self withArgNodes: (self popArgNodesForProduction: grammarProd fromParser: parser)])!
 
pushStack: anObject

    ^self stack push: anObject!
  
result
    "Answer the root of the tree build by this tree builder."

    self stack size = 1 ifFalse: [self error: 'incorrectly built tree'].
    ^self popStack!
  
stack

    ^stack!

stack: argument

    stack := argument! !

!ParseTreeBuilder class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This is an abstract class that provides a framework for building parse trees during parsing.  Parse trees are built in a bottom-up fashion during parsing by processing key productions, and with the help of a stack.  In general, a key production has the form:

    A -> N1 N2 ... Nk => symbol

where A and the Ni are nonterminals (terminals may be interspersed freely in the right-hand side) and symbol is the production directive (or translation symbol).  Since trees are built bottom-up, the information flow in a production is from the right-hand side to the left-hand side.  When a production is ready to be processed, the top of the stack contains objects (parse trees) associated with the right-hand-side nonterminals of the production.  Processing a production involves replacing these objects with a single object representing (associated with) the left-hand-side nonterminal.  This can be thought of as computing a value for A as a function of the values of the Ni''s, i.e. value(A) = fcn(value(N1), value(N2), ..., value(Nk)).  Default functions are defined in my concrete subclasses but users may define their own production processing functions by creating a new subclass and implementing appropriate messages.  This enables users to have direct control over exactly how parse trees are built.

Instance Variables:
    stack    <Stack> - holds intermediate node values during production processing.'!
   
new

    ^super new init! !

!ParseTreeNode methodsFor: 'as yet unclassified' !
 
addChildrenFirst: anOrderedCollection
    "Subclasses should implement this message."

    self shouldNotImplement!
  
addChildrenInitial: anOrderedCollection
    "Subclasses should implement this message."

    self shouldNotImplement!

addChildrenLast: anOrderedCollection
    "Subclasses should implement this message."

    self shouldNotImplement!
   
setAttribute: value
    "Subclasses should implement this message."

    self shouldNotImplement! !

!ParseTreeNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class that provides the framework for parse tree nodes, basically just a reminder that the following messages may need to be implemented by concrete subclasses:

    addChildrenFirst:
    addChildrenInitial:
    addChildrenLast:
    setAttribute:'! !

!PartitionTransitionMap methodsFor: 'as yet unclassified' !
  
goto: aPartition on: aSymbol

    (self transitionMap includesKey: aSymbol)
        ifTrue: [self error: 'these are supposed to be deterministic, what gives?'].
    self transitionMap at: aSymbol put: aPartition!

hasSameTransitionMapAs: aPTMap
    "Two partition transition maps are equivalent if they have equivalent transition maps."

    | map1 map2 keys1 keys2 values1 values2 |
    ^aPTMap isPartitionTransitionMap
        ifTrue:
            ["First, check map sizes."
            map1 := self transitionMap.
            map2 := aPTMap transitionMap.
            map1 size ~= map2 size ifTrue: [^false].
            "Next, check map domain sizes."
            keys1 := map1 keys.
            keys2 := map2 keys.
            keys1 size ~= (keys1 union: keys2) size ifTrue: [^false].
            "Last, check map range sizes."
            values1 := map1 valuesAsSet.
            values2 := map2 valuesAsSet.
            values1 size ~= (values1 union: values2) size ifTrue: [^false].
            ^true]
        ifFalse: [false]!
 
initWithPartition: pt

    self transitionMap: Dictionary new.
    self partition: pt!
   
isPartitionTransitionMap

    ^true!
  
partition

    ^partition!

partition: argument

    partition := argument!
   
printOn: aStream

    aStream nextPutAll: self partition hash printString; cr.
    self transitionMap printOn: aStream!
  
transitionMap

    ^transitionMap!

transitionMap: argument

    transitionMap := argument! !

!PartitionTransitionMap class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a partition-based transition map for an ordinary fsa state.  I am used as an intermediate computational object in the dfsa minimization algorithm (see #asMinimalDFSA in class FiniteStateAutomata).  My responsibilities include adding new partition-based transitions and testing for transition map equivalence.

Instance Variables:
    partition            <Partition> - the partition for the super state that I represent.
    transitionMap     <Dictionary from: (transition symbol) to: Partition>

where <Partition> = <Set of: (FSAState + FSAFinalState)>'!
   
forPartition: pt

    ^self new initWithPartition: pt! !

!PlusClosureNode methodsFor: 'as yet unclassified' !
  
asPureRegExpr
    "Answer a new version of the receiver consisting of only characters,
    concatenations, alternations, and (star) closures."

    ^self concatenationNodeClass children: (OrderedChildren with: self onlyChild asPureRegExpr with: (self starClosureNodeClass onlyChild: self onlyChild asPureRegExpr))!
  
createCatNode: lhs with: gamma

    | catNode lhsNode |
    catNode := OrderedCollection new.
    lhsNode := OrderedCollection new.
    lhsNode add: lhs.
    catNode add: (ConcatenationNode new addChildrenInitial: lhsNode).
    gamma isEmpty
        ifTrue:
            [catNode add: EpsilonNode new.
            ^catNode].
    catNode addLast: (ConcatenationNode new addChildrenInitial: gamma).
    ^catNode!
   
createNewRHS: lhs with: gamma
    | aCollection1 aCollection2 |
    aCollection1 := OrderedCollection new.
    aCollection2 := OrderedCollection new.
    aCollection1 add: self onlyChild; add: lhs.
    aCollection2 add: self onlyChild.
    gamma isEmpty ifFalse: [aCollection2 addAll: gamma].
    ^super
        createNewRHS: lhs
        with: aCollection1
        with: aCollection2!
  
createNewRHS: lhs with: alpha with: gamma
    | aCollection1 aCollection2 |
    self halt.
    aCollection1 := OrderedCollection new.
    aCollection2 := OrderedCollection new.
    aCollection1 add: self onlyChild; add: lhs.
    aCollection2 add: self onlyChild.
    gamma isEmpty ifFalse: [aCollection2 addAll: gamma].
    ^super
        createNewRHS: lhs
        with: aCollection1
        with: aCollection2!
  
performTransformation: lhs with: gamma with: lhsNames

    | rhsNode newLHS newProd catNode |
    onlyChild isTerminalNode
        ifTrue:
            [rhsNode := self createNewRHS: lhs with: gamma.
            ^self createNewProduction: lhs and: rhsNode]
        ifFalse:
            [newProd := OrderedCollection new.
            newLHS := self newNonterminal: lhs symbol , 'P' with: lhsNames.
            onlyChild isCatNode
                ifTrue:
                    [onlyChild children addLast: newLHS.
                    newProd add: (self createNewProduction: lhs with: onlyChild)]
                ifFalse:
                    [catNode := OrderedCollection new.
                    catNode add: onlyChild; add: newLHS.
                    newProd add: (self createNewProduction: lhs with: (ConcatenationNode new addChildrenInitial: catNode))].
            rhsNode := self createCatNode: lhs with: gamma.
            newProd addAllLast: (self createNewProduction: newLHS and: rhsNode).
            ^newProd]!

printOn: aStream

    aStream nextPut: $(.
    self onlyChild printOn: aStream.
    aStream nextPutAll: ')+'! !

!PlusClosureNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent the regular expression ''(expr)+'' which denotes ''expr (expr)*''.'! !

!ProductionNode methodsFor: 'as yet unclassified' !

addChildrenInitial: anOrderedCollection

    self leftHandSide: anOrderedCollection removeFirst.
    self rightHandSides: anOrderedCollection removeFirst!
   
asProductions
    "Answer the collection of GrammarProductions I represent."

    | prods lhs |
    prods := OrderedCollection new.
    lhs := self leftHandSide asGrammarSymbol.
    self rightHandSides do: [:rhs | prods add: (rhs asProductionWithLeftHandSide: lhs)].
    ^prods!
   
childrenDo: aBlock
    "Evaluate aBlock for each of my children."

    aBlock value: self leftHandSide.
    self rightHandSides do: aBlock!
 
leftHandSide

    ^leftHandSide!
  
leftHandSide: argument

    leftHandSide := argument!
 
printOn: aStream

    self leftHandSide printOn: aStream.
    self rightHandSides do:
        [:rhs |
        rhs printOn: aStream.
        aStream
             cr;
             nextPutAll: '    ';
             nextPut: $|.
        aStream cr]!
  
rightHandSides

    ^rightHandSides!
  
rightHandSides: argument

    rightHandSides := argument!
 
updateChildrenUsing: aBlock
    "Replace my children according to the value of aBlock."

    self leftHandSide: (aBlock value: self leftHandSide).
    self rightHandSides: (self rightHandSides collect: aBlock)! !

!ProductionNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a grammar production.

Instance Variables:

    leftHandSide    <NonterminalNode>
    rightHandSides     <OrderedCollection>    - rhs''s for productions of the form A -> x | y | z.'! !

!ProductionPartition methodsFor: 'as yet unclassified' !
   
addOtherProduction: prod

    self otherProductions add: prod!

addProblemProduction: prod

    self problemProductions add: prod!

anyProblems

    ^self problemProductions isEmpty not!

initWithLeftHandSide: lhs

    self leftHandSide: lhs.
    self problemProductions: Set new.
    self otherProductions: Set new!

leftHandSide

    ^leftHandSide!
  
leftHandSide: argument

    leftHandSide := argument!
 
otherProductions

    ^otherProductions!
  
otherProductions: argument

    otherProductions := argument!
 
problemProductions

    ^problemProductions!
  
problemProductions: argument

    problemProductions := argument! !

!ProductionPartition class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent a partition of productions for a given nonterminal into two sets, potentially problematic productions and others.  I am currently used for detecting left-recursive productions and productions with common prefixes.

Instance Variables:
    leftHandSide            <Symbol> - the left hand side nonterminal of my productions.
    problemProductions    <Set of: GrammarProduction> - when used for left-recursion
                            <Set of: (Set of: GrammarProduction)> - when used for left-factoring.
    otherProductions        <Set of: GrammarProduction>.'!
  
epsilon
    "Answer an object used to represent the empty string (epsilon)."

    ^EpsilonNode epsilon!
  
partitionProdSetForLeftFactoring: prodSet
    "ProdSet contains all productions for a given nonterminal. Partition these
    productions into two sets: a set of sets of problem productions with common
    prefixes and all the rest. Answer the partitioned productions."

    | prodPrefix newPP |
    prodSet isEmpty ifTrue: [self error: 'cannot partition an empty prodSet'].
    prodPrefix := SetDictionary new.
    prodSet do: [:prod | prodPrefix at: (prod rightHandSide isEmpty
                ifTrue: [self epsilon]
                ifFalse: [prod rightHandSide first])
            add: prod].
    newPP := self new initWithLeftHandSide: prodSet first leftHandSide.
    prodPrefix do: [:set | set size > 1
            ifTrue: [newPP addProblemProduction: set]
            ifFalse: [newPP addOtherProduction: set first]].
    ^newPP!
   
partitionProdSetForLeftRecursion: prodSet
    "ProdSet contains all productions for a given nonterminal. Partition these
    productions into two sets: left-recursive problem productions and other
    non-left-recursive productions. Answer the partitioned productions."

    | newPP |
    prodSet isEmpty ifTrue: [self error: 'cannot partition an empty prodSet'].
    newPP := self new initWithLeftHandSide: prodSet first leftHandSide.
    prodSet do: [:prod | (prod rightHandSide isEmpty or: [prod leftHandSide ~= prod rightHandSide first])
            ifTrue: [newPP addOtherProduction: prod]
            ifFalse: [newPP addProblemProduction: prod]].
    ^newPP! !

!RecursiveDescentParser methodsFor: 'as yet unclassified' !

abort

    | exitBlock |
    encoder == nil
        ifFalse:
            [encoder release.
            encoder := nil].        "break cycle"
    exitBlock := failBlock.
    failBlock := nil.
    ^exitBlock value!
   
advance

    | this |
    prevMark := hereMark.        "Now means prev size"
    prevToken := hereType == #number | (hereType == #string)
                ifTrue: [scanner mark - prevMark]
                ifFalse: [here size].
    this := here.
    here := scanner nextToken.
    hereType := scanner nextTokenType.
    hereMark := scanner mark.
    scanner scanToken.
    ^this!
   
bareEndOfLastToken

    ^prevMark + prevToken - 1 + correctionDelta max: 0!
   
compile: textOrStream encodeIn: anEncoder notifying: aRequestor ifFail: aBlock
    "Answer with the result of the compilation. NOTE: information may be added
    to the argument anEncoder during the course of this compilation."

    | result |
    self
        init: textOrStream
        notifying: aRequestor
        failBlock: aBlock.
    class isNil ifTrue: [class := Object].        "some methods rely on class being non-nil"
    self initEncoder: anEncoder.
    result := self parse.
    encoder := failBlock := requestor := parseNode := nil.        "break cycles & mitigate refct overflow"
    ^result!
   
compile: textOrStream in: aClass encodeIn: anEncoder notifying: aRequestor ifFail: aBlock
    "Answer the result of compiling the text in the context of aClass. NOTE:
    information
    may be added to the argument anEncoder during the course of this compilation."

    class := aClass.
    ^self
        compile: textOrStream
        encodeIn: anEncoder
        notifying: aRequestor
        ifFail: aBlock!
 
compile: textOrStream in: aClass notifying: aRequestor ifFail: aBlock
    "Answer the result of compiling the text in the context of aClass."

    class := aClass.
    ^self
        compile: textOrStream
        notifying: aRequestor
        ifFail: aBlock!

compile: textOrStream notifying: aRequestor ifFail: aBlock
    "Answer with the result of the compilation."

    | result |
    self
        init: textOrStream
        notifying: aRequestor
        failBlock: aBlock.
    class isNil ifTrue: [class := Object].        "some methods rely on class being non-nil"
    self initEncoder.
    result := self parse.
    encoder := failBlock := requestor := parseNode := nil.        "break cycles & mitigate refct overflow"
    ^result!
   
editor

    ^requestor!
   
endOfInput
    "Use the eof token."

    ^self endOfInputToken!
  
endOfLastToken

    hereType == #doIt ifTrue: [^prevMark + prevToken + 1 + correctionDelta].
    scanner atEnd ifTrue: [^prevMark + prevToken + correctionDelta].
    ^prevMark + prevToken - 1 + correctionDelta!
  
expected: aString
    "Notify a problem at token 'here'"

    scanner atEnd ifTrue: [hereMark := hereMark + 1].
    hereType == #doIt ifTrue: [hereMark := hereMark + 1].
    ^self notify: aString , ' expected ->' at: hereMark + correctionDelta!
   
init: sourceString notifying: req failBlock: aBlock

    requestor := req.
    failBlock := aBlock.
    correctionDelta := 0.
    scanner := self preferredScannerClass new.
    scanner scan: sourceString notifying: self.
    prevMark := hereMark := scanner mark.
    self advance!

initEncoder

    self subclassResponsibility!
 
initEncoder: anEncoder

    encoder := anEncoder!
 
match: type
    "Answer with true if next tokens type matches"

    hereType == type
        ifTrue:
            [self advance.
            ^true].
    ^false!
  
matchToken: thing
    "matches the token, not its type"

    here = thing
        ifTrue:
            [self advance.
            ^true].
    ^false!
 
notify: aString
    "Notify problem at token before 'here'"

    ^self notify: aString , ' ->' at: prevMark + correctionDelta!
   
notify: aString at: position
    "If the editor is nil, pop up a SyntaxError, otherwise have the editor insert
    aString."

    | editor |
    editor := self editor.
    Cursor normal show.
    editor == nil
        ifTrue: [SyntaxError
                errorInClass: class
                withCode: (scanner contents
                        copyReplaceFrom: position
                        to: position - 1
                        with: aString)
                errorString: aString]
        ifFalse: [editor insertAndSelectTGEN: aString at: (position max: 1)].
    self abort!

offEnd: aString
    "notify a problem beyond 'here' (in lookAhead token). Don't be offEnded!!"

    ^self notify: aString at: scanner mark + correctionDelta!

parse
    "This is the top level method that controls the (recursive descent) parse."

    self subclassResponsibility!
  
preferredScannerClass

    ^self class preferredScannerClass!
 
reset
    "Reinitialize the scanner and the parse."

    scanner reset.
    prevMark := hereMark := scanner mark.
    self advance!

startOfNextToken
    "return starting position in source of next token"

    hereType == #doIt ifTrue: [^scanner position + 1 + correctionDelta].
    ^hereMark + correctionDelta! !

!RecursiveDescentParser class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class that provides the framework for creating objects from textual representations using a recursive descent parse.
This class is what used to be called ''NewCompiler'' in old TS implementations.  It has not been rewritten to reflect its new place in the compiler framework in order to maintain compatibility with the old TS subclasses.  When they are rewritten (when the Tektronix implementation is abandoned) this class should be also.

Instance Variables:
    here            <Object> the current token
    hereType        <Symbol> the "type" of the current token
    hereMark        <Integer> position in source stream (mark) where this token began
    prevToken*    <Integer> size in chars of the previous token parsed
    prevMark        <Integer> mark of previous token
    class            <Class> provides a context for the text being parsed
    encoder        <Encoder> which uses tables to decode tokens
    parseNode    <ParseNode> intermediate result of current parse (for use by subclasses)
    lastTempMark <Integer> mark of last temp;
                        points to vert bar, or last char of pattern if no temps declared
    correctionDelta    <Integer> offset of corrected code relative to source stream
                        owing to interactive corrections so far.

* inherited from AbstractParser, but with new semantics.'!
  
preferredScannerClass
    "Answer with a scanner class which is appropiate for scanning tokens used
    by this compiler class. Should be overwritten by subclasses."

    self subclassResponsibility! !

!RegularExpressionNode methodsFor: 'as yet unclassified' !
 
addNonemptyLeavesTo: aSet

    ^self        "default is do nothing"!
  
alternationNodeClass

    ^AlternationNode!
   
asDFSA

    | fsa |
    fsa := self asFSA.
    ^fsa asDeterministicFSA!
 
asFSA

    | startState finalState |
    startState := self fsaStateClass new.
    finalState := self fsaFinalStateClass new.
    self asFSAStartingAt: startState endingAt: finalState.
    ^startState!
 
asFSAStartingAt: startState endingAt: finalState

    self subclassResponsibility!

asFSAWithLiteral: literal startingAt: startState

    | finalState |
    "First, build main fsa."
    finalState := self fsaFinalStateClass new.
    self asFSAStartingAt: startState endingAt: finalState.
    finalState addLiteralToken: literal.
    ^startState!

asFSAWithType: type andAction: action startingAt: startState

    | finalState |
    "First, build main fsa."
    finalState := self fsaFinalStateClass new.
    self asFSAStartingAt: startState endingAt: finalState.
    finalState addTokenClass: (self tokenClassificationClass tokenType: type action: action).
    ^startState!
   
asPureRegExpr
    "Answer a new version of the receiver consisting of only characters,
    concatenations, alternations, and (star) closures. Also, eliminate single
    child alternations and concatenations."

    ^self        "default"!
  
characterNodeClass

    ^CharacterNode!
   
collectNonemptyLeavesIn: aSet

    self postorderDo: [:child | child addNonemptyLeavesTo: aSet]!
  
concatenationNodeClass

    ^ConcatenationNode!
   
createNewProduction: lhsNode and: node

    | prodChildren rule |
    prodChildren := OrderedCollection new.
    rule := OrderedCollection new.
    rule add: lhsNode; add: (RRPGRightHandSideNode new symbols: node first).
    prodChildren add: (RRPGProductionNode new addChildrenInitial: rule).
    rule add: lhsNode; add: (RRPGRightHandSideNode new symbols: node last).
    prodChildren add: (RRPGProductionNode new addChildrenInitial: rule).
    ^prodChildren!
  
createNewProduction: lhs with: node

    | prodChildren rule |
    prodChildren := OrderedCollection new.
    rule := OrderedCollection new.
    rule add: lhs; add: (RRPGRightHandSideNode new symbols: node).
    ^prodChildren add: (RRPGProductionNode new addChildrenInitial: rule)!
 
createNewRHS: lhs with: oc1 with: oc2

    | catChildren |
    catChildren := OrderedCollection new.
    catChildren add: (ConcatenationNode new addChildrenInitial: oc1).
    oc2 first isEpsilonNode
        ifTrue: [catChildren add: oc2 first]
        ifFalse: [catChildren add: (ConcatenationNode new addChildrenInitial: oc2)].
    ^catChildren!
  
epsilon
    "Answer an object used to represent the empty string (epsilon)."

    ^self epsilonNodeClass epsilon!

epsilonNodeClass

    ^EpsilonNode!
   
fsaFinalStateClass

    ^FSAFinalState!
   
fsaStateClass

    ^FSAState!
 
minimize: recognizer

    ^recognizer asMinimalDFSA!
  
newNonterminal: lhsNode with: lhsNames

    | lhs |
    lhs := lhsNode.
    lhsNames isEmpty
        ifTrue: [lhsNames add: lhs]
        ifFalse:
            [[lhsNames includes: lhs]
                whileTrue: [lhs := lhs , 'P'].
            lhsNames add: lhs].
    ^NonterminalNode new setAttribute: lhs!

processTransformation: lhsNode with: lhsNames

    | prods newProds |
    newProds := OrderedCollection new.
    prods := self
                performTransformation: lhsNode
                with: OrderedCollection new
                with: lhsNames.
    prods do: [:ea | (newProds addAll: (ea rightHandSides processTransformation: ea leftHandSide with: lhsNames)) isEmpty ifTrue: [newProds add: ea]].
    ^newProds!

starClosureNodeClass

    ^StarClosureNode!
   
tokenClassificationClass

    ^TokenClassification! !

!RegularExpressionNode class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am the root of a regular expression tree.'! !

!RetractableFileStream methodsFor: 'as yet unclassified' !

atBeginning

    ^position = 0!
   
backspace
    "Backup one position, if possible. It may be best to signal an error when attempting to backup
    past the beginning of the stream, but for now just do nothing."

    self atBeginning ifFalse: [self skip: -1]!

current
    "Answer the element at the current position or nil if at the beginning. This is useful for
    rereading the stream after backspacing."

    ^self atBeginning
        ifTrue: [nil]
        ifFalse: [collection at: position]!
  
next
"-----------------------------------------------------------
Date           By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"        "Answer the next object accessible by the receiver
         and advance the stream position. "
    <primitive: 65>
    self position: self position.
    self atEnd
        ifTrue: [
          ^self pastEnd ]
        ifFalse: [
            (position := position + 1) > readLimit
                ifTrue: [self error: 'position outside of stream'].
            ^collection at: position]!
   
pastEnd
"The receiver has attempted to read past the end, answer an EOF indicator."
    "NOTE: currently, this class is used only by T-gen so it is acceptable to use the end-of-input character
    rather than nil to denote the end of the stream. However, in a more general context, it may
    be desirable to change this back to nil. If this is done then either the transitionFor:ifNone:
    method in class FSAState must be changed to check for nil as a transition symbol
    (Dictionaries do not allow nil keys), or scanners must be changed to translate a nil character
    to the end-of-input character. These changes affect what happens when a scanner runs out of
      input in the middle of a token."

    ^Character endOfInput
    "
    ^Signal noHandlerSignal handle: [:ex | ex parameter proceedWith: (Character endOfInput)]
        do: [self class endOfStreamSignal raiseRequestFrom: self]
    "!
 
size
    "Answer how many elements the receiver contains."

    ^position! !

!RetractableFileStream class methodsFor: 'as yet unclassified' !
 
pathName: aFileName

     ^self pathName: aFileName in: Disk!
 
pathName: aFileName in: aDirectory

     ^self on: (File open: aFileName in: aDirectory)! !

!RetractableReadStream methodsFor: 'as yet unclassified' !
 
atBeginning

    ^position = 0!
   
backspace
    "Backup one position, if possible. It may be best to signal an error when attempting to backup
    past the beginning of the stream, but for now just do nothing."

    self atBeginning ifFalse: [self skip: -1]!

current
    "Answer the element at the current position or nil if at the beginning. This is useful for
    rereading the stream after backspacing."

    ^self atBeginning
        ifTrue: [nil]
        ifFalse: [collection at: position]!
  
next
"-----------------------------------------------------------
Date           By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"        "Answer the next object accessible by the receiver
         and advance the stream position. "
    <primitive: 65>
    position < readLimit
        ifTrue: [
            position := position + 1.
            ^collection at: position]
        ifFalse: [
          ^self pastEnd ]!
  
pastEnd
"The receiver has attempted to read past the end, answer an EOF indicator."
    "NOTE: currently, this class is used only by T-gen so it is acceptable to use the end-of-input character
    rather than nil to denote the end of the stream. However, in a more general context, it may
    be desirable to change this back to nil. If this is done then either the transitionFor:ifNone:
    method in class FSAState must be changed to check for nil as a transition symbol
    (Dictionaries do not allow nil keys), or scanners must be changed to translate a nil character
    to the end-of-input character. These changes affect what happens when a scanner runs out of
      input in the middle of a token."

    ^Character endOfInput
    "
    ^Signal noHandlerSignal handle: [:ex | ex parameter proceedWith: (Character endOfInput)]
        do: [self class endOfStreamSignal raiseRequestFrom: self]
    "! !

!RetractableReadStream class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class adds a ''backspace'' method and overrides several methods to correctly support this behavior.'! !

!RetractableWriteStream methodsFor: 'as yet unclassified' !
  
atBeginning

    ^position = 0!
   
backspace
    "Backup one position, if possible. It may be best to signal an error when attempting to backup
    past the beginning of the stream, but for now just do nothing."

    self atBeginning ifFalse: [self skip: -1]!

size
    "Answer how many elements the receiver contains."

    ^position! !

!RetractableWriteStream class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class adds a ''backspace'' method and overrides several methods to correctly support this behavior.'! !

!RightHandSideNode methodsFor: 'as yet unclassified' !
   
addChildrenInitial: anOrderedCollection

    self symbols: anOrderedCollection removeFirst.
    self translationSymbol: anOrderedCollection removeFirst!
 
asProductionWithLeftHandSide: lhs
    "Answer the GrammarProduction I represent."

    | rhs |
    rhs := self symbols collect: [:sym | sym asGrammarSymbol].
    ^self translationSymbol isNil
        ifTrue: [GrammarProduction leftHandSide: lhs rightHandSide: rhs]
        ifFalse: [TransductionGrammarProduction
                leftHandSide: lhs
                rightHandSide: rhs
                translationSymbol: self translationSymbol symbol]!
  
childrenDo: aBlock
    "Evaluate aBlock for each of my children."

    self symbols do: aBlock.
    aBlock value: self translationSymbol!
   
printOn: aStream

    self symbols do:
        [:sym |
        sym printOn: aStream.
        aStream space].
    self translationSymbol notNil
        ifTrue:
            [aStream nextPutAll: ${.
            self translationSymbol printOn: aStream.
            aStream nextPutAll: '}  ;']!
 
symbols

    ^symbols!

symbols: argument

    symbols := argument!
   
translationSymbol

    ^translationSymbol!

translationSymbol: argument

    translationSymbol := argument!
   
updateChildrenUsing: aBlock
    "Replace my children according to the value of aBlock."

    self symbols: (self symbols collect: aBlock).
    self translationSymbol: (aBlock value: self translationSymbol)! !

!RightHandSideNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class represents the right-hand side of a grammar rule.

Instance Variables

    symbols        <OrderedCollection>    - rhs of production rule.
    translationSymbol    <Symbol>    - symbol for transduction.'! !

!RRPGProductionNode methodsFor: 'as yet unclassified' !

asProductions: lhsNames
    "Answer the collection of GrammarProductions I represent."

    | prods lhs newProds |
    newProds := OrderedCollection new.
    prods := self transformWith: lhsNames.
    prods do:
        [:ea |
        lhs := ea leftHandSide asGrammarSymbol.
        newProds add: (ea rightHandSides asProductionWithLeftHandSide: lhs)].
    ^newProds!

printOn: aStream

    self leftHandSide printOn: aStream.
    self rightHandSides printOn: aStream!
  
transformWith: lhsNames

    | newProd |
    newProd := OrderedCollection new.
    (newProd addAll: (self rightHandSides processTransformation: self leftHandSide with: lhsNames)) isEmpty ifTrue: [newProd add: self].
    ^newProd! !

!RRPGProductionNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an RRPG production.'! !

!RRPGRightHandSideNode methodsFor: 'as yet unclassified' !
   
asProductionWithLeftHandSide: lhs
    "Answer the GrammarProduction I represent."

    | rhs |
    rhs := self symbols collectSymbol.
    ^self translationSymbol isNil
        ifTrue: [GrammarProduction leftHandSide: lhs rightHandSide: rhs]
        ifFalse: [TransductionGrammarProduction
                leftHandSide: lhs
                rightHandSide: rhs
                translationSymbol: self translationSymbol symbol]!
  
doPartialTransformation: aProd with: lhsNames

    ^self symbols doPartialTransformation: aProd with: lhsNames!
   
isAltNode

    ^false!

printOn: aStream

    self symbols printOn: aStream.
    aStream space.
    self translationSymbol notNil
        ifTrue:
            [aStream nextPutAll: ' {'.
            self translationSymbol printOn: aStream.
            aStream nextPutAll: '}']!
 
processTransformation: lhsNode with: lhsNames

    ^self symbols processTransformation: lhsNode with: lhsNames! !

!RRPGRightHandSideNode class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class represents the right hand side of an RRPG grammar production.

Instance Variables:

    regexpr    <RegularExpressionNode>    - the rhs of an RRPG grammar production is a regular expression of grammar symbols.'! !

!ScannerTransitionError class methodsFor: 'as yet unclassified' !

classHeader
^'----------------------------------------------------------
Signal subclass: #NoTransition

Date        By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------'! !

!SetDictionary methodsFor: 'as yet unclassified' !
  
asDictionary

    | newDict |
    self isDeterministic
        ifTrue:
            [newDict := Dictionary new: self size.
            self associationsDo: [:assoc | newDict at: assoc key put: assoc value first].
            ^newDict]
        ifFalse: [self error: 'SetDictionary cannot be converted to a Dictionary']!
   
at: key add: anObject

    (self at: key ifAbsent: [self at: key put: Set new])
        add: anObject!
   
at: key addAll: aSet

    (self at: key ifAbsent: [self at: key put: Set new])
        addAll: aSet!
 
at: key ifAbsent: absentBlock ifNotUnique: notUniqueBlock

    | elementSet |
    elementSet := self at: key ifAbsent: [^absentBlock value].
    ^elementSet size > 1
        ifTrue: [notUniqueBlock value]
        ifFalse: [elementSet first]!
 
at: key ifNotUnique: aBlock

    | elementSet |
    elementSet := self at: key.
    ^elementSet size > 1
        ifTrue: [aBlock value]
        ifFalse: [elementSet first]!
  
at: key remove: anObject

    ^(self at: key)
        remove: anObject!
  
at: key remove: anObject ifAbsent: aBlock

    ^(self at: key)
        remove: anObject ifAbsent: aBlock!

elements

    | elements |
    elements := Set new.
    self do: [:set | elements addAll: set].
    ^elements!
 
elementsDo: aBlock
    "Evaluate aBlock with each element of each of the receiver's set elements as the
    argument."

    self elements do: [:element | aBlock value: element]!
   
isDeterministic

    self associationsDo: [:assoc | assoc value size > 1 ifTrue: [^false]].
    ^true! !

!SetDictionary class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class represents a Dictionary of Sets.'! !

!Stack methodsFor: 'as yet unclassified' !

copyEmpty: aSize
    "Answer a copy of the receiver that contains no elements.

    This method should be redefined in subclasses that add
    instance variables, so that the state of those variables
    is preserved"

    ^(super copyEmpty: aSize) topPtr: self topPtr.!
   
do: aBlock
    "Evaluate aBlock for each object on the stack, from top to bottom."

    ^super reverseDo: aBlock!

init

    self topPtr: 0!
 
isEmpty
    ^topPtr = 0!
   
isFull
    ^ topPtr = self basicSize!
  
pop
    "Answer the object on top of the stack."

    | n |
    n := self at: topPtr.
    topPtr := topPtr - 1.
    ^n!
   
pop: numElem
    "Pop and discard top numElems and answer receiver"

    topPtr := topPtr - numElem!
 
push: anObject
    "Push anObject onto the top of the stack."

    self isFull ifTrue: [self grow].
    topPtr := topPtr + 1.
    ^self at: topPtr put: anObject!
  
reverseDo: aBlock
    "Evaluate aBlock for each object on the stack, from bottom to top."

    ^super do: aBlock!

size
    "Answer the number of objects on the stack."

    ^topPtr!
  
top
    "Answer (without removing) the object on top of the stack."

    ^self at: topPtr!
   
topPtr
    ^topPtr!

topPtr: arg
    topPtr := arg! !

!Stack class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This class provides a more traditional push/pop interface for Arrays.'!
  
new

    ^self new: 100!
  
new: arg

    ^( super new: arg ) init! !

!StarClosureNode methodsFor: 'as yet unclassified' !
 
asFSAStartingAt: startState endingAt: finalState

    | middleState |
    middleState := self fsaStateClass new.
    startState goto: middleState on: self epsilon.
    middleState goto: finalState on: self epsilon.
    self onlyChild asFSAStartingAt: middleState endingAt: middleState!
 
asPureRegExpr
    "Answer a new version of the receiver consisting of only characters,
    concatenations, alternations, and (star) closures."

    ^self starClosureNodeClass onlyChild: self onlyChild asPureRegExpr!
 
createCatNode: lhs with: gamma

    | catNode |
    catNode := OrderedCollection new.
    onlyChild children addLast: lhs.
    catNode add: onlyChild.
    gamma isEmpty
        ifTrue:
            [catNode add: EpsilonNode new.
            ^catNode].
    catNode add: (ConcatenationNode new addChildrenInitial: gamma).
    ^catNode!
 
createNewRHS: lhs with: gamma

    | aCollection1 aCollection2 |
    aCollection1 := OrderedCollection new.
    aCollection2 := OrderedCollection new.
    aCollection1 add: self onlyChild; add: lhs.
    gamma isEmpty
        ifTrue: [aCollection2 add: EpsilonNode new]
        ifFalse: [aCollection2 addAll: gamma].
    ^super
        createNewRHS: lhs
        with: aCollection1
        with: aCollection2!
 
createNewRHS: lhs with: alpha with: gamma

    | aCollection1 aCollection2 |
    self halt.
    aCollection1 := OrderedCollection new.
    aCollection2 := OrderedCollection new.
    aCollection1 add: self onlyChild; add: lhs.
    gamma isEmpty
        ifTrue: [aCollection2 add: EpsilonNode new]
        ifFalse: [aCollection2 addAll: gamma].
    ^super
        createNewRHS: lhs
        with: aCollection1
        with: aCollection2!
 
printOn: aStream

    aStream nextPut: $(.
    self onlyChild printOn: aStream.
    aStream nextPutAll: ')*'! !

!StarClosureNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent the regular expression ''(expr)*'' which denotes zero or more repetitions of ''expr''.'! !

!SyntaxError class methodsFor: 'as yet unclassified' !
 
classHeader
^'----------------------------------------------------------
Event subclass: #SyntaxError

Date        By      Description
06/02/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------'! !

!TableDrivenParser methodsFor: 'as yet unclassified' !

abort

    | block |
    block := self failBlock.
    self failBlock: nil.
    block value!

classInitializationMethodTextForClassNamed: name spec: grammarSpec

    ^self subclassResponsibility!
 
cr

    self show: '
'!
  
createParserClassNamed: name category: category spec: grammarSpec

    | parserClass |
    parserClass := self defaultParserClass
                subclass: name asSymbol
                instanceVariableNames: ''
                classVariableNames: ''
                poolDictionaries: ''.
    parserClass class compileMethod: (self classInitializationMethodTextForClassNamed: name spec: grammarSpec).
    parserClass initialize.
    ^parserClass!

createScannerClassNamed: name category: category spec: tokenSpec

    ^self scanner
        createScannerClassNamed: name
        category: category
        spec: tokenSpec!
  
createScannerParserClassesNamed: namePrefix category: category tokenSpec: tokenSpec grammarSpec: grammarSpec
    | parserClass |
    self
        createScannerClassNamed: namePrefix , 'Scanner'
        category: category
        spec: tokenSpec.
    parserClass := self
                createParserClassNamed: namePrefix , 'Parser'
                category: category
                spec: grammarSpec.
    parserClass compileMethod: 'scannerClass
    ^' , namePrefix , 'Scanner'.
    parserClass compileMethod: 'treeBuilderClass
    ^' , self treeBuilder class printString!
  
defaultParserClass

    ^self class!
  
defaultTranscript

    ^Transcript!
   
derivationTreeBuilderClass

    ^DerivationTreeBuilder!
   
endOfInput
    "Use the eof token type."

    ^self endOfInputTokenType!
 
endOfInputTokenType
    "Answer the token type used by my scanner to represent the end of the input."

    ^self scanner endOfInputTokenType!

exceptionHandle: aBlock

    "Ported by Ian Upright"

    aBlock on: ScannerTransitionError, ParserTransitionError do:[ :ex |
    
        ex class = ScannerTransitionError ifTrue:[
            self requestor notNil ifTrue: [
                self requestor insertAndSelectTGEN: 'SCANNER ERROR: ' , ex errorString , ' ->' at: self scanner errorPosition.
            ].
            "self abort."
            "ex exitWith: false."
        ].
        ex class = ParserTransitionError ifTrue:[
            self requestor notNil ifTrue: [
                self requestor insertAndSelectTGEN: '<- PARSER ERROR: ' , ex errorString at: self scanner errorPosition.
            ].
            "self abort."
            "ex exitWith: false."
        ].
        ^false
    ].
    ^true!
  
init

    super init.
    self parseTable: self myParseTable.
    self treeBuilder: self treeBuilderClass new!
  
myParseTable

    ^self class parseTable!
 
parse

    self subclassResponsibility!
   
parse: aString ifFail: aBlock

    | rslt |

    self failBlock: aBlock.
    (self exceptionHandle: [
        self initScannerSource: aString.
        rslt := self parse.
        true
    ]) ifFalse: [^self abort].

    ^rslt!
   
parseAndTrace: aString ifFail: aBlock

    | rslt |

    self failBlock: aBlock.

    "Make sure we don't accidently write to someone else's window."
    self transcript: nil.

    (self exceptionHandle: [
        self initScannerSource: aString.
        rslt := self traceParse.
        true
    ]) ifFalse: [^self abort].

    ^rslt!
  
parseAndTrace: aString on: aTranscript ifFail: aBlock

    | rslt |

    self failBlock: aBlock.
    self transcript: aTranscript.
    (self exceptionHandle: [
        self initScannerSource: aString.
        rslt := self traceParse.
        true
    ]) ifFalse: [^self abort].
    ^rslt!
 
parseForAST

    | builder |
    builder := self treeBuilder reset.
    ^self parseWithTreeBuilder: builder!

parseForAST: aString ifFail: aBlock

    | rslt |

    self failBlock: aBlock.
    (self exceptionHandle: [
        self initScannerSource: aString.
        rslt := self parseForAST.
        true
    ]) ifFalse: [^self abort].

    ^rslt!
   
parseForDerivationTree

    ^self parseWithTreeBuilder: self derivationTreeBuilderClass new!
  
parseForDerivationTree: aString ifFail: aBlock

    | rslt |
    self failBlock: aBlock.

    (self exceptionHandle: [
        self initScannerSource: aString.
        rslt := self parseForDerivationTree.
        true
    ]) ifFalse: [^self abort].

    ^rslt!
 
parseForShamAST

    | builder |
    builder := self treeBuilder reset.
    builder setShamMode.
    ^self parseWithTreeBuilder: builder!
  
parseForShamAST: aString ifFail: aBlock

    | rslt |

    self failBlock: aBlock.
    (self exceptionHandle: [
        self initScannerSource: aString.
        rslt := self parseForShamAST.
        true
    ]) ifFalse: [^self abort].

    ^rslt!
   
parseIfFail: aBlock

    | rslt |

    self failBlock: aBlock.
    (self exceptionHandle: [
        scanner reset.
        rslt := self parse.
        true
    ]) ifFalse: [^self abort].

    ^rslt!
   
parseTable

    ^parseTable!
  
parseTable: argument

    parseTable := argument!
 
parseWithTreeBuilder: parseTreeBuilder
"-----------------------------------------------------------
Date           By      Description
06/10/92    HsH     Creation

Copyright (c) 1992 Anamet Laboratories, Inc.  All Rights Reserved.
-----------------------------------------------------------"
    self implementedBySubclass!
 
performsLeftmostDerivation
    "This is the default, let subclasses override."

    ^false!
  
performsRightmostDerivation
    "This is the default, let subclasses override."

    ^false!
 
requestor

    ^requestor!

requestor: argument

    requestor := argument!
   
scannerClass
    "Translator generator tools may initially create an 'abstract' parser and 'plug-in'
    a scanner. This allows instances of these abstract parsers to be used in this
    fashion. Ultimately, the tools will create concrete scanner and parser classes
    with the proper links established."

    ^Object!
   
scannerErrorSignal

    ^FSAState noTransitionSignal!
 
show: aString

    (self transcript isNil
        ifTrue: [self defaultTranscript]
        ifFalse: [self transcript])
        show: aString!
  
showCR: aString

    self show: aString , '
'!
   
spaceOptimize

    self parseTable spaceOptimize!
 
traceParse

    self subclassResponsibility!
  
transcript

    ^transcript!
  
transcript: argument

    transcript := argument!
 
treeBuilder

    ^treeBuilder!

treeBuilder: argument

    treeBuilder := argument!
   
treeBuilderClass
    "Different tree builders can either be plugged in or subclasses can override this
    method."

    ^AbstractSyntaxTreeBuilder! !

!TableDrivenParser class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class representing table (FSA) driven parsers.


Instance Variables:
    parseTable    <LL1ParserTable | LRParserState> - basic parsing mechanism.
    transcript        <TranslatorGenerator | UndefinedObject> - status messages get sent here.
    treeBuilder    <ParseTreeBuilder> - used in the construction of abstract syntax trees.'!

initialize
"Concrete subclasses must somehow provide a parse table. Subclasses created
    by automatic means may simply 'plug-in' a dynamically computed parse table.
    However, if a class that can be filed-out is desired then it is worthwhile to
    override this initialization method with one that can build the appropriate parse
    table directly."
    "TableDrivenParser initialize"

    self parseTable: nil!
   
new

    ^super new init!
 
parseTable

    ^parseTable!
  
parseTable: argument

    parseTable := argument! !

!TerminalNode methodsFor: 'as yet unclassified' !
  
asGrammarSymbol
    "Answer my symbol as a Terminal (String). A literal token is a string within a
    string so trim the extra quotes."

    | sym |
    ^(sym := self symbol) isTokenClassTerminal
        ifTrue: [sym]
        ifFalse: [sym copyFrom: 2 to: sym size - 1]!
  
collectSymbol

    | regexpr |
    regexpr := OrderedCollection new.
    regexpr add: self asGrammarSymbol.
    ^regexpr!
  
doTransformingNow

    ^false!

hasBeenTransformed
    ^true!
  
isAltNode

    ^false!

isCatNode

    ^false!

isEpsilonNode

    ^false!

isTerminalNode

    ^true!

needTransforming
    ^false!
   
processTransformation: prod with: lhsNames

    ^OrderedCollection new! !

!TerminalNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I hold a terminal.'! !

!TGenException methodsFor: 'as yet unclassified' !
 
errorInClass: aClass withCode: aCode errorString: aString

    self notYetImplemented!

errorString

    ^self messageText!
   
errorString: text

    ^self messageText: text
!
 
exitWith: anObject

    ^self exit: anObject!
 
signalWith: anObject

    ^self signal: anObject! !

!TGenException class methodsFor: 'as yet unclassified' !
   
signalWith: anObject

	^self signal: anObject
! !

!TokenClassification methodsFor: 'as yet unclassified' !

action

    ^action!
  
action: argument

    action := argument!
 
isTokenClassification

    ^true!
 
printOn: aStream

    self tokenType printOn: aStream.
    aStream space.
    self action printOn: aStream!
 
reconstructOn: aStream
"Emit #( tokenType  action ) on aStream"
    (Array with: tokenType with: action) reconstructOn: aStream

    "
    aStream poundSign; leftParenthesis.
    self tokenType reconstructOn: aStream.
    aStream space.
    self action reconstructOn: aStream.
    aStream rightParenthesis.
    "!
 
tokenType

    ^tokenType!

tokenType: argument

    tokenType := argument! !

!TokenClassification class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I represent a class of tokens.

Instance Variables:
    tokenType    <String> - name of this token class.
    action        <Symbol + UndefinedObject> - a message selector that will be sent to the scanner (via #perform:) when a token with this type is recognized.'!

tokenType: arg1 action: arg2

    | newMe |
    newMe := self new.
    newMe tokenType: arg1.
    newMe action: arg2.
    ^newMe! !

!TokenClassNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I hold the token class.'! !

!TokenSpecificationRule methodsFor: 'as yet unclassified' !
   
directive

    ^directive!

directive: argument

    directive := argument!
   
regExpr

    ^regExpr!

regExpr: argument

    regExpr := argument!
   
tokenClass

    ^tokenClass!
  
tokenClass: argument

    tokenClass := argument! !

!TokenSpecificationRule class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

Instance Variables:
    tokenClass    <String> - the name of the token class.
    regExpr        <RegularExpressionNode> (actually, any one of its concrete subclasses) - the (pure) regular expression tree representing the specification of the token class.
    directive         <String + UndefinedObject> - the optional scanner directive.'!
  
tokenClass: arg1 regExpr: arg2 directive: arg3

    | newMe |
    newMe := self new.
    newMe tokenClass: arg1.
    newMe regExpr: arg2.
    newMe directive: arg3.
    ^newMe! !

!TokenSpecLeafNode methodsFor: 'as yet unclassified' !
 
printOn: aStream

    self symbol printOn: aStream!
   
setAttribute: value

    self symbol: value!
  
symbol

    ^symbol!
  
symbol: argument

    symbol := argument! !

!TokenSpecLeafNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class for token spec leaf nodes.

Instance Variables:

    symbol    <Character>    - token symbol'! !

!TokenSpecNode methodsFor: 'as yet unclassified' !

addChildrenFirst: anOrderedCollection

    self specRules addAllFirst: anOrderedCollection!
   
addChildrenInitial: anOrderedCollection

    self specRules addAll: anOrderedCollection!
  
asSpecRuleList
    "Answer the collection of specification rules I represent."

    | rules |
    rules := OrderedCollection new.
    self specRules do: [:rule | rules add: rule asSpecRule].
    ^rules!

init

    self specRules: OrderedCollection new!
  
printOn: aStream

    self specRules do:
        [:rule |
        rule printOn: aStream.
        aStream cr]!
  
specRules

    ^specRules!

specRules: argument

    specRules := argument! !

!TokenSpecNode class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am the root of a token specification.

Instance Variables:

    specRules    <OrderedCollection>    - the rules for this spec.'!
   
new

    ^super new init! !

!TokenSpecParseNode class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am an abstract class for token specification parse tree nodes.'! !

!TokenSpecParser methodsFor: 'as yet unclassified' !
 
scannerClass

    ^TokenSpecScanner! !

!TokenSpecParser class methodsFor: 'as yet unclassified' !
  
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a parser for T-gen token specifications.'!
  
grammar
"-----------------------------------------------------------
Date           By      Description
06/04/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

        ^Grammar buildGrammarFrom:
            ((Array new: 27)
                at: 1 put: (
                    Array with: #spec
                              with: #(rule spec )
                              with: #liftRightChild );
                at: 2 put: (
                    Array with: #spec
                              with: #()
                              with: #TokenSpecNode );
                at: 3 put: (
                    Array with: #rule
                              with: #(type ':' regexpr directive ';' )
                              with: #TokenSpecRuleNode );
                at: 4 put: (
                    Array with: #type
                              with: #('<tokenclass>' )
                              with: #TokenClassNode );
                at: 5 put: (
                    Array with: #directive
                              with: #('<directive>' )
                              with: #DirectiveNode );
                at: 6 put: (
                    Array with: #directive
                              with: #()
                              with: #nil );
                at: 7 put: (
                    Array with: #regexpr
                              with: #(catexpr '|' regexpr )
                              with: #liftRightChild );
                at: 8 put: (
                    Array with: #regexpr
                              with: #(catexpr )
                              with: #AlternationNode );
                at: 9 put: (
                    Array with: #catexpr
                              with: #(expr catexpr )
                              with: #liftRightChild );
                at: 10 put: (
                    Array with: #catexpr
                              with: #(expr )
                              with: #ConcatenationNode );
                at: 11 put: (
                    Array with: #expr
                              with: #(baseexpr '*' )
                              with: #StarClosureNode );
                at: 12 put: (
                    Array with: #expr
                              with: #(baseexpr '+' )
                              with: #PlusClosureNode );
                at: 13 put: (
                    Array with: #expr
                             with: #(baseexpr '?' )
                             with: #OptionalNode );
                at: 14 put: (
                    Array with: #expr
                              with: #(baseexpr ) );
                at: 15 put: (
                    Array with: #baseexpr
                              with:#(atom ) );
                at: 16 put: (
                    Array with: #baseexpr
                              with: #('(' regexpr ')' ) );
                at: 17 put: (
                    Array with: #baseexpr
                              with: #('[' atomlist ']' )
                              with: #AlternationRangeNode );
                at: 18 put: (
                    Array with: #baseexpr
                              with: #('~' '[' atomlist ']' )
                              with: #ComplementedAlternationRangeNode );
                at: 19 put: (
                    Array with: #atomlist
                              with: #(listelmt atomlist )
                              with: #liftRightChild );
                at: 20 put: (
                    Array with: #atomlist
                              with: #(listelmt )
                              with: #OrderedChildren );
                at: 21 put: (
                    Array with: #listelmt
                              with: #(atom ) );
                at: 22 put: (
                    Array with: #listelmt
                              with: #(atom '-' atom )
                              with: #CharRangeNode );
                at: 23 put: (
                    Array with: #atom
                              with: #('<dchar>' )
                              with: #DecimalCharNode );
                at: 24 put: (
                    Array with: #atom
                              with: #('<ochar>' )
                              with: #OctalCharNode );
                at: 25 put: (
                    Array with: #atom
                              with: #('<hchar>' )
                              with: #HexadecimalCharNode );
                at: 26 put: (
                    Array with: #atom
                              with: #('<eschar>' )
                              with: #EscapedCharNode );
                at: 27 put: (
                    Array with: #atom
                              with: #('<char>' )
                              with: #CharacterNode );
                yourself
    ).!
  
initialize
"TokenSpecParser initialize"
    "grammar:
    spec            -> rule spec                        => liftRightChild
    spec            ->                                     => TokenSpecNode .
    rule            -> type '':'' regexpr directive '';''    => TokenSpecRuleNode .
    type            -> <tokenclass>                    => TokenClassNode .
    directive        -> <directive>                    => DirectiveNode
    directive        ->                                    => nil .
    regexpr        -> catexpr ''|'' regexpr            => liftRightChild
    regexpr        -> catexpr                        => AlternationNode .
    catexpr        -> expr catexpr                    => liftRightChild
    catexpr        -> expr                            => ConcatenationNode .
    expr            -> baseexpr ''*''                    => StarClosureNode
    expr            -> baseexpr ''+''                    => PlusClosureNode
    expr             -> baseexpr ''?''                    => OptionalNode
    expr            ->     baseexpr .
    baseexpr        -> atom
    baseexpr        -> ''('' regexpr '')''

    baseexpr        -> ''['' atomlist '']''                => AlternationRangeNode
    baseexpr        -> ''~'' ''['' atomlist '']''            => ComplementedAlternationRangeNode .
    atomlist        -> listelmt atomlist                => liftRightChild
    atomlist        -> listelmt                            => OrderedChildren .
    listelmt        -> atom
    listelmt        -> atom ''-'' atom                => CharRangeNode .
    atom            -> <dchar>                        => DecimalCharNode
    atom            -> <ochar>                        => OctalCharNode
    atom            -> <hchar>                        => HexadecimalCharNode
    atom            -> <eschar>                        => EscapedCharNode
    atom            -> <char>                            => CharacterNode .

    status: SLR(1) and LL(1), with transformations"

    | newTGen parser rules fsa par |
    parser := DLGParser parse: '
        %%
        <tokenclass> = \<[a-zA-Z_][a-zA-Z_0-9]*\>
        <directive> = \{[a-zA-Z_][a-zA-Z_0-9]*\}
        <dchar> = \\[0-9][0-9][0-9]
        <ochar> = \\o[0-7][0-7][0-7]
        <hchar> = \\x[0-9A-F][0-9A-F]
        <eschar> = \\[!!-\~]
        <char> = [!!-\~]
        <comment> = "(~["]|""|[\ \    \
])*"            <<ignoreComment>>
        <space> = [\ \    \
]+            <<ignoreDelimiter>>
        %%' onError: [self halt].
    parser notNil
        ifTrue:
            [rules := parser execute.
            fsa := parser buildFSAFrom: rules and: #(':' ';' '\|' '\*' '\+' '?' '\(' '\)' '\[' '\]' '\~' '\-' ).
            TokenSpecScanner fsa: fsa.
            newTGen := TranslatorGenerator new.
            newTGen grammar: self grammar.
            newTGen generateLRParser.
            Transcript cr; show: newTGen grammarClassification.
            par := newTGen parser.
            par scanner: TokenSpecScanner new.
            self parseTable: par parseTable.
            self finalState: par finalState]! !

!TokenSpecRuleNode methodsFor: 'as yet unclassified' !

addChildrenInitial: anOrderedCollection

    anOrderedCollection size = 3
        ifTrue:
            [self tokenClass: anOrderedCollection removeFirst.
            self regExpr: anOrderedCollection removeFirst.
            self directive: anOrderedCollection removeFirst]
        ifFalse: [self error: 'wrong number of children']!
  
asSpecRule
    "Answer the specification rule I represent."

    ^self specRuleClass
        tokenClass: self tokenClass symbol
        regExpr: self regExpr asPureRegExpr
        directive: (self directive notNil
                ifTrue: [self directive asMessageSelector]
                ifFalse: [nil])!
   
directive

    ^directive!

directive: argument

    directive := argument!
   
printOn: aStream

    self tokenClass printOn: aStream.
    aStream nextPutAll: ' = '.
    self regExpr printOn: aStream.
    aStream
        nextPutAll: '    ';
        nextPutAll: '    '.
    self directive printOn: aStream!
  
regExpr

    ^regExpr!

regExpr: argument

    regExpr := argument!
   
specRuleClass

    ^TokenSpecificationRule!
   
tokenClass

    ^tokenClass!
  
tokenClass: argument

    tokenClass := argument! !

!TokenSpecRuleNode class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================


Instance Variables:
    tokenClass    <TokenClassNode> - the name of the token class.
    regExpr        <RegularExpressionNode> (actually, any one of its concrete subclasses) - the regular expression tree representing the specification of the token class.
    directive         <DirectiveNode + UndefinedObject> - the optional scanner directive.'!

tokenClass: arg1 regExpr: arg2 directive: arg3

    | newMe |
    newMe := self new.
    newMe tokenClass: arg1.
    newMe regExpr: arg2.
    newMe directive: arg3.
    ^newMe! !

!TokenSpecScanner methodsFor: 'as yet unclassified' !
  
newScanToken
    "Scan the next token and compute its token type."

    | ch |
    self atEnd
        ifTrue: [self signalEndOfInput]
        ifFalse:
            [(ch := self nextChar) == $\
                ifTrue:
                    [self getNextChar.
                    self tokenType: '<eschar>'.
                    (ch := self nextChar) == $x
                        ifTrue: [self scanForTwoHexDigits ifTrue: [self tokenType: '<hchar>']]
                        ifFalse: [ch == $o
                                ifTrue: [self scanForThreeOctalDigits ifTrue: [self tokenType: '<ochar>']]
                                ifFalse: [self nextChar isDigit ifTrue: [self scanForTwoDigits ifTrue: [self tokenType: '<dchar>']]]]]
                ifFalse:
                    [self tokenType: '<char>'.
                    ch == $<
                        ifTrue: [self scanForTokenClass ifTrue: [self tokenType: '<tokenclass>']]
                        ifFalse: [ch == ${
                                ifTrue: [self scanForDirective ifTrue: [self tokenType: '<directive>']]
                                ifFalse: [ch == $"
                                        ifTrue:
                                            [[self getNextChar.
                                            self nextChar == $"] whileFalse.
                                            self getNextChar; getNextChar.
                                            self buffer reset.
                                            ^self scanToken]
                                        ifFalse: [self nextChar isSeparator
                                                ifTrue:
                                                    [[self getNextChar.
                                                    self nextChar isSeparator] whileTrue.
                                                    self buffer reset.
                                                    ^self scanToken]]]]].
            self token: self buffer contents.
            self buffer reset]!

scanForThreeOctalDigits

    self atEnd ifTrue: [^false].
    self getNextChar.
    (self nextChar between: $0 and: $7)
        ifTrue:
            [self atEnd
                ifTrue:
                    [self putBackChar.
                    ^false].
            self getNextChar.
            (self nextChar between: $0 and: $7)
                ifTrue:
                    [self atEnd
                        ifTrue:
                            [self putBackChar; putBackChar.
                            ^false].
                    self getNextChar.
                    (self nextChar between: $0 and: $7)
                        ifTrue: [^true]
                        ifFalse:
                            [self
                                 putBackChar;
                                 putBackChar;
                                 putBackChar.
                            ^false]]
                ifFalse:
                    [self putBackChar; putBackChar.
                    ^false]]
        ifFalse:
            [self putBackChar.
            ^false]!

scanForTwoHexDigits

    | ch |
    self atEnd ifTrue: [^false].
    self getNextChar.
    ((ch := self nextChar) isDigit or: [(ch between: $A and: $F)
            or: [ch between: $a and: $f]])
        ifTrue:
            [self atEnd
                ifTrue:
                    [self putBackChar.
                    ^false].
            self getNextChar.
            ((ch := self nextChar) isDigit or: [(ch between: $A and: $F)
                    or: [ch between: $a and: $f]])
                ifTrue: [^true]
                ifFalse:
                    [self putBackChar; putBackChar.
                    ^false]]
        ifFalse:
            [self putBackChar.
            ^false]! !

!TokenSpecScanner class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a scanner for T-gen token specifications.'! !

!TokenTypeActionHolder methodsFor: 'as yet unclassified' !
 
action

    ^action!
  
action: argument

    action := argument!
 
type

    ^type!
  
type: argument

    type := argument! !

!TokenTypeActionHolder class methodsFor: 'as yet unclassified' !
   
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am used to package token type and actions together for transport between FSAFinalStates and the scanner.

Instance Variables:
    type        <String> - token type.
    action        <Symbol + UndefinedObject> - a message selector that will be sent to the scanner (via #perform:) when a token with this type is recognized.'!
   
type: arg1 action: arg2

    | newMe |
    newMe := self new.
    newMe type: arg1.
    newMe action: arg2.
    ^newMe! !

!TransductionGrammarProduction methodsFor: 'as yet unclassified' !
   
asInitialLR0Item

    ^self lr0ItemClass
        leftHandSide: self leftHandSide
        preDotSymbols: OrderedCollection new
        postDotSymbols: self rightHandSide copy
        translationSymbol: self translationSymbol!
  
asInitialLR1ItemWithLookahead: terminal

    ^self lr1ItemClass
        leftHandSide: self leftHandSide
        preDotSymbols: OrderedCollection new
        postDotSymbols: self rightHandSide copy
        lookahead: terminal
        translationSymbol: self translationSymbol!
  
asNonLalrSuffixedProduction
    "Assuming I am of the form 'A.<stuff1>* -> B.<stuff2>* C.<stuff3>*',
    answer the prefix production 'A -> B C'."

    | separator lhs rhs |
    separator := self symbolSuffixSeparatorChar.
    lhs := self leftHandSide copyUpTo: separator.
    rhs := self rightHandSide collect: [:sym | sym copyUpTo: separator].
    ^self species
        leftHandSide: lhs
        rightHandSide: rhs
        translationSymbol: self translationSymbol!
  
computeResultNodeFor: builder withArgNodes: nodes
    "Three kinds of translation symbols are currently supported: node names, special
    directives, and arbitrary message selectors. For a node name, a new instance of
    the specified node is created and given nodes, if any, as its children. The special
    directive 'nil' simply returns nil. The directive liftRightChild adds any nodes
    preceeding the right-most node as children to the right-most node, and returns
    the right-most node. The directive liftLeftChild works in an analogous fashion.
    Arbitrary message selectors must take the number of arguments in nodes and
    are invoked as a builder message, thus allowing users to define their own
    tree-building messages."

    | symbol node |
    symbol := self translationSymbol asSymbol.
    symbol first isUpperCase ifTrue: [^nodes isEmpty
            ifTrue: [builder makeNewNode: symbol]
            ifFalse: [builder makeNewNode: symbol withChildren: nodes]].
    symbol = self epsilonSymbol ifTrue: [^builder answerNil].
    symbol = self rightLiftSymbol
        ifTrue:
            [nodes size < 2 ifTrue: [self error: 'Only use liftRightChild when there are at least two right-hand-side nonterminals.'].
            "special case for building lists ending with epsilon"
            (nodes size = 2 and: [nodes last isNil])
                ifTrue: [^builder answerArgument: nodes first].
            node := nodes removeLast.
            ^builder addChildrenFirst: nodes to: node].
    symbol = self leftLiftSymbol
        ifTrue:
            [nodes size < 2 ifTrue: [self error: 'Only use liftLeftChild when there are at least two right-hand-side nonterminals.'].
            "special case for building lists beginning with epsilon"
            (nodes size = 2 and: [nodes first isNil])
                ifTrue: [^builder answerArgument: nodes last].
            node := nodes removeFirst.
            ^builder addChildrenLast: nodes to: node].
    symbol numArgs = nodes size ifFalse: [self error: 'Translation message selectors must have the same number of arguments as right-hand-side nonterminals.'].
    nodes isEmpty ifTrue: [^builder perform: symbol].
    "It may be more efficient to check the number of arguments and use
    perform:with:, etc., but probably not."
    ^builder perform: symbol withArguments: nodes asArray!
 
computeResultNodeFor: builder withTokenClassValue: value
    "I am assumed to be a production of the form 'A -> <tc> => symbol'.
    The symbol can be either a node name or a one-argument message selector.
    If it is a node name then create a new instance of that node with the specified
    attribute value. If it is a message selector then invoke the corresponding
    operation on the builder with the specified value."

    | symbol |
    symbol := self translationSymbol asSymbol.
    symbol first isUpperCase
        ifTrue: [^builder makeNewNode: symbol withAttribute: value]
        ifFalse: [symbol numArgs = 1
                ifTrue: [^builder perform: symbol with: value]
                ifFalse: [self error: 'Expected either a node name or a one argument
message selector as a translation symbol.']]!
   
constructItsContentOn: aStream using: tokenTable
"Emit  lhs , #( rhs ) and translationSymbol on aStream"

    | array |

    array := Array with: (tokenTable indexOf: self leftHandSide)
                           with: (Array new: self rightHandSide size)
                           with: (tokenTable indexOf: self translationSymbol).

    self rightHandSide inject: 1 into: [:i :ea |
        (array at: 2) at: i put: (tokenTable indexOf: ea).
        i + 1
    ].

    array reconstructOn: aStream.

    "
    super constructItsContentOn: aStream using: tokenTable.
    (tokenTable indexOf: self translationSymbol)
        reconstructOn: aStream
    "!
   
epsilonSymbol

    ^#nil!
 
hasTranslation

    ^true!

leftLiftSymbol

    ^#liftLeftChild!
  
printOn: aStream

    super printOn: aStream.
    aStream nextPutAll: ' {'.
    self printSymbol: self translationSymbol asSymbol on: aStream.
    aStream nextPutAll: '} '!
   
rightLiftSymbol

    ^#liftRightChild!

translationSymbol

    ^translationSymbol!

translationSymbol: argument

    translationSymbol := argument! !

!TransductionGrammarProduction class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I add a translation attribute to context-free grammar productions so that I can be used to build simple transduction grammars (or syntax-directed translation scheme).  Transduction grammars are used to build abstract syntax trees rather than derivation trees during parsing.  For more information, refer to Chapter 7. ("Syntax-Directed Translation") in {\em Compiler Construction:  Theory and Practice} by Barrett, Bates, Gustafson, and Couch.

Instance Variables:
    translationSymbol <String> - used as basis for translation node when parsing.'!
  
leftHandSide: arg1 rightHandSide: arg2 translationSymbol: arg3

    | newMe |
    newMe := self new.
    newMe leftHandSide: arg1.
    newMe rightHandSide: arg2.
    newMe translationSymbol: arg3.
    ^newMe! !

!TranslationNode class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I hold a transduction node.'! !

!TranslatorGenerator methodsFor: 'as yet unclassified' !
  
acceptGrammarSpec: aText from: aPane

    self grammarSpecification: aText.
    self grammarSpecParser requestor: aPane.
    self tokenSpecParser requestor: self tokenSpecController.
    (self tokenSpecification isNil or: [self tokenSpecification isEmpty])
        ifTrue: [self cr; showCR: 'No token classes have been specified (did you forget to ''accept'' them?).'].

    self buildParserIfFail: [^false].
    ^true!

acceptInputText: aText from: aPane

    self inputText: aText.
    self parser isNil
        ifTrue:
            [self cr; showCR: 'No parser has been generated.'.
            ^true].
    isLL1 | isSLR1 | isLALR1 | isLR1 ifFalse: [(MessageBox confirm: 'The current parser was nondeterministic when built.
Are you sure you want to continue?')
            ifFalse: [^true]].
    self parser requestor: aPane.
    self isParserModeDefault
        ifTrue:
            [self parserResult: (self parser parseForDerivationTree: aText ifFail: [^false]).
            self postInspectResultMessage.
            ^true].
    self isParserModeTrace
        ifTrue:
            [self parserResult: (self parser
                    parseAndTrace: aText
                    on: self
                    ifFail: [^false]).
            self postSuccessMessage.
            ^true].
    self isParserModeShamAST
        ifTrue:
            [self parserResult: (self parser parseForShamAST: aText ifFail: [^false]).
            self postInspectResultMessage.
            ^true].
    self isParserModeAST
        ifTrue:
            [self parserResult: (self parser parseForAST: aText ifFail: [^false]).
            self postInspectResultMessage.
            ^true].
    ^false!
  
acceptTokenSpec: aText from: aController

    self tokenSpecification: aText.
    ^true!
 
astModeMarker

    ^#AST!
 
buildFSAFrom: rules and: literalDict
    "Answer a minimal deterministic FSA that will recognize rules and literals."

    | startState |
    startState := self fsaStateClass new.
    rules do: [:rule | rule regExpr
            asFSAWithType: rule tokenClass
            andAction: rule directive
            startingAt: startState].
    literalDict associationsDo: [:assoc | assoc value asFSAWithLiteral: assoc key startingAt: startState].
    ^startState asNearMinimalDFSAWithUniqueTokenClasses!
 
buildLiteralDictionaryIfFail: aBlock
    "Answer a Dictionary from (de-escaped) literal tokens to their corresponding
    regular expressions."

    | litDict |
    litDict := Dictionary new.
    self grammar literalTerminals do: [:lit | litDict at: lit put: (self convertToRegExpr: lit ifFail: aBlock)].
    ^litDict!
   
buildParserIfFail: aBlock

    | tokenSpecNode grammarNode rules scanner newParser litDict |
    self resetParserAndFlags.
    tokenSpecNode := self tokenSpecParser parseForAST: self tokenSpecification ifFail: aBlock.
    grammarNode := self grammarSpecParser parseForAST: self grammarSpecification ifFail: aBlock.
    rules := tokenSpecNode asSpecRuleList.
    self cr; show: 'Checking grammar... '.
    ([self grammar: grammarNode asGrammar. true] on: GrammarNotReduced do: [:ex |
        self showCR: ex errorString.
        ex exitWith: false.
    ]) ifFalse: [^aBlock value].
    self showCR: 'done.'.
    litDict := self buildLiteralDictionaryIfFail: aBlock.
    self show: 'Building scanner... starting at: '.
    self showCR: Time now printString; tab.
    (self sameScannerSpec: self tokenSpecification usingLits: litDict)
        ifTrue:
            [self showCR: 'Scanner has not changed - no build required.'.
            scanner := self oldScanner]
        ifFalse:
            [self showCR: 'Scanner new or has changed - build required.'.
            CursorManager execute changeFor: [scanner := self buildScannerFromRules: rules withLiteralDict: litDict]].
    self tab; showCR: '...done at: '.
    self showCR: Time now printString.
    self oldScannerSpec: self tokenSpecification asString.        "Must force a copy"
    self oldScannerLits: litDict keys.
    self oldScanner: scanner.
    self show: 'Building parser...starting at: '.
    self showCR: Time now printString.
    CursorManager execute changeFor: [self isGrammarModeDefault
            ifTrue: [self generateParser]
            ifFalse: [self isGrammarModeLL
                    ifTrue: [self generateLLParser]
                    ifFalse: [
                        self isGrammarModeLR
                            ifTrue: [
                                self isGrammarModeLR1
                                    ifTrue: [self generateLR1Parser]
                                    ifFalse: [self generateLRParser]
                            ]
                            ifFalse: [self error: 'What mode am I in then?!!?!!']]]].
    self tab; show: '...done at: '.
    self showCR: Time now printString.
    self showCR: self grammarClassification.
    newParser := self parser.
    newParser scanner: scanner.
    newParser treeBuilder: self treeBuilderClass new.
    ^newParser!
 
buildScannerFromRules: rules withLiteralDict: literalDict
    "Answer a scanner that scans according to the rules, also recognizing
    literalTokens."

    | fsa |
    fsa := self buildFSAFrom: rules and: literalDict.
    ^self scannerClass new fsa: fsa!
   
clear
"Reset the transcriptView for the next accept."

    self statusTextBuffer: String new.
    self changed: #clear!
 
computeLR0ClosureOf: itemSet
    "For all items in itemSet of the form 'B -> <alpha> . A <beta>'
    recursively add new items of the form 'A -> . <gamma>'."

    ^self computeLR0ClosureOf: itemSet withProdMap: self computeProductionMap!
   
computeLR0ClosureOf: itemSet withProdMap: prodMap
    "For all items in itemSet of the form 'B -> <alpha> . A <beta>'
    recursively add new items of the form 'A -> . <gamma>'."

    | nonterms sym newItemSet |
    nonterms := Set new.
    itemSet do: [:item | (sym := item nextSymbol) isNonterminal ifTrue: [nonterms add: sym]].
    newItemSet := ItemSet new.
    newItemSet addAll: itemSet.
    nonterms do: [:nont | newItemSet addAll: ((prodMap at: nont)
                collect: [:prod | prod asInitialLR0Item])].
    ^itemSet size = newItemSet size
        ifTrue: [newItemSet]
        ifFalse: [self computeLR0ClosureOf: newItemSet withProdMap: prodMap]!
  
computeLR1ClosureOf: itemSet
    "For all items in itemSet of the form 'B -> <alpha> . A <beta> : lookahead'
    recursively add new items of the form 'A -> . <gamma> : First(<beta> lookahead)'."

    ^self computeLR1ClosureOf: itemSet withProdMap: self computeProductionMap!
 
computeLR1ClosureOf: itemSet withProdMap: prodMap
    "For all items in itemSet of the form 'B -> <alpha> . A <beta> : lookahead'
    recursively add new items of the form 'A -> . <gamma> : First(<beta> lookahead)'."

    | nontermItems newItemSet |
    nontermItems := Set new.
    itemSet do: [:item | item nextSymbol isNonterminal ifTrue: [nontermItems add: item]].
    newItemSet := ItemSet new.
    newItemSet addAll: itemSet.
    nontermItems do: [:item | (self lr1LookaheadSetFor: item)
            do: [:la | (prodMap at: item nextSymbol)
                    do: [:prod | newItemSet add: (prod asInitialLR1ItemWithLookahead: la)]]].
    ^itemSet size = newItemSet size
        ifTrue: [newItemSet]
        ifFalse: [self computeLR1ClosureOf: newItemSet withProdMap: prodMap]!
   
computeProductionMap
    "Delegate to my grammar."

    ^self grammar computeProductionMap!
  
convertToRegExpr: aString ifFail: aBlock
    "Answer a regular expression object by interpreting aString as a token class
    specification. Token specification meta-characters must be escaped in aString."

    | rules tokenSpecNode |
    tokenSpecNode := self tokenSpecParser parseForAST: (self escapedTokenSpecDeclFor: aString)
                ifFail: aBlock.
    rules := tokenSpecNode asSpecRuleList.
    ^rules first regExpr!
  
cr
    "Perform a carriage return."

    self show: (String with: Character cr)!
 
defaultModeMarker

    ^#default!
 
defaultScannerClass
    "This is the default scanner class, a more specialized scanner class may be designated using a
    middle button menu item in the transcript pane."

    ^FSABasedScanner!
  
defaultTreeBuilderClass
    "This is the default tree builder class, a more specialized tree builder class may be designated
    using a middle button menu item in the transcript pane."

    ^AbstractSyntaxTreeBuilder!
  
defineScannerClass
    "Prompt the user for the name of a new scanner class. An instance of this class will
    be installed in each new parser built."

    | scannerName newScannerClass |
    (scannerName := Prompter prompt: 'Type the name of the preferred scanner class.' default: 'FSABasedScanner')
        isNil ifTrue: [^nil].
    newScannerClass := Smalltalk at: scannerName asSymbol ifAbsent: [^self showCR: 'No class named ' , scannerName , '.'].
    newScannerClass isBehavior ifFalse: [^self showCR: scannerName , ' is not a class name.'].
    self scannerClass: newScannerClass.
    self showCR: 'Rebuild scanner and parser.'.
    self resetParserAndFlags!
  
defineTreeBuilderClass
    "Prompt the user for the name of a new parse tree builder class. An instance of this class will
    be installed in each new parser built."

    | builderName builderClass |
    (builderName := Prompter prompt: 'Type the name of the new parse tree builder class.' default: 'AbstractSyntaxTreeBuilder')
        isNil ifTrue: [^self].
    builderClass := Smalltalk at: builderName asSymbol ifAbsent: [^self showCR: 'No class named ' , builderName , '.'].
    builderClass isBehavior ifFalse: [^self showCR: builderName , ' is not a class name.'].
    self treeBuilderClass: builderClass.
    self parser notNil
        ifTrue:
            [self parser treeBuilder: builderClass new.
            self showCR: 'New parse tree builder installed in current parser.']!
   
escapedTokenSpecDeclFor: aString
    "Answer a string of the form '<x> : aString ;' where all metacharacters in aString
    have been escaped (proceeded by a backslash)."

    | aStream metaChars |
    aStream := WriteStream on: (String new: 20).
    aStream nextPutAll: '<x> : '.
    metaChars := self tokenSpecMetaChars.
    aString do:
        [:ch |
        (metaChars includes: ch)
            ifTrue: [aStream nextPut: $\].
        aStream nextPut: ch].
    aStream nextPut: $;.
    ^aStream contents!
   
extantStateFor: itemSet in: stateItemMap
    "If stateItemMap includes itemSet as one of its values answer the corresponding
    state, otherwise answer nil. (This is the same as Dictionary>>keyAtValue:ifAbsent:
    [^nil] except that it uses = rather than ==.)"

    stateItemMap associationsDo: [:assoc | assoc value = itemSet ifTrue: [^assoc key]].
    ^nil!
 
findTransitionItemSet: itemSet
    "Arbitrarily choose a transition symbol (immediately after a dot)
    and answer the set of items that have transitions on that symbol.
    All 'atEnd' items have already been removed."

    | transitSym |
    transitSym := itemSet first postDotSymbols first.
    ^itemSet select: [:item | self is: item postDotSymbols first theSameAs: transitSym]!
  
fsaStateClass

    ^FSAState!
 
generateLLParser
    "Try to build an LL parser for this language."

    self ll1Parser ifTrue: [^true].
    (MessageBox confirm: 'Grammar is not LL(1) but a transformation may be.
Do you wish to try transforming the grammar?')
        ifTrue: [self ll1ParserWithTransformations ifTrue: [^true]].
    ^false!
 
generateLR1Parser
"Try to build an LR parser for this language."

    self lr1Parser ifTrue: [^true].
    ^false!
   
generateLRParser
    "Try to build an LR parser for this language."

    self slr1Parser ifTrue: [^true].
    (MessageBox confirm: 'Grammar is not LALR(1).
Do you wish to try LR(1) analysis
(this may take a while)?')
        ifTrue: [self lr1Parser ifTrue: [^true]].
    ^false!
  
generateParser
    "Try to build a parser for this language."

    ^self generateLLParser
        ifTrue: [true]
        ifFalse: [self generateLRParser]!
 
generateSLR1Parser
"Try to build an LR parser for this language."

    self slr1Parser ifTrue: [^true].
    (MessageBox confirm: 'Grammar is not LALR(1).
Do you wish to try LR(1) analysis
(this may take a while)?')
        ifTrue: [self lr1Parser ifTrue: [^true]].
    ^false!

grammar

    ^grammar!

grammar: argument

    grammar := argument!
   
grammarClass

    ^Grammar!
   
grammarClassification
    "Answer a string describing my classification."

    self isLL1 ifTrue: [self transformedGrammar isNil
            ifTrue: [^'Grammar is LL(1).']
            ifFalse: [^'Grammar is LL(1), but required transformations.']].
    self isSLR1 ifTrue: [^'Grammar is SLR(1).'].
    self isLALR1 ifTrue: [^'Grammar is LALR(1).'].
    self isLR1
        ifTrue: [^'Grammar is LR(1).']
        ifFalse: [^'Parser generation failed; nondeterministic parser is available for inspection.']!
   
grammarMode

    ^grammarMode!

grammarMode: argument

    grammarMode := argument!
   
grammarSpecification

    ^grammarSpecification!
  
grammarSpecification: argument

    grammarSpecification := argument!
 
grammarSpecParser

    ^self class grammarSpecParser!
 
init
"set status defaults"

    self resetParserAndFlags.
    self tokenSpecification: String new.
    self setGrammarModeToDefault.
    self setParserModeToDefault.
    self scannerClass: self defaultScannerClass.
    self treeBuilderClass: self defaultTreeBuilderClass.
    self oldScannerSpec: nil.
    self oldScannerLits: nil!
   
initialLR0ItemSet

    ^ItemSet with: (self lr0ItemClass initialItemForGrammar: self grammar)!

initialLR1ItemSet

    ^ItemSet with: (self lr1ItemClass initialItemForGrammar: self grammar)!

inputText

    ^inputText!

inputText: argument

    inputText := argument!
   
inspectGrammar

    self transformedGrammar isNil
        ifTrue: [self grammar inspect]
        ifFalse: [self transformedGrammar inspect]!

inspectParser

    self parser isNil
        ifTrue: [self showCR: 'No parser to inspect.']
        ifFalse: [self parser inspect]!
 
inspectResult

    self parserResult inspect!
 
installScannerAndParserClasses
    | baseName category |
    ((baseName := Prompter prompt: 'Type in a base name for the new scanner
and parser classes, e.g. if you typed ''Gork''
the classes created would be named
GorkScanner and GorkParser' default: 'Gork')  notNil and: [baseName notEmpty])
            ifTrue:
                [self
                    cr;
                    show: 'Installing classes ';
                    show: baseName;
                    show: 'Scanner and ';
                    show: baseName;
                    show: 'Parser... '.
                self parser fastParser
                    createScannerParserClassesNamed: baseName
                    category: category
                    tokenSpec: self tokenSpecification
                    grammarSpec: self grammarSpecification.
                self showCR: 'done.']!
 
is: symOne theSameAs: symTwo
    "Compare the symbols for equality. This method is required because T-gen uses
    Strings to represent terminals and Symbols for non-terminals, and a String and
    Symbol with the same characters are considered equal. Thus, 'prod' = #prod is true
    in Smalltalk but not in T-gen."

    ^symOne isTerminal = symTwo isTerminal
        ifTrue: [symOne = symTwo]
        ifFalse: [false]!

isGrammarModeDefault

    ^self grammarMode = self defaultModeMarker!
 
isGrammarModeLALR1

    ^self grammarMode = self lalr1ModeMarker!
 
isGrammarModeLL

    ^self grammarMode = self llModeMarker!
   
isGrammarModeLR

    ^self lrModeMarkers includes: self grammarMode!
  
isGrammarModeLR1

    ^self grammarMode = self lr1ModeMarker!
 
isGrammarModeSLR1

    ^self grammarMode = self slr1ModeMarker!
   
isLALR1

    ^isLALR1!

isLALR1: argument

    isLALR1 := argument!
   
isLL1

    ^isLL1!

isLL1: argument

    isLL1 := argument!
   
isLR1

    ^isLR1!

isLR1: argument

    isLR1 := argument!
   
isParserModeAST

    ^self parserMode = self astModeMarker!
   
isParserModeDefault

    ^self parserMode = self defaultModeMarker!
   
isParserModeShamAST

    ^self parserMode = self shamAstModeMarker!
   
isParserModeTrace

    ^self parserMode = self traceModeMarker!
   
isSLR1

    ^isSLR1!
  
isSLR1: argument

    isSLR1 := argument!
 
lalr1ModeMarker

    ^#LALR1!
 
ll1Parser
    "Attempt to construct an LL(1) parser for my grammar.
    Answer true if I can and false otherwise."

    | table prod |
    table := self llParserTableClass new.
    self grammar selectSets
        associationsDo:
            [:assoc |
            prod := assoc key.
            assoc value do: [:term | table
                    atNonterminal: prod leftHandSide
                    andTerminal: term
                    addProduction: prod]].
    table isDeterministic
        ifTrue:
            [self isLL1: true.
            self parser: (self ll1ParserClass parseTable: table spaceOptimize startSymbol: self grammar startSymbol).
            ^true]
        ifFalse:
            [self parser: (self ll1ParserClass parseTable: table startSymbol: self grammar startSymbol).
            ^false]!

ll1ParserClass

    ^LL1Parser!
   
ll1ParserWithTransformations
    "Assuming my original grammar is not LL(1), attempt to derive an equivalent LL(1)
    grammar and parser for my original grammar through various grammar
    manipulations. Answer true if I can and false otherwise."

    | oldGrammar |
    oldGrammar := self grammar.
    self grammar: oldGrammar copyForManipulation.
    self grammar makeLL1Transformations.
    self ll1Parser
        ifTrue:
            [self isLL1: true.
            self transformedGrammar: self grammar.
            self grammar: oldGrammar.
            ^true]
        ifFalse:
            [self grammar: oldGrammar.
            ^false]!
  
llModeMarker

    ^#LL!
   
llParserTableClass

    ^LLParserTable!
   
lr0ItemClass

    ^LR0Item!
   
lr1ItemClass

    ^LR1Item!
   
lr1LookaheadSetFor: item
    "Delegate to my grammar."

    ^self grammar lr1LookaheadSetFor: item!
  
lr1ModeMarker

    ^#LR1!
 
lr1Parser
    "Attempt to build an LR(1) parser for my grammar.
    Answer true if successful and false otherwise.

    Based on Algorithm 6.2 from 'Principles of Compiler Design',
    by Aho and Ullman, 1977."

    | stateItemMap startState unprocessedStates currState closure transitItems transitSym newItemSet nextState finalState conflictStates |
    stateItemMap := Dictionary new.
    conflictStates := Set new.
    startState := self lrParserStateClass new.
    unprocessedStates := Set with: startState.
    stateItemMap at: startState put: self initialLR1ItemSet.
    [unprocessedStates isEmpty]
        whileFalse:
            [currState := unprocessedStates removeFirst.
            closure := self computeLR1ClosureOf: (stateItemMap at: currState).
            "Process all reduce items."
            (closure select: [:item | item atEnd])
                do:
                    [:item |
                    item isFinalStateItem
                        ifTrue: [finalState := currState]
                        ifFalse:
                            [currState reduceMap at: item lookahead add: item asGrammarProduction.
                            currState reduceMap at: item lookahead ifNotUnique:
                                ["reduce/reduce conflict"
                                conflictStates add: currState]].
                    closure remove: item].
            [closure isEmpty]
                whileFalse:
                    [transitItems := self findTransitionItemSet: closure.
                    transitSym := transitItems first postDotSymbols first.
                    newItemSet := ItemSet new.
                    transitItems do: [:item | newItemSet add: item deepCopy shift].
                    (nextState := self extantStateFor: newItemSet in: stateItemMap) isNil
                        ifTrue:
                            [nextState := self lrParserStateClass new.
                            unprocessedStates add: nextState.
                            stateItemMap at: nextState put: newItemSet].
                    currState goto: nextState on: transitSym.
                    (currState reduceMap includesKey: transitSym)
                        ifTrue:
                            ["shift/reduce conflict"
                            conflictStates add: currState].
                    closure removeAll: transitItems]].
    conflictStates isEmpty
        ifTrue:
            [self isLR1: true.
            self parser: (self lrParserClass parseTable: startState finalState: finalState) spaceOptimize.
            ^true]
        ifFalse:
            [self parser: (self lrParserClass parseTable: startState finalState: finalState).
            ^false]!
   
lrModeMarker

    ^#LR!
   
lrModeMarkers

    ^#(LR1 SLR1 LALR1)!

lrParserClass

    ^LR1Parser!

lrParserFinalStateClass

    ^FSAFinalState!
  
lrParserStateClass

    ^LRParserState!
   
oldScanner

    ^oldScanner!
  
oldScanner: argument

    oldScanner := argument!
 
oldScannerLits

    ^oldScannerLits!
  
oldScannerLits: argument

    oldScannerLits := argument!
 
oldScannerSpec

    ^oldScannerSpec!
  
oldScannerSpec: argument

    oldScannerSpec := argument!
 
parser

    ^parser!
  
parser: argument

    parser := argument!
 
parserMode

    ^parserMode!
  
parserMode: argument

    parserMode := argument!
 
parserResult

    ^parserResult!
  
parserResult: argument

    parserResult := argument!
 
postInspectResultMessage

    self cr; showCR: 'Choose ''result'' from the middle button menu in this pane to inspect the results of the successful parse.'!
  
postSuccessMessage

    self cr; showCR: 'The parse of the test input was successful.'!
   
resetParserAndFlags
    "Reset my state for parser generation."

    self isLL1: false.
    self isSLR1: false.
    self isLALR1: false.
    self isLR1: false.
    self parser: nil.
    self grammar: nil.
    self transformedGrammar: nil!
 
sameScannerSpec: newSpec usingLits: newLits
    "Has the Specification for the scanner changed since it was last generated?"

    (oldScannerSpec = nil or: [oldScannerLits = nil])
        ifTrue: [^false].
    ^oldScannerLits size = (newLits keys union: oldScannerLits) size and: [oldScannerSpec = newSpec asString]!
   
scannerClass

    ^scannerClass!
  
scannerClass: argument

    scannerClass := argument!
 
setGrammarMode: modeMarker

    self grammarMode: modeMarker.!

setGrammarModeToDefault

    self grammarMode: self defaultModeMarker!

setGrammarModeToLL

    self grammarMode: self llModeMarker!
  
setGrammarModeToLR

    self grammarMode: self lrModeMarker!
  
setParserMode: modeMarker

    self parserMode: modeMarker.!
  
setParserModeToAST

    self parserMode: self astModeMarker!
  
setParserModeToDefault

    self parserMode: self defaultModeMarker!
  
setParserModeToShamAST

    self parserMode: self shamAstModeMarker!
  
setParserModeToTrace

    self parserMode: self traceModeMarker!
  
shamAstModeMarker

    ^#shamAST!
 
show: aString
"Append aString to the status transcript text."

    self statusTextBuffer: aString.
    self changed: #statusTextBuffer!
 
showCR: aString
    "Append aString to the status transcript text and perform a carriage return."

    self show: aString; cr!
   
slr1ModeMarker

    ^#SLR1!
   
slr1Parser
    "Attempt to build an SLR(1) parser for my grammar.
    Answer true if successful and false otherwise.

    Based on Algorithm 6.1 from 'Principles of Compiler Design',
    by Aho and Ullman, 1977."

    | stateItemMap startState unprocessedStates currState closure transitItems transitSym newItemSet nextState finalState conflictStates slr1Parser |
    stateItemMap := Dictionary new.
    conflictStates := Set new.
    startState := self lrParserStateClass new.
    unprocessedStates := Set new.
    stateItemMap at: startState put: self initialLR0ItemSet.
    unprocessedStates add: startState.
    [unprocessedStates isEmpty]
        whileFalse:
            [currState := unprocessedStates removeFirst.
            closure := self computeLR0ClosureOf: (stateItemMap at: currState).
            "Process all reduce items."
            (closure select: [:item | item atEnd])
                do:
                    [:item |
                    item isFinalStateItem
                        ifTrue: [finalState := currState]
                        ifFalse:
                            ["SLR(1) lookahead symbols"
                            (self grammar followSetOf: item leftHandSide)
                                do:
                                    [:term |
                                    currState reduceMap at: term add: item asGrammarProduction.
                                    currState reduceMap at: term ifNotUnique:
                                        ["reduce/reduce conflict"
                                        conflictStates add: currState]]].
                    closure remove: item].
            [closure isEmpty]
                whileFalse:
                    [transitItems := self findTransitionItemSet: closure.
                    transitSym := transitItems first postDotSymbols first.
                    newItemSet := ItemSet new.
                    transitItems do: [:item | newItemSet add: item deepCopy shift].
                    (nextState := self extantStateFor: newItemSet in: stateItemMap) isNil
                        ifTrue:
                            [nextState := self lrParserStateClass new.
                            unprocessedStates add: nextState.
                            stateItemMap at: nextState put: newItemSet].
                    currState goto: nextState on: transitSym.
                    (currState reduceMap includesKey: transitSym)
                        ifTrue:
                            ["shift/reduce conflict"
                            conflictStates add: currState].
                    closure removeAll: transitItems]].
    slr1Parser := self lrParserClass parseTable: startState finalState: finalState.
    conflictStates isEmpty
        ifTrue:
            [self isSLR1: true.
            self parser: slr1Parser spaceOptimize.
            ^true]
        ifFalse:
            ["try LALR(1) analysis"
            (slr1Parser lalr1AnalyzeConflicts: conflictStates originalGrammar: self grammar)
                ifTrue:
                    [self isLALR1: true.
                    self parser: slr1Parser spaceOptimize.
                    ^true]
                ifFalse:
                    [self parser: slr1Parser.
                    ^false]]!
 
statusTextBuffer

    ^statusTextBuffer!
  
statusTextBuffer: argument

    statusTextBuffer := argument!
 
statusTextBufferMenu

    ^Menu
        labels: 'again\undo\copy\cut\paste\accept\cancel\result\builder\grammar\parser\scanner\install' withCrs
        selectors: #(again undo copySelection cut paste accept cancel inspectResult defineTreeBuilderClass inspectGrammar inspectParser defineScannerClass installScannerAndParserClasses )!

tab
    "Perform a tab over."

    self show: '    '.
    "
    self show: (String with: Character tab)
    "!

text

    ^'hello' asText!

textMenu
    "Answer an Menu of operations on the source code that is to be displayed
    when the operate menu button is pressed."

    ^Menu
        labels: 'again\undo\copy\cut\paste\accept\cancel' withCrs
        lines: #(2 5 )
        selectors: #(again undo copySelection cut paste alwaysAccept cancel )!
   
tokenSpecController

    ^tokenSpecController!

tokenSpecController: argument

    tokenSpecController := argument!
   
tokenSpecification

    ^tokenSpecification!
  
tokenSpecification: argument

    tokenSpecification := argument!
 
tokenSpecMetaChars

    ^TokenSpecMetaChars!
  
tokenSpecParser

    ^self class tokenSpecParser!
 
traceModeMarker

    ^#Trace!
 
transformedGrammar

    ^transformedGrammar!
  
transformedGrammar: argument

    transformedGrammar := argument!
 
treeBuilderClass

    ^treeBuilderClass!
  
treeBuilderClass: argument

    treeBuilderClass := argument! !

!TranslatorGenerator class methodsFor: 'as yet unclassified' !
 
classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I''m an application for generating scanners and parsers for arbitrary context-free languages.  My view contains four panes and several status buttons, as described below:

View Panes:
    top-left         - token class specifications are entered and ''accepted'' here.
    bottom-left    - grammar specifications are entered and ''accepted'' here.  Status buttons control what kind of parser is generated, either LL or LR varieties.
    top-right        - status transcript, status messages and other information is sent here.
    bottom-right    - test strings in the specified language are entered and ''accepted'' here.  Status buttons control the resulting parser actions.  To view the result of a test input parse choose the middle button menu item ''result'' in the transcript pane.

I attempt to generate a parser for a given a context-free grammar.  Basically, I try LL(1) first and LR variations second.  (See the parser generation protocol for more details.)

Instance Variables:
    grammar                    <Grammar> - original context-free grammar for which I''m trying to build a parser.
    transformedGrammar    <Grammar | UndefinedObject> - an LL(1) transformed version of my grammar, if needed, requested, and possible.
    isLL1,
    isSLR1,
    isLALR1,
    isLR1                        <Boolean> - grammar status flags.
    parser                        <LL1Parser | LR1Parser | UndefinedObject> - a parser for my grammar, if one could be built.
    statusTextBuffer            <Text> - status transcript pane text buffer.
    tokenSpecification        <Text>
    grammarSpecification    <Text>
    inputText                    <Text>
    grammarMode                <Symbol> - represents state of grammar pane status button.
    parserMode                <Symbol> - represents state of test input pane status button.
    parserResult                <DerivationTreeNode | ParseTreeNode> - result of test input parse.
    tokenSpecController        <Controller> - ''accepting'' a grammar specification actually processes both grammar and token class specifications.  Direct access to the token spec Controller is needed for reporting errors in the token class specification.
    scannerClass                <FSABasedScanner | ?> - class used to build scanners.  Some languages may require more sophisticated scanners with multiple-token lookahead (see FSABasedScannerWithOneTokenLookahead and FSABasedScannerWithTwoTokenLookahead).
    treeBuilderClass            <AbstractSyntaxTreeBuilder | ?> - class used to build AST builders for parsers.  Users may define specilizations of this class.
    oldScannerSpec             <String> - previous scanner spec.
    oldScannerLits                 <Set of String> - literals from previous grammar spec.
    oldScanner                     <FSABasedScanner | ?> - previously generated scanner.'!
 
example1
    "Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    (none)

    grammar spec:
    S    : 'a' S 'b'     {Pair} ;
    S    :              {Core} ;

    status: LL(1) and SLR(1)

    test input:
    aaabbb
    "!
 
example10
    "Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    <var>    : [a-z] ;
    <num>    : [0-9]+ ;
    <space> : [\s\t\r]+            {ignoreDelimiter} ;

    grammar spec:
    Prog             : LetExpr ;
    Prog             : Expr                         {LetNode} ;
    LetExpr        : 'let' Defs 'in' Expr         {LetNode} ;
    Defs             : Def Defs0                {liftRightChild} ;
    Defs0             : ',' Defs ;
    Defs0             :                             {OrderedChildren} ;
    Def             : VarName '=' Number    {DefinitionNode} ;
    Expr             : Term Expr0                 {liftRightChild};
    Expr0             : '+' Expr                     {PlusNode} ;
    Expr0            : '-' Expr                     {MinusNode} ;
    Expr0            :                             {nil} ;
    Term            : Factor Term0             {liftRightChild};
    Term0            : '*' Term                     {TimesNode} ;
    Term0            : '/' Term                     {DivideNode} ;
    Term0         :                             {nil};
    Factor        : VarName ;
    Factor         : Number ;
    Factor         : '(' Expr ')' ;
    VarName        : <var>                     {VarNode} ;
    Number        : <num>                     {NumberNode} ;

    status: LL(1) and SLR(1)

    test input:
    let
    x = 3,
    y = 7,
    z = 2
    in
    x * (y + z / 4)    "!
 
example11
    "This grammar demonstrates the ability to fix nondeterministic parsers by hand.
    Evaluate the following expression and then test the grammar. Try to build an LL(1) parser
    and when asked to perform transformations, answer no. From the middle button menu in
    the transcript pane inspect the parser. Inspect the parseTable instance variable. The 'E' row
    and 'else' column has a double entry. Using the inspectors, remove the production 'E : ;' from
    the set and evaluate 'self spaceOptimize' in the parseTable inspector. The resulting parser
    will successfully parse the input and can be installed. For more information see the T-gen
    User's Guide."
    "TranslatorGeneratorView open"
    "token spec:
    <space> : [\s\t\r]+    {ignoreDelimiter} ;

    grammar spec:
    G : S ';' ;
    S : 'if' S E | 'other' ;
    E : 'else' S | ;

    status: not LL(1) and not LR(1)

    test input:
    if if other else other;
    "!
  
example2
    "Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    <id> : [a-z]+ ;
    <number> : [0-9]+ ;
    <space> : [\s\t\r]+            {ignoreDelimiter} ;



    grammar spec:
    Z        : 'program' Decls Stmts    {Program} ;
    Decls    : 'var' IdList ':' 'integer'    {Decls} ;
    IdList    : Name IdList                {liftRightChild} ;
    IdList    : Name                    {IdList} ;
    Stmts    : 'begin' SL 'end'            {Stmts} ;
    SL        : S SL                         {liftRightChild} ;
    SL        : Stmts SL                    {liftRightChild} ;
    SL        : S                             {StmtList} ;
    SL        : Stmts                    {StmtList} ;
    S        : Name ':=' E ';'             {Assign} ;
    E        : E '+' T                        {Plus} ;
    E        : T ;
    T        : P '*' T                        {Times} ;
    T        : P;
    P        : '(' E ')' ;
    P        : Name ;
    P        : <number>                {Number} ;
    Name    : <id>                        {Id} ;
    status: SLR(1) and LL(1), with transformations

    test input:
    program
    var
    a b c : integer
    begin
    a := 3;
    b := a * 4;
    begin
    c := a + b;
    a := a + 1;
    end
    end
    "!

example3
    "Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    <space> : [\s\t\r]+            {ignoreDelimiter} ;

    grammar spec:
    E : T Ec         {liftRightChild} ;
    Ec : '+' E        {Plus} ;
    Ec :                {nil} ;
    T : P Tc        {liftRightChild} ;
    Tc : '*' T        {Times} ;
    Tc :            {nil} ;
    P : 'a'             {A} ;
    P : 'b'             {B} ;
    P : 'c'             {C} ;

    status: LL(1) and SLR(1)

    test input:
    a + b * c + a
    "!
  
example4
    "Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    <space> : [\s\t\r]+            {ignoreDelimiter} ;


    grammar spec:
    E : P ;
    P : 'a'
    | '(' A ';' A ')'
    | '(' V ',' V ')' ;
    V : 'a' ;
    A : 'a' ;

    status: LALR(1)

    test input:
    (a ; a)
    "!

example5
    "Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    <space> : [\s\t\r]+            {ignoreDelimiter} ;


    grammar spec:
    S : 'a' B 'b'
    | 'a' D 'a'
    | 'b' B 'a'
    | 'b' D 'b' ;
    B : A ;
    A : 'a' ;
    D : 'a' ;

    status: LR(1)

    test input:
    a a a
    "!
 
example6
    "Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    <space> : [\s\t\r]+            {ignoreDelimiter} ;


    grammar spec:
    E : E '+' E
    | E '*' E
    | 'a' ;

    status: not LL(1) and not LR(1)

    test input:
    a + a * a
    "!
 
example7
    "This grammar demonstrates the need of simple scanner backup.
    Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    (none)

    grammar spec:
    S : E S | ;
    E : 'a' | 'abc' | 'bd' ;

    status: LL(1) and SLR(1)

    test input:
    abd
    "!

example8
    "This grammar demonstrates the need of two-token scanner lookahead.
    Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    (none)

    grammar spec:
    S : E S | ;
    E : 'a' | 'ab' | 'abc' | 'bd' ;

    status: LL(1) and SLR(1)

    test input:
    abd
    "!
   
example9
    "This demonstrates how to build flat non-empty lists.
    Evaluate the following expression and then test the grammar."
    "TranslatorGeneratorView open"
    "token spec:
    (none)

    grammar spec:
    E : E P        {liftLeftChild}
    | P            {OrderedChildren} ;
    P : 'a'        {A}
    | 'b'            {B}
    | 'c'            {C} ;

    status: LL(1) with transformations (translations are still not handled) and SLR(1)

    test input:
    abc
    "!
   
grammarSpecParser

    ^grammarSpecParser!

grammarSpecParser: argument

    grammarSpecParser := argument!
   
initialize
    "TranslatorGenerator initialize"

    self grammarSpecParser: GrammarSpecParser new.
    self tokenSpecParser: TokenSpecParser new.
    self initializeTokenSpecMetaChars!
  
initializeTokenSpecMetaChars
    "These characters are special to the TokenSpecParser and must be escaped."

    | chars |
    chars := Set new.
    chars addAll: #($: $; $| $* $+ $? $( $) $[ $] $~ $- $< $> ${ $} $\ ).
    chars
         add: Character space;
         add: Character tab;
         add: Character cr.
    TokenSpecMetaChars := chars!
 
new

    ^super new init!
 
tokenSpecParser

    ^tokenSpecParser!

tokenSpecParser: argument

    tokenSpecParser := argument! !

!TreNode methodsFor: 'as yet unclassified' !
 
childrenDo: aBlock
    "Evaluate aBlock for each of my children.
    This message should be reimplemented by my subclasses."

    ^self        "default"!
   
copyTree
    "Answer a copy of this tree."

    ^self copy updateChildrenUsing: [:child | child copyTree]!
   
postorderDo: aBlock
    "Perform a postorder traversal on myself and my children.
    This message may be used for examining the nodes of a tree
    for the purpose of gathering data or altering data fields.
    To alter the structure of the tree see traverseDo:.  One of
    the main advantages of this message is that it allows all nodes
    of the tree 'global' access to objects referenced in aBlock.
    Before, such arguments had to be passed explitely as arguments.
    This message may be used as follows.

    aMethodNode postorderDo: [:node | node enc: encoder root: self]"

    self childrenDo: [:child | child postorderDo: aBlock].
    aBlock value: self!

preorderDo: preBlock postorderDo: postBlock
    "Perform a traversal on myself and my children.  The preBlock is
    evaluated when entering a node and postBlock is evaluated just before
    leaving.  See comment in postorderDo:."

    preBlock value: self.
    self childrenDo: [:child | child preorderDo: preBlock postorderDo: postBlock].
    postBlock value: self!
  
preorderDo: preBlock updateUsing: postBlock
    "Perform a traversal on myself and my children.  The preBlock is
    evaluated when first entering a node.  My children are replaced
    with the results of the traversal.  Thus, this message can be used
    to generate objects or alter my structure, whereas postorderDo:
    can only be used to examine my structure.  This message may be
    used in the following manner.

    a := aMethodNode
        preorderDo: [:node | node msg1]
        updateUsing: [:node | node msg2: globalRef]"

    preBlock value: self.
    self updateChildrenUsing: [:child | child preorderDo: preBlock updateUsing: postBlock].
    ^postBlock value: self!

updateChildrenUsing: aBlock
    "Replace my children according to the value of aBlock.
    This message should be reimplemented by my subclasses."

    ^self        "default"!
 
updateCopyUsing: aBlock
    "Perform a postorder traversal on a copy of myself and
    my children, replacing my children with the results of the traversal.
    Thus, this message can be used to generate objects or alter
    my structure, whereas postorderDo: can only be used to examine
    my structure.  This message may be used in the following manner.

    a := aMethodNode updateCopyUsing: [:node | node msg: globalRef]"

    | newNode |
    newNode := self copy.
    newNode updateChildrenUsing: [:child | child updateCopyUsing: aBlock].
    ^aBlock value: newNode!

updateUsing: aBlock
    "Perform a postorder traversal on myself and my children,
    replacing my children with the results of the traversal.
    Thus, this message can be used to generate objects or alter
    my structure, whereas postorderDo: can only be used to examine
    my structure.  This message may be used in the following manner.

    a := aMethodNode updateUsing: [:node | node msg: globalRef]"

    self updateChildrenUsing: [:child | child updateUsing: aBlock].
    ^aBlock value: self! !

!TreNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

This abstract class provides the framework for both destructive and non-destructive tree traversals in which references to locally global objects are available without being explicitly passed as arguments.

Concrete subclasses must implement methods for traversing

    childrenDo:
        "Evaluate the argument block with each of my children."

    updateChildrenUsing:
        "Replace my children with the result of evaluating the argument block with the corresponding child."'! !

!UnaryRegExprNode methodsFor: 'as yet unclassified' !

addChildrenInitial: anOrderedCollection

    anOrderedCollection size = 1
        ifTrue: [self onlyChild: anOrderedCollection removeFirst]
        ifFalse: [self error: 'wrong number of children']!
  
childrenDo: aBlock
    "Evaluate aBlock for each of my children."

    aBlock value: self onlyChild!
 
hasBeenTransformed

    ^true!

isAltNode

    ^false!

isCatNode

    ^false!

isEpsilonNode

    ^false!

needTransforming

    ^true!
  
onlyChild

    ^onlyChild!

onlyChild: argument

    onlyChild := argument!
   
performTransformation: lhs with: gamma with: lhsNames

    | rhsNode |
    onlyChild isCatNode
        ifTrue: [rhsNode := self createCatNode: lhs with: gamma]
        ifFalse: [rhsNode := self createNewRHS: lhs with: gamma].
    ^self createNewProduction: lhs and: rhsNode!

updateChildrenUsing: aBlock
    "Replace my children according to the value of aBlock."

    self onlyChild: (aBlock value: self onlyChild)! !

!UnaryRegExprNode class methodsFor: 'as yet unclassified' !

classHeader
    ^'=================================================
    Copyright (c) 1992 by Justin O. Graver.
    All rights reserved (with exceptions).
    For complete information evaluate "Object tgenCopyright."
=================================================

I am a unary regular expression.'!
   
onlyChild: arg1

    | newMe |
    newMe := self new.
    newMe onlyChild: arg1.
    ^newMe! !

!Object methodsFor: 'as yet unclassified' !
  
@ anObject
    "Answer an OrderedPair with the receiver as the x element and anObject as the y element."

    ^OrderedPair x: self y: anObject! !

!Object methodsFor: 'as yet unclassified' !
 
isFSAFinalState

    ^false! !

!Object methodsFor: 'as yet unclassified' !
 
isGrammarProduction

    ^false! !

!Object methodsFor: 'as yet unclassified' !
 
isItemSet

    ^false! !

!Object methodsFor: 'as yet unclassified' !
   
isLR0Item

    ^false! !

!Object methodsFor: 'as yet unclassified' !
   
isLR1Item

    ^false! !

!Object methodsFor: 'as yet unclassified' !
   
isNonterminal

    ^false! !

!Object methodsFor: 'as yet unclassified' !
   
isPartitionTransitionMap

    ^false! !

!Object methodsFor: 'as yet unclassified' !

isTerminal

    ^false! !

!Object methodsFor: 'as yet unclassified' !
  
isTokenClassification

    ^false! !

!Object methodsFor: 'as yet unclassified' !
   
reconstructOn: aStream

    self printOn: aStream! !

!Object methodsFor: 'as yet unclassified' !
   
reconstructOn: aStream using: dummy

    self printOn: aStream! !

!Object methodsFor: 'as yet unclassified' !
  
reversePairWith: x
    "Answer a new OrderedPair whose x value is the argument and whose y value is the receiver."

    ^OrderedPair x: x y: self! !

!Behavior methodsFor: 'as yet unclassified' !

compileMethod: aString

    | result |

    result := self compile: aString.

    (result isNil)
        ifTrue: [^false].
    
    SourceManager current
        logSource: aString
        forSelector: result key
        inClass: self.
        
    ^true! !

!Collection methodsFor: 'as yet unclassified' !
  
reconstructOn: aStream
"Emit #( elements ) on aStream"

    self asArray reconstructOn: aStream.
    "
    aStream poundSign; leftParenthesis.
    self do:
        [:ea |
        ea reconstructOn: aStream.
        aStream space].
    aStream rightParenthesis
    "! !

!IndexedCollection methodsFor: 'as yet unclassified' !

prevIndexOf: anObject from: start to: stop
"Answer the index position of the element equal
         to anObject in the receiver.  If no such element
         is found, evaluate aBlock (without any arguments)."
    | index size |
    size := self size.
    index := start.
    [index < stop or: [index <= 0]] whileFalse: [
        (self at: index) = anObject ifTrue: [^index].
        index := index - 1.
    ].
    ^nil! !

!Array class methodsFor: 'as yet unclassified' !
   
new: size withAll: anObject
"-----------------------------------------------------------
Date           By      Description
06/03/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    ^(self new: size)
        atAllPut: anObject;
        yourself! !

!Array methodsFor: 'as yet unclassified' !
 
reconstructOn: aStream
"Emit #( elements) on aStream ."

    | size index firstTime |

    size := self size.
    aStream
        nextPutAll: '((';
        nextPutAll: 'A n: '.
    size printOn: aStream.
    aStream nextPut: $).
    index := 1.
    firstTime := true.
    [index <= size] whileTrue: [
        (self at: index) notNil ifTrue: [
            firstTime ifFalse: [aStream nextPut: $;].
            firstTime := false.
            aStream nextPutAll: 'a: '.
            index printOn: aStream.
            aStream nextPutAll: ' p: '.
            (self at: index) reconstructOn: aStream.
        ].
        index := index + 1.
    ].
    firstTime
        ifFalse: [aStream nextPutAll: ';y'].
    aStream nextPut: $); cr.

    "
    aStream
         poundSign;
         leftParenthesis;
         space.
    1 to: self size do:
        [:index |
        (self at: index)
            reconstructOn: aStream.
        aStream space].
    aStream rightParenthesis
    "! !

!Array methodsFor: 'as yet unclassified' !
   
reconstructOn: aStream using: tokenTable
"Emit #( elements) on aStream ."
    | size index firstTime |

    size := self size.
    aStream
        nextPutAll: '((';
        nextPutAll: 'A n: '.
    size printOn: aStream.
    aStream nextPut: $).
    index := 1.
    firstTime := true.
    [index <= size] whileTrue: [
        (self at: index) notNil ifTrue: [
            firstTime ifFalse: [aStream nextPut: $;].
            firstTime := false.
            aStream nextPutAll: 'a: '.
            index printOn: aStream.
            aStream nextPutAll: ' p: '.
            (self at: index) reconstructOn: aStream using: tokenTable.
        ].
        index := index + 1.
    ].
    firstTime
        ifFalse: [aStream nextPutAll: ';y'].
    aStream nextPut: $); cr.


    "
    aStream
         poundSign;
         leftParenthesis;
         space.
    1 to: self size do:
        [:index |
        (self at: index)
            reconstructOn: aStream.
        aStream space].
    aStream rightParenthesis
    "! !

!String methodsFor: 'as yet unclassified' !
  
asNonterminal

    ^self asSymbol! !

!String methodsFor: 'as yet unclassified' !
   
copyUpToLast: aCharacter
"-----------------------------------------------------------
Date           By      Description
06/08/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"
    "Answer a copy of the receiver from index 1 to the last occurrence of
    aCharacter, non-inclusive."

    | index |
    (index := self
                prevIndexOf: aCharacter
                from: self size
                to: 1) isNil ifTrue: [^self].
    ^self copyFrom: 1 to: index - 1! !

!String methodsFor: 'as yet unclassified' !

isTerminal

    ^true! !

!String methodsFor: 'as yet unclassified' !
   
isTokenClassTerminal

    ^'<*>' match: self! !

!String methodsFor: 'as yet unclassified' !

match: aString
"-----------------------------------------------------------
Date           By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    ^((Pattern new: self) match: aString index: 1) notNil! !

!String methodsFor: 'as yet unclassified' !

numArgs
"-----------------------------------------------------------
Date           By      Description
06/05/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    ^self occurrencesOf: $:! !

!String methodsFor: 'as yet unclassified' !
 
reconstructOn: aStream

    self printOn: aStream! !

!String methodsFor: 'as yet unclassified' !
   
replaceFrom: start to: stop with: aCollection
"-----------------------------------------------------------
Date           By      Description
06/09/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"
    (start = 1 and: [stop = 65535]) ifFalse: [
        ^super replaceFrom: start to: stop with: aCollection
    ].

    stop - start + 1 = aCollection size
        ifFalse: [
            ^self error: 'replacement collection has wrong size'].

    self replaceFrom: 1
           to: 65534
           with: aCollection
           startingAt: 1.

    self at: 65535 put: (aCollection at: 65535).
    ^self! !

!Symbol methodsFor: 'as yet unclassified' !

isNonterminal

    ^true! !

!Symbol methodsFor: 'as yet unclassified' !

isTerminal

    ^false! !

!Symbol methodsFor: 'as yet unclassified' !
  
isTokenClassTerminal

    ^false! !

!Symbol methodsFor: 'as yet unclassified' !

reconstructOn: aStream
"-----------------------------------------------------------
Date           By      Description
06/08/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"
    self storeOn: aStream! !

!OrderedCollection methodsFor: 'as yet unclassified' !
   
removeFirst: numOfObjects
"-----------------------------------------------------------
Date           By      Description
06/08/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    numOfObjects timesRepeat: [self removeFirst]! !

!Set methodsFor: 'as yet unclassified' !
 
first
"Answer an arbitrary element. If the receiver is empty, provide an error
    notification. The selector 'first' is used for compatibility with
    SequenceableCollections."

    self isEmpty ifTrue: [self errorAbsentElement].
    self do: [:each | ^each]! !

!Set methodsFor: 'as yet unclassified' !
   
removeFirst
    "Answer (and remove) an arbitrary element. The selector 'removeFirst' is used for
    compatibility with SequenceableCollections."

    | element |
    element := self first.
    self remove: element.
    ^element! !

!Set methodsFor: 'as yet unclassified' !
 
union: aCollection

        "CX added -

         Answer a new set containing all elements that are
         in either the receiver or aCollection, or in both."

    aCollection isNil
        ifTrue: [^self copy].
    ^self copy
        addAll: aCollection;
        yourself! !

!Dictionary methodsFor: 'as yet unclassified' !
 
asDictionary

    ^self! !

!Dictionary methodsFor: 'as yet unclassified' !
 
associationsSelect: aBlock ifNone: eBlock
"For each key/value pair in the receiver, evaluate
         aBlock with the association as the argument.
         Answer a new object containing those key/value pairs
         for which aBlock evaluates to true."
    | answer |
    (answer := super associationsSelect: aBlock) isEmpty ifTrue: [^eBlock].
    ^answer! !

!Dictionary methodsFor: 'as yet unclassified' !
  
elements

    ^self values! !

!Dictionary methodsFor: 'as yet unclassified' !
  
reconstructOn: aStream
"Emit #( keys ) and #( values ) on aSteam"

    aStream
         poundSign;
         leftParenthesis;
         space.
    self
        associationsDo:
            [:assoc |
            assoc key reconstructOn: aStream.
            aStream space].
    aStream
         rightParenthesis;
         space;
         poundSign;
         leftParenthesis.
    self
        associationsDo:
            [:assoc |
            assoc value reconstructOn: aStream.
            aStream space].
    aStream rightParenthesis; space! !

!Dictionary methodsFor: 'as yet unclassified' !
   
valuesAsSet
    "Answer a set containing the receiver's values."

    | aSet |
    aSet := Set new: self size.
    self do: [:each | aSet add: each].
    ^aSet! !

!Character class methodsFor: 'as yet unclassified' !

cr

    ^Cr! !

!Character class methodsFor: 'as yet unclassified' !

endOfInput
    "Answer the Character representing ctrl-d ."

    ^self value: 4! !

!Character class methodsFor: 'as yet unclassified' !
   
leftParenthesis
    "Answer the Character representing a left parenthesis."

    ^self value: 40! !

!Character class methodsFor: 'as yet unclassified' !
  
period
    "Answer the Character representing a carriage period."

    ^self value: 46! !

!Character class methodsFor: 'as yet unclassified' !

poundSign
    "Answer the Character representing a pound sign."

    ^self value: 35! !

!Character class methodsFor: 'as yet unclassified' !
  
rightParenthesis
    "Answer the Character representing a right parenthesis."

    ^self value: 41! !

!Character class methodsFor: 'as yet unclassified' !

space

    ^Space! !

!Character methodsFor: 'as yet unclassified' !

copyUpToLast: char

    ^self! !

!Number methodsFor: 'as yet unclassified' !
   
reversePairWith: x
"-----------------------------------------------------------
Date           By      Description
06/03/92    HsH     Creation

Copyright (c) 1992 GENESYS, and Hal Hildebrand.  All Rights Reserved.
-----------------------------------------------------------"

    ^Point x: x y: self! !

!Stream methodsFor: 'as yet unclassified' !
  
leftParenthesis
    "Append a left parenthesis character to the receiver."

    self nextPut: Character leftParenthesis! !

!Stream methodsFor: 'as yet unclassified' !

period
    "Append a period character to the receiver."

    self nextPut: Character period! !

!Stream methodsFor: 'as yet unclassified' !

poundSign
    "Append a # character to the receiver."

    self nextPut: Character poundSign! !

!Stream methodsFor: 'as yet unclassified' !
   
rightParenthesis
    "Append a right parenthesis character to the receiver."

    self nextPut: Character rightParenthesis! !

!WriteStream methodsFor: 'as yet unclassified' !

crTab
"Write the line terminating character (carriage-line-feed)
         to the receiver stream."
    self nextPut: Cr;
        nextPut: Lf;
        nextPutAll: '    '.! !

!WriteStream methodsFor: 'as yet unclassified' !
   
crtab
"Write the line terminating character (carriage-line-feed)
         to the receiver stream."
    self nextPut: Cr;
        nextPut: Lf;
        nextPutAll: '    '.! !

!Character methodsFor: 'as yet unclassified' !
 
asStringTGEN
    "Answer the receiver converted into a String."

    ^String with: self
! !

!Character class methodsFor: 'as yet unclassified' !
 
tabTGEN

    ^Tab
! !

!Stream methodsFor: 'private' !
 
skipSeparatorsTGEN

    [self atEnd or:[self peek > $ ]]
        whileFalse: [self next]
! !

!Stream methodsFor: 'as yet unclassified' !
 
skipWhiteSpaceTGEN
        "Skip over whiteSpace characters. "

    [self atEnd or:[self peek > $ ]]
        whileFalse: [self next]
! !

!String methodsFor: 'as yet unclassified' !

strippedForTGEN: chars

        "CX added -

         Returns a compressed version of self with all
         instances of chars stripped out."

    | new pos |
    new := String new: self size.
    pos := 0.
    (chars isKindOf: Collection)
        ifTrue: [
            self do: [ :c |
                (chars includes: c)
                    ifFalse: [ new at: (pos := pos + 1) put: c]]]
        ifFalse: [
            self do: [ :c |
                (chars == c)
                    ifFalse: [ new at: (pos := pos + 1) put: c]]].
    (pos == 0)
        ifTrue: [^'']
        ifFalse: [^new copyFrom: 1 to: pos]! !

!Object methodsFor: 'publishAndSubscribe' !
 
subclassResponsibility

  ^self implementedBySubclass! !

!Object methodsFor: 'as yet unclassified' !
   
shouldNotImplement
        "Initiate a walkback because a subclass doesn't
		 implement a message that it should."
	^self error:
		'should not implement'! !

!String methodsFor: 'as yet unclassified' !
 
copyUpTo: aCharacter

    ^self upTo: aCharacter! !

!Collection methodsFor: 'as yet unclassified' !

removeAll: aCollection ifAbsent: aBlock
        "Answer aCollection.  Remove all the elements
         contained in aCollection from the receiver collection."
    aCollection do: [ :element | self remove: element ifAbsent: aBlock ].
    ^aCollection! !

" File In of Application: TranGenApp  generated: Jun 22, 1992 at: 19:15:48 "!
   
" DefinedClasses: " !

!TranslatorGenerator class methodsFor: 'as yet unclassified' !
 
TranslatorGeneratorInitialization

    FSABasedScanner initialize.
    HandCodedScanner initialize.
    OptimizedScanner initialize.

    TableDrivenParser initialize.
    OptimizedLL1Parser initialize.
    OptimizedLR1Parser initialize.

    EscapedCharNode initialize.

    LRParserState initialize.
    LLParserTable initialize.
    FSAState initialize.

    Grammar initialize.

    DLGScanner initialize.
    TokenSpecParser initialize.
    GrammarSpecParser initialize.
    TranslatorGenerator initialize.! !
 
TranslatorGenerator TranslatorGeneratorInitialization!
  
"TranGenApp preLoad initialization code"

    (Smalltalk includesKey: #A) ifFalse: [
        Array variableSubclass: #A
            instanceVariableNames: ''
            classVariableNames: ''
            poolDictionaries: ''.
    ].
!
 
"Methods for application: CGraphNodes " !
   
"Methods for application: CollectionsGraphs " !
 
"Methods for application: CollectionsStreams " !

"Methods for application: CollectionsUnordered " !
  
"Methods for application: CompilersParsers " !
  
"Methods for application: CompilersScanners " !
 
"Methods for application: HSHScannerMods " !

"Methods for application: SingleTokenScanners " !
   
"Methods for application: TwoTokenScanners " !
  
"Methods for application: KernelObjects " !
 
"Methods for application: TgenGrammarNodes " !
  
"Methods for application: TgenInterface " !
 
"Methods for application: TgenParseTrees " !

"Methods for application: TgenRegularExpressionNodes " !

"Methods for application: TgenScanningParsing " !
   
"Methods for application: TgenSupport " !
   
"Methods for application: TgenTokenSpecificationNodes " !
   
"Methods for application: TranGenApp " !

"TranGenApp postLoad initialization code"


    FSABasedScanner initialize.
    HandCodedScanner initialize.
    OptimizedScanner initialize.


    TableDrivenParser initialize.
    OptimizedLL1Parser initialize.
    OptimizedLR1Parser initialize.

    EscapedCharNode initialize.

    LRParserState initialize.
    LLParserTable initialize.
    FSAState initialize.

    Grammar initialize.

    DLGScanner initialize.
    TokenSpecParser initialize.
    GrammarSpecParser initialize.
    TranslatorGenerator initialize.


!