"
******************************************************************************
Application : Drag Drop Example
Date        : 06/01/94
Time        : 12:00:00

Introduction
============

This file contains the source code for the WindowBuilder Pro/V Win32
Drag & Drop Example.

Use the 'File | Install..' command to install this example.

(c) Objectshare Systems, Inc. 1994

For more information contact:

    Objectshare Systems, Inc.
    5 Town & Country Village, Suite 735
    San jose, CA 95128-2026
    (408) 970-7280 Orders & Support
    (408) 970-7282 Fax




Description
===========

Classes : 
    DragAndDropExample 

Methods : 

******************************************************************************
"!

ViewManager subclass: #DragAndDropExample
  instanceVariableNames: 
    ' moveMsg '
  classVariableNames: ''
  poolDictionaries: 
    ' ColorConstants WinConstants '!




!DragAndDropExample class methods !

wbCreated

    ^true! !



!DragAndDropExample methods !
  
clearMove
    "Clear the move message."

    moveMsg := nil.!

createViews

     "WARNING!!  This method was automatically generated by
      WindowBuilder.  Code you add here which does not conform
      to the WindowBuilder API will probably be lost the next time
      you save your layout definition."

     | v p |

    self addView: (
        v := self topPaneClass new
            owner: self;
            labelWithoutPrefix:  'Drag and Drop Example';
            noSmalltalkMenuBar;
            viewName: 'mainView';
            framingBlock: ( FramingParameters new iDUE: 951 @ 456; xC; yC; cRDU: (2 @ 454 rightBottom: 949 @ 40));
            pStyle: #(sysmenu titlebar);
            addSubpane: (
                StaticBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 357 @ 98; lDU: 576 r: #left; tDU: 8 r: #top);
                    blackFrame;
                    startGroup;
                    yourself
            );
            addSubpane: (
                StaticBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 357 @ 280; lDU: 576 r: #left; rDU: 933 r: #left; tDU: 120 r: #top; bDU: 400 r: #top);
                    blackFrame;
                    startGroup;
                    yourself
            );
            addSubpane: (
                StaticBox new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 539 @ 392; lDU: 18 r: #left; tDU: 8 r: #top);
                    blackFrame;
                    startGroup;
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 238 @ 32; lDU: 293 r: #left; rDU: 530 r: #left; tDU: 16 r: #top; bDU: 48 r: #top);
                    centered;
                    startGroup;
                    contents: 'Text Editor';
                    yourself
            );
            addSubpane: (
                StaticText new
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 229 @ 32; lDU: 37 r: #left; rDU: 265 r: #left; tDU: 16 r: #top; bDU: 48 r: #top);
                    centered;
                    startGroup;
                    contents: 'Sorted List';
                    yourself
            );
            addSubpane: (
                (p := TextEdit new)
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 247 @ 328; lDU: 293 r: #left; rDU: 539 r: #left; tDU: 56 r: #top; bDU: 384 r: #top);
                    paneName: 'text editor';
                    wordWrap;
                    startGroup;
                    when: #losingFocus send: #clearMove to: self;
                    when: #dragDropped: send: #droppedOnTextEditor:pane: to: self withArgument: p;
                    when: #needsDragDropObjects send: #dragFromTextEditor: to: self withArgument: p;
                    dragDropSender;
                    dragDropReceiver;
                    backColor: ClrBackground;
                    yourself
            );
            addSubpane: (
                (p := DropDownList new)
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 304 @ 306; lDU: 603 r: #left; rDU: 907 r: #left; tDU: 32 r: #top; bDU: 338 r: #top);
                    paneName: 'drop down list';
                    dropDownList;
                    startGroup;
                    when: #losingFocus send: #clearMove to: self;
                    when: #dragDropped: send: #droppedOnDropDownList:pane: to: self withArgument: p;
                    when: #needsDragDropObjects send: #dragFromDropDownList: to: self withArgument: p;
                    dragDropSender;
                    dragDropReceiver;
                    backColor: ClrBackground;
                    yourself
            );
            addSubpane: (
                (p := MultipleSelectListBox new)
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 238 @ 328; lDU: 37 r: #left; rDU: 274 r: #left; tDU: 56 r: #top; bDU: 384 r: #top);
                    contents: #( 'Bart' 'Dan' 'Dina' 'Eric' 'James' 'Karen' 'Ken' 'Ray' 'Robert' 'Sridhar' 'Steve' 'Susan' 'Ted' );
                    startGroup;
                    when: #losingFocus send: #clearMove to: self;
                    when: #dragDropped: send: #droppedOnList:pane: to: self withArgument: p;
                    when: #needsDragDropObjects send: #dragFromList: to: self withArgument: p;
                    dragDropSender;
                    dragDropReceiver;
                    backColor: ClrBackground;
                    yourself
            );
            addSubpane: (
                (p := EntryField new)
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 320 @ 48; lDU: 594 r: #left; rDU: 914 r: #left; tDU: 136 r: #top; bDU: 184 r: #top; indent: 3 @ 4);
                    paneName: 'field 1';
                    startGroup;
                    when: #losingFocus send: #clearMove to: self;
                    when: #dragDropped: send: #droppedOnField:pane: to: self withArgument: p;
                    when: #needsDragDropObjects send: #dragFromField: to: self withArgument: p;
                    dragDropSender;
                    dragDropReceiver;
                    backColor: ClrBackground;
                    yourself
            );
            addSubpane: (
                (p := EntryField new)
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 320 @ 48; lDU: 594 r: #left; rDU: 914 r: #left; tDU: 200 r: #top; bDU: 248 r: #top; indent: 3 @ 4);
                    paneName: 'field 2';
                    startGroup;
                    when: #losingFocus send: #clearMove to: self;
                    when: #dragDropped: send: #droppedOnField:pane: to: self withArgument: p;
                    when: #needsDragDropObjects send: #dragFromField: to: self withArgument: p;
                    dragDropSender;
                    dragDropReceiver;
                    backColor: ClrBackground;
                    yourself
            );
            addSubpane: (
                (p := EntryField new)
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 320 @ 48; lDU: 594 r: #left; rDU: 914 r: #left; tDU: 264 r: #top; bDU: 312 r: #top; indent: 3 @ 4);
                    paneName: 'field 3';
                    startGroup;
                    when: #losingFocus send: #clearMove to: self;
                    when: #dragDropped: send: #droppedOnField:pane: to: self withArgument: p;
                    when: #needsDragDropObjects send: #dragFromField: to: self withArgument: p;
                    dragDropSender;
                    dragDropReceiver;
                    backColor: ClrBackground;
                    yourself
            );
            addSubpane: (
                (p := EntryField new)
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: 320 @ 48; lDU: 594 r: #left; rDU: 914 r: #left; tDU: 328 r: #top; bDU: 376 r: #top; indent: 3 @ 4);
                    paneName: 'field 4';
                    startGroup;
                    when: #losingFocus send: #clearMove to: self;
                    when: #dragDropped: send: #droppedOnField:pane: to: self withArgument: p;
                    when: #needsDragDropObjects send: #dragFromField: to: self withArgument: p;
                    dragDropSender;
                    dragDropReceiver;
                    backColor: ClrBackground;
                    yourself
            );
        yourself
    ).!
   
dragFromDropDownList: aPane
    "Drag the selected item."

    | item |

    ( item := aPane selectedItem ) notNil ifTrue: [
        aPane setDragDropObjects: ( Array with: item ).

        moveMsg := Message
            receiver: self
            selector: #moveFromList:pane:
            arguments: ( Array with: nil with: aPane ) ].!
 
dragFromField: aPane
    "Drag the pane's contents."

    | item |

    ( item := aPane contents ) notEmpty ifTrue: [
        aPane setDragDropObjects: ( Array with: item ).

        moveMsg := Message
            receiver: self
            selector: #moveFromField:pane:
            arguments: ( Array with: nil with: aPane ) ].!
   
dragFromList: aPane
    "Drag the selected items."

    | items |

    ( items := aPane selectedItems ) notNil ifTrue: [
        aPane setDragDropObjects: items asArray.

        moveMsg := Message
            receiver: self
            selector: #moveFromList:pane:
            arguments: ( Array with: nil with: aPane ) ].!

dragFromTextEditor: aPane
    "Drag the selected text."

    | text stream items |

    ( text := aPane selectedItem ) notEmpty ifTrue: [

        stream := ReadStream on: text.
        items := OrderedCollection new.
        [ stream atEnd ] whileFalse: [ items add: stream nextLine ].
        aPane setDragDropObjects: items asArray.

        moveMsg := Message
            receiver: self
            selector: #moveFromTextEditor:pane:
            arguments: ( Array with: nil with: aPane ) ].!

dragged: aDragDropList
    "Perform the move operation as necessary."

    aDragDropList moveOperation ifTrue: [
        moveMsg evaluateWithArguments: ( Array with: aDragDropList ) ].
    moveMsg := nil.!
  
droppedOnDropDownList: aDragDropList pane: aPane
    "Accept the drag and drop."

    aDragDropList items notEmpty ifTrue: [
        aPane contents: aPane contents, aDragDropList items.
        self dragged: aDragDropList ].!
  
droppedOnField: aDragDropList pane: aPane
    "Accept the drag and drop."

    aDragDropList items notEmpty ifTrue: [
        aPane contents: aDragDropList items first.
        self dragged: aDragDropList ].!
   
droppedOnList: aDragDropList pane: aPane
    "Accept the drag and drop."

    aPane contents: ( aPane contents, aDragDropList items ) asSortedCollection.
    self dragged: aDragDropList.!
 
droppedOnTextEditor: aDragDropList pane: aPane
    "Accept the drag and drop."

    | stream |

    stream := WriteStream on: ( String new: 1000 ).

    stream nextPutAll: aPane contents.
    aDragDropList items do: [ :str | stream cr; nextPutAll: str ].

    aPane contents: stream contents.

    aPane isTextPane ifTrue: [
        aPane class == TextPaneControl ifFalse: [
            aPane update ] ].

    self dragged: aDragDropList.!
 
moveFromDropDownList: aDragDropList pane: aPane
    "Remove the selected text."

    aPane contents: (
        aPane contents reject: [ :elem |
            aDragDropList items includes: elem ] ).!
   
moveFromField: aDragDropList pane: aPane
    "Remove the selected text."

    aPane contents: ''.!
   
moveFromList: aDragDropList pane: aPane
    "Remove the selected text."

    aPane contents: (
        aPane contents reject: [ :elem |
            aDragDropList items includes: elem ] ).!
   
moveFromTextEditor: aDragDropList pane: aPane
    "Remove the selected text."

    aPane clearSelection.

    aPane isTextPane ifTrue: [
        aPane class == TextPaneControl ifFalse: [
            aPane update ] ].!

preInitWindow
    "Initialize the pane contents."

    ( self paneNamed: 'drop down list' )
        contents: #( 'One' 'Two' 'Three' ).

    ( self paneNamed: 'text editor' )
        contents: 'Drag text from one area to another using Ctrl and Alt keys'.! !

"construct application"
((Smalltalk at: #OSIApplication ifAbsent: [])
    isKindOf: Class) ifTrue: [
        ((Smalltalk at: #OSIApplication) for:'Drag Drop Example')
            addClass: DragAndDropExample;
            comments: 'This file contains the source code for the WindowBuilder Pro/V Win32
Drag & Drop Example.

Use the ''File | Install..'' command to install this example.

(c) Objectshare Systems, Inc. 1994

For more information contact:

    Objectshare Systems, Inc.
    5 Town & Country Village, Suite 735
    San jose, CA 95128-2026
    (408) 970-7280 Orders & Support
    (408) 970-7282 Fax

';
            initCode: nil;
            finalizeCode: '        Transcript
            cr; cr; show: ''You can run the example by executing:'';
            cr; cr; show: ''    DragAndDropExample new open''; cr.

';
            fileName: 'dragdrop.st';
            startUpCode: nil;
            dllName: 'NwEvntEx.DLL';
            dllSpecialCode: '';
            dllinitMethod: nil]!

"Finalize"

        Transcript
            cr; cr; show: 'You can run the example by executing:';
            cr; cr; show: '    DragAndDropExample new open'; cr.

!

 
    Transcript cr; show: 'Drag Drop Example installed.'!
