!STB 0 F    Package    6  String   SmallWorldsr   $   Packages\SmallWorlds\SmallWorlds.pacr        STBCollectionProxy    
 STBClassProxy    r      IdentitySet&  Array    STBSymbolProxy    r      SimpleCommandParser*      r      SimpleActor*      r      TerminalLocation*      r      Treasure*      r      ForwardingLocation*      r   
   ImmovableItem*      r      Item*      r   	   TestWorld*      r   
   CommandParser*      r      LightSource*      r      Action*      r      DarkLocation*      r      Describable*      r   
   Connection*      r      AdventureShell*      r   	   Container*      r      Response*      r      Location*      r      Actor*      r      ReflectingLocation*      r      World              r      Set                                  r      Dolphin    STBIdentityDictionaryProxy           r      IdentityDictionary     *      r      postinstallr       *      r      preuninstall  *      r   
   postuninstall  *      r   
   preinstall                       Object subclass: #Action
	instanceVariableNames: 'verb arguments'
	classVariableNames: ''
	poolDictionaries: ''!

Object subclass: #CommandParser
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Object subclass: #Connection
	instanceVariableNames: 'destination synonyms locked key closeable closed entryProbability linkedConnection openDescription closedDescription lockedDescription'
	classVariableNames: ''
	poolDictionaries: ''!

Object subclass: #Describable
	instanceVariableNames: 'longDescription shortDescription shortNounPhrase longNounPhrase article longDescriptionSeen plural'
	classVariableNames: 'RandomGenerator'
	poolDictionaries: ''!

Object subclass: #Response
	instanceVariableNames: 'text'
	classVariableNames: 'RandomGenerator'
	poolDictionaries: ''!

CommandParser subclass: #SimpleCommandParser
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Describable subclass: #Container
	instanceVariableNames: 'contents inventoryable'
	classVariableNames: ''
	poolDictionaries: ''!

Container subclass: #Actor
	instanceVariableNames: 'parser location world alive sequence points'
	classVariableNames: ''
	poolDictionaries: ''!

Container subclass: #Item
	instanceVariableNames: 'lightSource lighted movable points treasure'
	classVariableNames: ''
	poolDictionaries: ''!

Container subclass: #Location
	instanceVariableNames: 'connections lighted world hasWater hasOil'
	classVariableNames: ''
	poolDictionaries: ''!

Container subclass: #World
	instanceVariableNames: 'actor responses randomGenerator oil water'
	classVariableNames: ''
	poolDictionaries: ''!

Actor subclass: #SimpleActor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Item subclass: #ImmovableItem
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Item subclass: #LightSource
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Item subclass: #Treasure
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Location subclass: #DarkLocation
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Location subclass: #ForwardingLocation
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Location subclass: #ReflectingLocation
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Location subclass: #TerminalLocation
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

World subclass: #TestWorld
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Shell subclass: #AdventureShell
	instanceVariableNames: 'inputTextPresenter displayTextPresenter'
	classVariableNames: ''
	poolDictionaries: ''!

'end-class-definition'! X ResourceIdentifier           r      AdventureShellr      AdventureShellF    ViewResource    $ STBResourceSTBByteArrayAccessorProxy    6 	 ByteArray  !STB 0 N    STBViewProxy    
 STBClassProxy    6  String	   ShellView&  Array                    `               '           
 FramingLayout     STBIdentityDictionaryProxy    z             LookupTable      Z       z             TextEdit          `         6  LargeInteger    D  P                                  ;w
 NullConverter                MessageSequence     STBCollectionProxy    z             OrderedCollection       MessageSend     STBSymbolProxy          createAt:extent:       Point                  5   P  b                  selectionRange:       Interval             P  b                  isModified:          P   WINDOWPLACEMENT    6 	 ByteArray,   ,                Y           0          FramingConstraints                fixedParentLeft               fixedParentRight               fixedParentTop   P  7   Z       z             MultilineTextEdit          `              D!D  p                                  ;w                             0        b                       7             p  b               2               p  b      `            p          ,   ,                Y           0               0     P  7               fixedParentBottom   
      z             IdentityDictionary      P     	   inputTextp        displayText     MenuBar                 0         Menu                 0         CommandMenuItem    F    CommandDescription                onSave      &Save                            	   onRestore      &Restore                               onExit      E&xit             &File                   0                                onHelp      &Help             &Help            AcceleratorTable                  Association                  `                              0        b                                  1  `   b                  menuBar:        `           ,   ,           
   
   k  "        0        P  p   Icon           r   
   ShellView.ico STBExternalResourceLibraryProxy    r   
   DolphinDevRes        

Action class instanceVariableNames: ''!

Action comment: ''!

!Action categoriesForClass!No category! !

!Action methodsFor!

arguments
	arguments isNil ifTrue: [ arguments := OrderedCollection new initialize ].
	^arguments!

arguments: aCollection
	arguments := aCollection asOrderedCollection!

verb
	"Answer the value of the receiver's instance variable verb.
	This method was automatically generated, but may be modified."

	^verb!

verb: aString		
	verb := aString! !

!Action categoriesFor: #arguments!accessing! !
!Action categoriesFor: #arguments:!no category! !
!Action categoriesFor: #verb!accessing! !
!Action categoriesFor: #verb:!accessing! !

!Action class methodsFor!

verb: aString arguments: aString2
	^self new initialize verb: aString; arguments: aString2! !

!Action class categoriesFor: #verb:arguments:!no category! !



CommandParser class instanceVariableNames: ''!

CommandParser comment: ''!

!CommandParser categoriesForClass!Adventure! !

!CommandParser methodsFor!

parse: aString withDirections: aCollection
	self subclassResponsibility! !

!CommandParser categoriesFor: #parse:withDirections:!no category! !



Connection class instanceVariableNames: ''!

Connection comment: 'Represents a connection from one location to another.  Connections are one way only - to have a bidirectional connection between locations each location must have a connection leading to the other.  Connections can optionally have a key object specified, in which case they can be locked and unlocked.  When locked the currentOpenProbability should be set to zero; when unlocked the currentOpenProbability should be reset to the baseOpenProbability value.'!

!Connection categoriesForClass!Adventure! !

!Connection methodsFor!

addSynonym: aString
	self removeSynonym: aString.
	self synonyms add: aString asLowercase!

addSynonyms: aCollection
	aCollection do: [ :each | self addSynonym: each ]!

basicClosed: aBoolean
	closed := aBoolean.
	aBoolean ifTrue: [ self closeable: true ]!

basicLocked: aBoolean
	locked := aBoolean!

basicOpen: aBoolean
	self basicClosed: aBoolean not!

closeable
	"Answer the value of the receiver's instance variable closeable.
	This method was automatically generated, but may be modified."

	^closeable!

closeable: aBoolean
	"Set the value of the receiver's instance variable closeable to anObject.
	This method was automatically generated, but may be modified."

	closeable := aBoolean!

closed
	"Answer the value of the receiver's instance variable closed.
	This method was automatically generated, but may be modified."

	^closed!

closed: aBoolean
	"Set the value of the receiver's instance variable closed to anObject.
	This method was automatically generated, but may be modified."

	self basicClosed: aBoolean.
	self linkedConnection notNil ifTrue: [ self linkedConnection basicClosed: aBoolean ]!

closedDescription
	"Answer the value of the receiver's instance variable closedDescription.
	This method was automatically generated, but may be modified."

	^closedDescription!

closedDescription: anObject
	"Set the value of the receiver's instance variable closedDescription to anObject.
	This method was automatically generated, but may be modified."

	closedDescription := anObject!

description
	self locked ifTrue: [ ^self lockedDescription ].
	self closed ifTrue: [ ^self closedDescription ].
	^self openDescription!

destination
	"Answer the value of the receiver's instance variable destination.
	This method was automatically generated, but may be modified."

	^destination!

destination: aLocation
	"Set the value of the receiver's instance variable destination to anObject.
	This method was automatically generated, but may be modified."

	destination := aLocation!

entryProbability
	"Answer the value of the receiver's instance variable entryProbability.
	This method was automatically generated, but may be modified."

	^entryProbability!

entryProbability: aFloat
	"Set the value of the receiver's instance variable entryProbability to anObject.
	This method was automatically generated, but may be modified."

	entryProbability := aFloat!

hasSynonym: aString
	^self synonyms includes: aString asLowercase
!

initialize
	super initialize.
	self
		locked: false;
		closeable: false;
		closed: false;
		entryProbability: 1.0;
		closedDescription: '';
		lockedDescription: '';
		openDescription: ''
		!

key
	"Answer the value of the receiver's instance variable key.
	This method was automatically generated, but may be modified."

	^key!

key: anObject
	"Set the value of the receiver's instance variable key to anObject.
	This method was automatically generated, but may be modified."

	key := anObject!

linkedConnection
	"Answer the value of the receiver's instance variable linkedConnection.
	This method was automatically generated, but may be modified."

	^linkedConnection!

linkedConnection: aConnection
	"Set the value of the receiver's instance variable linkedConnection to anObject.
	This method was automatically generated, but may be modified."

	linkedConnection := aConnection!

locked
	"Answer the value of the receiver's instance variable locked.
	This method was automatically generated, but may be modified."

	^locked!

locked: aBoolean
	self basicLocked: aBoolean.
	self linkedConnection notNil ifTrue: [ self linkedConnection basicLocked: aBoolean ]!

lockedDescription
	"Answer the value of the receiver's instance variable lockedDescription.
	This method was automatically generated, but may be modified."

	lockedDescription = ''
		ifTrue: [ ^'It''s locked' ]
		ifFalse: [ ^lockedDescription ]!

lockedDescription: anObject
	"Set the value of the receiver's instance variable lockedDescription to anObject.
	This method was automatically generated, but may be modified."

	lockedDescription := anObject!

open
	^self closed not!

open: aBoolean
	self basicOpen: aBoolean.
	self linkedConnection notNil ifTrue: [ self linkedConnection basicOpen: aBoolean ]!

openDescription
	"Answer the value of the receiver's instance variable openDescription.
	This method was automatically generated, but may be modified."

	^openDescription!

openDescription: anObject
	"Set the value of the receiver's instance variable openDescription to anObject.
	This method was automatically generated, but may be modified."

	openDescription := anObject!

removeAllSynonyms
	synonyms := nil!

removeSynonym: aString
	self synonyms remove: aString asLowercase ifAbsent: [ ]!

synonyms
	synonyms isNil ifTrue: [ synonyms := OrderedCollection new initialize ].
	^synonyms!

synonyms: anArray
	anArray do: [ :each | self addSynonym: each ]!

transport: anActor
	^self destination receiveActor: anActor
!

unlocked
	^self locked not! !

!Connection categoriesFor: #addSynonym:!no category! !
!Connection categoriesFor: #addSynonyms:!no category! !
!Connection categoriesFor: #basicClosed:!no category! !
!Connection categoriesFor: #basicLocked:!no category! !
!Connection categoriesFor: #basicOpen:!no category! !
!Connection categoriesFor: #closeable!accessing! !
!Connection categoriesFor: #closeable:!accessing! !
!Connection categoriesFor: #closed!accessing! !
!Connection categoriesFor: #closed:!accessing! !
!Connection categoriesFor: #closedDescription!accessing! !
!Connection categoriesFor: #closedDescription:!accessing! !
!Connection categoriesFor: #description!no category! !
!Connection categoriesFor: #destination!accessing! !
!Connection categoriesFor: #destination:!accessing! !
!Connection categoriesFor: #entryProbability!accessing! !
!Connection categoriesFor: #entryProbability:!accessing! !
!Connection categoriesFor: #hasSynonym:!no category! !
!Connection categoriesFor: #initialize!no category! !
!Connection categoriesFor: #key!accessing! !
!Connection categoriesFor: #key:!accessing! !
!Connection categoriesFor: #linkedConnection!accessing! !
!Connection categoriesFor: #linkedConnection:!accessing! !
!Connection categoriesFor: #locked!accessing! !
!Connection categoriesFor: #locked:!accessing! !
!Connection categoriesFor: #lockedDescription!accessing! !
!Connection categoriesFor: #lockedDescription:!accessing! !
!Connection categoriesFor: #open!accessing! !
!Connection categoriesFor: #open:!accessing! !
!Connection categoriesFor: #openDescription!accessing! !
!Connection categoriesFor: #openDescription:!accessing! !
!Connection categoriesFor: #removeAllSynonyms!no category! !
!Connection categoriesFor: #removeSynonym:!no category! !
!Connection categoriesFor: #synonyms!no category! !
!Connection categoriesFor: #synonyms:!no category! !
!Connection categoriesFor: #transport:!no category! !
!Connection categoriesFor: #unlocked!no category! !



Describable class instanceVariableNames: ''!

Describable comment: 'Something which has a description.'!

!Describable categoriesForClass!Adventure! !

!Describable methodsFor!

article
	article isNil
		ifTrue: [ ^self generateArticle ]
		ifFalse: [ ^article ]
!

article: anObject
	"Set the value of the receiver's instance variable article to anObject.
	This method was automatically generated, but may be modified."

	article := anObject
!

basicDescription
	"Answers the long description if it has not been seen before; otherwise answers
	the short description"

	self longDescriptionSeen
		ifTrue: [ ^self shortDescription ]
		ifFalse: [ self longDescriptionSeen: true.
			     ^self longDescription ]!

basicLongDescription
	^longDescription!

basicLongNounPhrase
	^longNounPhrase!

basicShortDescription
	^shortDescription!

basicShortNounPhrase
	^shortNounPhrase!

description
	^self basicDescription
!

generateArticle
	"Private"
	self longDescriptionSeen
		ifFalse: [ (longNounPhrase at: 1) isVowel ifTrue: [ ^'an' ] ifFalse: [ ^'a' ] ]
		ifTrue: [ (shortNounPhrase at: 1) isVowel ifTrue: [ ^'an' ] ifFalse: [ ^'a' ] ]!

initialize
	super initialize.
	self
		longDescriptionSeen: false;
		plural: false!

inventoryDescription2ndPerson
	^'have ', self article, ' ', self nounPhrase!

inventoryDescription3dPerson
	self plural
		ifTrue: [ ^'are ', self article, ' ', self nounPhrase ]
		ifFalse: [ ^'is ', self article, ' ', self nounPhrase ]!

longDescription
	self longNounPhrase notNil
		ifTrue: [ ^(self article size > 0 ifTrue: [ self article, ' '] ifFalse: [ '' ]), self longNounPhrase ]
		ifFalse: [ ^longDescription ]!

longDescription: anObject
	"Set the value of the receiver's instance variable longDescription to anObject.
	This method was automatically generated, but may be modified."

	longDescription := anObject.
	self basicShortDescription isNil ifTrue: [ self shortDescription: anObject ]!

longDescriptionSeen
	"Answer the value of the receiver's instance variable longDescriptionSeen.
	This method was automatically generated, but may be modified."

	^longDescriptionSeen!

longDescriptionSeen: aBoolean
	"Set the value of the receiver's instance variable longDescriptionSeen to anObject.
	This method was automatically generated, but may be modified."

	longDescriptionSeen := aBoolean!

longNounPhrase
	"Answer the value of the receiver's instance variable longNounPhrase.
	This method was automatically generated, but may be modified."

	^longNounPhrase!

longNounPhrase: anObject
	"Set the value of the receiver's instance variable longNounPhrase to anObject.
	This method was automatically generated, but may be modified."

	longNounPhrase := anObject.
	self basicShortNounPhrase isNil ifTrue: [ self shortNounPhrase: anObject ]!

nounPhrase
	self longDescriptionSeen
		ifTrue: [ ^self shortNounPhrase ]
		ifFalse: [ self longDescriptionSeen: true. ^self longNounPhrase ]!

plural
	"Answer the value of the receiver's instance variable plural.
	This method was automatically generated, but may be modified."

	^plural!

plural: anObject
	"Set the value of the receiver's instance variable plural to anObject.
	This method was automatically generated, but may be modified."

	plural := anObject!

points
	^0!

randomGenerator
	^self class randomGenerator!

shortDescription
	self shortNounPhrase notNil
		ifTrue: [ ^self article, ' ', self shortNounPhrase ]
		ifFalse: [ ^shortDescription ]!

shortDescription: anObject
	"Set the value of the receiver's instance variable shortDescription to anObject.
	This method was automatically generated, but may be modified."

	shortDescription := anObject.
	self basicLongDescription isNil ifTrue: [ self longDescription: anObject ]!

shortNounPhrase
	"Answer the value of the receiver's instance variable shortNounPhrase.
	This method was automatically generated, but may be modified."

	^shortNounPhrase!

shortNounPhrase: anObject
	"Set the value of the receiver's instance variable shortNounPhrase to anObject.
	This method was automatically generated, but may be modified."

	shortNounPhrase := anObject.
	self basicLongNounPhrase isNil ifTrue: [ self longNounPhrase: anObject ]! !

!Describable categoriesFor: #article!no category! !
!Describable categoriesFor: #article:!no category! !
!Describable categoriesFor: #basicDescription!no category! !
!Describable categoriesFor: #basicLongDescription!no category! !
!Describable categoriesFor: #basicLongNounPhrase!no category! !
!Describable categoriesFor: #basicShortDescription!no category! !
!Describable categoriesFor: #basicShortNounPhrase!no category! !
!Describable categoriesFor: #description!no category! !
!Describable categoriesFor: #generateArticle!no category! !
!Describable categoriesFor: #initialize!no category! !
!Describable categoriesFor: #inventoryDescription2ndPerson!no category! !
!Describable categoriesFor: #inventoryDescription3dPerson!no category! !
!Describable categoriesFor: #longDescription!accessing! !
!Describable categoriesFor: #longDescription:!accessing! !
!Describable categoriesFor: #longDescriptionSeen!accessing! !
!Describable categoriesFor: #longDescriptionSeen:!accessing! !
!Describable categoriesFor: #longNounPhrase!accessing! !
!Describable categoriesFor: #longNounPhrase:!accessing! !
!Describable categoriesFor: #nounPhrase!no category! !
!Describable categoriesFor: #plural!accessing! !
!Describable categoriesFor: #plural:!accessing! !
!Describable categoriesFor: #points!no category! !
!Describable categoriesFor: #randomGenerator!no category! !
!Describable categoriesFor: #shortDescription!accessing! !
!Describable categoriesFor: #shortDescription:!accessing! !
!Describable categoriesFor: #shortNounPhrase!accessing! !
!Describable categoriesFor: #shortNounPhrase:!accessing! !

!Describable class methodsFor!

chooseFrom: anArrayedCollection
	"Choose a response at random from a collection of possible text strings"

	| randomValue randomNumber |

	randomValue := self randomGenerator next.
	randomNumber := (randomValue * anArrayedCollection size) truncated + 1.
	^anArrayedCollection at: randomNumber!

randomGenerator
	RandomGenerator isNil ifTrue: [ RandomGenerator := Random new initialize ].
	^RandomGenerator! !

!Describable class categoriesFor: #chooseFrom:!no category! !
!Describable class categoriesFor: #randomGenerator!no category! !



Response class instanceVariableNames: ''!

Response comment: ''!

!Response categoriesForClass!Adventure! !

!Response methodsFor!

text
	"Answer the value of the receiver's instance variable text.
	This method was automatically generated, but may be modified."

	^text!

text: anObject
	"Set the value of the receiver's instance variable text to anObject.
	This method was automatically generated, but may be modified."

	text := anObject! !

!Response categoriesFor: #text!accessing! !
!Response categoriesFor: #text:!accessing! !

!Response class methodsFor!

chooseFrom: anArrayedCollection
	"Choose a response at random from a collection of possible text strings"

	| randomValue randomNumber |

	randomValue := self randomGenerator next.
	randomNumber := (randomValue * anArrayedCollection size) truncated + 1.
	^Response text: (anArrayedCollection at: randomNumber)!

randomGenerator
	RandomGenerator isNil ifTrue: [ RandomGenerator := Random new initialize ].
	^RandomGenerator!

text: aString
	^self new initialize text: aString! !

!Response class categoriesFor: #chooseFrom:!no category! !
!Response class categoriesFor: #randomGenerator!no category! !
!Response class categoriesFor: #text:!no category! !



SimpleCommandParser class instanceVariableNames: ''!

SimpleCommandParser comment: ''!

!SimpleCommandParser categoriesForClass!Adventure! !

!SimpleCommandParser methodsFor!

normalizeVerb: aString
	"Normalize a verb into its basic form.  If no translation exists
	answer aString"

	^self verbNormalizationDictionary at: aString ifAbsent: [ aString ]!

parse: aString withDirections: aCollection
	| subStrings validDirections validVerbs actions translatedVerb |

	validDirections := aCollection.
	validVerbs := self class verbs.
	actions := OrderedCollection new initialize.

	subStrings := aString asLowercase subStrings.

	subStrings size > 0 ifTrue: [ translatedVerb := self normalizeVerb: (subStrings at: 1) ].

	"Parse single-word phrases"

	subStrings size = 1 ifTrue: [
		(validDirections includes: translatedVerb)
			ifTrue: [ ^self parse: 'go ', translatedVerb withDirections: validDirections ]
			ifFalse: [ 
				(validVerbs includes: translatedVerb)
					ifTrue: [ actions add: (Action
										verb: translatedVerb
										arguments: (OrderedCollection new initialize)) ]
					ifFalse: [ actions add: (Action
								verb: 'respond'
								arguments: (OrderedCollection with: 'Huh?')) ] ] ].

	"Parse verb-noun phrases."

	subStrings size = 2 ifTrue: [
		(validVerbs includes: translatedVerb)
			ifTrue: [ actions add: (Action
								verb: translatedVerb
								arguments: (OrderedCollection with: (subStrings at: 2))) ]
			ifFalse: [ actions add: (Action
								verb: 'respond'
								arguments: (OrderedCollection with: 'I don''t know how to ' with: aString)) ] ].

	"Complain if we get a more complex phrase."

	subStrings size > 2 ifTrue: [ actions add: (Action
									verb: 'respond'
									arguments: (OrderedCollection with: 'I don''t understand ' with: aString)) ].

	^actions!

verbNormalizationDictionary
	"Private - create a Dictionary used to translate common verb
	 synonyms to verbs this parser understands.  At some point it
	 might prove useful to cache this in a variable."

	^Dictionary new initialize
		add: 'onward' -> 'forward';
		add: 'back' -> 'backward';
		add: 'retreat' -> 'backward';
		add: 'return' -> 'backward';
		add: 'leave' -> 'exit';
		add: 'out' -> 'exit';
		add: 'outside' -> 'exit';
		add: 'inside' -> 'in';
		add: 'inward' -> 'in';
		add: 'above' -> 'up';
		add: 'ascend' -> 'up';
		add: 'u' -> 'up';
		add: 'upward' -> 'up';
		add: 'd' -> 'down';
		add: 'descend' -> 'down';
		add: 'downward' -> 'down';
		add: 'describe' -> 'look';
		add: 'examine' -> 'look';
		add: 'touch' -> 'look';
		add: 'i' -> 'inventory';
		add: 'e' -> 'east';
		add: 'w' -> 'west';
		add: 'n' -> 'north';
		add: 's' -> 'south';
		add: 'ne' -> 'northeast';
		add: 'se' -> 'southeast';
		add: 'sw' -> 'southwest';
		add: 'nw' -> 'northwest';
		add: 'take' -> 'get';
		add: 'leave' -> 'drop';
		add: 'dump' -> 'drop';
		add: 'lose' -> 'drop';
		add: 'journey' -> 'go';
		add: 'speak' -> 'say';
		add: 'talk' -> 'say';
		yourself! !

!SimpleCommandParser categoriesFor: #normalizeVerb:!no category! !
!SimpleCommandParser categoriesFor: #parse:withDirections:!no category! !
!SimpleCommandParser categoriesFor: #verbNormalizationDictionary!no category! !

!SimpleCommandParser class methodsFor!

verbs
	^#('go' 'look' 'get' 'inventory' 'drop' 'say' 'unlock' 'open' 'light' 'wave' 'fill' 'empty' 'help' 'close' 'score')! !

!SimpleCommandParser class categoriesFor: #verbs!no category! !



Container class instanceVariableNames: ''!

Container comment: 'Something which can contain other things.'!

!Container categoriesForClass!Adventure! !

!Container methodsFor!

add: anObject
	"Add a new object to the collection of objects in this container"

	self remove: anObject.	"Make sure it's not already in this container"
	self contents add: anObject.
	^Response text: 'OK'!

basicLighted
	^false!

contains: anObject
	^self contents includes: anObject!

containsLightSource
	^self basicLighted | (self contents inject: false into: [ :tot :each | tot | each containsLightSource ])!

contents
	"Answer the value of the receiver's instance variable contents.
	This method was automatically generated, but may be modified."

	^contents!

contentsDescription
	^''!

contentsLike: aString
	| pattern |

	pattern := '*', aString, '*'.
	^self contents select: [ :each |
		(pattern match: each shortDescription) | (pattern match: each longDescription) ]!

initialize
	super initialize.
	contents := OrderedCollection new initialize.
	self inventoryable: true!

inventory
	"Answer a string describing the contents of this container"

	^self subclassResponsibility!

inventory2ndPersonWithPrefix: aPrefixString suffix: aSuffixString
	"Private - answer this Container's inventory using the given prefix and suffix"
	^self contents inject: '' into: [ :string :each |
		each inventoryable
			ifTrue: [
				(each basicLongDescription isNil
					ifTrue: [
						string, (string size > 0 ifTrue: [ String lineDelimiter ] ifFalse: ['']),
						aPrefixString, ' ', each inventoryDescription2ndPerson,
						(aSuffixString size > 0 ifTrue: [ ' ', aSuffixString ] ifFalse: [ '' ]) ]
					ifFalse: [ string, each basicDescription ]),
				(each contents size > 0
					ifTrue: [ '.  The ', each shortNounPhrase, ' contains:',
											String lineDelimiter,
											(each inventoryWithPrefix: '   ' suffix: '') ]
					ifFalse: [ '' ]) ]
			ifFalse: [ string ] ]!

inventory3dPersonWithPrefix: aPrefixString suffix: aSuffixString
	"Private - answer this Container's inventory using the given prefix and suffix"

	^self contents inject: '' into: [ :string :each |
		each inventoryable
			ifTrue: [
				(each basicLongDescription isNil
					ifTrue: [
						string, (string size > 0 ifTrue: [ String lineDelimiter ] ifFalse: ['']),
						aPrefixString, ' ', each inventoryDescription3dPerson,
						(aSuffixString size > 0 ifTrue: [ ' ', aSuffixString ] ifFalse: [ '' ]),
						(each treasure ifTrue: [ '!!' ] ifFalse: [ '' ]) ]
					ifFalse: [ string, each basicDescription ]),
				(each contents size > 0
					ifTrue: [ '.  The ', each shortNounPhrase, ' contains:',
											String lineDelimiter,
											(each inventoryWithPrefix: '   ' suffix: '') ]
					ifFalse: [ '' ]) ]
			ifFalse: [ string ] ]!

inventoryable
	"Answer the value of the receiver's instance variable inventoryable.
	This method was automatically generated, but may be modified."

	^inventoryable!

inventoryable: anObject
	"Set the value of the receiver's instance variable inventoryable to anObject.
	This method was automatically generated, but may be modified."

	inventoryable := anObject!

inventoryStringWithPrefix: aPrefixString suffix: aSuffixString
	| description contentsDescription |

	self inventoryable
		ifTrue: [
			self basicLongDescription size > 0
				ifTrue: [ description := self basicDescription ]
				ifFalse: [ description := aPrefixString, ' ', self description,
					      ((aSuffixString size > 0) ifTrue: [ ' ' ] ifFalse: [ '' ]), aSuffixString, '.' ].

			self contents size > 0
				ifTrue: [ contentsDescription := 'The ', self shortNounPhrase, ' contains:',
								String lineDelimiter,
								(self inventoryWithPrefix: '   ' suffix: '') ]
				ifFalse: [ contentsDescription := '' ] ]
		ifFalse: [ description := ''.  contentsDescription := ''. ].

	^description, contentsDescription!

inventoryWithPrefix: aPrefixString suffix: aSuffixString
	"Private - answer this Container's inventory using the given prefix and suffix"
	^self contents inject: '' into: [ :string :each |
		string, (string size > 0 ifTrue: [ String lineDelimiter ] ifFalse: ['']),
			(each inventoryStringWithPrefix: aPrefixString suffix: aSuffixString) ]!

remove: anObject
	^self contents remove: anObject ifAbsent: [ ]! !

!Container categoriesFor: #add:!no category! !
!Container categoriesFor: #basicLighted!no category! !
!Container categoriesFor: #contains:!no category! !
!Container categoriesFor: #containsLightSource!no category! !
!Container categoriesFor: #contents!accessing! !
!Container categoriesFor: #contentsDescription!no category! !
!Container categoriesFor: #contentsLike:!no category! !
!Container categoriesFor: #initialize!no category! !
!Container categoriesFor: #inventory!no category! !
!Container categoriesFor: #inventory2ndPersonWithPrefix:suffix:!no category! !
!Container categoriesFor: #inventory3dPersonWithPrefix:suffix:!no category! !
!Container categoriesFor: #inventoryable!accessing! !
!Container categoriesFor: #inventoryable:!accessing! !
!Container categoriesFor: #inventoryStringWithPrefix:suffix:!no category! !
!Container categoriesFor: #inventoryWithPrefix:suffix:!no category! !
!Container categoriesFor: #remove:!no category! !



Actor class instanceVariableNames: ''!

Actor comment: 'An object which is capable of processing commands.'!

!Actor categoriesForClass!Adventure! !

!Actor methodsFor!

accumulatePoints: anItem
	self points: self points + anItem points.
	anItem points: 0!

alive
	"Answer the value of the receiver's instance variable alive.
	This method was automatically generated, but may be modified."

	^alive!

alive: anObject
	"Set the value of the receiver's instance variable alive to anObject.
	This method was automatically generated, but may be modified."

	alive := anObject!

close: aCollection
	| connections |

	connections := self location connectionsTo: (aCollection at: 1).
	connections size = 0 ifTrue: [ ^Response text: 'What are you trying to open?' ].

	connections size = 1 ifTrue: [
		(connections at: 1) closeable ifFalse: [ ^Response text: 'There''s no way to close that.' ].
		(connections at: 1) closed: true.
		^Response text: 'OK' ].

	"connections size > 1"

	^Response text: 'Could you be a bit more specific?'!

drop: anOrderedCollection
	| matchingObjects item |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).

	matchingObjects size = 0
		ifTrue: [ 
			self contents do: [ :each | 
				matchingObjects := each contentsLike: (anOrderedCollection at: 1).
				matchingObjects size = 1 ifTrue: [
					item := matchingObjects at: 1.
					each remove: item.
					self add: item.
					^self drop: anOrderedCollection ] ].
			^Response text: 'You don''t have a ', (anOrderedCollection at: 1) ].

	matchingObjects size = 1
		ifTrue: [
			self remove: (matchingObjects at: 1).
			^self location add: (matchingObjects at: 1) ].

	^Response text: 'Could you be a bit more specific?'!

empty: anOrderedCollection
	| matchingObjects response |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).
	matchingObjects size = 0
		ifTrue: [ ^Response text: 'I don''t see a ', (anOrderedCollection at: 1), ' here.' ].
	matchingObjects size > 1
		ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	response := Response text: 'OK'.

	(matchingObjects at: 1) contents do: [ :each |
		each ~= self world water & (each ~= self world oil)
			ifTrue: [ self location add: each ]
			ifFalse: [ response := Response text: 'The ', each shortNounPhrase, ' splashes on the floor and evaporates.' ] ].

	(matchingObjects at: 1) contents removeAll: (matchingObjects at: 1) contents.
	^response!

execute: anAction
	"Execute the given action, answering an appropriate Response"

	^self perform: (anAction verb, ':') asSymbol with: anAction arguments!

fill: anOrderedCollection
	| matchingObjects |

	matchingObjects := self contentsLike: (anOrderedCollection at: 1).
	matchingObjects size = 0 ifTrue: [ ^Response text: 'I don''t see a ', (anOrderedCollection at: 1), ' here.' ].
	matchingObjects size > 1 ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	self location hasWater
		ifTrue: [ (matchingObjects at: 1) add: self world water.
				^Response text: 'OK' ].

	self location hasOil
		ifTrue: [ (matchingObjects at: 1) add: self world oil.
				^Response text: 'OK' ].

	^Response text: 'I don''t see anything to fill the ', (anOrderedCollection at: 1), ' with.'!

get: anOrderedCollection
	| matchingObjects |

	matchingObjects := self location contentsLike: (anOrderedCollection at: 1).
	matchingObjects size = 0
		ifTrue: [ ^Response text: 'I don''t see a ', (anOrderedCollection at: 1), ' here.' ].
	matchingObjects size > 1
		ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	(matchingObjects at: 1) movable
		ifTrue: [
			self location remove: (matchingObjects at: 1).
			^self add: (matchingObjects at: 1) ]
		ifFalse: [ ^Response text: 'You can''t seem to pick up the ', (matchingObjects at: 1) shortNounPhrase ]!

go: anOrderedCollection
	| connections responseText |

	connections := self location connectionsTo: (anOrderedCollection at: 1).
	connections do: [ :aConnection | 
		(aConnection open) & (aConnection unlocked) 
			ifTrue: [
				(self location allowTravelBy: self through: aConnection)
					ifTrue: [ ^Response text: (aConnection transport: self) ]
					ifFalse: [ ^Response text: (self location travelFailureReasonFor: self through: aConnection) ] ] ].

	"Couldn't find a way to go in the desired direction, so we need to determine an
	  appropriate response"

	connections do: [ :aConnection |
		aConnection locked & (aConnection lockedDescription ~= '')
				ifTrue: [ ^Response text: aConnection lockedDescription ].
		aConnection open not & (aConnection closedDescription ~= '')
				ifTrue: [ ^Response text: aConnection closedDescription ] ].

	^Response chooseFrom: #('There''s no exit in that direction'
						'You can''t go that way'
						'You might be able to do that if you had a pickaxe'
						'Huh?')!

help: anOrderedCollection
	^Response text: self world helpString!

initialize
	super initialize.
	self
		alive: true;
		inventoryable: false;
		sequence: 0;
		points: 0!

inventory
	^self inventory2ndPersonWithPrefix: 'You' suffix: ''!

inventory: aCollection
	^Response text: self inventory!

inventoryStringWithPrefix: aPrefixString suffix: aSuffixString
	^''!

light: aCollection
	| items wasLit |

	wasLit := self location lighted.
	items := self contentsLike: (aCollection at: 1).
	items size > 0
		ifTrue: [ (items at: 1) lightSource
				ifTrue: [ (items at: 1) lighted: true.
						wasLit
							ifTrue: [ ^Response text: 'OK' ]
							ifFalse: [ ^Response text: 'Ahh, much better...', String lineDelimiter, self location description ] ]
				ifFalse: [ ^Response chooseFrom: (Array with:'Nothing happens'
										   with: 'You can''t find the switch'
										   with: 'Huh?'
										   with: 'I''m game.  How?'
										   with: 'Let me guess - half the calories of our regular ',
												(items at: 1) nounPhrase, ' and all the great taste?') ] ]
		ifFalse: [ ^Response text: 'You don''t seem to have a ', (aCollection at: 1) ]!

location
	"Answer the value of the receiver's instance variable location.
	This method was automatically generated, but may be modified."

	^location!

location: aLocation
	location := aLocation!

look: anOrderedCollection
	"Answer a description of the current location"

	self location longDescriptionSeen: false.
	^Response text: self location description, String lineDelimiter, self location inventory!

open: aCollection
	| connections |

	connections := self location connectionsTo: (aCollection at: 1).
	connections size = 0 ifTrue: [ ^Response text: 'What are you trying to open?' ].

	connections size = 1 ifTrue: [
		(connections at: 1) locked ifTrue: [ ^Response text: 'It seems to be locked' ].

		(connections at: 1) open ifTrue: [ ^Response text: 'It''s already open' ].

		(connections at: 1) open: true.
		^Response text: 'OK' ].

	"connections size > 1"

	^Response text: 'Could you be a bit more specific?'!

parser
	"Answer the value of the receiver's instance variable parser.
	This method was automatically generated, but may be modified."

	parser isNil ifTrue: [ parser := self class defaultParserClass new initialize ].
	^parser!

points
	"Answer the value of the receiver's instance variable points.
	This method was automatically generated, but may be modified."

	^points!

points: anObject
	"Set the value of the receiver's instance variable points to anObject.
	This method was automatically generated, but may be modified."

	points := anObject!

processCommand: aString
	"Process the given command, answering a collection of Responses"

	| actions |

	self sequence: self sequence + 1.
	actions := self parser parse: aString withDirections: self location allDirections.
	^actions collect: [ :anAction | self execute: anAction ]!

respond: anOrderedCollection
	^Response text: (anOrderedCollection inject: '' into: [ :string :each | string := string, each ])!

say: anOrderedCollection
	^Response text: '''', (anOrderedCollection inject: '' into: [ :tot :each | tot, each ]), ''''!

score: anOrderedCollection
	^Response text: 'Current score: ', self points printString!

sequence
	"Answer the value of the receiver's instance variable sequence.
	This method was automatically generated, but may be modified."

	^sequence!

sequence: anObject
	"Set the value of the receiver's instance variable sequence to anObject.
	This method was automatically generated, but may be modified."

	sequence := anObject!

unlock: aCollection
	| connections |

	connections := self location connectionsTo: (aCollection at: 1).
	connections size = 0 ifTrue: [ ^Response text: 'What are you trying to unlock?' ].

	connections size = 1 ifTrue: [
		(connections at: 1) locked
			ifTrue: [
				(self contains: (connections at: 1) key)
					ifTrue: [
						(connections at: 1) locked: false.
						^Response text: (connections at: 1) description, String lineDelimiter, 'OK' ]
					ifFalse: [ ^Response text: 'You don''t seem to have the key' ] ]
			ifFalse: [ ^Response text: 'I don''t think it''s locked' ] ].

	"connections size > 1"

	^Response text: 'Could you be a bit more specific?'!

wave: aCollection
	| matchingObjects |

	matchingObjects := self contentsLike: (aCollection at: 1).
	matchingObjects size = 0 ifTrue: [ ^Response text: 'Huh?' ].
	matchingObjects size > 1 ifTrue: [ ^Response text: 'Could you be a bit more specific?' ].

	^Response chooseFrom: #('Swoosh!!'
						'Hey, that was neat!!  Do it again!!'
						'Nothing happens'
						'Is that your nose on the floor?')!

world
	"Answer the value of the receiver's instance variable world.
	This method was automatically generated, but may be modified."

	^world!

world: anObject
	"Set the value of the receiver's instance variable world to anObject.
	This method was automatically generated, but may be modified."

	world := anObject! !

!Actor categoriesFor: #accumulatePoints:!no category! !
!Actor categoriesFor: #alive!accessing! !
!Actor categoriesFor: #alive:!accessing! !
!Actor categoriesFor: #close:!no category! !
!Actor categoriesFor: #drop:!no category! !
!Actor categoriesFor: #empty:!no category! !
!Actor categoriesFor: #execute:!no category! !
!Actor categoriesFor: #fill:!no category! !
!Actor categoriesFor: #get:!no category! !
!Actor categoriesFor: #go:!no category! !
!Actor categoriesFor: #help:!no category! !
!Actor categoriesFor: #initialize!no category! !
!Actor categoriesFor: #inventory!no category! !
!Actor categoriesFor: #inventory:!no category! !
!Actor categoriesFor: #inventoryStringWithPrefix:suffix:!no category! !
!Actor categoriesFor: #light:!no category! !
!Actor categoriesFor: #location!accessing! !
!Actor categoriesFor: #location:!accessing! !
!Actor categoriesFor: #look:!no category! !
!Actor categoriesFor: #open:!no category! !
!Actor categoriesFor: #parser!accessing! !
!Actor categoriesFor: #points!accessing! !
!Actor categoriesFor: #points:!accessing! !
!Actor categoriesFor: #processCommand:!no category! !
!Actor categoriesFor: #respond:!no category! !
!Actor categoriesFor: #say:!no category! !
!Actor categoriesFor: #score:!no category! !
!Actor categoriesFor: #sequence!accessing! !
!Actor categoriesFor: #sequence:!accessing! !
!Actor categoriesFor: #unlock:!no category! !
!Actor categoriesFor: #wave:!no category! !
!Actor categoriesFor: #world!accessing! !
!Actor categoriesFor: #world:!accessing! !

!Actor class methodsFor!

defaultParserClass
	self subclassResponsibility! !

!Actor class categoriesFor: #defaultParserClass!no category! !



Item class instanceVariableNames: ''!

Item comment: 'A ''thing'' in the database which is not an actor (e.g. is passive, not active), e.g. lamp, key, rod, etc.

Items should be capable of responding to simple commands, e.g.
    wave rod
when parsed and processed by an Actor might result in
    self perform: (Message selector: #wave: argument: ''rod'')

The Actor handler for #wave might be something like

    wave: aString
        | items |
        items := self findItemsLike: aString.
        items size = 0 ifTrue: [ AdvNoItemFoundException signalWith: aString ].
        items size > 1 ifTrue: [ AdvMultipleItemsFoundException signalWith: aString ]

        ^(items at: 1) performAction: #wave

Thus, items need to have a Collection of things they can do, which may consist of a Dictionary of BlockClosures since we''ll need to change this on an instance-by-instance basis.'!

!Item categoriesForClass!Adventure! !

!Item methodsFor!

basicLighted
	"Answer the value of the receiver's instance variable lighted.
	This method was automatically generated, but may be modified."

	^lighted!

initialize
	super initialize.
	self
		lightSource: false;
		lighted: false;
		movable: true;
		points: 0;
		treasure: false!

lighted
	"Answer the value of the receiver's instance variable lighted.
	This method was automatically generated, but may be modified."

	^self basicLighted!

lighted: aBoolean
	"Set the value of the receiver's instance variable lighted to anObject.
	This method was automatically generated, but may be modified."

	lighted := aBoolean!

lightSource
	"Answer the value of the receiver's instance variable lightSource.
	This method was automatically generated, but may be modified."

	^lightSource!

lightSource: aBoolean
	"Set the value of the receiver's instance variable lightSource to anObject.
	This method was automatically generated, but may be modified."

	lightSource := aBoolean!

movable
	"Answer the value of the receiver's instance variable movable.
	This method was automatically generated, but may be modified."

	^movable!

movable: anObject
	"Set the value of the receiver's instance variable movable to anObject.
	This method was automatically generated, but may be modified."

	movable := anObject!

points
	"Answer the value of the receiver's instance variable points.
	This method was automatically generated, but may be modified."

	^points!

points: anObject
	"Set the value of the receiver's instance variable points to anObject.
	This method was automatically generated, but may be modified."

	points := anObject!

treasure
	"Answer the value of the receiver's instance variable treasure.
	This method was automatically generated, but may be modified."

	^treasure!

treasure: anObject
	"Set the value of the receiver's instance variable treasure to anObject.
	This method was automatically generated, but may be modified."

	treasure := anObject! !

!Item categoriesFor: #basicLighted!no category! !
!Item categoriesFor: #initialize!no category! !
!Item categoriesFor: #lighted!accessing! !
!Item categoriesFor: #lighted:!accessing! !
!Item categoriesFor: #lightSource!accessing! !
!Item categoriesFor: #lightSource:!accessing! !
!Item categoriesFor: #movable!accessing! !
!Item categoriesFor: #movable:!accessing! !
!Item categoriesFor: #points!accessing! !
!Item categoriesFor: #points:!accessing! !
!Item categoriesFor: #treasure!accessing! !
!Item categoriesFor: #treasure:!accessing! !



Location class instanceVariableNames: ''!

Location comment: ''!

!Location categoriesForClass!Adventure! !

!Location methodsFor!

addConnection: aConnection
	self connections add: aConnection!

allDirections
	"Answers a collection of all directions which are valid in this location"

	| allDirections |

	allDirections := OrderedCollection new initialize.

	self connections do: [ :each |
		each synonyms do: [ :each2 |
			(allDirections includes: each2) ifFalse: [ allDirections add: each2 ] ] ].

	^allDirections!

allowTravelBy: anActor through: aConnection
	^true!

basicLighted
	^lighted!

connections
	connections isNil ifTrue: [ connections := OrderedCollection new initialize ].
	^connections!

connectionsTo: aString
	^self connections select: [ :each | (each hasSynonym: aString) & (each entryProbability >= self randomGenerator next) ]!

description
	| connectionDescription |

	self lighted
		ifTrue: [
			connectionDescription := self connections inject: '' into: [ :sum :each | sum, each description ].
			^super description,
				(connectionDescription size > 0 ifTrue: [ String lineDelimiter ] ifFalse: ['']),
				connectionDescription ]
		ifFalse: [ ^self class chooseFrom: #( 'Gee, it''s awfully dark in here...'
									'You have wandered into a dark place.  You may be eaten by a grue...'
									'<gulp!!>  Have I m-m-mentioned I''m afraid of the d-d-d-d-dark?') ]!

hasOil
	"Answer the value of the receiver's instance variable hasOil.
	This method was automatically generated, but may be modified."

	^hasOil!

hasOil: anObject
	"Set the value of the receiver's instance variable hasOil to anObject.
	This method was automatically generated, but may be modified."

	hasOil := anObject!

hasWater
	"Answer the value of the receiver's instance variable hasWater.
	This method was automatically generated, but may be modified."

	^hasWater!

hasWater: anObject
	"Set the value of the receiver's instance variable hasWater to anObject.
	This method was automatically generated, but may be modified."

	hasWater := anObject!

initialize
	super initialize.
	self
		lighted: true;
		hasWater: false;
		hasOil: false!

inventory
	"Answer a string describing the contents of this container"

	self lighted
		ifTrue: [ ^self inventory3dPersonWithPrefix: 'There' suffix: 'here' ]
		ifFalse: [ ^'' ]!

inventoryWithPrefix: aPrefixString suffix: aSuffixString
	self lighted
		ifTrue: [ ^super inventoryWithPrefix: aPrefixString suffix: aSuffixString ]
		ifFalse: [ ^'' ]!

lighted
	^self basicLighted | self containsLightSource!

lighted: aBoolean
	"Set the value of the receiver's instance variable lighted to anObject.
	This method was automatically generated, but may be modified."

	lighted := aBoolean!

receiveActor: anActor
	anActor location notNil ifTrue: [ anActor location remove: anActor ].
	anActor location: self.
	self add: anActor.
	^anActor location description, String lineDelimiter, anActor location inventory
!

removeConnection: aConnection
	self connections remove: aConnection ifAbsent: [ ]!

travelFailureReasonFor: anActor through: aConnection
	^''!

world
	"Answer the value of the receiver's instance variable world.
	This method was automatically generated, but may be modified."

	^world!

world: anObject
	"Set the value of the receiver's instance variable world to anObject.
	This method was automatically generated, but may be modified."

	world := anObject! !

!Location categoriesFor: #addConnection:!no category! !
!Location categoriesFor: #allDirections!no category! !
!Location categoriesFor: #allowTravelBy:through:!no category! !
!Location categoriesFor: #basicLighted!no category! !
!Location categoriesFor: #connections!no category! !
!Location categoriesFor: #connectionsTo:!no category! !
!Location categoriesFor: #description!no category! !
!Location categoriesFor: #hasOil!accessing! !
!Location categoriesFor: #hasOil:!accessing! !
!Location categoriesFor: #hasWater!accessing! !
!Location categoriesFor: #hasWater:!accessing! !
!Location categoriesFor: #initialize!no category! !
!Location categoriesFor: #inventory!no category! !
!Location categoriesFor: #inventoryWithPrefix:suffix:!no category! !
!Location categoriesFor: #lighted!accessing! !
!Location categoriesFor: #lighted:!accessing! !
!Location categoriesFor: #receiveActor:!no category! !
!Location categoriesFor: #removeConnection:!no category! !
!Location categoriesFor: #travelFailureReasonFor:through:!no category! !
!Location categoriesFor: #world!accessing! !
!Location categoriesFor: #world:!accessing! !



World class instanceVariableNames: ''!

World comment: ''!

!World categoriesForClass!Adventure! !

!World methodsFor!

actor
	"Answer the value of the receiver's instance variable actor.
	This method was automatically generated, but may be modified."

	^actor!

actor: anActor
	"Set the value of the receiver's instance variable actor to anObject.
	This method was automatically generated, but may be modified."

	actor := anActor.
	self actor world: self!

addLocation: aLocation
	aLocation world: self.
	self add: aLocation!

defaultFileName
	^'World.stb'!

helpString
	^'No help is available'!

initialize
	super initialize.

	self water: (Item new initialize
				longNounPhrase: 'water';
				shortNounPhrase: 'water';
				article: '').

	self oil: (Item new initialize
				longNounPhrase: 'oil';
				shortNounPhrase: 'oil';
				article: '').!

oil
	"Answer the value of the receiver's instance variable oil.
	This method was automatically generated, but may be modified."

	^oil!

oil: anObject
	"Set the value of the receiver's instance variable oil to anObject.
	This method was automatically generated, but may be modified."

	oil := anObject!

processCommand: aString
	self responses add: (Response text: aString).
	self responses addAll: (self actor processCommand: aString).
	self trigger: #responsesChanged!

randomGenerator
	randomGenerator isNil ifTrue: [ self randomGenerator: Random new initialize ].
	^randomGenerator!

randomGenerator: aRandom
	randomGenerator := aRandom!

responses
	"Answer the value of the receiver's instance variable responses.
	This method was automatically generated, but may be modified."

	responses isNil ifTrue: [ responses := OrderedCollection new ].
	^responses!

restore
	| aFileStream aWorld |

	aFileStream := FileStream read: self defaultFileName text: false.
	aWorld := (STBInFiler on: aFileStream) next.
	self become: aWorld.
	self trigger: #responsesChanged!

save
	| aFileStream |

	aFileStream := FileStream write: self defaultFileName text: false.
	(STBOutFiler on: aFileStream)
		nextPut: self.
	aFileStream close.!

water
	"Answer the value of the receiver's instance variable water.
	This method was automatically generated, but may be modified."

	^water!

water: anObject
	"Set the value of the receiver's instance variable water to anObject.
	This method was automatically generated, but may be modified."

	water := anObject! !

!World categoriesFor: #actor!accessing! !
!World categoriesFor: #actor:!accessing! !
!World categoriesFor: #addLocation:!adding! !
!World categoriesFor: #defaultFileName!accessing! !
!World categoriesFor: #helpString!accessing! !
!World categoriesFor: #initialize!initializing! !
!World categoriesFor: #oil!accessing! !
!World categoriesFor: #oil:!accessing! !
!World categoriesFor: #processCommand:!accessing! !
!World categoriesFor: #randomGenerator!accessing! !
!World categoriesFor: #randomGenerator:!accessing! !
!World categoriesFor: #responses!accessing! !
!World categoriesFor: #restore!no category! !
!World categoriesFor: #save!binary filing! !
!World categoriesFor: #water!accessing! !
!World categoriesFor: #water:!accessing! !



SimpleActor class instanceVariableNames: ''!

SimpleActor comment: ''!

!SimpleActor categoriesForClass!No category! !

!SimpleActor class methodsFor!

defaultParserClass
	^SimpleCommandParser! !

!SimpleActor class categoriesFor: #defaultParserClass!no category! !



ImmovableItem class instanceVariableNames: ''!

ImmovableItem comment: ''!

!ImmovableItem categoriesForClass!No category! !

!ImmovableItem methodsFor!

initialize
	super initialize.
	self movable: false! !

!ImmovableItem categoriesFor: #initialize!no category! !



LightSource class instanceVariableNames: ''!

LightSource comment: ''!

!LightSource categoriesForClass!No category! !

!LightSource methodsFor!

initialize
	super initialize.
	self lightSource: true! !

!LightSource categoriesFor: #initialize!no category! !



Treasure class instanceVariableNames: ''!

Treasure comment: ''!

!Treasure categoriesForClass!No category! !

!Treasure methodsFor!

initialize
	super initialize.
	self treasure: true! !

!Treasure categoriesFor: #initialize!no category! !



DarkLocation class instanceVariableNames: ''!

DarkLocation comment: ''!

!DarkLocation categoriesForClass!No category! !

!DarkLocation methodsFor!

initialize
	super initialize.
	self lighted: false! !

!DarkLocation categoriesFor: #initialize!no category! !



ForwardingLocation class instanceVariableNames: ''!

ForwardingLocation comment: ''!

!ForwardingLocation categoriesForClass!No category! !

!ForwardingLocation methodsFor!

receiveActor: anActor
	^self description, String lineDelimiter, ((self connections at: 1) destination receiveActor: anActor)! !

!ForwardingLocation categoriesFor: #receiveActor:!no category! !



ReflectingLocation class instanceVariableNames: ''!

ReflectingLocation comment: 'A ReflectingLocation is one which returns the Actor to its original location after displaying the location''s description.  This is basically a cheap, no-special-code-required way to spit out a message when an Actor goes in a given direction without moving the Actor from its current location.'!

!ReflectingLocation categoriesForClass!No category! !

!ReflectingLocation methodsFor!

receiveActor: anActor
	^self description! !

!ReflectingLocation categoriesFor: #receiveActor:!no category! !



TerminalLocation class instanceVariableNames: ''!

TerminalLocation comment: ''!

!TerminalLocation categoriesForClass!No category! !

!TerminalLocation methodsFor!

receiveActor: anActor
	anActor alive: false.
	^self description! !

!TerminalLocation categoriesFor: #receiveActor:!no category! !



TestWorld class instanceVariableNames: ''!

TestWorld comment: ''!

!TestWorld categoriesForClass!No category! !

!TestWorld methodsFor!

defaultFileName
		^'TestWorld.stb'!

initialize
	"Create a world with a few locations and items."

	| loc1 loc2 loc3 loc4 |

	super initialize.

	self
		longDescription: 'You''ve entered a world full of new possibilities';
		shortDescription: 'You''re in the test world'.

	loc1 := Location new initialize
			longDescription: 'You have entered a room with bright red walls.  An arched portico leads north.';
			shortDescription: 'You''re in the red room'.						

	loc2 := Location new initialize
			longDescription: 'You are in a room with bright blue walls.  There is a plain wooden door to the east ',
						'while a damp and dingy tunnel runs to the southeast.';
			shortDescription: 'You''re in the blue room'.

	loc3 := Location new initialize
			longDescription: 'Before you lies a room with bright green walls.  A dusty passageway leads to the ',
						'west, while a narrow hallway leads south.';
			shortDescription: 'You''re a resident of the green room'.

	loc4 := Location new initialize
			longDescription: 'Your eyes are jolted by the electric purple walls of this room.  A ',
						'portal festooned with gilt and pearls leads to the northwest.';
			shortDescription: 'You''re in the purple room'.

	self
		addLocation: loc1;
		addLocation: loc2;
		addLocation: loc3;
		addLocation: loc4.

	loc1 addConnection: (Connection new initialize
					synonyms: #('north' 'portico');
					destination: loc2);
		add: (Item new initialize
				longNounPhrase: 'old-fashioned oil lamp';
				shortNounPhrase: 'lamp').

	loc2
		addConnection: (Connection new initialize
					synonyms: #('east' 'door');
					destination: loc3);
		addConnection: (Connection new initialize
					synonyms: #('southeast' 'tunnel');
					destination: loc4);
		add: (Item new initialize
				longNounPhrase: 'large grandfather clock';
				shortNounPhrase: 'grandfather clock').

	loc3
		addConnection: (Connection new initialize
					synonyms: #('west' 'passage' 'passageway');
					destination: loc2);
		addConnection: (Connection new initialize
					synonyms: #('south' 'hall' 'hallway');
					destination: loc4);
		add: (Item new initialize
				longNounPhrase: 'iron-bound chest';
				shortNounPhrase: 'chest').

	loc4 addConnection: (Connection new initialize
					synonyms: #('northwest' 'portal');
					destination: loc2);
		add: (Item new initialize
				longNounPhrase: 'intricate key';
				shortNounPhrase: 'intricate key').

	self actor: (SimpleActor new initialize
					location: loc1;
					longDescription: 'a nervous-looking individual with thick glasses';
					shortDescription: 'an adventurer').! !

!TestWorld categoriesFor: #defaultFileName!accessing! !
!TestWorld categoriesFor: #initialize!initializing! !



AdventureShell class instanceVariableNames: ''!

AdventureShell comment: ''!

!AdventureShell categoriesForClass!No category! !

!AdventureShell methodsFor!

createComponents
	super createComponents.

	inputTextPresenter := self add: TextPresenter new name: 'inputText'.
	displayTextPresenter := self add: TextPresenter new name: 'displayText'.!

createSchematicWiring
	super createSchematicWiring.

	inputTextPresenter
		when: #keyPressed: send: #onKeyPressed: to: self.

	self model
		when: #responsesChanged send: #onResponsesChanged to: self.!

displayTextPresenter
	"Answer the value of the receiver's instance variable displayTextPresenter.
	This method was automatically generated, but may be modified."

	^displayTextPresenter!

displayTextPresenter: anObject
	"Set the value of the receiver's instance variable displayTextPresenter to anObject.
	This method was automatically generated, but may be modified."

	displayTextPresenter := anObject!

inputTextPresenter
	"Answer the value of the receiver's instance variable inputTextPresenter.
	This method was automatically generated, but may be modified."

	^inputTextPresenter!

inputTextPresenter: anObject
	"Set the value of the receiver's instance variable inputTextPresenter to anObject.
	This method was automatically generated, but may be modified."

	inputTextPresenter := anObject!

onExit
	self exit!

onHelp
	MessageBox new
		caption: 'Adventure Help';
		notify: self model helpString!

onKeyPressed: aKeyEvent
	aKeyEvent wParam asCharacter = Character cr	"Enter key pressed"
		ifTrue: [
			self model processCommand: self inputTextPresenter value.
			self model actor alive
				ifFalse: [ MessageBox warning: 'You seem to have died'.
						self inputTextPresenter view disable ] ]!

onResponsesChanged
	"Display the text of all the responses in the model"

	| text |

	self inputTextPresenter value: ''.
	text := String new initialize.
	self model responses do: [ :each | text := text, String lineDelimiter, each text ].
	self displayTextPresenter value: text.

	self displayTextPresenter view scrollVertical: self displayTextPresenter view lines!

onRestore
	self displayTextPresenter value: ''.
	self model restore!

onSave
	self model save!

onViewOpened
	super onViewOpened.
	self model processCommand: 'look'! !

!AdventureShell categoriesFor: #createComponents!no category! !
!AdventureShell categoriesFor: #createSchematicWiring!no category! !
!AdventureShell categoriesFor: #displayTextPresenter!accessing! !
!AdventureShell categoriesFor: #displayTextPresenter:!accessing! !
!AdventureShell categoriesFor: #inputTextPresenter!accessing! !
!AdventureShell categoriesFor: #inputTextPresenter:!accessing! !
!AdventureShell categoriesFor: #onExit!no category! !
!AdventureShell categoriesFor: #onHelp!no category! !
!AdventureShell categoriesFor: #onKeyPressed:!no category! !
!AdventureShell categoriesFor: #onResponsesChanged!no category! !
!AdventureShell categoriesFor: #onRestore!no category! !
!AdventureShell categoriesFor: #onSave!no category! !
!AdventureShell categoriesFor: #onViewOpened!no category! !

!AdventureShell class methodsFor!

defaultModel
	^TestWorld new initialize!

defaultView
	^'AdventureShell'! !

!AdventureShell class categoriesFor: #defaultModel!no category! !
!AdventureShell class categoriesFor: #defaultView!no category! !

 