"Filed out from Dolphin Smalltalk/Version 2.1"!

Container subclass: #World
	instanceVariableNames: 'actor responses randomGenerator oil water'
	classVariableNames: ''
	poolDictionaries: ''!

World class instanceVariableNames: ''!

World comment: ''!

!World categoriesForClass!Adventure! !

!World methodsFor!

actor
	"Answer the value of the receiver's instance variable actor.
	This method was automatically generated, but may be modified."

	^actor!

actor: anActor
	"Set the value of the receiver's instance variable actor to anObject.
	This method was automatically generated, but may be modified."

	actor := anActor.
	self actor world: self!

addLocation: aLocation
	aLocation world: self.
	self add: aLocation!

defaultFileName
	^'World.stb'!

helpString
	^'No help is available'!

initialize
	super initialize.

	self water: (Item new initialize
				longNounPhrase: 'water';
				shortNounPhrase: 'water';
				article: '').

	self oil: (Item new initialize
				longNounPhrase: 'oil';
				shortNounPhrase: 'oil';
				article: '').!

oil
	"Answer the value of the receiver's instance variable oil.
	This method was automatically generated, but may be modified."

	^oil!

oil: anObject
	"Set the value of the receiver's instance variable oil to anObject.
	This method was automatically generated, but may be modified."

	oil := anObject!

processCommand: aString
	self responses add: (Response text: aString).
	self responses addAll: (self actor processCommand: aString).
	self trigger: #responsesChanged!

randomGenerator
	randomGenerator isNil ifTrue: [ self randomGenerator: Random new initialize ].
	^randomGenerator!

randomGenerator: aRandom
	randomGenerator := aRandom!

responses
	"Answer the value of the receiver's instance variable responses.
	This method was automatically generated, but may be modified."

	responses isNil ifTrue: [ responses := OrderedCollection new ].
	^responses!

restore
	| aFileStream aWorld |

	aFileStream := FileStream read: self defaultFileName text: false.
	aWorld := (STBInFiler on: aFileStream) next.
	self become: aWorld.
	self trigger: #responsesChanged!

save
	| aFileStream |

	aFileStream := FileStream write: self defaultFileName text: false.
	(STBOutFiler on: aFileStream)
		nextPut: self.
	aFileStream close.!

water
	"Answer the value of the receiver's instance variable water.
	This method was automatically generated, but may be modified."

	^water!

water: anObject
	"Set the value of the receiver's instance variable water to anObject.
	This method was automatically generated, but may be modified."

	water := anObject! !

!World categoriesFor: #actor!accessing! !
!World categoriesFor: #actor:!accessing! !
!World categoriesFor: #addLocation:!adding! !
!World categoriesFor: #defaultFileName!accessing! !
!World categoriesFor: #helpString!accessing! !
!World categoriesFor: #initialize!initializing! !
!World categoriesFor: #oil!accessing! !
!World categoriesFor: #oil:!accessing! !
!World categoriesFor: #processCommand:!accessing! !
!World categoriesFor: #randomGenerator!accessing! !
!World categoriesFor: #randomGenerator:!accessing! !
!World categoriesFor: #responses!accessing! !
!World categoriesFor: #restore!no category! !
!World categoriesFor: #save!binary filing! !
!World categoriesFor: #water!accessing! !
!World categoriesFor: #water:!accessing! !

