"Filed out from Dolphin Smalltalk/Version 2.1"!

World subclass: #TestWorld
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

TestWorld class instanceVariableNames: ''!

TestWorld comment: ''!

!TestWorld categoriesForClass!No category! !

!TestWorld methodsFor!

defaultFileName
		^'TestWorld.stb'!

initialize
	"Create a world with a few locations and items."

	| loc1 loc2 loc3 loc4 |

	super initialize.

	self
		longDescription: 'You''ve entered a world full of new possibilities';
		shortDescription: 'You''re in the test world'.

	loc1 := Location new initialize
			longDescription: 'You have entered a room with bright red walls.  An arched portico leads north.';
			shortDescription: 'You''re in the red room'.						

	loc2 := Location new initialize
			longDescription: 'You are in a room with bright blue walls.  There is a plain wooden door to the east ',
						'while a damp and dingy tunnel runs to the southeast.';
			shortDescription: 'You''re in the blue room'.

	loc3 := Location new initialize
			longDescription: 'Before you lies a room with bright green walls.  A dusty passageway leads to the ',
						'west, while a narrow hallway leads south.';
			shortDescription: 'You''re a resident of the green room'.

	loc4 := Location new initialize
			longDescription: 'Your eyes are jolted by the electric purple walls of this room.  A ',
						'portal festooned with gilt and pearls leads to the northwest.';
			shortDescription: 'You''re in the purple room'.

	self
		addLocation: loc1;
		addLocation: loc2;
		addLocation: loc3;
		addLocation: loc4.

	loc1 addConnection: (Connection new initialize
					synonyms: #('north' 'portico');
					destination: loc2);
		add: (Item new initialize
				longNounPhrase: 'old-fashioned oil lamp';
				shortNounPhrase: 'lamp').

	loc2
		addConnection: (Connection new initialize
					synonyms: #('east' 'door');
					destination: loc3);
		addConnection: (Connection new initialize
					synonyms: #('southeast' 'tunnel');
					destination: loc4);
		add: (Item new initialize
				longNounPhrase: 'large grandfather clock';
				shortNounPhrase: 'grandfather clock').

	loc3
		addConnection: (Connection new initialize
					synonyms: #('west' 'passage' 'passageway');
					destination: loc2);
		addConnection: (Connection new initialize
					synonyms: #('south' 'hall' 'hallway');
					destination: loc4);
		add: (Item new initialize
				longNounPhrase: 'iron-bound chest';
				shortNounPhrase: 'chest').

	loc4 addConnection: (Connection new initialize
					synonyms: #('northwest' 'portal');
					destination: loc2);
		add: (Item new initialize
				longNounPhrase: 'intricate key';
				shortNounPhrase: 'intricate key').

	self actor: (SimpleActor new initialize
					location: loc1;
					longDescription: 'a nervous-looking individual with thick glasses';
					shortDescription: 'an adventurer').! !

!TestWorld categoriesFor: #defaultFileName!accessing! !
!TestWorld categoriesFor: #initialize!initializing! !

