"Filed out from Dolphin Smalltalk/Version 2.1"!

CommandParser subclass: #SimpleCommandParser
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

SimpleCommandParser class instanceVariableNames: ''!

SimpleCommandParser comment: ''!

!SimpleCommandParser categoriesForClass!Adventure! !

!SimpleCommandParser methodsFor!

normalizeVerb: aString
	"Normalize a verb into its basic form.  If no translation exists
	answer aString"

	^self verbNormalizationDictionary at: aString ifAbsent: [ aString ]!

parse: aString withDirections: aCollection
	| subStrings validDirections validVerbs actions translatedVerb |

	validDirections := aCollection.
	validVerbs := self class verbs.
	actions := OrderedCollection new initialize.

	subStrings := aString asLowercase subStrings.

	subStrings size > 0 ifTrue: [ translatedVerb := self normalizeVerb: (subStrings at: 1) ].

	"Parse single-word phrases"

	subStrings size = 1 ifTrue: [
		(validDirections includes: translatedVerb)
			ifTrue: [ ^self parse: 'go ', translatedVerb withDirections: validDirections ]
			ifFalse: [ 
				(validVerbs includes: translatedVerb)
					ifTrue: [ actions add: (Action
										verb: translatedVerb
										arguments: (OrderedCollection new initialize)) ]
					ifFalse: [ actions add: (Action
								verb: 'respond'
								arguments: (OrderedCollection with: 'Huh?')) ] ] ].

	"Parse verb-noun phrases."

	subStrings size = 2 ifTrue: [
		(validVerbs includes: translatedVerb)
			ifTrue: [ actions add: (Action
								verb: translatedVerb
								arguments: (OrderedCollection with: (subStrings at: 2))) ]
			ifFalse: [ actions add: (Action
								verb: 'respond'
								arguments: (OrderedCollection with: 'I don''t know how to ' with: aString)) ] ].

	"Complain if we get a more complex phrase."

	subStrings size > 2 ifTrue: [ actions add: (Action
									verb: 'respond'
									arguments: (OrderedCollection with: 'I don''t understand ' with: aString)) ].

	^actions!

verbNormalizationDictionary
	"Private - create a Dictionary used to translate common verb
	 synonyms to verbs this parser understands.  At some point it
	 might prove useful to cache this in a variable."

	^Dictionary new initialize
		add: 'onward' -> 'forward';
		add: 'back' -> 'backward';
		add: 'retreat' -> 'backward';
		add: 'return' -> 'backward';
		add: 'leave' -> 'exit';
		add: 'out' -> 'exit';
		add: 'outside' -> 'exit';
		add: 'inside' -> 'in';
		add: 'inward' -> 'in';
		add: 'above' -> 'up';
		add: 'ascend' -> 'up';
		add: 'u' -> 'up';
		add: 'upward' -> 'up';
		add: 'd' -> 'down';
		add: 'descend' -> 'down';
		add: 'downward' -> 'down';
		add: 'describe' -> 'look';
		add: 'examine' -> 'look';
		add: 'touch' -> 'look';
		add: 'i' -> 'inventory';
		add: 'e' -> 'east';
		add: 'w' -> 'west';
		add: 'n' -> 'north';
		add: 's' -> 'south';
		add: 'ne' -> 'northeast';
		add: 'se' -> 'southeast';
		add: 'sw' -> 'southwest';
		add: 'nw' -> 'northwest';
		add: 'take' -> 'get';
		add: 'leave' -> 'drop';
		add: 'dump' -> 'drop';
		add: 'lose' -> 'drop';
		add: 'journey' -> 'go';
		add: 'speak' -> 'say';
		add: 'talk' -> 'say';
		yourself! !

!SimpleCommandParser categoriesFor: #normalizeVerb:!no category! !
!SimpleCommandParser categoriesFor: #parse:withDirections:!no category! !
!SimpleCommandParser categoriesFor: #verbNormalizationDictionary!no category! !

!SimpleCommandParser class methodsFor!

verbs
	^#('go' 'look' 'get' 'inventory' 'drop' 'say' 'unlock' 'open' 'light' 'wave' 'fill' 'empty' 'help' 'close' 'score')! !

!SimpleCommandParser class categoriesFor: #verbs!no category! !

