"Filed out from Dolphin Smalltalk/Version 2.1"!

Container subclass: #Item
	instanceVariableNames: 'lightSource lighted movable points treasure'
	classVariableNames: ''
	poolDictionaries: ''!

Item class instanceVariableNames: ''!

Item comment: 'A ''thing'' in the database which is not an actor (e.g. is passive, not active), e.g. lamp, key, rod, etc.

Items should be capable of responding to simple commands, e.g.
    wave rod
when parsed and processed by an Actor might result in
    self perform: (Message selector: #wave: argument: ''rod'')

The Actor handler for #wave might be something like

    wave: aString
        | items |
        items := self findItemsLike: aString.
        items size = 0 ifTrue: [ AdvNoItemFoundException signalWith: aString ].
        items size > 1 ifTrue: [ AdvMultipleItemsFoundException signalWith: aString ]

        ^(items at: 1) performAction: #wave

Thus, items need to have a Collection of things they can do, which may consist of a Dictionary of BlockClosures since we''ll need to change this on an instance-by-instance basis.'!

!Item categoriesForClass!Adventure! !

!Item methodsFor!

basicLighted
	"Answer the value of the receiver's instance variable lighted.
	This method was automatically generated, but may be modified."

	^lighted!

initialize
	super initialize.
	self
		lightSource: false;
		lighted: false;
		movable: true;
		points: 0;
		treasure: false!

lighted
	"Answer the value of the receiver's instance variable lighted.
	This method was automatically generated, but may be modified."

	^self basicLighted!

lighted: aBoolean
	"Set the value of the receiver's instance variable lighted to anObject.
	This method was automatically generated, but may be modified."

	lighted := aBoolean!

lightSource
	"Answer the value of the receiver's instance variable lightSource.
	This method was automatically generated, but may be modified."

	^lightSource!

lightSource: aBoolean
	"Set the value of the receiver's instance variable lightSource to anObject.
	This method was automatically generated, but may be modified."

	lightSource := aBoolean!

movable
	"Answer the value of the receiver's instance variable movable.
	This method was automatically generated, but may be modified."

	^movable!

movable: anObject
	"Set the value of the receiver's instance variable movable to anObject.
	This method was automatically generated, but may be modified."

	movable := anObject!

points
	"Answer the value of the receiver's instance variable points.
	This method was automatically generated, but may be modified."

	^points!

points: anObject
	"Set the value of the receiver's instance variable points to anObject.
	This method was automatically generated, but may be modified."

	points := anObject!

treasure
	"Answer the value of the receiver's instance variable treasure.
	This method was automatically generated, but may be modified."

	^treasure!

treasure: anObject
	"Set the value of the receiver's instance variable treasure to anObject.
	This method was automatically generated, but may be modified."

	treasure := anObject! !

!Item categoriesFor: #basicLighted!no category! !
!Item categoriesFor: #initialize!no category! !
!Item categoriesFor: #lighted!accessing! !
!Item categoriesFor: #lighted:!accessing! !
!Item categoriesFor: #lightSource!accessing! !
!Item categoriesFor: #lightSource:!accessing! !
!Item categoriesFor: #movable!accessing! !
!Item categoriesFor: #movable:!accessing! !
!Item categoriesFor: #points!accessing! !
!Item categoriesFor: #points:!accessing! !
!Item categoriesFor: #treasure!accessing! !
!Item categoriesFor: #treasure:!accessing! !

