"Filed out from Dolphin Smalltalk/Version 2.1"!

Object subclass: #Describable
	instanceVariableNames: 'longDescription shortDescription shortNounPhrase longNounPhrase article longDescriptionSeen plural'
	classVariableNames: 'RandomGenerator'
	poolDictionaries: ''!

Describable class instanceVariableNames: ''!

Describable comment: 'Something which has a description.'!

!Describable categoriesForClass!Adventure! !

!Describable methodsFor!

article
	article isNil
		ifTrue: [ ^self generateArticle ]
		ifFalse: [ ^article ]
!

article: anObject
	"Set the value of the receiver's instance variable article to anObject.
	This method was automatically generated, but may be modified."

	article := anObject
!

basicDescription
	"Answers the long description if it has not been seen before; otherwise answers
	the short description"

	self longDescriptionSeen
		ifTrue: [ ^self shortDescription ]
		ifFalse: [ self longDescriptionSeen: true.
			     ^self longDescription ]!

basicLongDescription
	^longDescription!

basicLongNounPhrase
	^longNounPhrase!

basicShortDescription
	^shortDescription!

basicShortNounPhrase
	^shortNounPhrase!

description
	^self basicDescription
!

generateArticle
	"Private"
	self longDescriptionSeen
		ifFalse: [ (longNounPhrase at: 1) isVowel ifTrue: [ ^'an' ] ifFalse: [ ^'a' ] ]
		ifTrue: [ (shortNounPhrase at: 1) isVowel ifTrue: [ ^'an' ] ifFalse: [ ^'a' ] ]!

initialize
	super initialize.
	self
		longDescriptionSeen: false;
		plural: false!

inventoryDescription2ndPerson
	^'have ', self article, ' ', self nounPhrase!

inventoryDescription3dPerson
	self plural
		ifTrue: [ ^'are ', self article, ' ', self nounPhrase ]
		ifFalse: [ ^'is ', self article, ' ', self nounPhrase ]!

longDescription
	self longNounPhrase notNil
		ifTrue: [ ^(self article size > 0 ifTrue: [ self article, ' '] ifFalse: [ '' ]), self longNounPhrase ]
		ifFalse: [ ^longDescription ]!

longDescription: anObject
	"Set the value of the receiver's instance variable longDescription to anObject.
	This method was automatically generated, but may be modified."

	longDescription := anObject.
	self basicShortDescription isNil ifTrue: [ self shortDescription: anObject ]!

longDescriptionSeen
	"Answer the value of the receiver's instance variable longDescriptionSeen.
	This method was automatically generated, but may be modified."

	^longDescriptionSeen!

longDescriptionSeen: aBoolean
	"Set the value of the receiver's instance variable longDescriptionSeen to anObject.
	This method was automatically generated, but may be modified."

	longDescriptionSeen := aBoolean!

longNounPhrase
	"Answer the value of the receiver's instance variable longNounPhrase.
	This method was automatically generated, but may be modified."

	^longNounPhrase!

longNounPhrase: anObject
	"Set the value of the receiver's instance variable longNounPhrase to anObject.
	This method was automatically generated, but may be modified."

	longNounPhrase := anObject.
	self basicShortNounPhrase isNil ifTrue: [ self shortNounPhrase: anObject ]!

nounPhrase
	self longDescriptionSeen
		ifTrue: [ ^self shortNounPhrase ]
		ifFalse: [ self longDescriptionSeen: true. ^self longNounPhrase ]!

plural
	"Answer the value of the receiver's instance variable plural.
	This method was automatically generated, but may be modified."

	^plural!

plural: anObject
	"Set the value of the receiver's instance variable plural to anObject.
	This method was automatically generated, but may be modified."

	plural := anObject!

points
	^0!

randomGenerator
	^self class randomGenerator!

shortDescription
	self shortNounPhrase notNil
		ifTrue: [ ^self article, ' ', self shortNounPhrase ]
		ifFalse: [ ^shortDescription ]!

shortDescription: anObject
	"Set the value of the receiver's instance variable shortDescription to anObject.
	This method was automatically generated, but may be modified."

	shortDescription := anObject.
	self basicLongDescription isNil ifTrue: [ self longDescription: anObject ]!

shortNounPhrase
	"Answer the value of the receiver's instance variable shortNounPhrase.
	This method was automatically generated, but may be modified."

	^shortNounPhrase!

shortNounPhrase: anObject
	"Set the value of the receiver's instance variable shortNounPhrase to anObject.
	This method was automatically generated, but may be modified."

	shortNounPhrase := anObject.
	self basicLongNounPhrase isNil ifTrue: [ self longNounPhrase: anObject ]! !

!Describable categoriesFor: #article!no category! !
!Describable categoriesFor: #article:!no category! !
!Describable categoriesFor: #basicDescription!no category! !
!Describable categoriesFor: #basicLongDescription!no category! !
!Describable categoriesFor: #basicLongNounPhrase!no category! !
!Describable categoriesFor: #basicShortDescription!no category! !
!Describable categoriesFor: #basicShortNounPhrase!no category! !
!Describable categoriesFor: #description!no category! !
!Describable categoriesFor: #generateArticle!no category! !
!Describable categoriesFor: #initialize!no category! !
!Describable categoriesFor: #inventoryDescription2ndPerson!no category! !
!Describable categoriesFor: #inventoryDescription3dPerson!no category! !
!Describable categoriesFor: #longDescription!accessing! !
!Describable categoriesFor: #longDescription:!accessing! !
!Describable categoriesFor: #longDescriptionSeen!accessing! !
!Describable categoriesFor: #longDescriptionSeen:!accessing! !
!Describable categoriesFor: #longNounPhrase!accessing! !
!Describable categoriesFor: #longNounPhrase:!accessing! !
!Describable categoriesFor: #nounPhrase!no category! !
!Describable categoriesFor: #plural!accessing! !
!Describable categoriesFor: #plural:!accessing! !
!Describable categoriesFor: #points!no category! !
!Describable categoriesFor: #randomGenerator!no category! !
!Describable categoriesFor: #shortDescription!accessing! !
!Describable categoriesFor: #shortDescription:!accessing! !
!Describable categoriesFor: #shortNounPhrase!accessing! !
!Describable categoriesFor: #shortNounPhrase:!accessing! !

!Describable class methodsFor!

chooseFrom: anArrayedCollection
	"Choose a response at random from a collection of possible text strings"

	| randomValue randomNumber |

	randomValue := self randomGenerator next.
	randomNumber := (randomValue * anArrayedCollection size) truncated + 1.
	^anArrayedCollection at: randomNumber!

randomGenerator
	RandomGenerator isNil ifTrue: [ RandomGenerator := Random new initialize ].
	^RandomGenerator! !

!Describable class categoriesFor: #chooseFrom:!no category! !
!Describable class categoriesFor: #randomGenerator!no category! !

