"Filed out from Dolphin Smalltalk/Version 2.1"!

Describable subclass: #Container
	instanceVariableNames: 'contents inventoryable'
	classVariableNames: ''
	poolDictionaries: ''!

Container class instanceVariableNames: ''!

Container comment: 'Something which can contain other things.'!

!Container categoriesForClass!Adventure! !

!Container methodsFor!

add: anObject
	"Add a new object to the collection of objects in this container"

	self remove: anObject.	"Make sure it's not already in this container"
	self contents add: anObject.
	^Response text: 'OK'!

basicLighted
	^false!

contains: anObject
	^self contents includes: anObject!

containsLightSource
	^self basicLighted | (self contents inject: false into: [ :tot :each | tot | each containsLightSource ])!

contents
	"Answer the value of the receiver's instance variable contents.
	This method was automatically generated, but may be modified."

	^contents!

contentsDescription
	^''!

contentsLike: aString
	| pattern |

	pattern := '*', aString, '*'.
	^self contents select: [ :each |
		(pattern match: each shortDescription) | (pattern match: each longDescription) ]!

initialize
	super initialize.
	contents := OrderedCollection new initialize.
	self inventoryable: true!

inventory
	"Answer a string describing the contents of this container"

	^self subclassResponsibility!

inventory2ndPersonWithPrefix: aPrefixString suffix: aSuffixString
	"Private - answer this Container's inventory using the given prefix and suffix"
	^self contents inject: '' into: [ :string :each |
		each inventoryable
			ifTrue: [
				(each basicLongDescription isNil
					ifTrue: [
						string, (string size > 0 ifTrue: [ String lineDelimiter ] ifFalse: ['']),
						aPrefixString, ' ', each inventoryDescription2ndPerson,
						(aSuffixString size > 0 ifTrue: [ ' ', aSuffixString ] ifFalse: [ '' ]) ]
					ifFalse: [ string, each basicDescription ]),
				(each contents size > 0
					ifTrue: [ '.  The ', each shortNounPhrase, ' contains:',
											String lineDelimiter,
											(each inventoryWithPrefix: '   ' suffix: '') ]
					ifFalse: [ '' ]) ]
			ifFalse: [ string ] ]!

inventory3dPersonWithPrefix: aPrefixString suffix: aSuffixString
	"Private - answer this Container's inventory using the given prefix and suffix"

	^self contents inject: '' into: [ :string :each |
		each inventoryable
			ifTrue: [
				(each basicLongDescription isNil
					ifTrue: [
						string, (string size > 0 ifTrue: [ String lineDelimiter ] ifFalse: ['']),
						aPrefixString, ' ', each inventoryDescription3dPerson,
						(aSuffixString size > 0 ifTrue: [ ' ', aSuffixString ] ifFalse: [ '' ]),
						(each treasure ifTrue: [ '!!' ] ifFalse: [ '' ]) ]
					ifFalse: [ string, each basicDescription ]),
				(each contents size > 0
					ifTrue: [ '.  The ', each shortNounPhrase, ' contains:',
											String lineDelimiter,
											(each inventoryWithPrefix: '   ' suffix: '') ]
					ifFalse: [ '' ]) ]
			ifFalse: [ string ] ]!

inventoryable
	"Answer the value of the receiver's instance variable inventoryable.
	This method was automatically generated, but may be modified."

	^inventoryable!

inventoryable: anObject
	"Set the value of the receiver's instance variable inventoryable to anObject.
	This method was automatically generated, but may be modified."

	inventoryable := anObject!

inventoryStringWithPrefix: aPrefixString suffix: aSuffixString
	| description contentsDescription |

	self inventoryable
		ifTrue: [
			self basicLongDescription size > 0
				ifTrue: [ description := self basicDescription ]
				ifFalse: [ description := aPrefixString, ' ', self description,
					      ((aSuffixString size > 0) ifTrue: [ ' ' ] ifFalse: [ '' ]), aSuffixString, '.' ].

			self contents size > 0
				ifTrue: [ contentsDescription := 'The ', self shortNounPhrase, ' contains:',
								String lineDelimiter,
								(self inventoryWithPrefix: '   ' suffix: '') ]
				ifFalse: [ contentsDescription := '' ] ]
		ifFalse: [ description := ''.  contentsDescription := ''. ].

	^description, contentsDescription!

inventoryWithPrefix: aPrefixString suffix: aSuffixString
	"Private - answer this Container's inventory using the given prefix and suffix"
	^self contents inject: '' into: [ :string :each |
		string, (string size > 0 ifTrue: [ String lineDelimiter ] ifFalse: ['']),
			(each inventoryStringWithPrefix: aPrefixString suffix: aSuffixString) ]!

remove: anObject
	^self contents remove: anObject ifAbsent: [ ]! !

!Container categoriesFor: #add:!no category! !
!Container categoriesFor: #basicLighted!no category! !
!Container categoriesFor: #contains:!no category! !
!Container categoriesFor: #containsLightSource!no category! !
!Container categoriesFor: #contents!accessing! !
!Container categoriesFor: #contentsDescription!no category! !
!Container categoriesFor: #contentsLike:!no category! !
!Container categoriesFor: #initialize!no category! !
!Container categoriesFor: #inventory!no category! !
!Container categoriesFor: #inventory2ndPersonWithPrefix:suffix:!no category! !
!Container categoriesFor: #inventory3dPersonWithPrefix:suffix:!no category! !
!Container categoriesFor: #inventoryable!accessing! !
!Container categoriesFor: #inventoryable:!accessing! !
!Container categoriesFor: #inventoryStringWithPrefix:suffix:!no category! !
!Container categoriesFor: #inventoryWithPrefix:suffix:!no category! !
!Container categoriesFor: #remove:!no category! !

