"Filed out from Dolphin Smalltalk/Version 2.1"!

Object subclass: #Connection
	instanceVariableNames: 'destination synonyms locked key closeable closed entryProbability linkedConnection openDescription closedDescription lockedDescription'
	classVariableNames: ''
	poolDictionaries: ''!

Connection class instanceVariableNames: ''!

Connection comment: 'Represents a connection from one location to another.  Connections are one way only - to have a bidirectional connection between locations each location must have a connection leading to the other.  Connections can optionally have a key object specified, in which case they can be locked and unlocked.  When locked the currentOpenProbability should be set to zero; when unlocked the currentOpenProbability should be reset to the baseOpenProbability value.'!

!Connection categoriesForClass!Adventure! !

!Connection methodsFor!

addSynonym: aString
	self removeSynonym: aString.
	self synonyms add: aString asLowercase!

addSynonyms: aCollection
	aCollection do: [ :each | self addSynonym: each ]!

basicClosed: aBoolean
	closed := aBoolean.
	aBoolean ifTrue: [ self closeable: true ]!

basicLocked: aBoolean
	locked := aBoolean!

basicOpen: aBoolean
	self basicClosed: aBoolean not!

closeable
	"Answer the value of the receiver's instance variable closeable.
	This method was automatically generated, but may be modified."

	^closeable!

closeable: aBoolean
	"Set the value of the receiver's instance variable closeable to anObject.
	This method was automatically generated, but may be modified."

	closeable := aBoolean!

closed
	"Answer the value of the receiver's instance variable closed.
	This method was automatically generated, but may be modified."

	^closed!

closed: aBoolean
	"Set the value of the receiver's instance variable closed to anObject.
	This method was automatically generated, but may be modified."

	self basicClosed: aBoolean.
	self linkedConnection notNil ifTrue: [ self linkedConnection basicClosed: aBoolean ]!

closedDescription
	"Answer the value of the receiver's instance variable closedDescription.
	This method was automatically generated, but may be modified."

	^closedDescription!

closedDescription: anObject
	"Set the value of the receiver's instance variable closedDescription to anObject.
	This method was automatically generated, but may be modified."

	closedDescription := anObject!

description
	self locked ifTrue: [ ^self lockedDescription ].
	self closed ifTrue: [ ^self closedDescription ].
	^self openDescription!

destination
	"Answer the value of the receiver's instance variable destination.
	This method was automatically generated, but may be modified."

	^destination!

destination: aLocation
	"Set the value of the receiver's instance variable destination to anObject.
	This method was automatically generated, but may be modified."

	destination := aLocation!

entryProbability
	"Answer the value of the receiver's instance variable entryProbability.
	This method was automatically generated, but may be modified."

	^entryProbability!

entryProbability: aFloat
	"Set the value of the receiver's instance variable entryProbability to anObject.
	This method was automatically generated, but may be modified."

	entryProbability := aFloat!

hasSynonym: aString
	^self synonyms includes: aString asLowercase
!

initialize
	super initialize.
	self
		locked: false;
		closeable: false;
		closed: false;
		entryProbability: 1.0;
		closedDescription: '';
		lockedDescription: '';
		openDescription: ''
		!

key
	"Answer the value of the receiver's instance variable key.
	This method was automatically generated, but may be modified."

	^key!

key: anObject
	"Set the value of the receiver's instance variable key to anObject.
	This method was automatically generated, but may be modified."

	key := anObject!

linkedConnection
	"Answer the value of the receiver's instance variable linkedConnection.
	This method was automatically generated, but may be modified."

	^linkedConnection!

linkedConnection: aConnection
	"Set the value of the receiver's instance variable linkedConnection to anObject.
	This method was automatically generated, but may be modified."

	linkedConnection := aConnection!

locked
	"Answer the value of the receiver's instance variable locked.
	This method was automatically generated, but may be modified."

	^locked!

locked: aBoolean
	self basicLocked: aBoolean.
	self linkedConnection notNil ifTrue: [ self linkedConnection basicLocked: aBoolean ]!

lockedDescription
	"Answer the value of the receiver's instance variable lockedDescription.
	This method was automatically generated, but may be modified."

	lockedDescription = ''
		ifTrue: [ ^'It''s locked' ]
		ifFalse: [ ^lockedDescription ]!

lockedDescription: anObject
	"Set the value of the receiver's instance variable lockedDescription to anObject.
	This method was automatically generated, but may be modified."

	lockedDescription := anObject!

open
	^self closed not!

open: aBoolean
	self basicOpen: aBoolean.
	self linkedConnection notNil ifTrue: [ self linkedConnection basicOpen: aBoolean ]!

openDescription
	"Answer the value of the receiver's instance variable openDescription.
	This method was automatically generated, but may be modified."

	^openDescription!

openDescription: anObject
	"Set the value of the receiver's instance variable openDescription to anObject.
	This method was automatically generated, but may be modified."

	openDescription := anObject!

removeAllSynonyms
	synonyms := nil!

removeSynonym: aString
	self synonyms remove: aString asLowercase ifAbsent: [ ]!

synonyms
	synonyms isNil ifTrue: [ synonyms := OrderedCollection new initialize ].
	^synonyms!

synonyms: anArray
	anArray do: [ :each | self addSynonym: each ]!

transport: anActor
	^self destination receiveActor: anActor
!

unlocked
	^self locked not! !

!Connection categoriesFor: #addSynonym:!no category! !
!Connection categoriesFor: #addSynonyms:!no category! !
!Connection categoriesFor: #basicClosed:!no category! !
!Connection categoriesFor: #basicLocked:!no category! !
!Connection categoriesFor: #basicOpen:!no category! !
!Connection categoriesFor: #closeable!accessing! !
!Connection categoriesFor: #closeable:!accessing! !
!Connection categoriesFor: #closed!accessing! !
!Connection categoriesFor: #closed:!accessing! !
!Connection categoriesFor: #closedDescription!accessing! !
!Connection categoriesFor: #closedDescription:!accessing! !
!Connection categoriesFor: #description!no category! !
!Connection categoriesFor: #destination!accessing! !
!Connection categoriesFor: #destination:!accessing! !
!Connection categoriesFor: #entryProbability!accessing! !
!Connection categoriesFor: #entryProbability:!accessing! !
!Connection categoriesFor: #hasSynonym:!no category! !
!Connection categoriesFor: #initialize!no category! !
!Connection categoriesFor: #key!accessing! !
!Connection categoriesFor: #key:!accessing! !
!Connection categoriesFor: #linkedConnection!accessing! !
!Connection categoriesFor: #linkedConnection:!accessing! !
!Connection categoriesFor: #locked!accessing! !
!Connection categoriesFor: #locked:!accessing! !
!Connection categoriesFor: #lockedDescription!accessing! !
!Connection categoriesFor: #lockedDescription:!accessing! !
!Connection categoriesFor: #open!accessing! !
!Connection categoriesFor: #open:!accessing! !
!Connection categoriesFor: #openDescription!accessing! !
!Connection categoriesFor: #openDescription:!accessing! !
!Connection categoriesFor: #removeAllSynonyms!no category! !
!Connection categoriesFor: #removeSynonym:!no category! !
!Connection categoriesFor: #synonyms!no category! !
!Connection categoriesFor: #synonyms:!no category! !
!Connection categoriesFor: #transport:!no category! !
!Connection categoriesFor: #unlocked!no category! !

